/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.shape.ShapeRenderer;
import org.jmol.shapespecial.Polyhedra;

public class PolyhedraRenderer
extends ShapeRenderer {
    private int drawEdges;

    protected void render() {
        Polyhedra polyhedra = (Polyhedra)this.shape;
        Polyhedra.Polyhedron[] polyhedrons = polyhedra.polyhedrons;
        this.drawEdges = polyhedra.drawEdges;
        int i = polyhedra.polyhedronCount;
        while (--i >= 0) {
            short colix = polyhedra.colixes == null ? (short)0 : polyhedra.colixes[polyhedrons[i].centralAtom.getAtomIndex()];
            this.render1(polyhedrons[i], colix);
        }
    }

    private void render1(Polyhedra.Polyhedron p, short colix) {
        int j;
        int i;
        boolean isFrontOnly;
        if (p.visibilityFlags == 0) {
            return;
        }
        colix = Graphics3D.getColixInherited(colix, p.centralAtom.getColix());
        Atom[] vertices = p.vertices;
        byte[] planes = p.planes;
        int i2 = vertices.length;
        while (--i2 >= 0) {
            if (!vertices[i2].isSimple()) continue;
            vertices[i2].transform(this.viewer);
        }
        boolean isAll = this.drawEdges == 1;
        boolean bl = isFrontOnly = this.drawEdges == 2;
        if (this.g3d.setColix(colix)) {
            i = 0;
            j = 0;
            while (j < planes.length) {
                this.fillFace(p.normixes[i++], vertices[planes[j++]], vertices[planes[j++]], vertices[planes[j++]]);
            }
        }
        if (!this.g3d.setColix(Graphics3D.getColixTranslucent(colix, false, 0.0f))) {
            return;
        }
        i = 0;
        j = 0;
        while (j < planes.length) {
            this.drawFace(p.normixes[i++], vertices[planes[j++]], vertices[planes[j++]], vertices[planes[j++]], isAll, isFrontOnly);
        }
    }

    private void drawFace(short normix, Atom atomA, Atom atomB, Atom atomC, boolean isAll, boolean isFrontOnly) {
        if (isAll || isFrontOnly && this.g3d.isDirectedTowardsCamera(normix)) {
            this.g3d.drawCylinderTriangle(atomA.screenX, atomA.screenY, atomA.screenZ, atomB.screenX, atomB.screenY, atomB.screenZ, atomC.screenX, atomC.screenY, atomC.screenZ, 3);
        }
    }

    private void fillFace(short normix, Atom atomA, Atom atomB, Atom atomC) {
        this.g3d.fillTriangle(normix, atomA.screenX, atomA.screenY, atomA.screenZ, atomB.screenX, atomB.screenY, atomB.screenZ, atomC.screenX, atomC.screenY, atomC.screenZ);
    }
}

