/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.modelset.Atom;
import org.jmol.shape.Shape;
import org.jmol.shape.ShapeRenderer;
import org.jmol.shapespecial.Vectors;

public class VectorsRenderer
extends ShapeRenderer {
    final Point3f pointVectorEnd = new Point3f();
    final Point3f pointArrowHead = new Point3f();
    final Point3i screenVectorEnd = new Point3i();
    final Point3i screenArrowHead = new Point3i();
    final Vector3f headOffsetVector = new Vector3f();
    int diameter;
    int headWidthPixels;
    float vectorScale;
    float headScale;
    boolean doShaft;
    static final float arrowHeadOffset = -0.2f;

    protected void render() {
        Vectors vectors = (Vectors)this.shape;
        if (!vectors.isActive) {
            return;
        }
        short[] mads = vectors.mads;
        if (mads == null) {
            return;
        }
        Atom[] atoms = vectors.atoms;
        short[] colixes = vectors.colixes;
        int i = this.modelSet.getAtomCount();
        while (--i >= 0) {
            Vector3f vibrationVector;
            Atom atom = atoms[i];
            if (!atom.isShapeVisible(this.myVisibilityFlag) || this.modelSet.isAtomHidden(i) || (vibrationVector = this.viewer.getVibrationVector(i)) == null) continue;
            this.vectorScale = this.viewer.getVectorScale();
            if (!this.transform(mads[i], atom, vibrationVector) || !this.g3d.setColix(Shape.getColix(colixes, i, atom))) continue;
            this.renderVector(atom);
        }
    }

    boolean transform(short mad, Atom atom, Vector3f vibrationVector) {
        float len = vibrationVector.length();
        if ((double)Math.abs(len * this.vectorScale) < 0.01) {
            return false;
        }
        this.headScale = -0.2f;
        if (this.vectorScale < 0.0f) {
            this.headScale = -this.headScale;
        }
        this.doShaft = 0.1 + (double)Math.abs(this.headScale / len) < (double)Math.abs(this.vectorScale);
        this.headOffsetVector.set(vibrationVector);
        this.headOffsetVector.scale(this.headScale / len);
        this.pointVectorEnd.scaleAdd(this.vectorScale, vibrationVector, atom);
        this.pointArrowHead.set(this.pointVectorEnd);
        this.pointArrowHead.add(this.headOffsetVector);
        this.screenArrowHead.set(this.viewer.transformPoint(this.pointArrowHead, vibrationVector));
        this.screenVectorEnd.set(this.viewer.transformPoint(this.pointVectorEnd, vibrationVector));
        this.diameter = mad < 1 ? 1 : (mad <= 20 ? (int)mad : (int)this.viewer.scaleToScreen(this.screenVectorEnd.z, mad));
        this.headWidthPixels = (int)((float)this.diameter * 2.0f);
        if (this.headWidthPixels < this.diameter + 2) {
            this.headWidthPixels = this.diameter + 2;
        }
        if (this.isGenerator) {
            this.diameter = mad < 1 ? (short)1 : mad;
        }
        return true;
    }

    void renderVector(Atom atom) {
        if (this.doShaft) {
            this.g3d.fillCylinder((byte)1, this.diameter, atom.screenX, atom.screenY, atom.screenZ, this.screenArrowHead.x, this.screenArrowHead.y, this.screenArrowHead.z);
        }
        this.g3d.fillCone((byte)2, this.headWidthPixels, this.screenArrowHead, this.screenVectorEnd);
    }
}

