/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.jvxl.api.MeshDataServer;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.shape.Mesh;
import org.jmol.shape.MeshCollection;
import org.jmol.shapesurface.IsosurfaceMesh;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.TextFormat;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

public class Isosurface
extends MeshCollection
implements MeshDataServer {
    private IsosurfaceMesh[] isomeshes = new IsosurfaceMesh[4];
    private IsosurfaceMesh thisMesh;
    private int lighting;
    private boolean iHaveBitSets;
    private boolean explicitContours;
    private int atomIndex;
    private int moNumber;
    private short defaultColix;
    private Point3f center;
    private boolean isPhaseColored;
    private boolean isColorExplicit;
    protected SurfaceGenerator sg;
    private JvxlData jvxlData;
    private ColorEncoder colorEncoder = new ColorEncoder();
    private int indexColorPositive;
    private int indexColorNegative;
    private int nLCAO = 0;
    private Point4f lcaoDir = new Point4f();
    private boolean associateNormals;
    private static final int MAX_OBJECT_CLICK_DISTANCE_SQUARED = 100;
    private final Point3i ptXY = new Point3i();

    public void allocMesh(String thisID) {
        this.isomeshes = (IsosurfaceMesh[])ArrayUtil.ensureLength(this.isomeshes, this.meshCount + 1);
        this.meshes = this.isomeshes;
        IsosurfaceMesh isosurfaceMesh = new IsosurfaceMesh(thisID, this.g3d, this.colix);
        this.isomeshes[this.meshCount++] = isosurfaceMesh;
        this.thisMesh = isosurfaceMesh;
        this.currentMesh = isosurfaceMesh;
        this.jvxlData = this.thisMesh.jvxlData;
        this.sg.setJvxlData(this.jvxlData);
    }

    public void initShape() {
        super.initShape();
        this.myType = "isosurface";
        this.newSg();
    }

    private void newSg() {
        this.jvxlData = new JvxlData();
        this.sg = new SurfaceGenerator(this.viewer, this, this.colorEncoder, null, this.jvxlData);
        this.sg.setVersion("Jmol " + Viewer.getJmolVersion());
    }

    protected void clearSg() {
        this.sg = null;
    }

    public void setProperty(String propertyName, Object value, BitSet bs) {
        if (Logger.debugging) {
            Logger.debug("Isosurface setProperty: " + propertyName + " = " + value);
        }
        if ("delete" == propertyName) {
            this.setPropertySuper(propertyName, value, bs);
            if (!this.explicitID) {
                this.nUnnamed = 0;
                this.nLCAO = 0;
            }
            return;
        }
        if ("remapcolor" == propertyName) {
            if (this.thisMesh != null) {
                this.remapColors();
            }
            return;
        }
        if ("thisID" == propertyName) {
            this.setPropertySuper("thisID", value, null);
            return;
        }
        if ("map" == propertyName) {
            this.setProperty("squareData", Boolean.FALSE, null);
            return;
        }
        if ("color" == propertyName) {
            if (this.thisMesh != null) {
                this.thisMesh.isColorSolid = true;
                this.thisMesh.polygonColixes = null;
            } else if (!TextFormat.isWild(this.previousMeshID)) {
                int i = this.meshCount;
                while (--i >= 0) {
                    this.isomeshes[i].isColorSolid = true;
                    this.isomeshes[i].polygonColixes = null;
                }
            }
            this.setPropertySuper(propertyName, value, bs);
            return;
        }
        if ("fixed" == propertyName) {
            this.isFixed = (Boolean)value;
            this.setModelIndex();
            return;
        }
        if ("modelIndex" == propertyName) {
            if (!this.iHaveModelIndex) {
                this.modelIndex = (Integer)value;
                this.sg.setModelIndex(this.modelIndex);
                this.isFixed = this.modelIndex < 0;
            }
            this.isFixed = this.modelIndex < 0;
            return;
        }
        if ("lcaoCartoon" == propertyName) {
            Vector3f[] info = (Vector3f[])value;
            if (!this.explicitID) {
                this.setPropertySuper("thisID", null, null);
            }
            if (!this.sg.setParameter("lcaoCartoonCenter", info[2])) {
                this.drawLcaoCartoon(info[0], info[1], info[3]);
            }
            return;
        }
        if ("title" == propertyName) {
            if (value instanceof String && "-".equals((String)value)) {
                value = null;
            }
            this.setPropertySuper(propertyName, value, bs);
            this.sg.setParameter("title", this.title, bs);
            return;
        }
        if ("select" == propertyName && this.iHaveBitSets) {
            return;
        }
        if ("ignore" == propertyName && this.iHaveBitSets) {
            return;
        }
        if ("contour" == propertyName) {
            this.explicitContours = true;
        }
        if ("atomIndex" == propertyName) {
            this.atomIndex = (Integer)value;
        }
        if ("pocket" == propertyName) {
            Boolean pocket = (Boolean)value;
            int n = this.lighting = pocket != false ? 1073741845 : 1073741843;
        }
        if ("colorRGB" == propertyName) {
            int rgb = (Integer)value;
            this.defaultColix = Graphics3D.getColix(rgb);
        }
        if ("molecularOrbital" == propertyName) {
            this.moNumber = (Integer)value;
            if (!this.isColorExplicit) {
                this.isPhaseColored = true;
            }
        }
        if (propertyName == "functionXY" && this.sg.isStateDataRead()) {
            this.setScriptInfo();
        }
        if ("center" == propertyName) {
            this.center.set((Point3f)value);
        }
        if ("phase" == propertyName) {
            this.isPhaseColored = true;
        }
        if ("plane" == propertyName) {
            this.allowContourLines = false;
        }
        if ("functionXY" == propertyName) {
            this.allowContourLines = false;
        }
        if ("finalize" == propertyName) {
            this.setScriptInfo();
            this.setJvxlInfo();
            this.clearSg();
            return;
        }
        if ("init" == propertyName) {
            this.newSg();
        }
        if (this.sg != null && this.sg.setParameter(propertyName, value, bs)) {
            return;
        }
        if ("init" == propertyName) {
            this.setPropertySuper("thisID", "+PREVIOUS_MESH+", null);
            this.iHaveBitSets = this.getScriptBitSets((String)value, null);
            if (!this.iHaveBitSets) {
                this.sg.setParameter("select", bs);
            }
            this.initializeIsosurface();
            this.sg.setModelIndex(this.modelIndex);
            return;
        }
        if ("clear" == propertyName) {
            this.discardTempData(true);
            return;
        }
        if (propertyName == "deleteModelAtoms") {
            int modelIndex = ((int[])((Object[])value)[2])[0];
            BitSet bsModels = new BitSet();
            bsModels.set(modelIndex);
            int firstAtomDeleted = ((int[])((Object[])value)[2])[1];
            int nAtomsDeleted = ((int[])((Object[])value)[2])[2];
            int i = this.meshCount;
            while (--i >= 0) {
                Mesh m = this.meshes[i];
                if (m == null) continue;
                if (m.modelIndex == modelIndex) {
                    --this.meshCount;
                    if (m == this.currentMesh) {
                        this.thisMesh = null;
                        this.currentMesh = null;
                    }
                    this.isomeshes = (IsosurfaceMesh[])ArrayUtil.deleteElements(this.meshes, i, 1);
                    this.meshes = this.isomeshes;
                    continue;
                }
                if (m.modelIndex <= modelIndex) continue;
                --m.modelIndex;
                if (m.atomIndex >= firstAtomDeleted) {
                    m.atomIndex -= nAtomsDeleted;
                }
                if (m.bitsets == null) continue;
                BitSetUtil.deleteBits(m.bitsets[0], bs);
                BitSetUtil.deleteBits(m.bitsets[1], bs);
                BitSetUtil.deleteBits(m.bitsets[2], bsModels);
            }
            return;
        }
        this.setPropertySuper(propertyName, value, bs);
    }

    private void setPropertySuper(String propertyName, Object value, BitSet bs) {
        this.currentMesh = this.thisMesh;
        super.setProperty(propertyName, value, bs);
        this.thisMesh = (IsosurfaceMesh)this.currentMesh;
        JvxlData jvxlData = this.jvxlData = this.thisMesh == null ? null : this.thisMesh.jvxlData;
        if (this.sg != null) {
            this.sg.setJvxlData(this.jvxlData);
        }
    }

    public Object getProperty(String property, int index) {
        Object ret = super.getProperty(property, index);
        if (ret != null) {
            return ret;
        }
        if (property == "dataRange") {
            float[] fArray;
            if (this.thisMesh == null) {
                fArray = null;
            } else {
                float[] fArray2 = new float[4];
                fArray2[0] = this.jvxlData.mappedDataMin;
                fArray2[1] = this.jvxlData.mappedDataMax;
                fArray2[2] = this.jvxlData.valueMappedToRed;
                fArray = fArray2;
                fArray2[3] = this.jvxlData.valueMappedToBlue;
            }
            return fArray;
        }
        if (property == "moNumber") {
            return new Integer(this.moNumber);
        }
        if (property == "area") {
            return new Float(this.thisMesh == null ? Float.NaN : this.thisMesh.calculateArea());
        }
        if (property == "volume") {
            return new Float(this.thisMesh == null ? Float.NaN : this.thisMesh.calculateVolume());
        }
        if (this.thisMesh == null) {
            return "no current isosurface";
        }
        if (property == "cutoff") {
            return new Float(this.jvxlData.cutoff);
        }
        if (property == "plane") {
            return this.jvxlData.jvxlPlane;
        }
        if (property == "jvxlFileData") {
            MeshData meshData = null;
            if (this.jvxlData.vertexDataOnly) {
                meshData = new MeshData();
                this.fillMeshData(meshData, 1);
            }
            return JvxlReader.jvxlGetFile(this, this.jvxlData, meshData, this.title, "", true, index, this.thisMesh.getState(this.myType), this.thisMesh.scriptCommand == null ? "" : this.thisMesh.scriptCommand);
        }
        if (property == "jvxlSurfaceData") {
            return JvxlReader.jvxlGetFile(this, this.jvxlData, null, this.title, "", false, 1, this.thisMesh.getState(this.myType), this.thisMesh.scriptCommand == null ? "" : this.thisMesh.scriptCommand);
        }
        if (property == "jvxlFileInfo") {
            return this.jvxlData.jvxlInfoLine;
        }
        return super.getProperty(property, index);
    }

    protected void getColorState(StringBuffer sb, Mesh mesh) {
        boolean colorArrayed;
        boolean bl = colorArrayed = mesh.isColorSolid && ((IsosurfaceMesh)mesh).polygonColixes != null;
        if (mesh.isColorSolid && !colorArrayed) {
            Isosurface.appendCmd(sb, this.getColorCommand(this.myType, mesh.colix));
        }
    }

    private boolean getScriptBitSets(String script, BitSet[] bsCmd) {
        this.script = script;
        this.getModelIndex(script);
        if (script == null) {
            return false;
        }
        int i = script.indexOf("# ({");
        if (i < 0) {
            return false;
        }
        int j = script.indexOf("})", i);
        if (j < 0) {
            return false;
        }
        BitSet bs = Escape.unescapeBitset(script.substring(i + 3, j + 1));
        if (bsCmd == null) {
            this.sg.setParameter("select", bs);
        } else {
            bsCmd[0] = bs;
        }
        i = script.indexOf("({", j);
        if (i < 0) {
            return true;
        }
        j = script.indexOf("})", i);
        if (j < 0) {
            return false;
        }
        bs = Escape.unescapeBitset(script.substring(i + 1, j + 1));
        if (bsCmd == null) {
            this.sg.setParameter("ignore", bs);
        } else {
            bsCmd[1] = bs;
        }
        i = script.indexOf("/({", j);
        if (i == j + 2) {
            j = script.indexOf("})", i);
            if (j < 0) {
                return false;
            }
            bs = Escape.unescapeBitset(script.substring(i + 3, j + 1));
            if (bsCmd == null) {
                this.viewer.setTrajectory(bs);
            } else {
                bsCmd[2] = bs;
            }
        }
        return true;
    }

    private void initializeIsosurface() {
        this.lighting = 1073741843;
        if (!this.iHaveModelIndex) {
            this.modelIndex = this.viewer.getCurrentModelIndex();
        }
        boolean bl = this.isFixed = this.modelIndex < 0;
        if (this.modelIndex < 0) {
            this.modelIndex = 0;
        }
        this.title = null;
        this.explicitContours = false;
        this.atomIndex = -1;
        this.colix = (short)5;
        this.defaultColix = 0;
        this.isColorExplicit = false;
        this.isPhaseColored = false;
        this.allowContourLines = true;
        this.center = new Point3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        this.linkedMesh = null;
        this.initState();
    }

    private void initState() {
        this.associateNormals = true;
        this.sg.initState();
    }

    private void discardTempData(boolean discardAll) {
        if (!discardAll) {
            return;
        }
        this.title = null;
        if (this.thisMesh == null) {
            return;
        }
        this.thisMesh.surfaceSet = null;
    }

    private short getDefaultColix() {
        int argb;
        if (this.defaultColix != 0) {
            return this.defaultColix;
        }
        if (!this.sg.isCubeData()) {
            return this.colix;
        }
        if (this.sg.getCutoff() >= 0.0f) {
            this.indexColorPositive %= JmolConstants.argbsIsosurfacePositive.length;
            argb = JmolConstants.argbsIsosurfacePositive[this.indexColorPositive++];
        } else {
            this.indexColorNegative %= JmolConstants.argbsIsosurfaceNegative.length;
            argb = JmolConstants.argbsIsosurfaceNegative[this.indexColorNegative++];
        }
        return Graphics3D.getColix(argb);
    }

    private void drawLcaoCartoon(Vector3f z, Vector3f x, Vector3f rotAxis) {
        IsosurfaceMesh meshA;
        String id;
        boolean isReverse;
        String lcaoCartoon = this.sg.setLcao();
        float rotRadians = rotAxis.x + rotAxis.y + rotAxis.z;
        this.defaultColix = Graphics3D.getColix(this.sg.getColor(1));
        int colorNeg = this.sg.getColor(-1);
        Vector3f y = new Vector3f();
        boolean bl = isReverse = lcaoCartoon.length() > 0 && lcaoCartoon.charAt(0) == '-';
        if (isReverse) {
            lcaoCartoon = lcaoCartoon.substring(1);
        }
        int sense = isReverse ? -1 : 1;
        y.cross(z, x);
        if (rotRadians != 0.0f) {
            AxisAngle4f a = new AxisAngle4f();
            if (rotAxis.x != 0.0f) {
                a.set(x, rotRadians);
            } else if (rotAxis.y != 0.0f) {
                a.set(y, rotRadians);
            } else {
                a.set(z, rotRadians);
            }
            Matrix3f m = new Matrix3f();
            m.set(a);
            m.transform(x);
            m.transform(y);
            m.transform(z);
        }
        if (this.thisMesh == null && this.nLCAO == 0) {
            this.nLCAO = this.meshCount;
        }
        String string = id = this.thisMesh == null ? "lcao" + ++this.nLCAO + "_" + lcaoCartoon : this.thisMesh.thisID;
        if (this.thisMesh == null) {
            this.allocMesh(id);
        }
        if (lcaoCartoon.equals("px")) {
            this.thisMesh.thisID = this.thisMesh.thisID + "a";
            meshA = this.thisMesh;
            this.createLcaoLobe(x, sense);
            this.setProperty("thisID", id + "b", null);
            this.createLcaoLobe(x, -sense);
            this.thisMesh.colix = Graphics3D.getColix(colorNeg);
            this.linkedMesh = this.thisMesh.linkedMesh = meshA;
            return;
        }
        if (lcaoCartoon.equals("py")) {
            this.thisMesh.thisID = this.thisMesh.thisID + "a";
            meshA = this.thisMesh;
            this.createLcaoLobe(y, sense);
            this.setProperty("thisID", id + "b", null);
            this.createLcaoLobe(y, -sense);
            this.thisMesh.colix = Graphics3D.getColix(colorNeg);
            this.linkedMesh = this.thisMesh.linkedMesh = meshA;
            return;
        }
        if (lcaoCartoon.equals("pz")) {
            this.thisMesh.thisID = this.thisMesh.thisID + "a";
            meshA = this.thisMesh;
            this.createLcaoLobe(z, sense);
            this.setProperty("thisID", id + "b", null);
            this.createLcaoLobe(z, -sense);
            this.thisMesh.colix = Graphics3D.getColix(colorNeg);
            this.linkedMesh = this.thisMesh.linkedMesh = meshA;
            return;
        }
        if (lcaoCartoon.equals("pxa")) {
            this.createLcaoLobe(x, sense);
            return;
        }
        if (lcaoCartoon.equals("pxb")) {
            this.createLcaoLobe(x, -sense);
            return;
        }
        if (lcaoCartoon.equals("pya")) {
            this.createLcaoLobe(y, sense);
            return;
        }
        if (lcaoCartoon.equals("pyb")) {
            this.createLcaoLobe(y, -sense);
            return;
        }
        if (lcaoCartoon.equals("pza")) {
            this.createLcaoLobe(z, sense);
            return;
        }
        if (lcaoCartoon.equals("pzb")) {
            this.createLcaoLobe(z, -sense);
            return;
        }
        if (lcaoCartoon.indexOf("sp") == 0 || lcaoCartoon.indexOf("lp") == 0) {
            this.createLcaoLobe(z, sense);
            return;
        }
        this.createLcaoLobe(null, 1.0f);
    }

    private void createLcaoLobe(Vector3f lobeAxis, float factor) {
        this.initState();
        if (Logger.debugging) {
            Logger.debug("creating isosurface ID " + this.thisMesh.thisID);
        }
        this.thisMesh.colix = this.defaultColix;
        if (lobeAxis == null) {
            this.setProperty("sphere", new Float(factor / 2.0f), null);
        } else {
            this.lcaoDir.x = lobeAxis.x * factor;
            this.lcaoDir.y = lobeAxis.y * factor;
            this.lcaoDir.z = lobeAxis.z * factor;
            this.lcaoDir.w = 0.7f;
            this.setProperty("lobe", this.lcaoDir, null);
        }
        this.setScriptInfo();
    }

    public void invalidateTriangles() {
        this.thisMesh.invalidateTriangles();
    }

    public void fillMeshData(MeshData meshData, int mode) {
        if (meshData == null) {
            if (this.thisMesh == null) {
                this.allocMesh(null);
            }
            this.thisMesh.clear("isosurface", this.sg.getIAddGridPoints());
            this.thisMesh.colix = this.getDefaultColix();
            if (this.isPhaseColored || this.thisMesh.jvxlData.isBicolorMap) {
                this.thisMesh.isColorSolid = false;
            }
            return;
        }
        switch (mode) {
            case 1: {
                meshData.vertices = this.thisMesh.vertices;
                meshData.vertexValues = this.thisMesh.vertexValues;
                meshData.vertexCount = this.thisMesh.vertexCount;
                meshData.vertexIncrement = this.thisMesh.vertexIncrement;
                meshData.polygonCount = this.thisMesh.polygonCount;
                meshData.polygonIndexes = this.thisMesh.polygonIndexes;
                meshData.polygonColixes = this.thisMesh.polygonColixes;
                return;
            }
            case 2: {
                if (this.thisMesh.vertexColixes == null || this.thisMesh.vertexCount > this.thisMesh.vertexColixes.length) {
                    this.thisMesh.vertexColixes = new short[this.thisMesh.vertexCount];
                }
                meshData.vertexColixes = this.thisMesh.vertexColixes;
                meshData.polygonIndexes = null;
                return;
            }
            case 3: {
                this.thisMesh.surfaceSet = meshData.surfaceSet;
                this.thisMesh.vertexSets = meshData.vertexSets;
                this.thisMesh.nSets = meshData.nSets;
                return;
            }
            case 4: {
                this.thisMesh.vertices = meshData.vertices;
                this.thisMesh.vertexValues = meshData.vertexValues;
                this.thisMesh.vertexCount = meshData.vertexCount;
                this.thisMesh.vertexIncrement = meshData.vertexIncrement;
                this.thisMesh.polygonCount = meshData.polygonCount;
                this.thisMesh.polygonIndexes = meshData.polygonIndexes;
                this.thisMesh.polygonColixes = meshData.polygonColixes;
                return;
            }
        }
    }

    public void notifySurfaceGenerationCompleted() {
        this.setModelIndex();
        this.thisMesh.insideOut = this.sg.isInsideOut();
        this.thisMesh.calculatedVolume = Float.NaN;
        this.thisMesh.calculatedArea = Float.NaN;
        this.thisMesh.initialize(this.sg.getPlane() != null ? 1073741845 : this.lighting);
        if (this.thisMesh.jvxlData.jvxlPlane != null) {
            this.allowContourLines = false;
        }
    }

    public void notifySurfaceMappingCompleted() {
        this.setModelIndex();
        String schemeName = this.colorEncoder.getColorSchemeName();
        this.viewer.setPropertyColorScheme(schemeName, false);
        this.viewer.setCurrentColorRange(this.jvxlData.valueMappedToRed, this.jvxlData.valueMappedToBlue);
        this.thisMesh.isColorSolid = false;
        this.thisMesh.getContours();
        if (this.thisMesh.jvxlData.jvxlPlane != null) {
            this.allowContourLines = false;
        }
        if (this.thisMesh.jvxlData.nContours != 0 && this.thisMesh.jvxlData.nContours != -1) {
            this.explicitContours = true;
        }
        this.setPropertySuper("token", new Integer(this.explicitContours ? 0x40000020 : 0x40000010), null);
        this.setPropertySuper("token", new Integer(this.explicitContours ? 0x40000070 : 1073741954), null);
        this.thisMesh.colorCommand = "color $" + this.thisMesh.thisID + " " + this.getUserColorScheme(schemeName) + " range " + (this.jvxlData.isColorReversed ? this.jvxlData.valueMappedToBlue + " " + this.jvxlData.valueMappedToRed : this.jvxlData.valueMappedToRed + " " + this.jvxlData.valueMappedToBlue);
    }

    public Point3f[] calculateGeodesicSurface(BitSet bsSelected, float envelopeRadius) {
        return this.viewer.calculateSurface(bsSelected, envelopeRadius);
    }

    public int getSurfacePointIndexAndFraction(float cutoff, boolean isCutoffAbsolute, int x, int y, int z, Point3i offset, int vA, int vB, float valueA, float valueB, Point3f pointA, Vector3f edgeVector, boolean isContourType, float[] fReturn) {
        return 0;
    }

    public int addVertexCopy(Point3f vertexXYZ, float value, int assocVertex) {
        return this.thisMesh.addVertexCopy(vertexXYZ, value, assocVertex, this.associateNormals);
    }

    public void addTriangleCheck(int iA, int iB, int iC, int check, boolean isAbsolute, int color) {
        if (isAbsolute && !MeshData.checkCutoff(iA, iB, iC, this.thisMesh.vertexValues)) {
            return;
        }
        this.thisMesh.addTriangleCheck(iA, iB, iC, check, color);
    }

    private void setModelIndex() {
        this.setModelIndex(this.atomIndex, this.modelIndex);
        this.thisMesh.ptCenter.set(this.center);
    }

    protected void setScriptInfo() {
        int pt;
        this.thisMesh.title = this.sg.getTitle();
        String script = this.sg.getScript();
        this.thisMesh.bitsets = null;
        if (script != null) {
            if (script.charAt(0) == ' ') {
                script = this.myType + " ID " + Escape.escape(this.thisMesh.thisID) + script;
            } else if (this.sg.getIUseBitSets()) {
                this.thisMesh.bitsets = new BitSet[3];
                this.thisMesh.bitsets[0] = this.sg.getBsSelected();
                this.thisMesh.bitsets[1] = this.sg.getBsIgnore();
                this.thisMesh.bitsets[2] = this.viewer.getBitSetTrajectories();
            }
        }
        if (!this.explicitID && script != null && (pt = script.indexOf("# ID=")) >= 0) {
            this.thisMesh.thisID = Parser.getNextQuotedString(script, pt);
        }
        this.thisMesh.scriptCommand = script;
        Vector v = this.sg.getFunctionXYinfo();
        if (this.thisMesh.data1 == null) {
            this.thisMesh.data1 = v;
        } else {
            this.thisMesh.data2 = v;
        }
    }

    private void setJvxlInfo() {
        if (this.sg.getJvxlData() != this.jvxlData || this.sg.getJvxlData() != this.thisMesh.jvxlData) {
            this.jvxlData = this.thisMesh.jvxlData = this.sg.getJvxlData();
        }
        this.jvxlData.jvxlDefinitionLine = JvxlReader.jvxlGetDefinitionLine(this.jvxlData, false);
        this.jvxlData.jvxlInfoLine = JvxlReader.jvxlGetDefinitionLine(this.jvxlData, true);
    }

    public Vector getShapeDetail() {
        Vector V = new Vector();
        for (int i = 0; i < this.meshCount; ++i) {
            Hashtable<String, Object> info = new Hashtable<String, Object>();
            IsosurfaceMesh mesh = this.isomeshes[i];
            if (mesh == null) continue;
            info.put("ID", mesh.thisID == null ? "<noid>" : mesh.thisID);
            info.put("vertexCount", new Integer(mesh.vertexCount));
            if (mesh.ptCenter.x != Float.MAX_VALUE) {
                info.put("center", mesh.ptCenter);
            }
            if (mesh.jvxlData.jvxlDefinitionLine != null) {
                info.put("jvxlDefinitionLine", mesh.jvxlData.jvxlDefinitionLine);
            }
            info.put("modelIndex", new Integer(mesh.modelIndex));
            if (mesh.title != null) {
                info.put("title", mesh.title);
            }
            V.addElement(info);
        }
        return V;
    }

    protected void remapColors() {
        JvxlData jvxlData = this.thisMesh.jvxlData;
        float[] vertexValues = this.thisMesh.vertexValues;
        short[] vertexColixes = this.thisMesh.vertexColixes;
        this.thisMesh.polygonColixes = null;
        if (vertexValues == null || jvxlData.isBicolorMap || jvxlData.vertexCount == 0) {
            return;
        }
        if (vertexColixes == null) {
            vertexColixes = this.thisMesh.vertexColixes = new short[this.thisMesh.vertexCount];
        }
        boolean isTranslucent = Graphics3D.isColixTranslucent(this.thisMesh.colix);
        int i = this.thisMesh.vertexCount;
        while (--i >= 0) {
            vertexColixes[i] = this.viewer.getColixForPropertyValue(vertexValues[i]);
            if (!isTranslucent) continue;
            vertexColixes[i] = Graphics3D.getColixTranslucent(vertexColixes[i], true, this.translucentLevel);
        }
        Vector[] contours = this.thisMesh.getContours();
        if (contours != null) {
            int i2 = contours.length;
            while (--i2 >= 0) {
                float value = ((Float)contours[i2].get(2)).floatValue();
                int[] color = (int[])contours[i2].get(3);
                color[0] = this.viewer.getColixArgb(this.viewer.getColixForPropertyValue(value));
            }
        }
        float[] range = this.viewer.getCurrentColorRange();
        jvxlData.valueMappedToRed = Math.min(range[0], range[1]);
        jvxlData.valueMappedToBlue = Math.max(range[0], range[1]);
        jvxlData.isJvxlPrecisionColor = true;
        JvxlReader.jvxlCreateColorData(jvxlData, vertexValues);
        String schemeName = this.viewer.getPropertyColorScheme();
        this.thisMesh.colorCommand = "color $" + this.thisMesh.thisID + " " + this.getUserColorScheme(schemeName) + " range " + range[0] + " " + range[1];
        this.thisMesh.isColorSolid = false;
    }

    private String getUserColorScheme(String schemeName) {
        String colors = this.viewer.getColorSchemeList(schemeName, false);
        return "\"" + (colors.length() == 0 ? schemeName : colors) + "\"";
    }

    public float getValue(int x, int y, int z) {
        return 0.0f;
    }

    public boolean checkObjectHovered(int x, int y, BitSet bsVisible) {
        String s = this.findValue(x, y, false, bsVisible);
        if (s == null) {
            return false;
        }
        if (this.g3d.isDisplayAntialiased()) {
            x <<= 1;
            y <<= 1;
        }
        this.viewer.hoverOn(x, y, s);
        return true;
    }

    private String findValue(int x, int y, boolean isPicking, BitSet bsVisible) {
        int dmin2 = 100;
        if (this.g3d.isAntialiased()) {
            x <<= 1;
            y <<= 1;
            dmin2 <<= 1;
        }
        Vector pickedContour = null;
        for (int i = 0; i < this.meshCount; ++i) {
            IsosurfaceMesh m = this.isomeshes[i];
            if (m.visibilityFlags == 0 || m.modelIndex >= 0 && !bsVisible.get(m.modelIndex)) continue;
            Vector[] vs = m.jvxlData.vContours;
            if (vs != null) {
                for (int j = 0; j < vs.length; ++j) {
                    Vector vc = vs[j];
                    int n = vc.size() - 1;
                    for (int k = 5; k < n; ++k) {
                        Point3f v = (Point3f)vc.get(k);
                        int d2 = this.coordinateInRange(x, y, v, dmin2);
                        if (d2 < 0) continue;
                        dmin2 = d2;
                        pickedContour = vc;
                    }
                }
                if (pickedContour == null) continue;
                return pickedContour.get(2).toString();
            }
            if (m.jvxlData.jvxlPlane == null || m.vertexValues == null) continue;
            int pickedVertex = -1;
            int k = m.vertexCount;
            while (--k >= m.firstRealVertex) {
                Point3f v = m.vertices[k];
                int d2 = this.coordinateInRange(x, y, v, dmin2);
                if (d2 < 0) continue;
                dmin2 = d2;
                pickedVertex = k;
            }
            if (pickedVertex == -1) continue;
            return "v" + pickedVertex + ": " + m.vertexValues[pickedVertex];
        }
        return null;
    }

    private int coordinateInRange(int x, int y, Point3f vertex, int dmin2) {
        int d2 = dmin2;
        this.viewer.transformPoint(vertex, this.ptXY);
        d2 = (x - this.ptXY.x) * (x - this.ptXY.x) + (y - this.ptXY.y) * (y - this.ptXY.y);
        return d2 < dmin2 ? d2 : -1;
    }

    public int getColixArgb(short colix) {
        return this.viewer.getColixArgb(colix);
    }
}

