/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.shape.Mesh;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class IsosurfaceMesh
extends Mesh {
    JvxlData jvxlData = new JvxlData();
    public boolean hideBackground;
    public int realVertexCount;
    public int vertexIncrement = 1;
    public int firstRealVertex = -1;
    public boolean hasGridPoints;
    float calculatedArea = Float.NaN;
    float calculatedVolume = Float.NaN;
    public float[] vertexValues;
    public short[] vertexColixes;
    Hashtable assocGridPointMap;
    Hashtable assocGridPointNormals;
    public short[] polygonColixes;
    private int lastColor;
    private short lastColix;
    private int iA;
    private int iB;
    private int iC;
    public BitSet[] surfaceSet;
    public int[] vertexSets;
    public int nSets = 0;
    public static final int CONTOUR_NPOLYGONS = 0;
    public static final int CONTOUR_BITSET = 1;
    public static final int CONTOUR_VALUE = 2;
    public static final int CONTOUR_COLOR = 3;
    public static final int CONTOUR_FDATA = 4;
    public static final int CONTOUR_POINTS = 5;

    IsosurfaceMesh(String thisID, Graphics3D g3d, short colix) {
        super(thisID, g3d, colix);
        this.haveCheckByte = true;
        this.jvxlData.version = Viewer.getJmolVersion();
    }

    void clear(String meshType, boolean iAddGridPoints) {
        super.clear(meshType);
        this.isColorSolid = true;
        this.vertexColixes = null;
        this.vertexValues = null;
        this.assocGridPointMap = null;
        this.assocGridPointNormals = null;
        this.vertexSets = null;
        this.firstRealVertex = -1;
        this.hasGridPoints = iAddGridPoints;
        this.showPoints = iAddGridPoints;
        this.jvxlData.jvxlSurfaceData = "";
        this.jvxlData.jvxlEdgeData = "";
        this.jvxlData.jvxlColorData = "";
        this.jvxlData.vContours = null;
        this.surfaceSet = null;
        this.nSets = 0;
    }

    void allocVertexColixes() {
        if (this.vertexColixes == null) {
            this.vertexColixes = new short[this.vertexCount];
            int i = this.vertexCount;
            while (--i >= 0) {
                this.vertexColixes[i] = this.colix;
            }
        }
        this.isColorSolid = false;
    }

    public void setColorSchemeSets() {
        this.allocVertexColixes();
        int n = 2;
        for (int i = 0; i < this.surfaceSet.length; ++i) {
            if (this.surfaceSet[i] == null) continue;
            int c = Graphics3D.getColorArgb(n++);
            short colix = Graphics3D.getColix(c);
            for (int j = 0; j < this.vertexCount; ++j) {
                if (!this.surfaceSet[i].get(j)) continue;
                this.vertexColixes[j] = colix;
            }
        }
    }

    int addVertexCopy(Point3f vertex, float value, int assocVertex, boolean associateNormals) {
        int vPt = this.addVertexCopy(vertex, value);
        switch (assocVertex) {
            case -1: {
                if (this.firstRealVertex >= 0) break;
                this.firstRealVertex = vPt;
                break;
            }
            case -2: {
                this.hasGridPoints = true;
                break;
            }
            case -3: {
                this.vertexIncrement = 3;
                break;
            }
            default: {
                if (this.firstRealVertex < 0) {
                    this.firstRealVertex = vPt;
                }
                if (!associateNormals) break;
                if (this.assocGridPointMap == null) {
                    this.assocGridPointMap = new Hashtable();
                    this.assocGridPointNormals = new Hashtable();
                }
                Integer key = new Integer(assocVertex);
                this.assocGridPointMap.put(new Integer(vPt), key);
                if (this.assocGridPointNormals.containsKey(key)) break;
                this.assocGridPointNormals.put(key, new Vector3f(0.0f, 0.0f, 0.0f));
            }
        }
        return vPt;
    }

    int addVertexCopy(Point3f vertex, float value) {
        if (this.vertexCount == 0) {
            this.vertexValues = new float[25];
        } else if (this.vertexCount >= this.vertexValues.length) {
            this.vertexValues = ArrayUtil.doubleLength(this.vertexValues);
        }
        this.vertexValues[this.vertexCount] = value;
        return this.addVertexCopy(vertex);
    }

    public void setTranslucent(boolean isTranslucent, float iLevel) {
        super.setTranslucent(isTranslucent, iLevel);
        if (this.vertexColixes != null) {
            int i = this.vertexCount;
            while (--i >= 0) {
                this.vertexColixes[i] = Graphics3D.getColixTranslucent(this.vertexColixes[i], isTranslucent, iLevel);
            }
        }
    }

    void addTriangleCheck(int vertexA, int vertexB, int vertexC, int check, int color) {
        if (this.vertices == null || this.vertexValues != null && (Float.isNaN(this.vertexValues[vertexA]) || Float.isNaN(this.vertexValues[vertexB]) || Float.isNaN(this.vertexValues[vertexC]))) {
            return;
        }
        if (Float.isNaN(this.vertices[vertexA].x) || Float.isNaN(this.vertices[vertexB].x) || Float.isNaN(this.vertices[vertexC].x)) {
            return;
        }
        if (this.polygonCount == 0) {
            this.polygonIndexes = new int[25][];
        } else if (this.polygonCount == this.polygonIndexes.length) {
            this.polygonIndexes = (int[][])ArrayUtil.doubleLength(this.polygonIndexes);
        }
        if (color != 0) {
            short s;
            if (this.polygonColixes == null) {
                this.polygonColixes = new short[25];
                this.lastColor = 0;
            } else if (this.polygonCount == this.polygonColixes.length) {
                this.polygonColixes = ArrayUtil.doubleLength(this.polygonColixes);
            }
            if (color == this.lastColor) {
                s = this.lastColix;
            } else {
                this.lastColor = color;
                s = this.lastColix = Graphics3D.getColix(this.lastColor);
            }
            this.polygonColixes[this.polygonCount] = s;
        }
        this.polygonIndexes[this.polygonCount++] = new int[]{vertexA, vertexB, vertexC, check};
    }

    void invalidateTriangles() {
        int i = this.polygonCount;
        while (--i >= 0) {
            if (this.setABC(i)) continue;
            this.polygonIndexes[i] = null;
        }
    }

    private boolean setABC(int i) {
        int[] vertexIndexes = this.polygonIndexes[i];
        return vertexIndexes != null && !Float.isNaN(this.vertexValues[this.iA = vertexIndexes[0]]) && !Float.isNaN(this.vertexValues[this.iB = vertexIndexes[1]]) && !Float.isNaN(this.vertexValues[this.iC = vertexIndexes[2]]);
    }

    float calculateArea() {
        if (!Float.isNaN(this.calculatedArea)) {
            return this.calculatedArea;
        }
        double v = 0.0;
        int i = this.polygonCount;
        while (--i >= 0) {
            if (!this.setABC(i)) continue;
            this.vAB.sub(this.vertices[this.iB], this.vertices[this.iA]);
            this.vAC.sub(this.vertices[this.iC], this.vertices[this.iA]);
            this.vTemp.cross(this.vAB, this.vAC);
            v += (double)this.vTemp.length();
        }
        this.calculatedArea = (float)(v / 2.0);
        return this.calculatedArea;
    }

    float calculateVolume() {
        if (!Float.isNaN(this.calculatedVolume)) {
            return this.calculatedVolume;
        }
        double v = 0.0;
        int i = this.polygonCount;
        while (--i >= 0) {
            if (!this.setABC(i)) continue;
            this.vAB.set(this.vertices[this.iB]);
            this.vAC.set(this.vertices[this.iC]);
            this.vTemp.cross(this.vAB, this.vAC);
            this.vAC.set(this.vertices[this.iA]);
            v += (double)this.vAC.dot(this.vTemp);
        }
        this.calculatedVolume = (float)(v / 6.0);
        return this.calculatedVolume;
    }

    public void sumVertexNormals(Vector3f[] vectorSums) {
        super.sumVertexNormals(vectorSums);
        if (this.assocGridPointMap != null) {
            Integer I;
            Enumeration e = this.assocGridPointMap.keys();
            while (e.hasMoreElements()) {
                I = (Integer)e.nextElement();
                ((Vector3f)this.assocGridPointNormals.get(this.assocGridPointMap.get(I))).add(vectorSums[I]);
            }
            e = this.assocGridPointMap.keys();
            while (e.hasMoreElements()) {
                I = (Integer)e.nextElement();
                vectorSums[I.intValue()] = (Vector3f)this.assocGridPointNormals.get(this.assocGridPointMap.get(I));
            }
        }
    }

    Vector[] getContours() {
        Vector[] vContours;
        int n = this.jvxlData.nContours;
        if (n == 0 || this.polygonIndexes == null) {
            return null;
        }
        this.havePlanarContours = this.jvxlData.jvxlPlane != null;
        if (this.havePlanarContours) {
            return null;
        }
        if (n < 0) {
            n = -1 - n;
        }
        if ((vContours = this.jvxlData.vContours) != null) {
            for (int i = 0; i < n; ++i) {
                if (vContours[i].size() > 5) {
                    return this.jvxlData.vContours;
                }
                JvxlReader.set3dContourVector(vContours[i], this.polygonIndexes, this.vertices);
            }
            this.dumpData();
            return this.jvxlData.vContours;
        }
        this.dumpData();
        vContours = new Vector[n];
        for (int i = 0; i < n; ++i) {
            vContours[i] = new Vector();
        }
        float dv = (this.jvxlData.valueMappedToBlue - this.jvxlData.valueMappedToRed) / (float)(n + 1);
        for (int i = 0; i < n; ++i) {
            float value = this.jvxlData.valueMappedToRed + (float)(i + 1) * dv;
            this.get3dContour(vContours[i], value, this.jvxlData.contourColors[i]);
        }
        Logger.info(n + " contour lines; separation = " + dv);
        this.jvxlData.vContours = vContours;
        return vContours;
    }

    public static void setContourVector(Vector v, int nPolygons, BitSet bsContour, float value, int color, StringBuffer fData) {
        v.add(new Integer(nPolygons));
        v.add(bsContour);
        v.add(new Float(value));
        v.add(new int[]{color});
        v.add(fData);
    }

    private void get3dContour(Vector v, float value, int color) {
        BitSet bsContour = new BitSet(this.polygonCount);
        StringBuffer fData = new StringBuffer();
        IsosurfaceMesh.setContourVector(v, this.polygonCount, bsContour, value, color, fData);
        block4: for (int i = 0; i < this.polygonCount; ++i) {
            float f2;
            if (!this.setABC(i)) continue;
            int type = 0;
            float f1 = this.checkPt(this.iA, this.iB, value);
            if (!Float.isNaN(f1)) {
                type |= 1;
                v.add(IsosurfaceMesh.getContourPoint(this.vertices, this.iA, this.iB, f1));
            }
            if (!Float.isNaN(f2 = this.checkPt(this.iB, this.iC, value))) {
                if (type == 0) {
                    f1 = f2;
                }
                type |= 2;
                v.add(IsosurfaceMesh.getContourPoint(this.vertices, this.iB, this.iC, f2));
            }
            switch (type) {
                case 0: {
                    continue block4;
                }
                case 3: {
                    break;
                }
                default: {
                    f2 = this.checkPt(this.iC, this.iA, value);
                    type |= 4;
                    v.add(IsosurfaceMesh.getContourPoint(this.vertices, this.iC, this.iA, f2));
                }
            }
            bsContour.set(i);
            fData.append(type);
            fData.append(JvxlReader.jvxlFractionAsCharacter(f1));
            fData.append(JvxlReader.jvxlFractionAsCharacter(f2));
        }
        v.add(new Point3f(Float.NaN, Float.NaN, Float.NaN));
    }

    private float checkPt(int i, int j, float f) {
        float f2;
        float f3;
        float f1 = this.vertexValues[i];
        float f22 = this.vertexValues[j];
        return f3 <= f == f < f2 ? (f - f1) / (f22 - f1) : Float.NaN;
    }

    public static Point3f getContourPoint(Point3f[] vertices, int i, int j, float f) {
        Point3f pt = new Point3f();
        pt.set(vertices[j]);
        pt.sub(vertices[i]);
        pt.scale(f);
        pt.add(vertices[i]);
        return pt;
    }

    private void dumpData() {
    }
}

