/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import java.util.BitSet;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.ModelSet;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesMolecule;
import org.jmol.smiles.SmilesParser;
import org.jmol.viewer.JmolConstants;

public class PatternMatcher
implements SmilesMatcherInterface {
    private int atomCount;
    private ModelSet modelSet;

    public void setModelSet(ModelSet modelSet) {
        this.modelSet = modelSet;
        this.atomCount = modelSet == null ? 0 : modelSet.getAtomCount();
    }

    public BitSet getSubstructureSet(String smiles) throws Exception {
        SmilesParser parser = new SmilesParser();
        SmilesMolecule pattern = parser.parseSmiles(smiles);
        return this.getSubstructureSet(pattern);
    }

    public BitSet getSubstructureSet(SmilesMolecule pattern) {
        BitSet bsSubstructure = new BitSet();
        this.searchMatch(bsSubstructure, pattern, 0);
        return bsSubstructure;
    }

    private void searchMatch(BitSet bs, SmilesMolecule pattern, int atomNum) {
        int i;
        SmilesAtom patternAtom = pattern.getAtom(atomNum);
        for (i = 0; i < patternAtom.getBondsCount(); ++i) {
            SmilesBond patternBond = patternAtom.getBond(i);
            if (patternBond.getAtom2() != patternAtom) continue;
            int matchingAtom = patternBond.getAtom1().getMatchingAtom();
            Atom atom = this.modelSet.getAtomAt(matchingAtom);
            Bond[] bonds = atom.getBonds();
            if (bonds != null) {
                for (int j = 0; j < bonds.length; ++j) {
                    if (bonds[j].getAtomIndex1() == matchingAtom) {
                        this.searchMatch(bs, pattern, patternAtom, atomNum, bonds[j].getAtomIndex2());
                    }
                    if (bonds[j].getAtomIndex2() != matchingAtom) continue;
                    this.searchMatch(bs, pattern, patternAtom, atomNum, bonds[j].getAtomIndex1());
                }
            }
            return;
        }
        for (i = 0; i < this.atomCount; ++i) {
            this.searchMatch(bs, pattern, patternAtom, atomNum, i);
        }
    }

    private void searchMatch(BitSet bs, SmilesMolecule pattern, SmilesAtom patternAtom, int atomNum, int i) {
        short isotopeMass;
        for (int j = 0; j < atomNum; ++j) {
            SmilesAtom previousAtom = pattern.getAtom(j);
            if (previousAtom.getMatchingAtom() != i) continue;
            return;
        }
        Atom atom = this.modelSet.getAtomAt(i);
        String targetSym = patternAtom.getSymbol();
        short n = atom.getElementNumber();
        if (targetSym != "*" && targetSym != JmolConstants.elementSymbolFromNumber(n)) {
            return;
        }
        int targetMass = patternAtom.getAtomicMass();
        if (targetMass > 0 && (isotopeMass = atom.getIsotopeNumber()) != targetMass) {
            return;
        }
        if (patternAtom.getCharge() != atom.getFormalCharge()) {
            return;
        }
        for (int j = 0; j < patternAtom.getBondsCount(); ++j) {
            SmilesBond patternBond = patternAtom.getBond(j);
            if (patternBond.getAtom2() != patternAtom) continue;
            int matchingAtom = patternBond.getAtom1().getMatchingAtom();
            Bond[] bonds = atom.getBonds();
            boolean bondFound = false;
            block9: for (int k = 0; k < bonds.length; ++k) {
                if (bonds[k].getAtomIndex1() != matchingAtom && bonds[k].getAtomIndex2() != matchingAtom) continue;
                switch (patternBond.getBondType()) {
                    case 4: {
                        if ((bonds[k].getOrder() & 0x200) == 0) continue block9;
                        bondFound = true;
                        continue block9;
                    }
                    case 2: {
                        if ((bonds[k].getOrder() & 2) == 0) continue block9;
                        bondFound = true;
                        continue block9;
                    }
                    case 1: 
                    case 5: 
                    case 6: {
                        if ((bonds[k].getOrder() & 1) == 0) continue block9;
                        bondFound = true;
                        continue block9;
                    }
                    case 3: {
                        if ((bonds[k].getOrder() & 3) == 0) continue block9;
                        bondFound = true;
                        continue block9;
                    }
                    case -1: {
                        bondFound = true;
                    }
                }
            }
            if (bondFound) continue;
            return;
        }
        patternAtom.setMatchingAtom(i);
        if (atomNum + 1 < pattern.getAtomsCount()) {
            this.searchMatch(bs, pattern, atomNum + 1);
        } else {
            for (int k = 0; k < pattern.getAtomsCount(); ++k) {
                SmilesAtom matching = pattern.getAtom(k);
                bs.set(matching.getMatchingAtom());
            }
        }
        patternAtom.setMatchingAtom(-1);
    }
}

