/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import org.jmol.smiles.SmilesAtom;

public class SmilesBond {
    public static final int TYPE_UNKOWN = -1;
    public static final int TYPE_NONE = 0;
    public static final int TYPE_SINGLE = 1;
    public static final int TYPE_DOUBLE = 2;
    public static final int TYPE_TRIPLE = 3;
    public static final int TYPE_AROMATIC = 4;
    public static final int TYPE_DIRECTIONAL_1 = 5;
    public static final int TYPE_DIRECTIONAL_2 = 6;
    public static final char CODE_NONE = '.';
    public static final char CODE_SINGLE = '-';
    public static final char CODE_DOUBLE = '=';
    public static final char CODE_TRIPLE = '#';
    public static final char CODE_AROMATIC = ':';
    public static final char CODE_DIRECTIONAL_1 = '/';
    public static final char CODE_DIRECTIONAL_2 = '\\';
    private SmilesAtom atom1;
    private SmilesAtom atom2;
    private int bondType;

    public SmilesBond(SmilesAtom atom1, SmilesAtom atom2, int bondType) {
        this.atom1 = atom1;
        this.atom2 = atom2;
        this.bondType = bondType;
    }

    public static int getBondTypeFromCode(char code) {
        switch (code) {
            case '.': {
                return 0;
            }
            case '-': {
                return 1;
            }
            case '=': {
                return 2;
            }
            case '#': {
                return 3;
            }
            case ':': {
                return 4;
            }
            case '/': {
                return 5;
            }
            case '\\': {
                return 6;
            }
        }
        return -1;
    }

    public SmilesAtom getAtom1() {
        return this.atom1;
    }

    public void setAtom1(SmilesAtom atom) {
        this.atom1 = atom;
    }

    public SmilesAtom getAtom2() {
        return this.atom2;
    }

    public void setAtom2(SmilesAtom atom) {
        this.atom2 = atom;
    }

    public int getBondType() {
        return this.bondType;
    }

    public void setBondType(int bondType) {
        this.bondType = bondType;
    }
}

