/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import javax.vecmath.Matrix4f;
import javax.vecmath.Point3i;
import org.jmol.symmetry.Rotation;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.symmetry.Translation;
import org.jmol.util.Logger;

class HallInfo {
    String hallSymbol;
    String primitiveHallSymbol;
    char latticeCode;
    String latticeExtension;
    boolean isCentrosymmetric;
    int nRotations;
    RotationTerm[] rotationTerms = new RotationTerm[16];
    Point3i vector12ths;
    String vectorCode;

    HallInfo(String hallSymbol) {
        try {
            String str = this.hallSymbol = hallSymbol.trim();
            str = this.extractLatticeInfo(str);
            if (Translation.getLatticeIndex(this.latticeCode) == 0) {
                return;
            }
            this.latticeExtension = Translation.getLatticeExtension(this.latticeCode, this.isCentrosymmetric);
            str = this.extractVectorInfo(str) + this.latticeExtension;
            Logger.info("Hallinfo: " + hallSymbol + " " + str);
            int prevOrder = 0;
            char prevAxisType = '\u0000';
            this.primitiveHallSymbol = "P";
            while (str.length() > 0 && this.nRotations < 16) {
                str = this.extractRotationInfo(str, prevOrder, prevAxisType);
                RotationTerm r = this.rotationTerms[this.nRotations - 1];
                prevOrder = r.order;
                prevAxisType = r.axisType;
                this.primitiveHallSymbol = this.primitiveHallSymbol + " " + r.primitiveCode;
            }
            this.primitiveHallSymbol = this.primitiveHallSymbol + this.vectorCode;
        }
        catch (Exception e) {
            Logger.error("Invalid Hall symbol");
            this.nRotations = 0;
        }
    }

    String dumpInfo() {
        StringBuffer sb = new StringBuffer("\nHall symbol: ").append(this.hallSymbol).append("\nprimitive Hall symbol: ").append(this.primitiveHallSymbol).append("\nlattice type: ").append(this.getLatticeDesignation());
        for (int i = 0; i < this.nRotations; ++i) {
            sb.append("\n\nrotation term ").append(i + 1).append(this.rotationTerms[i].dumpInfo());
        }
        return sb.toString();
    }

    private String getLatticeDesignation() {
        return Translation.getLatticeDesignation(this.latticeCode, this.isCentrosymmetric);
    }

    private String extractLatticeInfo(String name) {
        int i = name.indexOf(" ");
        if (i < 0) {
            return "";
        }
        String term = name.substring(0, i).toUpperCase();
        this.latticeCode = term.charAt(0);
        if (this.latticeCode == '-') {
            this.isCentrosymmetric = true;
            this.latticeCode = term.charAt(1);
        }
        return name.substring(i + 1).trim();
    }

    private String extractVectorInfo(String name) {
        this.vector12ths = new Point3i();
        this.vectorCode = "";
        int i = name.indexOf("(");
        int j = name.indexOf(")", i);
        if (i > 0 && j > i) {
            String term = name.substring(i + 1, j);
            this.vectorCode = " (" + term + ")";
            name = name.substring(0, i).trim();
            i = term.indexOf(" ");
            if (i >= 0) {
                this.vector12ths.x = Integer.parseInt(term.substring(0, i));
                if ((i = (term = term.substring(i + 1).trim()).indexOf(" ")) >= 0) {
                    this.vector12ths.y = Integer.parseInt(term.substring(0, i));
                    term = term.substring(i + 1).trim();
                }
            }
            this.vector12ths.z = Integer.parseInt(term);
        }
        return name;
    }

    private String extractRotationInfo(String name, int prevOrder, char prevAxisType) {
        String code;
        int i = name.indexOf(" ");
        if (i >= 0) {
            code = name.substring(0, i);
            name = name.substring(i + 1).trim();
        } else {
            code = name;
            name = "";
        }
        this.rotationTerms[this.nRotations] = new RotationTerm(code, prevOrder, prevAxisType);
        ++this.nRotations;
        return name;
    }

    class RotationTerm {
        String inputCode;
        String primitiveCode;
        String lookupCode;
        String translationString;
        Rotation rotation;
        Translation translation;
        Matrix4f seitzMatrix12ths = new Matrix4f();
        boolean isImproper;
        int order;
        char axisType;
        char diagonalReferenceAxis;
        boolean allPositive = true;

        RotationTerm() {
        }

        RotationTerm(String code, int prevOrder, char prevAxisType) {
            this.getRotationInfo(code, prevOrder, prevAxisType);
        }

        String dumpInfo() {
            StringBuffer sb = new StringBuffer("\ninput code: ").append(this.inputCode).append("; primitive code: ").append(this.primitiveCode).append("\norder: ").append(this.order).append(this.isImproper ? " (improper axis)" : "");
            if (this.axisType != '_') {
                sb.append("; axisType: ").append(this.axisType);
                if (this.diagonalReferenceAxis != '\u0000') {
                    sb.append(this.diagonalReferenceAxis);
                }
            }
            if (this.translationString.length() > 0) {
                sb.append("; translation: ").append(this.translationString);
            }
            if (HallInfo.this.vectorCode.length() > 0) {
                sb.append("; vector offset:").append(HallInfo.this.vectorCode);
            }
            if (this.rotation != null) {
                sb.append("\noperator: ").append(this.getXYZ(this.allPositive)).append("\nSeitz matrix:\n").append(SymmetryOperation.dumpSeitz(this.seitzMatrix12ths));
            }
            return sb.toString();
        }

        String getXYZ(boolean allPositive) {
            return SymmetryOperation.getXYZFromMatrix(this.seitzMatrix12ths, allPositive);
        }

        private void getRotationInfo(String code, int prevOrder, char prevAxisType) {
            this.inputCode = code;
            if ((code = code + "   ").charAt(0) == '-') {
                this.isImproper = true;
                code = code.substring(1);
            }
            this.primitiveCode = "";
            this.order = code.charAt(0) - 48;
            this.diagonalReferenceAxis = '\u0000';
            this.axisType = '\u0000';
            int ptr = 2;
            char c = code.charAt(1);
            block0 : switch (c) {
                case 'x': 
                case 'y': 
                case 'z': {
                    switch (code.charAt(2)) {
                        case '\"': 
                        case '\'': {
                            this.diagonalReferenceAxis = c;
                            c = code.charAt(2);
                            ++ptr;
                        }
                    }
                }
                case '*': {
                    this.axisType = c;
                    break;
                }
                case '\"': 
                case '\'': {
                    this.axisType = c;
                    switch (code.charAt(2)) {
                        case 'x': 
                        case 'y': 
                        case 'z': {
                            this.diagonalReferenceAxis = code.charAt(2);
                            ++ptr;
                            break block0;
                        }
                    }
                    this.diagonalReferenceAxis = prevAxisType;
                    break;
                }
                default: {
                    this.axisType = (char)(this.order == 1 ? 95 : (HallInfo.this.nRotations == 0 ? 122 : (HallInfo.this.nRotations == 2 ? 42 : (prevOrder == 2 || prevOrder == 4 ? 120 : 39))));
                    code = code.substring(0, 1) + this.axisType + code.substring(1);
                }
            }
            this.primitiveCode = this.primitiveCode + (this.axisType == '_' ? "1" : code.substring(0, 2));
            if (this.diagonalReferenceAxis != '\u0000') {
                code = code.substring(0, 1) + this.diagonalReferenceAxis + this.axisType + code.substring(ptr);
                this.primitiveCode = this.primitiveCode + this.diagonalReferenceAxis;
                ptr = 3;
            }
            this.lookupCode = code.substring(0, ptr);
            this.rotation = Rotation.lookup(this.lookupCode);
            if (this.rotation == null) {
                Logger.error("Rotation lookup could not find " + this.inputCode + " ? " + this.lookupCode);
                return;
            }
            this.translation = new Translation();
            this.translationString = "";
            int len = code.length();
            for (int i = ptr; i < len; ++i) {
                char translationCode = code.charAt(i);
                Translation t = new Translation(translationCode, this.order);
                if (t.translationCode == '\u0000') continue;
                this.translationString = this.translationString + "" + t.translationCode;
                this.translation.rotationShift12ths += t.rotationShift12ths;
                this.translation.vectorShift12ths.add(t.vectorShift12ths);
            }
            this.primitiveCode = (this.isImproper ? "-" : "") + this.primitiveCode + this.translationString;
            if (this.isImproper) {
                this.seitzMatrix12ths.set(this.rotation.seitzMatrixInv);
            } else {
                this.seitzMatrix12ths.set(this.rotation.seitzMatrix);
            }
            this.seitzMatrix12ths.m03 = this.translation.vectorShift12ths.x;
            this.seitzMatrix12ths.m13 = this.translation.vectorShift12ths.y;
            this.seitzMatrix12ths.m23 = this.translation.vectorShift12ths.z;
            switch (this.axisType) {
                case 'x': {
                    this.seitzMatrix12ths.m03 += (float)this.translation.rotationShift12ths;
                    break;
                }
                case 'y': {
                    this.seitzMatrix12ths.m13 += (float)this.translation.rotationShift12ths;
                    break;
                }
                case 'z': {
                    this.seitzMatrix12ths.m23 += (float)this.translation.rotationShift12ths;
                }
            }
            if (HallInfo.this.vectorCode.length() > 0) {
                Matrix4f m1 = new Matrix4f();
                Matrix4f m2 = new Matrix4f();
                m1.setIdentity();
                m2.setIdentity();
                m1.m03 = HallInfo.this.vector12ths.x;
                m1.m13 = HallInfo.this.vector12ths.y;
                m1.m23 = HallInfo.this.vector12ths.z;
                m2.m03 = -HallInfo.this.vector12ths.x;
                m2.m13 = -HallInfo.this.vector12ths.y;
                m2.m23 = -HallInfo.this.vector12ths.z;
                this.seitzMatrix12ths.mul(m1, this.seitzMatrix12ths);
                this.seitzMatrix12ths.mul(m2);
            }
            if (Logger.debugging) {
                Logger.debug("code = " + code + "; primitive code =" + this.primitiveCode + "\n Seitz Matrix(12ths):" + this.seitzMatrix12ths);
            }
        }
    }
}

