/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.BitSet;
import java.util.Hashtable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.api.SymmetryInterface;
import org.jmol.modelset.Atom;
import org.jmol.symmetry.PointGroup;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.SymmetryInfo;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.Logger;

public class Symmetry
implements SymmetryInterface {
    private PointGroup pointGroup;
    private SpaceGroup spaceGroup;
    private SymmetryInfo symmetryInfo;
    private UnitCell unitCell;

    public SymmetryInterface setPointGroup(SymmetryInterface siLast, Atom[] atomset, BitSet bsAtoms, boolean haveVibration, float distanceTolerance, float linearTolerance) {
        this.pointGroup = PointGroup.getPointGroup(siLast == null ? null : ((Symmetry)siLast).pointGroup, atomset, bsAtoms, haveVibration, distanceTolerance, linearTolerance);
        return this;
    }

    public String getPointGroupName() {
        return this.pointGroup.getName();
    }

    public Object getPointGroupInfo(int modelIndex, boolean asDraw, boolean asInfo, String type, int index, float scale) {
        if (!asDraw && !asInfo && this.pointGroup.textInfo != null) {
            return this.pointGroup.textInfo;
        }
        if (asDraw && this.pointGroup.isDrawType(type, index)) {
            return this.pointGroup.drawInfo;
        }
        if (asInfo && this.pointGroup.info != null) {
            return this.pointGroup.info;
        }
        return this.pointGroup.getInfo(modelIndex, asDraw, asInfo, type, index, scale);
    }

    public void setSpaceGroup(boolean doNormalize) {
        if (this.spaceGroup == null) {
            this.spaceGroup = new SpaceGroup(doNormalize);
        }
    }

    public boolean addSpaceGroupOperation(String xyz) {
        return this.spaceGroup.addSymmetry(xyz);
    }

    public void setLattice(int latt) {
        this.spaceGroup.setLattice(latt);
    }

    public String getSpaceGroupName() {
        return this.symmetryInfo != null ? this.symmetryInfo.spaceGroup : (this.spaceGroup != null ? this.spaceGroup.getName() : "");
    }

    public Object getSpaceGroup() {
        return this.spaceGroup;
    }

    public void setSpaceGroup(SymmetryInterface symmetry) {
        this.spaceGroup = symmetry == null ? null : (SpaceGroup)symmetry.getSpaceGroup();
    }

    public boolean createSpaceGroup(int desiredSpaceGroupIndex, String name, float[] notionalUnitCell, boolean doNormalize) {
        this.spaceGroup = SpaceGroup.createSpaceGroup(desiredSpaceGroupIndex, name, notionalUnitCell, doNormalize);
        if (this.spaceGroup != null && Logger.debugging) {
            Logger.debug("using generated space group " + this.spaceGroup.dumpInfo());
        }
        return this.spaceGroup != null;
    }

    public boolean haveSpaceGroup() {
        return this.spaceGroup != null;
    }

    public int determineSpaceGroupIndex(String name) {
        return SpaceGroup.determineSpaceGroupIndex(name);
    }

    public String getSpaceGroupInfo(String name, float[] unitCell) {
        return SpaceGroup.getInfo(name, unitCell);
    }

    public Object getLatticeDesignation() {
        return this.spaceGroup.getLatticeDesignation();
    }

    public void setFinalOperations(Point3f[] atoms, int iAtomFirst, int noSymmetryCount, boolean doNormalize) {
        this.spaceGroup.setFinalOperations(atoms, iAtomFirst, noSymmetryCount, doNormalize);
    }

    public int getSpaceGroupOperationCount() {
        return this.spaceGroup.finalOperations.length;
    }

    public Matrix4f getSpaceGroupOperation(int i) {
        return this.spaceGroup.finalOperations[i];
    }

    public String getSpaceGroupXyz(int i, boolean doNormalize) {
        return this.spaceGroup.finalOperations[i].getXyz(doNormalize);
    }

    public void newSpaceGroupPoint(int i, Point3f atom1, Point3f atom2, int transX, int transY, int transZ) {
        this.spaceGroup.finalOperations[i].newPoint(atom1, atom2, transX, transY, transZ);
    }

    public Object rotateEllipsoid(int i, Point3f ptTemp, Vector3f[] axes, Point3f ptTemp1, Point3f ptTemp2) {
        return this.spaceGroup.finalOperations[i].rotateEllipsoid(ptTemp, axes, this.unitCell, ptTemp1, ptTemp2);
    }

    public boolean haveUnitCell() {
        return this.unitCell != null;
    }

    public String getUnitsymmetryInfo() {
        return this.unitCell == null ? "no unit cell information" : this.unitCell.dumpInfo(false);
    }

    public void setUnitCell(float[] notionalUnitCell) {
        this.unitCell = new UnitCell(notionalUnitCell);
    }

    public void toCartesian(Point3f pt) {
        if (this.unitCell == null) {
            return;
        }
        this.unitCell.toCartesian(pt);
    }

    public Object[] getEllipsoid(float[] parBorU) {
        return this.unitCell.getEllipsoid(parBorU);
    }

    public Point3f ijkToPoint3f(int nnn) {
        return UnitCell.ijkToPoint3f(nnn);
    }

    public void toFractional(Point3f pt) {
        if (this.unitCell != null) {
            this.unitCell.toFractional(pt);
        }
    }

    public Point3f[] getUnitCellVertices() {
        return this.unitCell.getVertices();
    }

    public Point3f getCartesianOffset() {
        return this.unitCell.getCartesianOffset();
    }

    public float[] getNotionalUnitCell() {
        return this.unitCell == null ? null : this.unitCell.getNotionalUnitCell();
    }

    public void toUnitCell(Point3f pt, Point3f offset) {
        if (this.unitCell != null) {
            this.unitCell.toUnitCell(pt, offset);
        }
    }

    public void setUnitCellOffset(Point3f pt) {
        this.unitCell.setOffset(pt);
    }

    public void setOffset(int nnn) {
        this.unitCell.setOffset(nnn);
    }

    public Point3f getFractionalOffset() {
        return this.unitCell.getFractionalOffset();
    }

    public float getUnitsymmetryInfo(int infoType) {
        return this.unitCell.getInfo(infoType);
    }

    public int getModelIndex() {
        return this.symmetryInfo.modelIndex;
    }

    public void setModelIndex(int i) {
        this.symmetryInfo.modelIndex = i;
    }

    public boolean getCoordinatesAreFractional() {
        return this.symmetryInfo.coordinatesAreFractional;
    }

    public int[] getCellRange() {
        return this.symmetryInfo.cellRange;
    }

    public String getSymmetryInfoString() {
        return this.symmetryInfo.symmetryInfoString;
    }

    public String[] getSymmetryOperations() {
        return this.symmetryInfo.symmetryOperations;
    }

    public boolean isPeriodic() {
        return this.symmetryInfo.isPeriodic();
    }

    public void setSymmetryInfo(int modelIndex, Hashtable modelAuxiliaryInfo) {
        this.symmetryInfo = new SymmetryInfo();
        float[] notionalUnitcell = this.symmetryInfo.setSymmetryInfo(modelIndex, modelAuxiliaryInfo);
        if (notionalUnitcell == null) {
            return;
        }
        this.setUnitCell(notionalUnitcell);
        if (Logger.debugging) {
            Logger.debug("symmetryInfos[" + modelIndex + "]:\n" + this.unitCell.dumpInfo(true));
        }
    }

    public float getUnitCellInfo(int infoType) {
        return this.unitCell.getInfo(infoType);
    }

    public String getUnitCellInfo() {
        return this.unitCell == null ? "no unit cell information" : this.unitCell.dumpInfo(false);
    }
}

