/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.util.Quadric;

class UnitCell {
    static final float toRadians = (float)Math.PI / 180;
    static final Point3f[] unitCubePoints = new Point3f[]{new Point3f(0.0f, 0.0f, 0.0f), new Point3f(0.0f, 0.0f, 1.0f), new Point3f(0.0f, 1.0f, 0.0f), new Point3f(0.0f, 1.0f, 1.0f), new Point3f(1.0f, 0.0f, 0.0f), new Point3f(1.0f, 0.0f, 1.0f), new Point3f(1.0f, 1.0f, 0.0f), new Point3f(1.0f, 1.0f, 1.0f)};
    float a;
    float b;
    float c;
    float alpha;
    float beta;
    float gamma;
    boolean isPrimitive;
    float[] notionalUnitcell;
    private Matrix4f matrixCartesianToFractional;
    private Matrix4f matrixFractionalToCartesian;
    private Point3f[] vertices;
    private Point3f cartesianOffset = new Point3f();
    private Point3f fractionalOffset = new Point3f();
    private Data data;

    UnitCell(float[] notionalUnitcell) {
        this.setUnitCell(notionalUnitcell);
    }

    final void toCartesian(Point3f pt) {
        if (this.matrixFractionalToCartesian == null) {
            return;
        }
        this.matrixFractionalToCartesian.transform(pt);
    }

    final void toFractional(Point3f pt) {
        if (this.matrixCartesianToFractional == null) {
            return;
        }
        this.matrixCartesianToFractional.transform(pt);
    }

    private final void toFractionalUnitCell(Point3f pt) {
        if (this.matrixCartesianToFractional == null) {
            return;
        }
        this.matrixCartesianToFractional.transform(pt);
        pt.x = UnitCell.toFractional(pt.x);
        pt.y = UnitCell.toFractional(pt.y);
        pt.z = UnitCell.toFractional(pt.z);
    }

    private static float toFractional(float x) {
        if ((x = (float)((double)x - Math.floor(x))) > 0.9999f || x < 1.0E-4f) {
            x = 0.0f;
        }
        return x;
    }

    final void toUnitCell(Point3f pt, Point3f offset) {
        if (this.matrixCartesianToFractional == null) {
            return;
        }
        this.toFractionalUnitCell(pt);
        if (offset != null) {
            pt.add(offset);
        }
        this.matrixFractionalToCartesian.transform(pt);
    }

    void setOffset(Point3f pt) {
        this.fractionalOffset.set(pt);
        this.matrixCartesianToFractional.m03 = -pt.x;
        this.matrixCartesianToFractional.m13 = -pt.y;
        this.matrixCartesianToFractional.m23 = -pt.z;
        this.cartesianOffset.set(pt);
        this.matrixFractionalToCartesian.m03 = 0.0f;
        this.matrixFractionalToCartesian.m13 = 0.0f;
        this.matrixFractionalToCartesian.m23 = 0.0f;
        this.matrixFractionalToCartesian.transform(this.cartesianOffset);
        this.matrixFractionalToCartesian.m03 = this.cartesianOffset.x;
        this.matrixFractionalToCartesian.m13 = this.cartesianOffset.y;
        this.matrixFractionalToCartesian.m23 = this.cartesianOffset.z;
    }

    void setOffset(int nnn) {
        this.setOffset(UnitCell.ijkToPoint3f(nnn));
    }

    static Point3f ijkToPoint3f(int nnn) {
        Point3f cell = new Point3f();
        cell.x = nnn / 100 - 5;
        cell.y = nnn % 100 / 10 - 5;
        cell.z = nnn % 10 - 5;
        return cell;
    }

    final String dumpInfo(boolean isFull) {
        return "a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", alpha=" + this.alpha + ", beta=" + this.beta + ", gamma=" + this.gamma + (isFull ? "\nfractional to cartesian: " + this.matrixFractionalToCartesian + "\ncartesian to fractional: " + this.matrixCartesianToFractional : "");
    }

    Point3f[] getVertices() {
        return this.vertices;
    }

    Point3f getCartesianOffset() {
        return this.cartesianOffset;
    }

    Point3f getFractionalOffset() {
        return this.fractionalOffset;
    }

    float[] getNotionalUnitCell() {
        return this.notionalUnitcell;
    }

    float getInfo(int infoType) {
        switch (infoType) {
            case 0: {
                return this.a;
            }
            case 1: {
                return this.b;
            }
            case 2: {
                return this.c;
            }
            case 3: {
                return this.alpha;
            }
            case 4: {
                return this.beta;
            }
            case 5: {
                return this.gamma;
            }
        }
        return Float.NaN;
    }

    private void setUnitCell(float[] notionalUnitcell) {
        if (notionalUnitcell == null || notionalUnitcell[0] == 0.0f) {
            return;
        }
        this.notionalUnitcell = notionalUnitcell;
        this.a = notionalUnitcell[0];
        this.b = notionalUnitcell[1];
        this.c = notionalUnitcell[2];
        this.alpha = notionalUnitcell[3];
        this.beta = notionalUnitcell[4];
        this.gamma = notionalUnitcell[5];
        this.constructFractionalMatrices();
        this.calcUnitcellVertices();
    }

    Object[] getEllipsoid(float[] parBorU) {
        if (parBorU == null) {
            return null;
        }
        if (this.data == null) {
            this.data = new Data();
        }
        return this.data.getEllipsoid(parBorU);
    }

    private void constructFractionalMatrices() {
        if (this.notionalUnitcell.length > 6 && !Float.isNaN(this.notionalUnitcell[21])) {
            float[] scaleMatrix = new float[16];
            for (int i = 0; i < 16; ++i) {
                scaleMatrix[i] = this.notionalUnitcell[6 + i];
            }
            this.matrixCartesianToFractional = new Matrix4f(scaleMatrix);
            this.matrixFractionalToCartesian = new Matrix4f();
            this.matrixFractionalToCartesian.invert(this.matrixCartesianToFractional);
        } else if (this.notionalUnitcell.length > 6 && !Float.isNaN(this.notionalUnitcell[14])) {
            this.isPrimitive = true;
            Matrix4f m = this.matrixFractionalToCartesian = new Matrix4f();
            float[] n = this.notionalUnitcell;
            if (this.data == null) {
                this.data = new Data();
            }
            m.setColumn(0, n[6], n[7], n[8], 0.0f);
            m.setColumn(1, n[9], n[10], n[11], 0.0f);
            m.setColumn(2, n[12], n[13], n[14], 0.0f);
            m.setColumn(3, 0.0f, 0.0f, 0.0f, 1.0f);
            this.matrixCartesianToFractional = new Matrix4f();
            this.matrixCartesianToFractional.invert(this.matrixFractionalToCartesian);
        } else {
            Matrix4f m = this.matrixFractionalToCartesian = new Matrix4f();
            if (this.data == null) {
                this.data = new Data();
            }
            m.setColumn(0, this.a, 0.0f, 0.0f, 0.0f);
            m.setColumn(1, (float)((double)this.b * this.data.cosGamma), (float)((double)this.b * this.data.sinGamma), 0.0f, 0.0f);
            m.setColumn(2, (float)((double)this.c * this.data.cosBeta), (float)((double)this.c * (this.data.cosAlpha - this.data.cosBeta * this.data.cosGamma) / this.data.sinGamma), (float)(this.data.volume / ((double)(this.a * this.b) * this.data.sinGamma)), 0.0f);
            m.setColumn(3, 0.0f, 0.0f, 0.0f, 1.0f);
            this.matrixCartesianToFractional = new Matrix4f();
            this.matrixCartesianToFractional.invert(this.matrixFractionalToCartesian);
        }
    }

    private void calcUnitcellVertices() {
        this.vertices = new Point3f[8];
        int i = 8;
        while (--i >= 0) {
            this.vertices[i] = new Point3f();
            this.matrixFractionalToCartesian.transform(unitCubePoints[i], this.vertices[i]);
        }
    }

    private class Data {
        double cosAlpha;
        double sinAlpha;
        double cosBeta;
        double sinBeta;
        double cosGamma;
        double sinGamma;
        double volume;
        double cA_;
        double cB_;
        double a_;
        double b_;
        double c_;
        static final double twoP2 = 19.739208802178716;

        Data() {
            this.cosAlpha = Math.cos((float)Math.PI / 180 * UnitCell.this.alpha);
            this.sinAlpha = Math.sin((float)Math.PI / 180 * UnitCell.this.alpha);
            this.cosBeta = Math.cos((float)Math.PI / 180 * UnitCell.this.beta);
            this.sinBeta = Math.sin((float)Math.PI / 180 * UnitCell.this.beta);
            this.cosGamma = Math.cos((float)Math.PI / 180 * UnitCell.this.gamma);
            this.sinGamma = Math.sin((float)Math.PI / 180 * UnitCell.this.gamma);
            double unitVolume = Math.sqrt(this.sinAlpha * this.sinAlpha + this.sinBeta * this.sinBeta + this.sinGamma * this.sinGamma + 2.0 * this.cosAlpha * this.cosBeta * this.cosGamma - 2.0);
            this.volume = (double)(UnitCell.this.a * UnitCell.this.b * UnitCell.this.c) * unitVolume;
            this.cA_ = (this.cosAlpha - this.cosBeta * this.cosGamma) / this.sinGamma;
            this.cB_ = unitVolume / this.sinGamma;
            this.a_ = (double)(UnitCell.this.b * UnitCell.this.c) * this.sinAlpha / this.volume;
            this.b_ = (double)(UnitCell.this.a * UnitCell.this.c) * this.sinBeta / this.volume;
            this.c_ = (double)(UnitCell.this.a * UnitCell.this.b) * this.sinGamma / this.volume;
        }

        Object[] getEllipsoid(float[] parBorU) {
            float[] lengths = new float[6];
            if (parBorU[0] == 0.0f) {
                lengths[1] = (float)Math.sqrt(parBorU[7]);
                return new Object[]{null, lengths};
            }
            int ortepType = (int)parBorU[6];
            boolean isFractional = ortepType == 4 || ortepType == 5 || ortepType == 8 || ortepType == 9;
            double cc = 2 - ortepType % 2;
            double dd = ortepType == 8 || ortepType == 9 || ortepType == 10 ? 19.739208802178716 : (ortepType == 4 || ortepType == 5 ? 0.25 : (ortepType == 2 || ortepType == 3 ? Math.log(2.0) : 1.0));
            double B11 = (double)parBorU[0] * dd * (isFractional ? this.a_ * this.a_ : 1.0);
            double B22 = (double)parBorU[1] * dd * (isFractional ? this.b_ * this.b_ : 1.0);
            double B33 = (double)parBorU[2] * dd * (isFractional ? this.c_ * this.c_ : 1.0);
            double B12 = (double)parBorU[3] * dd * (isFractional ? this.a_ * this.b_ : 1.0) * cc;
            double B13 = (double)parBorU[4] * dd * (isFractional ? this.a_ * this.c_ : 1.0) * cc;
            double B23 = (double)parBorU[5] * dd * (isFractional ? this.b_ * this.c_ : 1.0) * cc;
            parBorU[7] = (float)Math.pow(B11 / 19.739208802178716 / this.a_ / this.a_ * B22 / 19.739208802178716 / this.b_ / this.b_ * B33 / 19.739208802178716 / this.c_ / this.c_, 0.3333);
            double[] Bcart = new double[]{(double)(UnitCell.this.a * UnitCell.this.a) * B11 + (double)(UnitCell.this.b * UnitCell.this.b) * this.cosGamma * this.cosGamma * B22 + (double)(UnitCell.this.c * UnitCell.this.c) * this.cosBeta * this.cosBeta * B33 + (double)(UnitCell.this.a * UnitCell.this.b) * this.cosGamma * B12 + (double)(UnitCell.this.b * UnitCell.this.c) * this.cosGamma * this.cosBeta * B23 + (double)(UnitCell.this.a * UnitCell.this.c) * this.cosBeta * B13, (double)(UnitCell.this.b * UnitCell.this.b) * this.sinGamma * this.sinGamma * B22 + (double)(UnitCell.this.c * UnitCell.this.c) * this.cA_ * this.cA_ * B33 + (double)(UnitCell.this.b * UnitCell.this.c) * this.cA_ * this.sinGamma * B23, (double)(UnitCell.this.c * UnitCell.this.c) * this.cB_ * this.cB_ * B33, (double)(2.0f * UnitCell.this.b * UnitCell.this.b) * this.cosGamma * this.sinGamma * B22 + (double)(2.0f * UnitCell.this.c * UnitCell.this.c) * this.cA_ * this.cosBeta * B33 + (double)(UnitCell.this.a * UnitCell.this.b) * this.sinGamma * B12 + (double)(UnitCell.this.b * UnitCell.this.c) * (this.cA_ * this.cosGamma + this.sinGamma * this.cosBeta) * B23 + (double)(UnitCell.this.a * UnitCell.this.c) * this.cA_ * B13, (double)(2.0f * UnitCell.this.c * UnitCell.this.c) * this.cB_ * this.cosBeta * B33 + (double)(UnitCell.this.b * UnitCell.this.c) * this.cosGamma * B23 + (double)(UnitCell.this.a * UnitCell.this.c) * this.cB_ * B13, (double)(2.0f * UnitCell.this.c * UnitCell.this.c) * this.cA_ * this.cB_ * B33 + (double)(UnitCell.this.b * UnitCell.this.c) * this.cB_ * this.sinGamma * B23};
            Vector3f[] unitVectors = new Vector3f[3];
            for (int i = 0; i < 3; ++i) {
                unitVectors[i] = new Vector3f();
            }
            Quadric.getAxesForEllipsoid(Bcart, unitVectors, lengths);
            double factor = Math.sqrt(0.5) / Math.PI;
            for (int i = 0; i < 3; ++i) {
                lengths[i] = (float)(factor / (double)lengths[i]);
            }
            return new Object[]{unitVectors, lengths};
        }
    }
}

