/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.BitSet;

public final class BitSetUtil {
    private static final BitSet bsNull = new BitSet();

    public static int length(BitSet bs) {
        int n = bs.size();
        while (--n >= 0 && !bs.get(n)) {
        }
        return n + 1;
    }

    public static int firstSetBit(BitSet bs) {
        int n;
        if (bs == null || (n = bs.size()) == 0) {
            return -1;
        }
        for (int i = 0; i < n; ++i) {
            if (!bs.get(i)) continue;
            return i;
        }
        return -1;
    }

    public static int cardinalityOf(BitSet bs) {
        int n = 0;
        if (bs != null) {
            int i = bs.size();
            while (--i >= 0) {
                if (!bs.get(i)) continue;
                ++n;
            }
        }
        return n;
    }

    public static BitSet setAll(int n) {
        BitSet bs = new BitSet(n);
        int i = n;
        while (--i >= 0) {
            bs.set(i);
        }
        return bs;
    }

    public static void andNot(BitSet a, BitSet b) {
        if (b == null) {
            return;
        }
        int i = b.size();
        while (--i >= 0) {
            if (!b.get(i)) continue;
            a.clear(i);
        }
    }

    public static BitSet copy(BitSet bs) {
        return bs == null ? null : (BitSet)bs.clone();
    }

    public static void copy(BitSet a, BitSet b) {
        b.clear();
        b.or(a);
    }

    public static void clear(BitSet bs) {
        bs.and(bsNull);
    }

    public static BitSet copyInvert(BitSet bs, int n) {
        if (bs == null) {
            return null;
        }
        BitSet allButN = BitSetUtil.setAll(n);
        BitSetUtil.andNot(allButN, bs);
        return allButN;
    }

    public static BitSet invertInPlace(BitSet bs, int n) {
        int i = n;
        while (--i >= 0) {
            if (bs.get(i)) {
                bs.clear(i);
                continue;
            }
            bs.set(i);
        }
        return bs;
    }

    public static BitSet toggleInPlace(BitSet a, BitSet b, int n) {
        int i = n;
        while (--i >= 0) {
            if (!b.get(i)) continue;
            if (a.get(i)) {
                a.clear(i);
                continue;
            }
            a.or(b);
            break;
        }
        return a;
    }

    public static void deleteBits(BitSet bs, BitSet bsDelete) {
        if (bs == null || bsDelete == null) {
            return;
        }
        int ipt = BitSetUtil.firstSetBit(bsDelete);
        if (ipt < 0) {
            return;
        }
        int len = bs.size();
        int lend = Math.min(len, bsDelete.size());
        for (int i = ipt; i < lend; ++i) {
            if (bsDelete.get(i)) continue;
            bs.set(ipt++, bs.get(i));
        }
        while (ipt < len) {
            bs.clear(ipt);
            ++ipt;
        }
    }

    public static boolean compareBits(BitSet a, BitSet b) {
        if (a == null || b == null) {
            return a == null && b == null;
        }
        int i = Math.max(a.size(), b.size());
        while (--i >= 0) {
            if (a.get(i) == b.get(i)) continue;
            return false;
        }
        return true;
    }
}

