/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Enumeration;
import java.util.Hashtable;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.viewer.JmolConstants;

public class ColorEncoder {
    public static final String BYELEMENT_PREFIX = "byelement";
    public static final String BYRESIDUE_PREFIX = "byresidue";
    private static final String BYELEMENT_JMOL = "byelement_jmol";
    private static final String BYELEMENT_RASMOL = "byelement_rasmol";
    private static final String BYRESIDUE_SHAPELY = "byresidue_shapely";
    private static final String BYRESIDUE_AMINO = "byresidue_amino";
    private static final String[] colorSchemes = new String[]{"roygb", "bgyor", "rwb", "bwr", "low", "high", "byelement_jmol", "byelement_rasmol", "byresidue_shapely", "byresidue_amino", "colorRGB", "user", "resu"};
    public static final int ROYGB = 0;
    public static final int BGYOR = 1;
    public static final int RWB = 2;
    public static final int BWR = 3;
    public static final int LOW = 4;
    public static final int HIGH = 5;
    public static final int JMOL = 6;
    public static final int RASMOL = 7;
    public static final int SHAPELY = 8;
    public static final int AMINO = 9;
    public static final int COLOR_RGB = 10;
    public static final int USER = -11;
    public static final int RESU = -12;
    private int palette = 0;
    private static int[] userScale = new int[]{-8355712};
    private static int[] thisScale = new int[]{-8355712};
    private static String thisName = "scheme";
    private static boolean isColorIndex;
    private static Hashtable schemes;
    private static int[] rasmolScale;
    private static int[] argbsCpk;
    private static int[] argbsRoygb;
    private static int[] argbsRwb;
    private static int[] argbsShapely;
    private static int[] argbsAmino;
    private static int ihalf;
    private static final int GRAY = -8355712;

    private static final int schemeIndex(String colorScheme) {
        for (int i = 0; i < colorSchemes.length; ++i) {
            if (!colorSchemes[i].equalsIgnoreCase(colorScheme)) continue;
            return i < 11 ? i : -i;
        }
        return -1;
    }

    public static synchronized int[] getRasmolScale(boolean forceNew) {
        if (rasmolScale[0] == 0 || forceNew) {
            int argb = JmolConstants.argbsCpkRasmol[0] | 0xFF000000;
            int i = rasmolScale.length;
            while (--i >= 0) {
                ColorEncoder.rasmolScale[i] = argb;
            }
            i = JmolConstants.argbsCpkRasmol.length;
            while (--i >= 0) {
                argb = JmolConstants.argbsCpkRasmol[i];
                ColorEncoder.rasmolScale[argb >> 24] = argb | 0xFF000000;
            }
        }
        return rasmolScale;
    }

    public static synchronized int makeColorScheme(String name, int[] scale, boolean isOverloaded) {
        name = ColorEncoder.fixName(name);
        if (scale == null) {
            schemes.remove(name);
            int iScheme = ColorEncoder.getColorScheme(name, false, isOverloaded);
            if (isOverloaded) {
                switch (iScheme) {
                    case 0: 
                    case 1: {
                        argbsRoygb = JmolConstants.argbsRoygbScale;
                        break;
                    }
                    case 2: 
                    case 3: {
                        argbsRwb = JmolConstants.argbsRwbScale;
                        break;
                    }
                    case 6: {
                        argbsCpk = JmolConstants.argbsCpk;
                        break;
                    }
                    case 7: {
                        ColorEncoder.getRasmolScale(true);
                        break;
                    }
                    case 9: {
                        argbsAmino = JmolConstants.argbsAmino;
                        break;
                    }
                    case 8: {
                        argbsShapely = JmolConstants.argbsShapely;
                    }
                }
            }
            return iScheme == Integer.MAX_VALUE ? 0 : iScheme;
        }
        thisName = name;
        thisScale = scale;
        schemes.put(thisName, scale);
        ColorEncoder.checkColorIndex();
        int iScheme = ColorEncoder.getColorScheme(name, false, isOverloaded);
        if (isOverloaded) {
            switch (iScheme) {
                case 0: 
                case 1: {
                    argbsRoygb = thisScale;
                    break;
                }
                case 2: 
                case 3: {
                    argbsRwb = thisScale;
                    break;
                }
                case 6: {
                    argbsCpk = thisScale;
                    break;
                }
                case 7: {
                    break;
                }
                case 9: {
                    argbsAmino = thisScale;
                    break;
                }
                case 8: {
                    argbsShapely = thisScale;
                }
            }
        }
        return -1;
    }

    private static void checkColorIndex() {
        isColorIndex = thisName.indexOf(BYELEMENT_PREFIX) == 0 || thisName.indexOf(BYRESIDUE_PREFIX) == 0;
    }

    private static String fixName(String name) {
        if ((name = name.toLowerCase()).equals(BYELEMENT_PREFIX)) {
            return BYELEMENT_JMOL;
        }
        if (name.equals("jmol")) {
            return BYELEMENT_JMOL;
        }
        if (name.equals("rasmol")) {
            return BYELEMENT_RASMOL;
        }
        if (name.equals(BYRESIDUE_PREFIX)) {
            return BYRESIDUE_SHAPELY;
        }
        return name;
    }

    public int setColorScheme(String colorScheme) {
        this.palette = ColorEncoder.getColorScheme(colorScheme, false);
        return this.palette;
    }

    public String getColorSchemeName() {
        return ColorEncoder.getColorSchemeName(this.palette);
    }

    public static final String getColorSchemeName(int i) {
        int absi = Math.abs(i);
        return i == -1 ? thisName : (absi < colorSchemes.length && absi >= 0 ? colorSchemes[absi] : null);
    }

    public static final int getColorScheme(String colorScheme, boolean isOverloaded) {
        return ColorEncoder.getColorScheme(colorScheme, true, isOverloaded);
    }

    private static final int getColorScheme(String colorScheme, boolean defaultToRoygb, boolean isOverloaded) {
        int pt = Math.max((colorScheme = colorScheme.toLowerCase()).indexOf("="), colorScheme.indexOf("["));
        if (pt >= 0) {
            String name = TextFormat.replaceAllCharacters(colorScheme.substring(0, pt), " =", "");
            if (name.length() > 0) {
                isOverloaded = true;
            }
            int n = 0;
            pt = -1;
            while ((pt = colorScheme.indexOf("[", pt + 1)) >= 0) {
                ++n;
            }
            if (n == 0) {
                return ColorEncoder.makeColorScheme(name, null, isOverloaded);
            }
            int[] scale = new int[n];
            pt = -1;
            n = 0;
            while ((pt = colorScheme.indexOf("[", pt + 1)) >= 0) {
                int c;
                int pt2 = colorScheme.indexOf("]", pt);
                if (pt2 < 0) {
                    pt2 = colorScheme.length() - 1;
                }
                scale[n++] = c = Graphics3D.getArgbFromString(colorScheme.substring(pt, pt2 + 1));
                if (c != 0) continue;
                Logger.error("error in color value: " + colorScheme.substring(pt, pt2 + 1));
                return 0;
            }
            if (name.equals("user")) {
                ColorEncoder.setUserScale(scale);
                return -11;
            }
            return ColorEncoder.makeColorScheme(name, scale, isOverloaded);
        }
        colorScheme = ColorEncoder.fixName(colorScheme);
        int ipt = ColorEncoder.schemeIndex(colorScheme);
        if (schemes.containsKey(colorScheme)) {
            thisName = colorScheme;
            thisScale = (int[])schemes.get(colorScheme);
            ColorEncoder.checkColorIndex();
            return ipt;
        }
        return ipt != -1 ? ipt : (defaultToRoygb ? 0 : Integer.MAX_VALUE);
    }

    public static final void setUserScale(int[] scale) {
        userScale = scale;
        ColorEncoder.makeColorScheme("user", scale, false);
    }

    public static final String getState(StringBuffer sfunc) {
        StringBuffer s = new StringBuffer();
        Enumeration e = schemes.keys();
        int n = 0;
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!(name.length() > 0 & n++ >= 0)) continue;
            s.append("color \"" + name + "=" + ColorEncoder.getColorSchemeList((int[])schemes.get(name)) + "\";\n");
        }
        if (n > 0 && sfunc != null) {
            sfunc.append("\n  _setColorState\n");
        }
        return n > 0 && sfunc != null ? "function _setColorState() {\n" + s.append("}\n\n").toString() : s.toString();
    }

    public static String getColorSchemeList(int[] scheme) {
        String colors = "";
        for (int i = 0; i < scheme.length; ++i) {
            colors = colors + (i == 0 ? "" : " ") + Escape.escapeColor(scheme[i]);
        }
        return colors;
    }

    public static final int[] getColorSchemeArray(int palette) {
        switch (palette) {
            case -1: {
                return ArrayUtil.arrayCopy(thisScale, 0, -1, false);
            }
            case 0: {
                return ArrayUtil.arrayCopy(argbsRoygb, 0, -1, false);
            }
            case 1: {
                return ArrayUtil.arrayCopy(argbsRoygb, 0, -1, true);
            }
            case 4: {
                return ArrayUtil.arrayCopy(argbsRoygb, 0, ihalf, false);
            }
            case 5: {
                int[] a = ArrayUtil.arrayCopy(argbsRoygb, ihalf, -1, false);
                int[] b = new int[ihalf];
                int i = ihalf;
                while (--i >= 0) {
                    b[i] = a[i + i];
                }
                return b;
            }
            case 2: {
                return ArrayUtil.arrayCopy(argbsRwb, 0, -1, false);
            }
            case 3: {
                return ArrayUtil.arrayCopy(argbsRwb, 0, -1, true);
            }
            case 6: {
                return ArrayUtil.arrayCopy(argbsCpk, 0, -1, false);
            }
            case 7: {
                return ArrayUtil.arrayCopy(ColorEncoder.getRasmolScale(false), 0, -1, false);
            }
            case 8: {
                return ArrayUtil.arrayCopy(argbsShapely, 0, -1, false);
            }
            case 9: {
                return ArrayUtil.arrayCopy(argbsAmino, 0, -1, false);
            }
            case 10: {
                return new int[0];
            }
            case -11: {
                return ArrayUtil.arrayCopy(userScale, 0, -1, false);
            }
            case -12: {
                return ArrayUtil.arrayCopy(userScale, 0, -1, true);
            }
        }
        return null;
    }

    public final int getArgbFromPalette(float val, float lo, float hi) {
        return ColorEncoder.getArgbFromPalette(val, lo, hi, this.palette);
    }

    public static final int getArgbFromPalette(float val, float lo, float hi, int palette) {
        if (Float.isNaN(val)) {
            return -8355712;
        }
        switch (palette) {
            case -1: {
                if (isColorIndex) {
                    lo = 0.0f;
                    hi = thisScale.length;
                }
                return thisScale[ColorEncoder.quantize(val, lo, hi, thisScale.length)];
            }
            case 0: {
                return JmolConstants.argbsRoygbScale[ColorEncoder.quantize(val, lo, hi, JmolConstants.argbsRoygbScale.length)];
            }
            case 1: {
                return JmolConstants.argbsRoygbScale[ColorEncoder.quantize(-val, -hi, -lo, JmolConstants.argbsRoygbScale.length)];
            }
            case 4: {
                return JmolConstants.argbsRoygbScale[ColorEncoder.quantize(val, lo, hi, ihalf)];
            }
            case 5: {
                return JmolConstants.argbsRoygbScale[ihalf + ColorEncoder.quantize(val, lo, hi, ihalf) * 2];
            }
            case 2: {
                return JmolConstants.argbsRwbScale[ColorEncoder.quantize(val, lo, hi, JmolConstants.argbsRwbScale.length)];
            }
            case 3: {
                return JmolConstants.argbsRwbScale[ColorEncoder.quantize(-val, -hi, -lo, JmolConstants.argbsRwbScale.length)];
            }
            case -11: {
                return userScale.length == 0 ? -8355712 : userScale[ColorEncoder.quantize(val, lo, hi, userScale.length)];
            }
            case -12: {
                return userScale.length == 0 ? -8355712 : userScale[ColorEncoder.quantize(-val, -hi, -lo, userScale.length)];
            }
            case 6: {
                return argbsCpk[ColorEncoder.colorIndex((int)val, argbsCpk.length)];
            }
            case 7: {
                return ColorEncoder.getRasmolScale(false)[ColorEncoder.colorIndex((int)val, rasmolScale.length)];
            }
            case 8: {
                return JmolConstants.argbsShapely[ColorEncoder.colorIndex((int)val, JmolConstants.argbsShapely.length)];
            }
            case 9: {
                return JmolConstants.argbsAmino[ColorEncoder.colorIndex((int)val, JmolConstants.argbsAmino.length)];
            }
            case 10: {
                return (int)val;
            }
        }
        return -8355712;
    }

    public static final short getColorIndexFromPalette(float val, float lo, float hi, int palette) {
        return ColorEncoder.getColorIndex(ColorEncoder.getArgbFromPalette(val, lo, hi, palette));
    }

    public static final short getColorIndex(int c) {
        return Graphics3D.getColix(c);
    }

    public static final int quantize(float val, float lo, float hi, int segmentCount) {
        float range = hi - lo;
        if (range <= 0.0f || Float.isNaN(val)) {
            return segmentCount / 2;
        }
        float t = val - lo;
        if (t <= 0.0f) {
            return 0;
        }
        float quanta = range / (float)segmentCount;
        int q = (int)(t / quanta + 1.0E-4f);
        if (q >= segmentCount) {
            q = segmentCount - 1;
        }
        return q;
    }

    public static final int colorIndex(int q, int segmentCount) {
        return q <= 0 | q >= segmentCount ? 0 : q;
    }

    public short getColorIndexFromPalette(float val, float lo, float hi) {
        return ColorEncoder.getColorIndexFromPalette(val, lo, hi, this.palette);
    }

    static {
        schemes = new Hashtable();
        rasmolScale = new int[JmolConstants.argbsCpk.length];
        argbsCpk = JmolConstants.argbsCpk;
        argbsRoygb = JmolConstants.argbsRoygbScale;
        argbsRwb = JmolConstants.argbsRwbScale;
        argbsShapely = JmolConstants.argbsShapely;
        argbsAmino = JmolConstants.argbsAmino;
        ihalf = JmolConstants.argbsRoygbScale.length / 3;
    }
}

