/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jmol.util.DCT;
import org.jmol.util.Huffman;
import org.jmol.util.JpegInfo;
import org.jmol.util.Logger;

public class JpegEncoder
extends Frame {
    private BufferedOutputStream outStream;
    private JpegInfo JpegObj;
    private Huffman Huf;
    private DCT dct;
    private int Quality;

    public JpegEncoder(Image image, int quality, OutputStream out) {
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(image, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.Quality = quality;
        this.JpegObj = new JpegInfo(image);
        this.outStream = new BufferedOutputStream(out);
        this.dct = new DCT(this.Quality);
        this.Huf = new Huffman(this.JpegObj.imageWidth, this.JpegObj.imageHeight);
    }

    public static byte[] getBytes(Image image, int quality) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        JpegEncoder.write(image, quality, os);
        try {
            os.flush();
            os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return os.toByteArray();
    }

    public static void write(Image image, int quality, OutputStream os) {
        new JpegEncoder(image, quality, os).Compress();
    }

    public void setQuality(int quality) {
        this.dct = new DCT(quality);
    }

    public void Compress() {
        JpegEncoder.WriteHeaders(this.outStream, this.JpegObj, this.dct);
        JpegEncoder.WriteCompressedData(this.outStream, this.JpegObj, this.dct, this.Huf);
        JpegEncoder.WriteEOI(this.outStream);
        try {
            this.outStream.flush();
        }
        catch (IOException e) {
            Logger.error("IO Error", e);
        }
    }

    private static void WriteCompressedData(BufferedOutputStream outStream, JpegInfo JpegObj, DCT dct, Huffman Huf) {
        int comp;
        float[][] dctArray1 = new float[8][8];
        double[][] dctArray2 = new double[8][8];
        int[] dctArray3 = new int[64];
        int[] lastDCvalue = new int[JpegObj.NumberOfComponents];
        int MinBlockWidth = Huf.ImageWidth % 8 != 0 ? (int)(Math.floor((double)Huf.ImageWidth / 8.0) + 1.0) * 8 : Huf.ImageWidth;
        int MinBlockHeight = Huf.ImageHeight % 8 != 0 ? (int)(Math.floor((double)Huf.ImageHeight / 8.0) + 1.0) * 8 : Huf.ImageHeight;
        for (comp = 0; comp < JpegObj.NumberOfComponents; ++comp) {
            MinBlockWidth = Math.min(MinBlockWidth, JpegObj.BlockWidth[comp]);
            MinBlockHeight = Math.min(MinBlockHeight, JpegObj.BlockHeight[comp]);
        }
        int xpos = 0;
        for (int r = 0; r < MinBlockHeight; ++r) {
            for (int c = 0; c < MinBlockWidth; ++c) {
                xpos = c * 8;
                int ypos = r * 8;
                for (comp = 0; comp < JpegObj.NumberOfComponents; ++comp) {
                    float[][] inputArray = JpegObj.Components[comp];
                    int VsampF = JpegObj.VsampFactor[comp];
                    int HsampF = JpegObj.HsampFactor[comp];
                    int QNumber = JpegObj.QtableNumber[comp];
                    int DCNumber = JpegObj.DCtableNumber[comp];
                    int ACNumber = JpegObj.ACtableNumber[comp];
                    for (int i = 0; i < VsampF; ++i) {
                        for (int j = 0; j < HsampF; ++j) {
                            int xblockoffset = j * 8;
                            int yblockoffset = i * 8;
                            for (int a = 0; a < 8; ++a) {
                                for (int b = 0; b < 8; ++b) {
                                    dctArray1[a][b] = inputArray[ypos + yblockoffset + a][xpos + xblockoffset + b];
                                }
                            }
                            dctArray2 = DCT.forwardDCT(dctArray1);
                            dctArray3 = DCT.quantizeBlock(dctArray2, dct.divisors[QNumber]);
                            Huf.HuffmanBlockEncoder(outStream, dctArray3, lastDCvalue[comp], DCNumber, ACNumber);
                            lastDCvalue[comp] = dctArray3[0];
                        }
                    }
                }
            }
        }
        Huf.flushBuffer(outStream);
    }

    private static void WriteEOI(BufferedOutputStream out) {
        byte[] EOI = new byte[]{-1, -39};
        JpegEncoder.WriteMarker(EOI, out);
    }

    private static void WriteHeaders(BufferedOutputStream out, JpegInfo JpegObj, DCT dct) {
        int i;
        byte[] SOI = new byte[]{-1, -40};
        JpegEncoder.WriteMarker(SOI, out);
        byte[] JFIF = new byte[]{-1, -32, 0, 16, 74, 70, 73, 70, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0};
        JpegEncoder.WriteArray(JFIF, out);
        String comment = "";
        comment = JpegObj.getComment();
        int length = comment.length();
        byte[] COM = new byte[length + 4];
        COM[0] = -1;
        COM[1] = -2;
        COM[2] = (byte)(length >> 8 & 0xFF);
        COM[3] = (byte)(length & 0xFF);
        System.arraycopy(JpegObj.Comment.getBytes(), 0, COM, 4, JpegObj.Comment.length());
        JpegEncoder.WriteArray(COM, out);
        byte[] DQT = new byte[134];
        DQT[0] = -1;
        DQT[1] = -37;
        DQT[2] = 0;
        DQT[3] = -124;
        int offset = 4;
        for (i = 0; i < 2; ++i) {
            DQT[offset++] = (byte)(0 + i);
            int[] tempArray = dct.quantum[i];
            for (int j = 0; j < 64; ++j) {
                DQT[offset++] = (byte)tempArray[Huffman.jpegNaturalOrder[j]];
            }
        }
        JpegEncoder.WriteArray(DQT, out);
        byte[] SOF = new byte[19];
        SOF[0] = -1;
        SOF[1] = -64;
        SOF[2] = 0;
        SOF[3] = 17;
        SOF[4] = (byte)JpegObj.Precision;
        SOF[5] = (byte)(JpegObj.imageHeight >> 8 & 0xFF);
        SOF[6] = (byte)(JpegObj.imageHeight & 0xFF);
        SOF[7] = (byte)(JpegObj.imageWidth >> 8 & 0xFF);
        SOF[8] = (byte)(JpegObj.imageWidth & 0xFF);
        SOF[9] = (byte)JpegObj.NumberOfComponents;
        int index = 10;
        for (i = 0; i < SOF[9]; ++i) {
            SOF[index++] = (byte)JpegObj.CompID[i];
            SOF[index++] = (byte)((JpegObj.HsampFactor[i] << 4) + JpegObj.VsampFactor[i]);
            SOF[index++] = (byte)JpegObj.QtableNumber[i];
        }
        JpegEncoder.WriteArray(SOF, out);
        JpegEncoder.WriteDHTHeader(Huffman.bitsDCluminance, Huffman.valDCluminance, out);
        JpegEncoder.WriteDHTHeader(Huffman.bitsACluminance, Huffman.valACluminance, out);
        JpegEncoder.WriteDHTHeader(Huffman.bitsDCchrominance, Huffman.valDCchrominance, out);
        JpegEncoder.WriteDHTHeader(Huffman.bitsACchrominance, Huffman.valACchrominance, out);
        byte[] SOS = new byte[14];
        SOS[0] = -1;
        SOS[1] = -38;
        SOS[2] = 0;
        SOS[3] = 12;
        SOS[4] = (byte)JpegObj.NumberOfComponents;
        index = 5;
        for (i = 0; i < SOS[4]; ++i) {
            SOS[index++] = (byte)JpegObj.CompID[i];
            SOS[index++] = (byte)((JpegObj.DCtableNumber[i] << 4) + JpegObj.ACtableNumber[i]);
        }
        SOS[index++] = (byte)JpegObj.Ss;
        SOS[index++] = (byte)JpegObj.Se;
        SOS[index++] = (byte)((JpegObj.Ah << 4) + JpegObj.Al);
        JpegEncoder.WriteArray(SOS, out);
    }

    static void WriteDHTHeader(int[] bits, int[] val, BufferedOutputStream out) {
        int j;
        int index = 4;
        int oldindex = 4;
        byte[] DHT1 = new byte[17];
        byte[] DHT4 = new byte[4];
        DHT4[0] = -1;
        DHT4[1] = -60;
        int bytes = 0;
        DHT1[index++ - oldindex] = (byte)bits[0];
        for (j = 1; j < 17; ++j) {
            int temp = bits[j];
            DHT1[index++ - oldindex] = (byte)temp;
            bytes += temp;
        }
        int intermediateindex = index;
        byte[] DHT2 = new byte[bytes];
        for (j = 0; j < bytes; ++j) {
            DHT2[index++ - intermediateindex] = (byte)val[j];
        }
        byte[] DHT3 = new byte[index];
        System.arraycopy(DHT4, 0, DHT3, 0, oldindex);
        System.arraycopy(DHT1, 0, DHT3, oldindex, 17);
        System.arraycopy(DHT2, 0, DHT3, oldindex + 17, bytes);
        DHT4 = DHT3;
        oldindex = index;
        DHT4[2] = (byte)(index - 2 >> 8 & 0xFF);
        DHT4[3] = (byte)(index - 2 & 0xFF);
        JpegEncoder.WriteArray(DHT4, out);
    }

    static void WriteMarker(byte[] data, BufferedOutputStream out) {
        try {
            out.write(data, 0, 2);
        }
        catch (IOException e) {
            Logger.error("IO Error", e);
        }
    }

    static void WriteArray(byte[] data, BufferedOutputStream out) {
        try {
            int length = ((data[2] & 0xFF) << 8) + (data[3] & 0xFF) + 2;
            out.write(data, 0, length);
        }
        catch (IOException e) {
            Logger.error("IO Error", e);
        }
    }
}

