/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;

public class TempArray {
    private static final int freePointsSize = 6;
    private final int[] lengthsFreePoints = new int[6];
    private final Point3f[][] freePoints = new Point3f[6][];
    private static final int freeScreensSize = 6;
    private final int[] lengthsFreeScreens = new int[6];
    private final Point3i[][] freeScreens = new Point3i[6][];
    private static final int freeBytesSize = 2;
    private final int[] lengthsFreeBytes = new int[2];
    private final byte[][] freeBytes = new byte[2][];

    public void clear() {
        this.clearTempPoints();
        this.clearTempScreens();
    }

    private static int findBestFit(int size, int[] lengths) {
        int iFit = -1;
        int fitLength = Integer.MAX_VALUE;
        int i = lengths.length;
        while (--i >= 0) {
            int freeLength = lengths[i];
            if (freeLength < size || freeLength >= fitLength) continue;
            fitLength = freeLength;
            iFit = i;
        }
        if (iFit >= 0) {
            lengths[iFit] = 0;
        }
        return iFit;
    }

    private static int findShorter(int size, int[] lengths) {
        int i = lengths.length;
        while (--i >= 0) {
            if (lengths[i] != 0) continue;
            lengths[i] = size;
            return i;
        }
        int iShortest = 0;
        int shortest = lengths[0];
        int i2 = lengths.length;
        while (--i2 > 0) {
            if (lengths[i2] >= shortest) continue;
            shortest = lengths[i2];
            iShortest = i2;
        }
        if (shortest < size) {
            lengths[iShortest] = size;
            return iShortest;
        }
        return -1;
    }

    private void clearTempPoints() {
        for (int i = 0; i < 6; ++i) {
            this.lengthsFreePoints[i] = 0;
            this.freePoints[i] = null;
        }
    }

    public Point3f[] allocTempPoints(int size) {
        Point3f[] tempPoints;
        int iFit = TempArray.findBestFit(size, this.lengthsFreePoints);
        if (iFit > 0) {
            tempPoints = this.freePoints[iFit];
        } else {
            tempPoints = new Point3f[size];
            int i = size;
            while (--i >= 0) {
                tempPoints[i] = new Point3f();
            }
        }
        return tempPoints;
    }

    public void freeTempPoints(Point3f[] tempPoints) {
        for (int i = 0; i < this.freePoints.length; ++i) {
            if (this.freePoints[i] != tempPoints) continue;
            this.lengthsFreePoints[i] = tempPoints.length;
            return;
        }
        int iFree = TempArray.findShorter(tempPoints.length, this.lengthsFreePoints);
        if (iFree >= 0) {
            this.freePoints[iFree] = tempPoints;
        }
    }

    private void clearTempScreens() {
        for (int i = 0; i < 6; ++i) {
            this.lengthsFreeScreens[i] = 0;
            this.freeScreens[i] = null;
        }
    }

    public Point3i[] allocTempScreens(int size) {
        Point3i[] tempScreens;
        int iFit = TempArray.findBestFit(size, this.lengthsFreeScreens);
        if (iFit > 0) {
            tempScreens = this.freeScreens[iFit];
        } else {
            tempScreens = new Point3i[size];
            int i = size;
            while (--i >= 0) {
                tempScreens[i] = new Point3i();
            }
        }
        return tempScreens;
    }

    public void freeTempScreens(Point3i[] tempScreens) {
        for (int i = 0; i < this.freeScreens.length; ++i) {
            if (this.freeScreens[i] != tempScreens) continue;
            this.lengthsFreeScreens[i] = tempScreens.length;
            return;
        }
        int iFree = TempArray.findShorter(tempScreens.length, this.lengthsFreeScreens);
        if (iFree >= 0) {
            this.freeScreens[iFree] = tempScreens;
        }
    }

    public byte[] allocTempBytes(int size) {
        int iFit = TempArray.findBestFit(size, this.lengthsFreeBytes);
        byte[] tempBytes = iFit > 0 ? this.freeBytes[iFit] : new byte[size];
        return tempBytes;
    }

    public void freeTempBytes(byte[] tempBytes) {
        for (int i = 0; i < this.freeBytes.length; ++i) {
            if (this.freeBytes[i] != tempBytes) continue;
            this.lengthsFreeBytes[i] = tempBytes.length;
            return;
        }
        int iFree = TempArray.findShorter(tempBytes.length, this.lengthsFreeBytes);
        if (iFree >= 0) {
            this.freeBytes[iFree] = tempBytes;
        }
    }
}

