/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.text.DecimalFormat;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import org.jmol.util.Parser;

public class TextFormat {
    private static final DecimalFormat[] formatters = new DecimalFormat[10];
    private static final String[] formattingStrings = new String[]{"0", "0.0", "0.00", "0.000", "0.0000", "0.00000", "0.000000", "0.0000000", "0.00000000", "0.000000000"};
    private static final Boolean[] useNumberLocalization = new Boolean[1];

    public TextFormat() {
        TextFormat.useNumberLocalization[0] = Boolean.TRUE;
    }

    public static void setUseNumberLocalization(boolean TF) {
        TextFormat.useNumberLocalization[0] = TF ? Boolean.TRUE : Boolean.FALSE;
    }

    public static String formatDecimal(float value, int decimalDigits) {
        DecimalFormat formatter;
        if (decimalDigits == Integer.MAX_VALUE) {
            return "" + value;
        }
        if (decimalDigits < 0) {
            double d;
            if ((decimalDigits = -decimalDigits) > formattingStrings.length) {
                decimalDigits = formattingStrings.length;
            }
            if (value == 0.0f) {
                return formattingStrings[decimalDigits] + "E+0";
            }
            int n = 0;
            if (Math.abs(value) < 1.0f) {
                n = 10;
                d = (double)value * 1.0E-10;
            } else {
                n = -10;
                d = (double)value * 1.0E10;
            }
            String s = ("" + d).toUpperCase();
            int i = s.indexOf("E");
            n = Parser.parseInt(s.substring(i + 1)) + n;
            return i < 0 ? "" + value : TextFormat.formatDecimal(Parser.parseFloat(s.substring(0, i)), decimalDigits - 1) + "E" + (n >= 0 ? "+" : "") + n;
        }
        if (decimalDigits >= formattingStrings.length) {
            decimalDigits = formattingStrings.length - 1;
        }
        if ((formatter = formatters[decimalDigits]) == null) {
            formatter = TextFormat.formatters[decimalDigits] = new DecimalFormat(formattingStrings[decimalDigits]);
        }
        String s = formatter.format(value);
        return Boolean.TRUE.equals(useNumberLocalization[0]) ? s : s.replace(',', '.');
    }

    public static String format(float value, int width, int precision, boolean alignLeft, boolean zeroPad) {
        return TextFormat.format(TextFormat.formatDecimal(value, precision), width, 0, alignLeft, zeroPad);
    }

    public static String format(double value, int width, int precision, boolean alignLeft, boolean zeroPad) {
        return TextFormat.format(TextFormat.formatDecimal((float)value, -1 - precision), width, 0, alignLeft, zeroPad);
    }

    public static String format(String value, int width, int precision, boolean alignLeft, boolean zeroPad) {
        if (value == null) {
            return "";
        }
        int len = value.length();
        if (precision != Integer.MAX_VALUE && precision > 0 && precision < len) {
            value = value.substring(0, precision);
        } else if (precision < 0 && len + precision >= 0) {
            value = value.substring(len + precision);
        }
        int padLength = width - value.length();
        if (padLength <= 0) {
            return value;
        }
        boolean isNeg = zeroPad && !alignLeft && value.charAt(0) == '-';
        char padChar = zeroPad ? (char)'0' : ' ';
        char padChar0 = isNeg ? (char)'-' : padChar;
        StringBuffer sb = new StringBuffer();
        if (alignLeft) {
            sb.append(value);
        }
        sb.append(padChar0);
        int i = padLength;
        while (--i > 0) {
            sb.append(padChar);
        }
        if (!alignLeft) {
            sb.append(isNeg ? padChar + value.substring(1) : value);
        }
        return sb.toString();
    }

    public static String formatString(String strFormat, String key, String strT) {
        return TextFormat.formatString(strFormat, key, strT, Float.NaN, Double.NaN, false);
    }

    public static String formatString(String strFormat, String key, float floatT) {
        return TextFormat.formatString(strFormat, key, null, floatT, Double.NaN, false);
    }

    public static String formatString(String strFormat, String key, int intT) {
        return TextFormat.formatString(strFormat, key, "" + intT, Float.NaN, Double.NaN, false);
    }

    public static String sprintf(String strFormat, Object[] values) {
        if (values == null) {
            return strFormat;
        }
        for (int o = 0; o < values.length; ++o) {
            int i;
            if (values[o] == null) continue;
            if (values[o] instanceof String) {
                strFormat = TextFormat.formatString(strFormat, "s", (String)values[o], Float.NaN, Double.NaN, true);
                continue;
            }
            if (values[o] instanceof Float) {
                strFormat = TextFormat.formatString(strFormat, "f", null, ((Float)values[o]).floatValue(), Double.NaN, true);
                continue;
            }
            if (values[o] instanceof Integer) {
                strFormat = TextFormat.formatString(strFormat, "d", "" + values[o], Float.NaN, Double.NaN, true);
                strFormat = TextFormat.formatString(strFormat, "i", "" + values[o], Float.NaN, Double.NaN, true);
                continue;
            }
            if (values[o] instanceof Double) {
                strFormat = TextFormat.formatString(strFormat, "e", null, Float.NaN, (Double)values[o], true);
                continue;
            }
            if (values[o] instanceof Point3f) {
                Point3f pVal = (Point3f)values[o];
                strFormat = TextFormat.formatString(strFormat, "p", null, pVal.x, Double.NaN, true);
                strFormat = TextFormat.formatString(strFormat, "p", null, pVal.y, Double.NaN, true);
                strFormat = TextFormat.formatString(strFormat, "p", null, pVal.z, Double.NaN, true);
                continue;
            }
            if (values[o] instanceof Point4f) {
                Point4f qVal = (Point4f)values[o];
                strFormat = TextFormat.formatString(strFormat, "q", null, qVal.x, Double.NaN, true);
                strFormat = TextFormat.formatString(strFormat, "q", null, qVal.y, Double.NaN, true);
                strFormat = TextFormat.formatString(strFormat, "q", null, qVal.z, Double.NaN, true);
                strFormat = TextFormat.formatString(strFormat, "q", null, qVal.w, Double.NaN, true);
                continue;
            }
            if (values[o] instanceof String[]) {
                String[] sVal = (String[])values[o];
                for (i = 0; i < sVal.length; ++i) {
                    strFormat = TextFormat.formatString(strFormat, "s", sVal[i], Float.NaN, Double.NaN, true);
                }
                continue;
            }
            if (values[o] instanceof float[]) {
                float[] fVal = (float[])values[o];
                for (i = 0; i < fVal.length; ++i) {
                    strFormat = TextFormat.formatString(strFormat, "f", null, fVal[i], Double.NaN, true);
                }
                continue;
            }
            if (values[o] instanceof double[]) {
                double[] dVal = (double[])values[o];
                for (i = 0; i < dVal.length; ++i) {
                    strFormat = TextFormat.formatString(strFormat, "e", null, Float.NaN, dVal[i], true);
                }
                continue;
            }
            if (!(values[o] instanceof int[])) continue;
            int[] iVal = (int[])values[o];
            for (i = 0; i < iVal.length; ++i) {
                strFormat = TextFormat.formatString(strFormat, "d", "" + iVal[i], Float.NaN, Double.NaN, true);
            }
            for (i = 0; i < iVal.length; ++i) {
                strFormat = TextFormat.formatString(strFormat, "i", "" + iVal[i], Float.NaN, Double.NaN, true);
            }
        }
        return TextFormat.simpleReplace(strFormat, "%%", "%");
    }

    private static String formatString(String strFormat, String key, String strT, float floatT, double doubleT, boolean doOne) {
        int ichKey;
        int ichPercent;
        if (strFormat == null) {
            return null;
        }
        if ("".equals(strFormat)) {
            return "";
        }
        int len = key.length();
        if (strFormat.indexOf("%") < 0 || len == 0 || strFormat.indexOf(key) < 0) {
            return strFormat;
        }
        String strLabel = "";
        int ich = 0;
        while ((ichPercent = strFormat.indexOf(37, ich)) >= 0 && (ichKey = strFormat.indexOf(key, ichPercent + 1)) >= 0) {
            if (ich != ichPercent) {
                strLabel = strLabel + strFormat.substring(ich, ichPercent);
            }
            ich = ichPercent + 1;
            if (ichKey > ichPercent + 6) {
                strLabel = strLabel + '%';
                continue;
            }
            try {
                String st;
                char ch;
                boolean alignLeft = false;
                if (strFormat.charAt(ich) == '-') {
                    alignLeft = true;
                    ++ich;
                }
                boolean zeroPad = false;
                if (strFormat.charAt(ich) == '0') {
                    zeroPad = true;
                    ++ich;
                }
                int width = 0;
                while ((ch = strFormat.charAt(ich)) >= '0' && ch <= '9') {
                    width = 10 * width + (ch - 48);
                    ++ich;
                }
                int precision = Integer.MAX_VALUE;
                boolean isExponential = false;
                if (strFormat.charAt(ich) == '.') {
                    if ((ch = strFormat.charAt(++ich)) == '-') {
                        isExponential = true;
                        ++ich;
                    }
                    if ((ch = strFormat.charAt(ich)) >= '0' && ch <= '9') {
                        precision = ch - 48;
                        ++ich;
                    }
                    if (isExponential) {
                        precision = -precision - (strT == null ? 1 : 0);
                    }
                }
                if (!(st = strFormat.substring(ich, ich + len)).equals(key)) {
                    ich = ichPercent + 1;
                    strLabel = strLabel + '%';
                    continue;
                }
                ich += len;
                if (!Float.isNaN(floatT)) {
                    strLabel = strLabel + TextFormat.format(floatT, width, precision, alignLeft, zeroPad);
                } else if (strT != null) {
                    strLabel = strLabel + TextFormat.format(strT, width, precision, alignLeft, zeroPad);
                } else if (!Double.isNaN(doubleT)) {
                    strLabel = strLabel + TextFormat.format(doubleT, width, precision, alignLeft, zeroPad);
                }
                if (!doOne) continue;
                break;
            }
            catch (IndexOutOfBoundsException ioobe) {
                ich = ichPercent;
                break;
            }
        }
        strLabel = strLabel + strFormat.substring(ich);
        return strLabel;
    }

    public static String formatCheck(String strFormat) {
        if (strFormat == null || strFormat.indexOf(112) < 0 && strFormat.indexOf(113) < 0) {
            return strFormat;
        }
        strFormat = TextFormat.simpleReplace(strFormat, "%%", "\u0001");
        strFormat = TextFormat.simpleReplace(strFormat, "%p", "%6.2p");
        strFormat = TextFormat.simpleReplace(strFormat, "%q", "%6.2q");
        String[] format = TextFormat.split(strFormat, '%');
        StringBuffer sb = new StringBuffer();
        sb.append(format[0]);
        for (int i = 1; i < format.length; ++i) {
            String f = "%" + format[i];
            if (f.length() >= 3) {
                int pt = f.indexOf(112);
                if (pt >= 0) {
                    f = TextFormat.fdup(f, pt, 3);
                }
                if ((pt = f.indexOf(113)) >= 0) {
                    f = TextFormat.fdup(f, pt, 4);
                }
            }
            sb.append(f);
        }
        return sb.toString().replace('\u0001', '%');
    }

    private static String fdup(String f, int pt, int n) {
        int count = 0;
        int i = pt;
        block4: while (--i >= 1) {
            char ch = f.charAt(i);
            if (Character.isDigit(ch)) continue;
            switch (ch) {
                case '.': {
                    if (count++ == 0) continue block4;
                    return f;
                }
                case '-': {
                    if (i == 1) continue block4;
                    return f;
                }
            }
            return f;
        }
        String s = f.substring(0, pt + 1);
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < n; ++i2) {
            sb.append(s);
        }
        sb.append(f.substring(pt + 1));
        return sb.toString();
    }

    public static String[] split(String text, String run) {
        int n = 1;
        int i = text.indexOf(run);
        int runLen = run.length();
        if (i < 0 || runLen == 0) {
            String[] lines = new String[]{text};
            return lines;
        }
        int len = text.length() - runLen;
        while (i >= 0 && i < len) {
            i = text.indexOf(run, i + runLen);
            ++n;
        }
        String[] lines = new String[n];
        i = 0;
        int ipt = 0;
        int pt = 0;
        while ((ipt = text.indexOf(run, i)) >= 0 && pt + 1 < n) {
            lines[pt++] = text.substring(i, ipt);
            i = ipt + runLen;
        }
        if (text.indexOf(run, len) != len) {
            len += runLen;
        }
        lines[pt] = text.substring(i, len);
        return lines;
    }

    public static String replaceAllCharacters(String str, String strFrom, String strTo) {
        int i = strFrom.length();
        while (--i >= 0) {
            String chFrom = strFrom.substring(i, i + 1);
            str = TextFormat.simpleReplace(str, chFrom, strTo);
        }
        return str;
    }

    public static String replaceAllCharacters(String str, String strFrom, char chTo) {
        int i = strFrom.length();
        while (--i >= 0) {
            str = str.replace(strFrom.charAt(i), chTo);
        }
        return str;
    }

    public static String simpleReplace(String str, String strFrom, String strTo) {
        boolean isOnce;
        if (str == null || str.indexOf(strFrom) < 0 || strFrom.equals(strTo)) {
            return str;
        }
        int fromLength = strFrom.length();
        if (fromLength == 0) {
            return str;
        }
        boolean bl = isOnce = strTo.indexOf(strFrom) >= 0;
        while (str.indexOf(strFrom) >= 0) {
            int ipt;
            StringBuffer s = new StringBuffer();
            int ipt0 = 0;
            while ((ipt = str.indexOf(strFrom, ipt0)) >= 0) {
                s.append(str.substring(ipt0, ipt)).append(strTo);
                ipt0 = ipt + fromLength;
            }
            s.append(str.substring(ipt0));
            str = s.toString();
            if (!isOnce) continue;
            break;
        }
        return str;
    }

    public static String trim(String str, String chars) {
        int m;
        int k;
        if (chars.length() == 0) {
            return str.trim();
        }
        int len = str.length();
        for (k = 0; k < len && chars.indexOf(str.charAt(k)) >= 0; ++k) {
        }
        for (m = str.length() - 1; m > k && chars.indexOf(str.charAt(m)) >= 0; --m) {
        }
        return str.substring(k, m + 1);
    }

    public static String[] split(String text, char ch) {
        return TextFormat.split(text, "" + ch);
    }

    public static void lFill(StringBuffer s, String s1, String s2) {
        s.append(s2);
        int n = s1.length() - s2.length();
        if (n > 0) {
            s.append(s1.substring(0, n));
        }
    }

    public static void rFill(StringBuffer s, String s1, String s2) {
        int n = s1.length() - s2.length();
        if (n > 0) {
            s.append(s1.substring(0, n));
        }
        s.append(s2);
    }

    public static String safeTruncate(float f, int n) {
        if ((double)f > -0.001 && (double)f < 0.001) {
            f = 0.0f;
        }
        return (f + "         ").substring(0, n);
    }

    public static boolean isWild(String s) {
        return s.indexOf("*") >= 0 || s.indexOf("?") >= 0;
    }

    public static boolean isMatch(String s, String strWildcard, boolean checkStar, boolean allowInitialStar) {
        boolean isStar0;
        int ich = 0;
        int cchWildcard = strWildcard.length();
        int cchs = s.length();
        if (cchs == 0 || cchWildcard == 0) {
            return cchs == cchWildcard || cchWildcard == 1 && strWildcard.charAt(0) == '*';
        }
        boolean bl = checkStar && allowInitialStar ? strWildcard.charAt(0) == '*' : (isStar0 = false);
        if (isStar0 && strWildcard.charAt(cchWildcard - 1) == '*') {
            return cchWildcard < 3 || s.indexOf(strWildcard.substring(1, cchWildcard - 1)) >= 0;
        }
        String qqq = "????";
        while (qqq.length() < s.length()) {
            qqq = qqq + qqq;
        }
        if (checkStar) {
            if (allowInitialStar && isStar0) {
                strWildcard = qqq + strWildcard.substring(1);
            }
            if (strWildcard.charAt(ich = strWildcard.length() - 1) == '*') {
                strWildcard = strWildcard.substring(0, ich) + qqq;
            }
            cchWildcard = strWildcard.length();
        }
        if (cchWildcard < cchs) {
            return false;
        }
        ich = 0;
        while (cchWildcard > cchs) {
            if (allowInitialStar && strWildcard.charAt(ich) == '?') {
                ++ich;
            } else if (strWildcard.charAt(ich + cchWildcard - 1) != '?') {
                return false;
            }
            --cchWildcard;
        }
        int i = cchs;
        while (--i >= 0) {
            char charWild = strWildcard.charAt(ich + i);
            if (charWild == '?' || charWild == s.charAt(i) || charWild == '\u0001' && s.charAt(i) == '?') continue;
            return false;
        }
        return true;
    }

    public static String join(String[] s, char c, int i0) {
        if (s.length < i0) {
            return null;
        }
        StringBuffer sb = new StringBuffer(s[i0++]);
        for (int i = i0; i < s.length; ++i) {
            sb.append(c).append(s[i]);
        }
        return sb.toString();
    }
}

