/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.modelset.ModelSet;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

class AnimationManager {
    Viewer viewer;
    int currentModelIndex = 0;
    int backgroundModelIndex = -1;
    private BitSet bsVisibleFrames = new BitSet();
    AnimationThread animationThread;
    boolean inMotion = false;
    int firstModelIndex;
    int lastModelIndex;
    int frameStep;
    int animationDirection = 1;
    int currentDirection = 1;
    int animationFps;
    static final int ANIMATION_ONCE = 0;
    static final int ANIMATION_LOOP = 1;
    static final int ANIMATION_PALINDROME = 2;
    int animationReplayMode = 0;
    float firstFrameDelay;
    float lastFrameDelay;
    int firstFrameDelayMs;
    int lastFrameDelayMs;
    boolean animationOn = false;
    boolean animationPaused = false;
    int intAnimThread = 0;

    AnimationManager(Viewer viewer) {
        this.viewer = viewer;
    }

    void setCurrentModelIndex(int modelIndex) {
        this.setCurrentModelIndex(modelIndex, true);
    }

    void setCurrentModelIndex(int modelIndex, boolean clearBackgroundModel) {
        int modelCount;
        int formerModelIndex = this.currentModelIndex;
        ModelSet modelSet = this.viewer.getModelSet();
        int n = modelCount = modelSet == null ? 0 : modelSet.getModelCount();
        if (modelCount == 1) {
            modelIndex = 0;
            this.currentModelIndex = 0;
        } else if (modelIndex < 0 || modelIndex >= modelCount) {
            modelIndex = -1;
        }
        String ids = null;
        boolean isSameSource = false;
        if (this.currentModelIndex != modelIndex) {
            if (modelCount > 0) {
                boolean toDataFrame = this.viewer.isJmolDataFrame(modelIndex);
                boolean fromDataFrame = this.viewer.isJmolDataFrame(this.currentModelIndex);
                if (fromDataFrame) {
                    this.viewer.setJmolDataFrame(null, -1, this.currentModelIndex);
                }
                if (this.currentModelIndex != -1) {
                    this.viewer.saveModelOrientation();
                }
                if (fromDataFrame || toDataFrame) {
                    ids = this.viewer.getJmolFrameType(modelIndex) + this.viewer.getJmolFrameType(this.currentModelIndex);
                    isSameSource = this.viewer.getJmolDataSourceFrame(modelIndex) == this.viewer.getJmolDataSourceFrame(this.currentModelIndex);
                }
            }
            this.currentModelIndex = modelIndex;
            if (ids != null) {
                if (modelIndex >= 0) {
                    this.viewer.restoreModelOrientation(modelIndex);
                }
                if (isSameSource && ids.indexOf("quaternion") >= 0 && ids.indexOf("ramachandran") < 0) {
                    this.viewer.restoreModelRotation(formerModelIndex);
                }
            }
        }
        this.viewer.setTrajectory(this.currentModelIndex);
        this.viewer.setFrameOffset(this.currentModelIndex);
        if (this.currentModelIndex == -1 && clearBackgroundModel) {
            this.setBackgroundModelIndex(-1);
        }
        this.viewer.setTainted(true);
        this.setFrameRangeVisible();
        if (modelSet != null) {
            this.setStatusFrameChanged();
            if (!this.viewer.getSelectAllModels()) {
                this.viewer.setSelectionSubset(this.viewer.getModelAtomBitSet(this.currentModelIndex, false));
            }
        }
    }

    private void setStatusFrameChanged() {
        this.viewer.setStatusFrameChanged(this.animationOn ? -2 - this.currentModelIndex : this.currentModelIndex);
    }

    void setBackgroundModelIndex(int modelIndex) {
        ModelSet modelSet = this.viewer.getModelSet();
        if (modelSet == null || modelIndex < 0 || modelIndex >= modelSet.getModelCount()) {
            modelIndex = -1;
        }
        this.backgroundModelIndex = modelIndex;
        if (modelIndex >= 0) {
            this.viewer.setTrajectory(modelIndex);
        }
        this.viewer.setTainted(true);
        this.setFrameRangeVisible();
    }

    BitSet getVisibleFramesBitSet() {
        return this.bsVisibleFrames;
    }

    private void setFrameRangeVisible() {
        this.bsVisibleFrames.clear();
        if (this.backgroundModelIndex >= 0) {
            this.bsVisibleFrames.set(this.backgroundModelIndex);
        }
        if (this.currentModelIndex >= 0) {
            this.bsVisibleFrames.set(this.currentModelIndex);
            return;
        }
        if (this.frameStep == 0) {
            return;
        }
        int nDisplayed = 0;
        int frameDisplayed = 0;
        for (int i = this.firstModelIndex; i != this.lastModelIndex; i += this.frameStep) {
            if (this.viewer.isJmolDataFrame(i)) continue;
            this.bsVisibleFrames.set(i);
            ++nDisplayed;
            frameDisplayed = i;
        }
        if (this.firstModelIndex == this.lastModelIndex || !this.viewer.isJmolDataFrame(this.lastModelIndex) || nDisplayed == 0) {
            this.bsVisibleFrames.set(this.lastModelIndex);
            if (nDisplayed == 0) {
                this.firstModelIndex = this.lastModelIndex;
            }
            nDisplayed = 0;
        }
        if (nDisplayed == 1 && this.currentModelIndex < 0) {
            this.setCurrentModelIndex(frameDisplayed);
        }
    }

    void setInMotion(boolean inMotion) {
        this.inMotion = inMotion;
    }

    void initializePointers(int frameStep) {
        this.firstModelIndex = 0;
        int modelCount = this.viewer.getModelCount();
        this.lastModelIndex = (frameStep == 0 ? 0 : modelCount) - 1;
        this.frameStep = frameStep;
        this.viewer.setFrameVariables(this.firstModelIndex, this.lastModelIndex);
    }

    void clear() {
        this.clearAnimation();
    }

    void clearAnimation() {
        this.setAnimationOn(false);
        this.setCurrentModelIndex(0);
        this.setAnimationDirection(1);
        this.setAnimationFps(10);
        this.setAnimationReplayMode(0, 0.0f, 0.0f);
        this.initializePointers(0);
    }

    Hashtable getAnimationInfo() {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("firstModelIndex", new Integer(this.firstModelIndex));
        info.put("lastModelIndex", new Integer(this.lastModelIndex));
        info.put("animationDirection", new Integer(this.animationDirection));
        info.put("currentDirection", new Integer(this.currentDirection));
        info.put("displayModelIndex", new Integer(this.currentModelIndex));
        info.put("displayModelNumber", this.viewer.getModelNumberDotted(this.currentModelIndex));
        info.put("displayModelName", this.currentModelIndex >= 0 ? this.viewer.getModelName(this.currentModelIndex) : "");
        info.put("animationFps", new Integer(this.animationFps));
        info.put("animationReplayMode", this.getAnimationModeName());
        info.put("firstFrameDelay", new Float(this.firstFrameDelay));
        info.put("lastFrameDelay", new Float(this.lastFrameDelay));
        info.put("animationOn", this.animationOn);
        info.put("animationPaused", this.animationPaused);
        return info;
    }

    String getState(StringBuffer sfunc) {
        BitSet bs;
        int modelCount = this.viewer.getModelCount();
        if (modelCount < 2) {
            return "";
        }
        StringBuffer commands = new StringBuffer();
        if (sfunc != null) {
            sfunc.append("  _setFrameState;\n");
            commands.append("function _setFrameState() {\n");
        }
        commands.append("# frame state;\n");
        commands.append("# modelCount ").append(modelCount).append(";\n# first ").append(this.viewer.getModelNumberDotted(0)).append(";\n# last ").append(this.viewer.getModelNumberDotted(modelCount - 1)).append(";\n");
        if (this.backgroundModelIndex >= 0) {
            StateManager.appendCmd(commands, "set backgroundModel " + this.viewer.getModelNumberDotted(this.backgroundModelIndex));
        }
        if ((bs = this.viewer.getFrameOffsets()) != null) {
            StateManager.appendCmd(commands, "frame align " + Escape.escape(bs));
        }
        StateManager.appendCmd(commands, "frame RANGE " + this.viewer.getModelNumberDotted(this.firstModelIndex) + " " + this.viewer.getModelNumberDotted(this.lastModelIndex));
        StateManager.appendCmd(commands, "animation DIRECTION " + (this.animationDirection == 1 ? "+1" : "-1"));
        StateManager.appendCmd(commands, "animation FPS " + this.animationFps);
        StateManager.appendCmd(commands, "animation MODE " + this.getAnimationModeName() + " " + this.firstFrameDelay + " " + this.lastFrameDelay);
        StateManager.appendCmd(commands, "frame " + this.viewer.getModelNumberDotted(this.currentModelIndex));
        StateManager.appendCmd(commands, "animation " + (!this.animationOn ? "OFF" : (this.currentDirection == 1 ? "PLAY" : "PLAYREV")));
        if (this.animationOn && this.animationPaused) {
            StateManager.appendCmd(commands, "animation PAUSE");
        }
        if (sfunc != null) {
            commands.append("}\n\n");
        }
        return commands.toString();
    }

    void setAnimationDirection(int animationDirection) {
        this.animationDirection = animationDirection;
    }

    void setAnimationFps(int animationFps) {
        this.animationFps = animationFps;
    }

    void setAnimationReplayMode(int animationReplayMode, float firstFrameDelay, float lastFrameDelay) {
        this.firstFrameDelay = firstFrameDelay > 0.0f ? firstFrameDelay : 0.0f;
        this.firstFrameDelayMs = (int)(this.firstFrameDelay * 1000.0f);
        this.lastFrameDelay = lastFrameDelay > 0.0f ? lastFrameDelay : 0.0f;
        this.lastFrameDelayMs = (int)(this.lastFrameDelay * 1000.0f);
        if (animationReplayMode >= 0 && animationReplayMode <= 2) {
            this.animationReplayMode = animationReplayMode;
        } else {
            Logger.error("invalid animationReplayMode:" + animationReplayMode);
        }
    }

    void setAnimationRange(int framePointer, int framePointer2) {
        int modelCount = this.viewer.getModelCount();
        if (framePointer < 0) {
            framePointer = 0;
        }
        if (framePointer2 < 0) {
            framePointer2 = modelCount;
        }
        if (framePointer >= modelCount) {
            framePointer = modelCount - 1;
        }
        if (framePointer2 >= modelCount) {
            framePointer2 = modelCount - 1;
        }
        this.firstModelIndex = framePointer;
        this.lastModelIndex = framePointer2;
        this.frameStep = framePointer2 < framePointer ? -1 : 1;
        this.rewindAnimation();
    }

    private void animationOn(boolean TF) {
        this.animationOn = TF;
        this.viewer.setBooleanProperty("_animating", TF);
    }

    void setAnimationOn(boolean animationOn) {
        if (!animationOn || !this.viewer.haveModelSet()) {
            this.setAnimationOff(false);
            return;
        }
        this.viewer.refresh(3, "Viewer:setAnimationOn");
        this.setAnimationRange(-1, -1);
        this.resumeAnimation();
    }

    void setAnimationOff(boolean isPaused) {
        if (this.animationThread != null) {
            this.animationThread.interrupt();
            this.animationThread = null;
        }
        this.animationPaused = isPaused;
        this.viewer.refresh(3, "Viewer:setAnimationOff");
        this.animationOn(false);
        this.setStatusFrameChanged();
    }

    void pauseAnimation() {
        this.setAnimationOff(true);
    }

    void reverseAnimation() {
        this.currentDirection = -this.currentDirection;
        if (!this.animationOn) {
            this.resumeAnimation();
        }
    }

    void resumeAnimation() {
        if (this.currentModelIndex < 0) {
            this.setAnimationRange(this.firstModelIndex, this.lastModelIndex);
        }
        if (this.viewer.getModelCount() <= 1) {
            this.animationOn(false);
            return;
        }
        this.animationOn(true);
        this.animationPaused = false;
        if (this.animationThread == null) {
            ++this.intAnimThread;
            this.animationThread = new AnimationThread(this.firstModelIndex, this.lastModelIndex, this.intAnimThread);
            this.animationThread.start();
        }
    }

    boolean setAnimationNext() {
        return this.setAnimationRelative(this.animationDirection);
    }

    void setAnimationLast() {
        this.setCurrentModelIndex(this.animationDirection > 0 ? this.lastModelIndex : this.firstModelIndex);
    }

    void rewindAnimation() {
        this.setCurrentModelIndex(this.animationDirection > 0 ? this.firstModelIndex : this.lastModelIndex);
        this.currentDirection = 1;
        this.viewer.setFrameVariables(this.firstModelIndex, this.lastModelIndex);
    }

    boolean setAnimationPrevious() {
        return this.setAnimationRelative(-this.animationDirection);
    }

    boolean setAnimationRelative(int direction) {
        boolean isDone;
        int frameStep = this.frameStep * direction * this.currentDirection;
        int modelIndexNext = this.currentModelIndex + frameStep;
        boolean bl = isDone = modelIndexNext > this.firstModelIndex && modelIndexNext > this.lastModelIndex || modelIndexNext < this.firstModelIndex && modelIndexNext < this.lastModelIndex;
        if (isDone) {
            switch (this.animationReplayMode) {
                case 0: {
                    return false;
                }
                case 1: {
                    modelIndexNext = this.animationDirection == this.currentDirection ? this.firstModelIndex : this.lastModelIndex;
                    break;
                }
                case 2: {
                    this.currentDirection = -this.currentDirection;
                    modelIndexNext -= 2 * frameStep;
                }
            }
        }
        int nModels = this.viewer.getModelCount();
        if (modelIndexNext < 0 || modelIndexNext >= nModels) {
            return false;
        }
        this.setCurrentModelIndex(modelIndexNext);
        return true;
    }

    String getAnimationModeName() {
        switch (this.animationReplayMode) {
            case 1: {
                return "LOOP";
            }
            case 2: {
                return "PALINDROME";
            }
        }
        return "ONCE";
    }

    class AnimationThread
    extends Thread
    implements Runnable {
        final int framePointer;
        final int framePointer2;
        int intThread;

        AnimationThread(int framePointer, int framePointer2, int intAnimThread) {
            this.framePointer = framePointer;
            this.framePointer2 = framePointer2;
            this.setName("AnimationThread");
            this.intThread = intAnimThread;
        }

        public void run() {
            long timeBegin = System.currentTimeMillis();
            int targetTime = 0;
            if (Logger.debugging) {
                Logger.debug("animation thread " + this.intThread + " running");
            }
            AnimationManager.this.viewer.requestRepaintAndWait();
            try {
                int sleepTime = targetTime - (int)(System.currentTimeMillis() - timeBegin);
                if (sleepTime > 0) {
                    Thread.sleep(sleepTime);
                }
                boolean isFirst = true;
                while (!this.isInterrupted() && AnimationManager.this.animationOn) {
                    if (AnimationManager.this.currentModelIndex == this.framePointer && (sleepTime = (targetTime += AnimationManager.this.firstFrameDelayMs) - (int)(System.currentTimeMillis() - timeBegin)) > 0) {
                        Thread.sleep(sleepTime);
                    }
                    if (AnimationManager.this.currentModelIndex == this.framePointer2 && (sleepTime = (targetTime += AnimationManager.this.lastFrameDelayMs) - (int)(System.currentTimeMillis() - timeBegin)) > 0) {
                        Thread.sleep(sleepTime);
                    }
                    if (!(isFirst || AnimationManager.this.viewer.isRepaintPending() || AnimationManager.this.setAnimationNext())) {
                        Logger.debug("animation thread " + this.intThread + " exiting");
                        AnimationManager.this.setAnimationOff(false);
                        return;
                    }
                    isFirst = false;
                    sleepTime = (targetTime += 1000 / AnimationManager.this.animationFps) - (int)(System.currentTimeMillis() - timeBegin);
                    while (!this.isInterrupted() && AnimationManager.this.animationOn && !AnimationManager.this.viewer.getRefreshing()) {
                        Thread.sleep(10L);
                    }
                    AnimationManager.this.viewer.refresh(1, "animationThread");
                    sleepTime = targetTime - (int)(System.currentTimeMillis() - timeBegin);
                    if (sleepTime <= 0) continue;
                    Thread.sleep(sleepTime);
                }
            }
            catch (InterruptedException ie) {
                Logger.debug("animation thread interrupted!");
                try {
                    AnimationManager.this.setAnimationOn(false);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }
}

