/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.HBond;
import org.jmol.modelset.ModelSet;
import org.jmol.util.ArrayUtil;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

class ColorManager {
    private Viewer viewer;
    private Graphics3D g3d;
    private int[] argbsCpk;
    private int[] altArgbsCpk;
    private float colorHi;
    private float colorLo;
    private float[] colorData;
    private int palette = 0;
    private boolean isDefaultColorRasmol;
    short colixRubberband = (short)22;
    short colixBackgroundContrast;

    ColorManager(Viewer viewer, Graphics3D g3d) {
        this.viewer = viewer;
        this.g3d = g3d;
        this.argbsCpk = JmolConstants.argbsCpk;
        this.altArgbsCpk = ArrayUtil.arrayCopy(JmolConstants.altArgbsCpk, 0, -1, false);
    }

    void clear() {
    }

    boolean getDefaultColorRasmol() {
        return this.isDefaultColorRasmol;
    }

    void resetElementColors() {
        this.setDefaultColors("Jmol");
    }

    void setDefaultColors(String colorScheme) {
        if (colorScheme.equalsIgnoreCase("Jmol")) {
            this.isDefaultColorRasmol = false;
            this.argbsCpk = JmolConstants.argbsCpk;
        } else if (colorScheme.equalsIgnoreCase("RasMol")) {
            this.isDefaultColorRasmol = true;
            this.argbsCpk = ColorEncoder.getRasmolScale(true);
        } else {
            Logger.error("unrecognized color scheme");
            return;
        }
        this.altArgbsCpk = ArrayUtil.arrayCopy(JmolConstants.altArgbsCpk, 0, -1, false);
        ColorEncoder.makeColorScheme(colorScheme, null, true);
        int i = JmolConstants.argbsCpk.length;
        while (--i >= 0) {
            this.g3d.changeColixArgb((short)i, this.argbsCpk[i]);
        }
        i = JmolConstants.altArgbsCpk.length;
        while (--i >= 0) {
            this.g3d.changeColixArgb((short)(JmolConstants.elementNumberMax + i), this.altArgbsCpk[i]);
        }
    }

    void setRubberbandArgb(int argb) {
        this.colixRubberband = argb == 0 ? (short)0 : Graphics3D.getColix(argb);
    }

    void setColixBackgroundContrast(int argb) {
        this.colixBackgroundContrast = (short)((Graphics3D.calcGreyscaleRgbFromRgb(argb) & 0xFF) < 128 ? 8 : 4);
    }

    short getColixBondPalette(Bond bond, byte pid) {
        int argb = 0;
        switch (pid) {
            case 19: {
                return ColorEncoder.getColorIndexFromPalette(((HBond)bond).getEnergy(), 0.5f, 4.5f, 3);
            }
        }
        return argb == 0 ? (short)10 : (short)Graphics3D.getColix(argb);
    }

    short getColixAtomPalette(Atom atom, byte pid) {
        int argb = 0;
        switch (pid) {
            case 84: {
                return this.getPropertyColix(atom.getAtomIndex());
            }
            case 0: 
            case 1: {
                short id = atom.getAtomicAndIsotopeNumber();
                if (id < JmolConstants.elementNumberMax) {
                    return this.g3d.getChangeableColix(id, this.argbsCpk[id]);
                }
                id = (short)JmolConstants.altElementIndexFromNumber(id);
                return this.g3d.getChangeableColix((short)(JmolConstants.elementNumberMax + id), this.altArgbsCpk[id]);
            }
            case 2: {
                int index = ColorEncoder.quantize(atom.getPartialCharge(), -1.0f, 1.0f, 31);
                return this.g3d.getChangeableColix((short)(JmolConstants.PARTIAL_CHARGE_COLIX_RED + index), JmolConstants.argbsRwbScale[index]);
            }
            case 3: {
                int index = atom.getFormalCharge() - -4;
                return this.g3d.getChangeableColix((short)(JmolConstants.FORMAL_CHARGE_COLIX_RED + index), JmolConstants.argbsFormalCharge[index]);
            }
            case 5: 
            case 68: {
                float hi;
                float lo;
                if (pid == 68) {
                    ModelSet modelSet = this.viewer.getModelSet();
                    lo = modelSet.getBfactor100Lo();
                    hi = modelSet.getBfactor100Hi();
                } else {
                    lo = 0.0f;
                    hi = 10000.0f;
                }
                return ColorEncoder.getColorIndexFromPalette(atom.getBfactor100(), lo, hi, 3);
            }
            case 86: {
                return ColorEncoder.getColorIndexFromPalette(atom.getStraightness(), -1.0f, 1.0f, 3);
            }
            case 70: {
                float hi = this.viewer.getSurfaceDistanceMax();
                return ColorEncoder.getColorIndexFromPalette(atom.getSurfaceDistance100(), 0.0f, hi, 3);
            }
            case 8: {
                return ColorEncoder.getColorIndexFromPalette(atom.getGroupID(), 0.0f, 0.0f, 9);
            }
            case 9: {
                return ColorEncoder.getColorIndexFromPalette(atom.getGroupID(), 0.0f, 0.0f, 8);
            }
            case 75: {
                return ColorEncoder.getColorIndexFromPalette(atom.getSelectedGroupIndexWithinChain(), 0.0f, atom.getSelectedGroupCountWithinChain() - 1, 1);
            }
            case 76: {
                return ColorEncoder.getColorIndexFromPalette(atom.getSelectedMonomerIndexWithinPolymer(), 0.0f, atom.getSelectedMonomerCountWithinPolymer() - 1, 1);
            }
            case 77: {
                ModelSet modelSet = this.viewer.getModelSet();
                return ColorEncoder.getColorIndexFromPalette(modelSet.getMoleculeIndex(atom.getAtomIndex()), 0.0f, modelSet.getMoleculeCountInModel(atom.getModelIndex()) - 1, 0);
            }
            case 14: {
                ModelSet modelSet = this.viewer.getModelSet();
                int modelIndex = atom.getModelIndex();
                return ColorEncoder.getColorIndexFromPalette(modelSet.getAltLocIndexInModel(modelIndex, atom.getAlternateLocationID()), 0.0f, modelSet.getAltLocCountInModel(modelIndex), 0);
            }
            case 15: {
                ModelSet modelSet = this.viewer.getModelSet();
                int modelIndex = atom.getModelIndex();
                return ColorEncoder.getColorIndexFromPalette(modelSet.getInsertionCodeIndexInModel(modelIndex, atom.getInsertionCode()), 0.0f, modelSet.getInsertionCountInModel(modelIndex), 0);
            }
            case 16: {
                short id = atom.getAtomicAndIsotopeNumber();
                argb = ColorManager.getJmolOrRasmolArgb(id, 1073741847);
                break;
            }
            case 17: {
                short id = atom.getAtomicAndIsotopeNumber();
                argb = ColorManager.getJmolOrRasmolArgb(id, 1073741869);
                break;
            }
            case 7: {
                argb = JmolConstants.argbsStructure[atom.getProteinStructureType()];
                break;
            }
            case 10: {
                int chain = atom.getChainID() & 0x1F;
                if (chain < 0) {
                    chain = 0;
                }
                if (chain >= JmolConstants.argbsChainAtom.length) {
                    chain %= JmolConstants.argbsChainAtom.length;
                }
                argb = (atom.isHetero() ? JmolConstants.argbsChainHetero : JmolConstants.argbsChainAtom)[chain];
            }
        }
        return argb == 0 ? (short)22 : (short)Graphics3D.getColix(argb);
    }

    private short getPropertyColix(int iAtom) {
        if (this.colorData == null || iAtom >= this.colorData.length) {
            return 12;
        }
        return this.getColixForPropertyValue(this.colorData[iAtom]);
    }

    private static int getJmolOrRasmolArgb(int id, int argb) {
        switch (argb) {
            case 1073741847: {
                if (id >= JmolConstants.elementNumberMax) break;
                return ColorEncoder.getArgbFromPalette(id, 0.0f, 0.0f, 6);
            }
            case 1073741869: {
                if (id >= JmolConstants.elementNumberMax) break;
                return ColorEncoder.getArgbFromPalette(id, 0.0f, 0.0f, 7);
            }
            default: {
                return argb;
            }
        }
        return JmolConstants.altArgbsCpk[JmolConstants.altElementIndexFromNumber(id)];
    }

    void setElementArgb(int id, int argb) {
        if (argb == 1073741847 && this.argbsCpk == JmolConstants.argbsCpk) {
            return;
        }
        argb = ColorManager.getJmolOrRasmolArgb(id, argb);
        if (this.argbsCpk == JmolConstants.argbsCpk) {
            this.argbsCpk = ArrayUtil.arrayCopy(JmolConstants.argbsCpk, 0, -1, false);
            this.altArgbsCpk = ArrayUtil.arrayCopy(JmolConstants.altArgbsCpk, 0, -1, false);
        }
        if (id < JmolConstants.elementNumberMax) {
            this.argbsCpk[id] = argb;
            this.g3d.changeColixArgb((short)id, argb);
            return;
        }
        id = JmolConstants.altElementIndexFromNumber(id);
        this.altArgbsCpk[id] = argb;
        this.g3d.changeColixArgb((short)(JmolConstants.elementNumberMax + id), argb);
    }

    int setColorScheme(String colorScheme, boolean isOverloaded) {
        this.palette = ColorEncoder.getColorScheme(colorScheme, isOverloaded);
        Logger.info("ColorManager: color scheme now \"" + ColorEncoder.getColorSchemeName(this.palette) + "\" color value range: " + this.colorLo + " to " + this.colorHi);
        return this.palette;
    }

    float[] getCurrentColorRange() {
        return new float[]{this.colorLo, this.colorHi};
    }

    void setCurrentColorRange(float[] data, BitSet bs, String colorScheme) {
        this.colorData = data;
        this.palette = ColorEncoder.getColorScheme(colorScheme, false);
        this.colorHi = Float.MIN_VALUE;
        this.colorLo = Float.MAX_VALUE;
        if (data == null) {
            return;
        }
        int i = data.length;
        while (--i >= 0) {
            float d;
            if (bs != null && !bs.get(i) || Float.isNaN(d = data[i])) continue;
            this.colorHi = Math.max(this.colorHi, d);
            this.colorLo = Math.min(this.colorLo, d);
        }
        this.setCurrentColorRange(this.colorLo, this.colorHi);
    }

    void setCurrentColorRange(float min, float max) {
        this.colorHi = max;
        this.colorLo = min;
        Logger.info("color \"" + ColorEncoder.getColorSchemeName(this.palette) + "\" range " + this.colorLo + " " + this.colorHi);
    }

    static String getState(StringBuffer sfunc) {
        return ColorEncoder.getState(sfunc);
    }

    static void setUserScale(int[] scale) {
        ColorEncoder.setUserScale(scale);
    }

    int[] getColorSchemeArray(String colorScheme) {
        return ColorEncoder.getColorSchemeArray(colorScheme == null || colorScheme.length() == 0 ? this.palette : ColorEncoder.getColorScheme(colorScheme, false));
    }

    String getColorSchemeList(String colorScheme, boolean ifDefault) {
        if (!ifDefault && ColorEncoder.getColorScheme(colorScheme, false) >= 0) {
            return "";
        }
        return ColorEncoder.getColorSchemeList(this.getColorSchemeArray(colorScheme));
    }

    short getColixForPropertyValue(float val) {
        return this.colorLo < this.colorHi ? ColorEncoder.getColorIndexFromPalette(val, this.colorLo, this.colorHi, this.palette) : ColorEncoder.getColorIndexFromPalette(-val, -this.colorLo, -this.colorHi, this.palette);
    }

    private static void flushCaches() {
        Graphics3D.flushShadesAndSphereCaches();
    }

    static void setSpecular(boolean specular) {
        if (Graphics3D.getSpecular() == specular) {
            return;
        }
        Graphics3D.setSpecular(specular);
        ColorManager.flushCaches();
    }

    static boolean getSpecular() {
        return Graphics3D.getSpecular();
    }

    static void setSpecularPercent(int specularPercent) {
        if (Graphics3D.getSpecularPercent() == specularPercent) {
            return;
        }
        Graphics3D.setSpecularPercent(specularPercent);
        ColorManager.flushCaches();
    }

    static int getSpecularPercent() {
        return Graphics3D.getSpecularPercent();
    }

    static void setSpecularPower(int specularPower) {
        if (specularPower < 0) {
            if (Graphics3D.getSpecularExponent() == -specularPower) {
                return;
            }
            Graphics3D.setSpecularExponent(-specularPower);
        } else {
            if (Graphics3D.getSpecularPower() == specularPower) {
                return;
            }
            Graphics3D.setSpecularPower(specularPower);
        }
        ColorManager.flushCaches();
    }

    static void setDiffusePercent(int diffusePercent) {
        if (Graphics3D.getDiffusePercent() == diffusePercent) {
            return;
        }
        Graphics3D.setDiffusePercent(diffusePercent);
        ColorManager.flushCaches();
    }

    static int getDiffusePercent() {
        return Graphics3D.getDiffusePercent();
    }

    static void setAmbientPercent(int ambientPercent) {
        if (Graphics3D.getAmbientPercent() == ambientPercent) {
            return;
        }
        Graphics3D.setAmbientPercent(ambientPercent);
        ColorManager.flushCaches();
    }

    static int getAmbientPercent() {
        return Graphics3D.getAmbientPercent();
    }
}

