/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import org.jmol.modelset.ModelLoader;
import org.jmol.modelset.ModelSet;
import org.jmol.viewer.Viewer;

class ModelManager {
    private final Viewer viewer;
    private ModelLoader modelLoader;
    private String fullPathName;
    private String fileName;

    ModelManager(Viewer viewer) {
        this.viewer = viewer;
    }

    ModelSet clear() {
        this.fileName = null;
        this.fullPathName = null;
        this.modelLoader = null;
        return null;
    }

    ModelSet zap() {
        this.clear();
        this.fullPathName = this.fileName;
        this.modelLoader = new ModelLoader(this.viewer, "empty");
        return this.modelLoader;
    }

    String getModelSetFileName() {
        return this.fileName == null ? "zapped" : this.fileName;
    }

    String getModelSetPathName() {
        return this.fullPathName;
    }

    ModelSet merge(Object atomSetCollection) {
        this.modelLoader = new ModelLoader(this.viewer, atomSetCollection, this.modelLoader, "merge");
        if (this.modelLoader.getAtomCount() == 0) {
            this.zap();
        }
        return this.modelLoader;
    }

    ModelSet createModelSet(String fullPathName, String fileName, Object atomSetCollection, boolean isAppend) {
        if (atomSetCollection == null) {
            this.clear();
            return null;
        }
        if (isAppend) {
            return this.merge(atomSetCollection);
        }
        this.fullPathName = fullPathName;
        this.fileName = fileName;
        String modelSetName = this.viewer.getModelAdapter().getAtomSetCollectionName(atomSetCollection);
        if (modelSetName != null && (modelSetName = modelSetName.trim()).length() == 0) {
            modelSetName = null;
        }
        if (modelSetName == null) {
            modelSetName = ModelManager.reduceFilename(fileName);
        }
        this.modelLoader = new ModelLoader(this.viewer, atomSetCollection, null, modelSetName);
        if (this.modelLoader.getAtomCount() == 0) {
            this.zap();
        }
        return this.modelLoader;
    }

    private static String reduceFilename(String fileName) {
        if (fileName == null) {
            return null;
        }
        int ichDot = fileName.indexOf(46);
        if (ichDot > 0) {
            fileName = fileName.substring(0, ichDot);
        }
        if (fileName.length() > 24) {
            fileName = fileName.substring(0, 20) + " ...";
        }
        return fileName;
    }
}

