/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.i18n.GT;
import org.jmol.modelset.MeasurementPending;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.viewer.Viewer;

class PickingManager {
    private Viewer viewer;
    private int pickingMode = 1;
    private int pickingStyleSelect = 0;
    private int pickingStyleMeasure = 5;
    private boolean drawHover;
    private int pickingStyle;
    private MeasurementPending measurementQueued;

    PickingManager(Viewer viewer) {
        this.viewer = viewer;
        this.clear();
    }

    void clear() {
        this.pickingMode = 1;
        this.drawHover = false;
    }

    void setPickingMode(int pickingMode) {
        this.pickingMode = pickingMode;
        this.resetMeasurement();
    }

    int getPickingMode() {
        return this.pickingMode;
    }

    private void resetMeasurement() {
        this.measurementQueued = new MeasurementPending(this.viewer.getModelSet());
    }

    void setPickingStyle(int pickingStyle) {
        this.pickingStyle = pickingStyle;
        if (pickingStyle >= 4) {
            this.pickingStyleMeasure = pickingStyle;
            this.resetMeasurement();
        } else {
            this.pickingStyleSelect = pickingStyle;
        }
    }

    int getPickingStyle() {
        return this.pickingStyle;
    }

    void setDrawHover(boolean TF) {
        this.drawHover = TF;
    }

    boolean getDrawHover() {
        return this.drawHover;
    }

    void atomsPicked(BitSet bs, int modifiers) {
        if (BitSetUtil.firstSetBit(bs) < 0) {
            return;
        }
        this.pickSelected(Escape.escape(bs), modifiers, false);
    }

    private void pickSelected(String spec, int modifiers, boolean isDoubleClick) {
        boolean shiftKey = (modifiers & 1) != 0;
        boolean alternateKey = (modifiers & 8) != 0;
        switch (this.pickingMode) {
            case 2: {
                this.viewer.script("set labeltoggle " + spec);
                return;
            }
            case 1: 
            case 8: {
                this.applyMouseStyle(spec, shiftKey, alternateKey, isDoubleClick);
                this.viewer.clearClickCount();
                return;
            }
            case 9: {
                this.applyMouseStyle("within(group, " + spec + ")", shiftKey, alternateKey, isDoubleClick);
                this.viewer.clearClickCount();
                return;
            }
            case 10: {
                this.applyMouseStyle("within(chain, " + spec + ")", shiftKey, alternateKey, isDoubleClick);
                this.viewer.clearClickCount();
                return;
            }
            case 11: {
                this.applyMouseStyle("visible and within(molecule, " + spec + ")", shiftKey, alternateKey, isDoubleClick);
                this.viewer.clearClickCount();
                return;
            }
            case 12: {
                this.applyMouseStyle("visible and within(site, " + spec + ")", shiftKey, alternateKey, isDoubleClick);
                this.viewer.clearClickCount();
                return;
            }
            case 13: {
                this.applyMouseStyle("within(model, " + spec + ")", shiftKey, alternateKey, isDoubleClick);
                this.viewer.clearClickCount();
                return;
            }
            case 14: {
                this.applyMouseStyle("visible and within(element, " + spec + ")", shiftKey, alternateKey, isDoubleClick);
                this.viewer.clearClickCount();
                return;
            }
        }
    }

    void atomPicked(int atomIndex, Point3f ptClicked, int modifiers, boolean isDoubleClick) {
        boolean alternateKey;
        boolean shiftKey = (modifiers & 1) != 0;
        boolean bl = alternateKey = (modifiers & 8) != 0;
        if (atomIndex < 0) {
            if (isDoubleClick) {
                return;
            }
            if (this.pickingStyleSelect == 2 && !shiftKey && !alternateKey) {
                this.viewer.script("select none");
            }
            this.resetMeasurement();
            if (this.pickingMode != 5) {
                return;
            }
        }
        int n = 2;
        switch (this.pickingMode) {
            case 0: {
                return;
            }
            case 18: {
                ++n;
            }
            case 17: {
                ++n;
            }
            case 15: 
            case 16: {
                if (isDoubleClick) {
                    return;
                }
                if (this.measurementQueued == null || this.measurementQueued.getCount() >= n) {
                    this.resetMeasurement();
                }
                if (this.queueAtom(atomIndex, ptClicked) < n) {
                    return;
                }
                this.viewer.setStatusMeasuring("measurePicked", n, this.measurementQueued.getStringDetail());
                if (this.pickingMode == 15 || this.pickingStyleMeasure == 4) {
                    this.viewer.script("measure " + this.measurementQueued.getMeasurementScript(" "));
                }
                return;
            }
            case 3: {
                if (isDoubleClick) {
                    return;
                }
                if (ptClicked == null) {
                    this.viewer.script("zoomTo (atomindex=" + atomIndex + ")");
                } else {
                    this.viewer.script("zoomTo " + Escape.escape(ptClicked));
                }
                return;
            }
            case 5: {
                int queuedAtomCount;
                if (isDoubleClick) {
                    return;
                }
                if (this.viewer.getSpinOn() || this.viewer.getPendingMeasurement() != null) {
                    this.resetMeasurement();
                    this.viewer.script("spin off");
                    return;
                }
                if (this.measurementQueued.getCount() >= 2) {
                    this.resetMeasurement();
                }
                if ((queuedAtomCount = this.measurementQueued.getCount()) == 1 && (ptClicked == null ? this.measurementQueued.getAtomIndex(1) == atomIndex : this.measurementQueued.getAtom(1).distance(ptClicked) == 0.0f)) {
                    return;
                }
                if (atomIndex >= 0 || ptClicked != null) {
                    queuedAtomCount = this.queueAtom(atomIndex, ptClicked);
                }
                if (queuedAtomCount < 2) {
                    this.viewer.scriptStatus(queuedAtomCount == 1 ? GT._("pick one more atom in order to spin the model around an axis") : GT._("pick two atoms in order to spin the model around an axis"));
                    return;
                }
                this.viewer.script("spin" + this.measurementQueued.getMeasurementScript(" ") + " " + this.viewer.getPickingSpinRate());
            }
        }
        if (ptClicked != null) {
            return;
        }
        switch (this.pickingMode) {
            case 1: {
                if (isDoubleClick) {
                    return;
                }
                this.viewer.setStatusAtomPicked(atomIndex, null);
                return;
            }
            case 2: {
                if (isDoubleClick) {
                    return;
                }
                this.viewer.script("set labeltoggle {atomindex=" + atomIndex + "}");
                return;
            }
        }
        this.pickSelected("atomindex=" + atomIndex, modifiers, isDoubleClick);
    }

    private int queueAtom(int atomIndex, Point3f ptClicked) {
        int n = this.measurementQueued.addPoint(atomIndex, ptClicked, true);
        if (atomIndex >= 0) {
            this.viewer.setStatusAtomPicked(atomIndex, "Atom #" + n + ":" + this.viewer.getAtomInfo(atomIndex));
        }
        return n;
    }

    private void applyMouseStyle(String item, boolean shiftKey, boolean alternateKey, boolean isDoubleClick) {
        item = "(" + item + ")";
        if (isDoubleClick) {
            this.viewer.script("select " + item);
        } else if (this.pickingStyleSelect == 2 || this.pickingStyleSelect == 3) {
            if (shiftKey && alternateKey) {
                this.viewer.script("select selected and not " + item);
            } else if (shiftKey) {
                this.viewer.script("select selected tog " + item);
            } else if (alternateKey) {
                this.viewer.script("select selected or " + item);
            } else {
                this.viewer.script("select " + item);
            }
        } else if (shiftKey || this.pickingStyleSelect == 0) {
            this.viewer.script("select selected tog " + item);
        } else {
            this.viewer.script("select " + item);
        }
    }
}

