/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Matrix3f;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.viewer.ScriptEvaluator;
import org.jmol.viewer.ScriptVariable;
import org.jmol.viewer.Token;
import org.jmol.viewer.Viewer;

class PropertyManager {
    private static final String atomExpression = "<atom selection>";
    private static final String[] propertyTypes = new String[]{"appletInfo", "", "", "fileName", "", "", "fileHeader", "", "", "fileContents", "<pathname>", "", "fileContents", "", "", "animationInfo", "", "", "modelInfo", "<atom selection>", "(*)", "X -vibrationInfo", "", "", "shapeInfo", "", "", "measurementInfo", "", "", "centerInfo", "", "", "orientationInfo", "", "", "transformInfo", "", "", "atomList", "<atom selection>", "(visible)", "atomInfo", "<atom selection>", "(visible)", "bondInfo", "<atom selection>", "(visible)", "chainInfo", "<atom selection>", "(visible)", "polymerInfo", "<atom selection>", "(visible)", "moleculeInfo", "<atom selection>", "(visible)", "stateInfo", "<state type>", "all", "extractModel", "<atom selection>", "(visible)", "jmolStatus", "statusNameList", "", "jmolViewer", "", "", "messageQueue", "", "", "auxiliaryInfo", "<atom selection>", "*", "boundBoxInfo", "", "", "dataInfo", "<data type>", "types", "image", "", "", "evaluate", "<expression>", "", "menu", "<type>", "current", "minimizationInfo", "", "", "PointGroupInfo", "<atom selection>", "(visible)", "PdbInfo", "<type>", "", "errorMessage", "", ""};
    private static final int PROP_APPLET_INFO = 0;
    private static final int PROP_FILENAME = 1;
    private static final int PROP_FILEHEADER = 2;
    static final int PROP_FILECONTENTS_PATH = 3;
    private static final int PROP_FILECONTENTS = 4;
    private static final int PROP_ANIMATION_INFO = 5;
    private static final int PROP_MODEL_INFO = 6;
    private static final int PROP_SHAPE_INFO = 8;
    private static final int PROP_MEASUREMENT_INFO = 9;
    private static final int PROP_CENTER_INFO = 10;
    private static final int PROP_ORIENTATION_INFO = 11;
    private static final int PROP_TRANSFORM_INFO = 12;
    private static final int PROP_ATOM_LIST = 13;
    private static final int PROP_ATOM_INFO = 14;
    private static final int PROP_BOND_INFO = 15;
    private static final int PROP_CHAIN_INFO = 16;
    private static final int PROP_POLYMER_INFO = 17;
    private static final int PROP_MOLECULE_INFO = 18;
    private static final int PROP_STATE_INFO = 19;
    private static final int PROP_EXTRACT_MODEL = 20;
    private static final int PROP_JMOL_STATUS = 21;
    private static final int PROP_JMOL_VIEWER = 22;
    private static final int PROP_MESSAGE_QUEUE = 23;
    private static final int PROP_AUXILIARY_INFO = 24;
    private static final int PROP_BOUNDBOX_INFO = 25;
    private static final int PROP_DATA_INFO = 26;
    private static final int PROP_IMAGE = 27;
    private static final int PROP_EVALUATE = 28;
    private static final int PROP_MENU = 29;
    private static final int PROP_MINIMIZATION_INFO = 30;
    private static final int PROP_POINTGROUP_INFO = 31;
    private static final int PROP_PDB_INFO = 32;
    private static final int PROP_ERROR_MESSAGE = 33;
    private static final int PROP_COUNT = 34;
    private static final String[] readableTypes = new String[]{"", "stateinfo", "extractmodel", "filecontents", "fileheader", "image", "menu"};

    PropertyManager() {
    }

    static int getPropertyNumber(String infoType) {
        if (infoType == null) {
            return -1;
        }
        for (int i = 0; i < 34; ++i) {
            if (!infoType.equalsIgnoreCase(PropertyManager.getPropertyName(i))) continue;
            return i;
        }
        return -1;
    }

    static String getDefaultParam(int propID) {
        if (propID < 0) {
            return "";
        }
        return propertyTypes[propID * 3 + 2];
    }

    static boolean acceptsStringParameter(String name) {
        int propID = PropertyManager.getPropertyNumber(name);
        String type = PropertyManager.getParamType(propID);
        return type.length() > 0 && type != atomExpression;
    }

    static Object getProperty(Viewer viewer, String returnType, String infoType, Object paramInfo) {
        if (propertyTypes.length != 102) {
            Logger.warn("propertyTypes is not the right length: " + propertyTypes.length + " != " + 102);
        }
        Object info = PropertyManager.getPropertyAsObject(viewer, infoType, paramInfo, returnType);
        if (returnType == null) {
            return info;
        }
        boolean requestedReadable = returnType.equalsIgnoreCase("readable");
        if (requestedReadable) {
            String string = returnType = PropertyManager.isReadableAsString(infoType) ? "String" : "JSON";
        }
        if (returnType.equalsIgnoreCase("String")) {
            return info == null ? "" : info.toString();
        }
        if (requestedReadable) {
            return Escape.toReadable(infoType, info);
        }
        if (returnType.equalsIgnoreCase("JSON")) {
            return "{" + Escape.toJSON(infoType, info) + "}";
        }
        return info;
    }

    static Object extractProperty(Object property, ScriptVariable[] args, int ptr) {
        if (ptr >= args.length) {
            return property;
        }
        ScriptVariable arg = args[ptr++];
        switch (arg.tok) {
            case 2: {
                int pt = ScriptVariable.iValue(arg) - 1;
                if (property instanceof Vector) {
                    Vector v = (Vector)property;
                    if (pt < 0) {
                        pt += v.size();
                    }
                    if (pt >= 0 && pt < v.size()) {
                        return PropertyManager.extractProperty(v.elementAt(pt), args, ptr);
                    }
                    return "";
                }
                if (property instanceof String[]) {
                    String[] slist = (String[])property;
                    if (pt < 0) {
                        pt += slist.length;
                    }
                    if (pt >= 0 && pt < slist.length) {
                        return slist[pt];
                    }
                    return "";
                }
                if (property instanceof Matrix3f) {
                    Matrix3f m = (Matrix3f)property;
                    float[][] f = new float[][]{{m.m00, m.m01, m.m02}, {m.m10, m.m11, m.m12}, {m.m20, m.m21, m.m22}};
                    if (pt < 0) {
                        pt += 3;
                    }
                    if (pt >= 0 && pt < 3) {
                        return PropertyManager.extractProperty(f, args, --ptr);
                    }
                    return "";
                }
                if (property instanceof float[]) {
                    float[] flist = (float[])property;
                    if (pt < 0) {
                        pt += flist.length;
                    }
                    if (pt >= 0 && pt < flist.length) {
                        return new Float(flist[pt]);
                    }
                    return "";
                }
                if (property instanceof int[]) {
                    int[] ilist = (int[])property;
                    if (pt < 0) {
                        pt += ilist.length;
                    }
                    if (pt >= 0 && pt < ilist.length) {
                        return new Integer(ilist[pt]);
                    }
                    return "";
                }
                if (property instanceof float[][]) {
                    float[][] fflist = (float[][])property;
                    if (pt < 0) {
                        pt += fflist.length;
                    }
                    if (pt >= 0 && pt < fflist.length) {
                        return PropertyManager.extractProperty(fflist[pt], args, ptr);
                    }
                    return "";
                }
                if (property instanceof int[][]) {
                    int[][] iilist = (int[][])property;
                    if (pt < 0) {
                        pt += iilist.length;
                    }
                    if (pt >= 0 && pt < iilist.length) {
                        return PropertyManager.extractProperty(iilist[pt], args, ptr);
                    }
                    return "";
                }
                if (!(property instanceof Object[])) break;
                Object[] olist = (Object[])property;
                if (pt < 0) {
                    pt += olist.length;
                }
                if (pt >= 0 && pt < olist.length) {
                    return olist[pt];
                }
                return "";
            }
            case 4: {
                String key = ScriptVariable.sValue(arg);
                if (!(property instanceof Hashtable)) break;
                Hashtable h = (Hashtable)property;
                if (key.equalsIgnoreCase("keys")) {
                    Vector keys = new Vector();
                    Enumeration e = h.keys();
                    while (e.hasMoreElements()) {
                        keys.addElement(e.nextElement());
                    }
                    return PropertyManager.extractProperty(keys, args, ptr);
                }
                if (!h.containsKey(key)) {
                    Enumeration e = h.keys();
                    String newKey = "";
                    while (e.hasMoreElements()) {
                        newKey = (String)e.nextElement();
                        if (!newKey.equalsIgnoreCase(key)) continue;
                        key = newKey;
                        break;
                    }
                }
                if (h.containsKey(key)) {
                    return PropertyManager.extractProperty(h.get(key), args, ptr);
                }
                return "";
            }
        }
        return property;
    }

    private static String getPropertyName(int propID) {
        if (propID < 0) {
            return "";
        }
        return propertyTypes[propID * 3];
    }

    private static String getParamType(int propID) {
        if (propID < 0) {
            return "";
        }
        return propertyTypes[propID * 3 + 1];
    }

    private static boolean isReadableAsString(String infoType) {
        int i = readableTypes.length;
        while (--i >= 0) {
            if (!infoType.equalsIgnoreCase(readableTypes[i])) continue;
            return true;
        }
        return false;
    }

    private static Object getPropertyAsObject(Viewer viewer, String infoType, Object paramInfo, String returnType) {
        if (infoType.equals("tokenList")) {
            return Token.getTokensLike((String)paramInfo);
        }
        int id = PropertyManager.getPropertyNumber(infoType);
        boolean iHaveParameter = paramInfo != null && paramInfo.toString().length() > 0;
        Object myParam = iHaveParameter ? paramInfo : PropertyManager.getDefaultParam(id);
        switch (id) {
            case 0: {
                return viewer.getAppletInfo();
            }
            case 5: {
                return viewer.getAnimationInfo();
            }
            case 13: {
                return viewer.getAtomBitSetVector(myParam);
            }
            case 14: {
                return viewer.getAllAtomInfo(myParam);
            }
            case 24: {
                return viewer.getAuxiliaryInfo(myParam);
            }
            case 15: {
                return viewer.getAllBondInfo(myParam);
            }
            case 25: {
                return viewer.getBoundBoxInfo();
            }
            case 10: {
                return viewer.getRotationCenter();
            }
            case 16: {
                return viewer.getAllChainInfo(myParam);
            }
            case 20: {
                return viewer.getModelExtract(myParam);
            }
            case 1: {
                return viewer.getFullPathName();
            }
            case 2: {
                return viewer.getFileHeader();
            }
            case 3: 
            case 4: {
                if (iHaveParameter) {
                    return viewer.getFileAsString(myParam.toString());
                }
                return viewer.getCurrentFileAsString();
            }
            case 21: {
                return viewer.getStatusChanged(myParam.toString());
            }
            case 22: {
                return viewer;
            }
            case 9: {
                return viewer.getMeasurementInfo();
            }
            case 29: {
                return viewer.getMenu(myParam.toString());
            }
            case 23: {
                return viewer.getMessageQueue();
            }
            case 30: {
                return viewer.getMinimizationInfo();
            }
            case 6: {
                return viewer.getModelInfo(myParam);
            }
            case 18: {
                return viewer.getMoleculeInfo(myParam);
            }
            case 11: {
                return viewer.getOrientationInfo();
            }
            case 17: {
                return viewer.getAllPolymerInfo(myParam);
            }
            case 8: {
                return viewer.getShapeInfo();
            }
            case 19: {
                return viewer.getStateInfo(myParam.toString());
            }
            case 31: {
                return viewer.getPointGroupInfo(myParam);
            }
            case 32: {
                return PropertyManager.getPdbInfo(viewer.getPDBHeader(), myParam.toString());
            }
            case 33: {
                return viewer.getErrorMessageUntranslated();
            }
            case 12: {
                return viewer.getMatrixRotate();
            }
            case 26: {
                return viewer.getData(myParam.toString());
            }
            case 28: {
                return ScriptEvaluator.evaluateExpression(viewer, myParam.toString());
            }
            case 27: {
                return viewer.getImageAs(returnType == null ? "JPEG" : "JPG64", -1, -1, -1, null, null);
            }
        }
        String info = "getProperty ERROR\n" + infoType + "?\nOptions include:\n";
        for (int i = 0; i < 34; ++i) {
            String paramType = PropertyManager.getParamType(i);
            String paramDefault = PropertyManager.getDefaultParam(i);
            String name = PropertyManager.getPropertyName(i);
            if (name.charAt(0) == 'X') continue;
            info = info + "\n getProperty " + name + (paramType != "" ? " " + paramType + (paramDefault != "" ? " #default: " + paramDefault : "") : "");
        }
        return info;
    }

    static Object getPdbInfo(String header, String type) {
        boolean haveType;
        Hashtable<String, String> ht = new Hashtable<String, String>();
        if (header == null) {
            return ht;
        }
        String[] lines = TextFormat.split(header, '\n');
        String keyLast = "";
        StringBuffer sb = new StringBuffer();
        boolean bl = haveType = type != null && type.length() > 0;
        if (haveType) {
            type = type.toUpperCase();
        }
        String key = "";
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line.length() < 12) continue;
            key = line.substring(0, 6).trim();
            String cont = line.substring(7, 10).trim();
            if (key.equals("REMARK")) {
                key = key + cont;
            }
            if (!key.equals(keyLast)) {
                if (haveType && keyLast.equals(type)) {
                    return sb.toString();
                }
                if (sb != null && !haveType) {
                    ht.put(keyLast, sb.toString());
                    sb = new StringBuffer();
                }
                keyLast = key;
            }
            if (haveType && !key.equals(type)) continue;
            sb.append(line.substring(10).trim()).append('\n');
        }
        if (sb != null && !haveType) {
            ht.put(keyLast, sb.toString());
        }
        if (haveType) {
            return key.equals(type) ? sb.toString() : "";
        }
        return ht;
    }
}

