/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.i18n.GT;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Group;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.ScriptCompilationTokenParser;
import org.jmol.viewer.ScriptContext;
import org.jmol.viewer.ScriptEvaluator;
import org.jmol.viewer.ScriptFlowContext;
import org.jmol.viewer.ScriptFunction;
import org.jmol.viewer.ScriptVariable;
import org.jmol.viewer.Token;
import org.jmol.viewer.Viewer;

class ScriptCompiler
extends ScriptCompilationTokenParser {
    private static final String LOAD_TYPES = "append;files;menu;trajectory;models;xyz;vxyz;vibration;temperature;occupancy;partialcharge";
    private Viewer viewer;
    private String filename;
    private boolean isSilent;
    private Hashtable contextVariables;
    private Token[][] aatokenCompiled;
    private short[] lineNumbers;
    private int[][] lineIndices;
    private int lnLength = 8;
    private boolean preDefining;
    private boolean isShowScriptOutput;
    private boolean isCheckOnly;
    private boolean haveComments;
    String scriptExtensions;
    private ScriptFunction thisFunction;
    private ScriptFlowContext flowContext;
    private Vector ltoken;
    private Vector lltoken;
    private Vector vBraces;
    private int ichBrace;
    private int cchToken;
    private int cchScript;
    private int nSemiSkip;
    private int parenCount;
    private int braceCount;
    private int setBraceCount;
    private int bracketCount;
    private int ptSemi;
    private int forPoint3;
    private int setEqualPt;
    private int iBrace;
    private boolean iHaveQuotedString;
    private boolean isEndOfCommand;
    private boolean needRightParen;
    private boolean endOfLine;
    private String comment;
    private static final int OK = 0;
    private static final int OK2 = 1;
    private static final int CONTINUE = 2;
    private static final int EOL = 3;
    private static final int ERROR = 4;
    private int tokLastMath;
    private boolean isShowCommand;
    char chFirst;

    ScriptCompiler(Viewer viewer) {
        this.viewer = viewer;
    }

    ScriptContext parseScriptForTokens(String script) {
        this.script = script;
        this.filename = null;
        this.isCheckOnly = true;
        this.isSilent = true;
        this.logMessages = false;
        this.preDefining = false;
        return this.parseScript(false);
    }

    private ScriptContext parseScript(boolean doFull) {
        if (!this.compile0(doFull)) {
            this.handleError();
        }
        ScriptContext sc = new ScriptContext();
        sc.script = this.script;
        sc.scriptExtensions = this.scriptExtensions;
        sc.errorType = this.errorType;
        if (this.errorType != null) {
            sc.iCommandError = this.iCommand;
            this.setAaTokenCompiled();
        }
        sc.aatoken = this.aatokenCompiled;
        sc.errorMessage = this.errorMessage;
        sc.errorMessageUntranslated = this.errorMessageUntranslated == null ? this.errorMessage : this.errorMessageUntranslated;
        sc.lineIndices = this.lineIndices;
        sc.lineNumbers = this.lineNumbers;
        sc.contextVariables = this.contextVariables;
        return sc;
    }

    ScriptContext compile(String filename, String script, boolean isPredefining, boolean isSilent, boolean debugScript, boolean isCheckOnly) {
        this.isCheckOnly = isCheckOnly;
        this.filename = filename;
        this.isSilent = isSilent;
        this.script = script;
        this.logMessages = !isSilent && !isPredefining && debugScript;
        this.preDefining = filename == "#predefine";
        return this.parseScript(true);
    }

    private void addContextVariable(String ident) {
        if (this.thisFunction == null) {
            if (this.contextVariables == null) {
                this.contextVariables = new Hashtable();
            }
            this.contextVariables.put(ident, new ScriptVariable(4, "").setName(ident));
        } else {
            this.thisFunction.addVariable(ident, false);
        }
    }

    private String cleanScriptComments(String script) {
        int pt = script.indexOf("\u0000##");
        if (pt >= 0) {
            this.scriptExtensions = script.substring(pt + 1);
            script = script.substring(0, pt);
        }
        this.haveComments = script.indexOf("#") >= 0;
        pt = script.indexOf("**** Jmol Embedded Script ****");
        if (pt < 0) {
            return script;
        }
        int pt1 = script.lastIndexOf("/*", pt);
        int pt2 = script.indexOf((script.charAt(pt1 + 2) == '*' ? "*" : "") + "*/", pt);
        return pt1 < 0 || pt2 < pt ? script : script.substring(pt + "**** Jmol Embedded Script ****".length(), pt2);
    }

    private void addTokenToPrefix(Token token) {
        if (this.logMessages) {
            Logger.debug("addTokenToPrefix" + token);
        }
        this.ltoken.addElement(token);
        this.lastToken = token;
    }

    /*
     * Unable to fully structure code
     */
    private boolean compile0(boolean isFull) {
        this.script = this.cleanScriptComments(this.script);
        this.cchScript = this.script.length();
        this.contextVariables = null;
        this.lineNumbers = null;
        this.lineIndices = null;
        this.aatokenCompiled = null;
        this.thisFunction = null;
        this.flowContext = null;
        this.errorType = null;
        this.errorMessage = null;
        this.errorMessageUntranslated = null;
        this.errorLine = null;
        this.nSemiSkip = 0;
        this.ichToken = 0;
        this.ichCurrentCommand = 0;
        this.ichComment = 0;
        this.ichBrace = 0;
        this.lineCurrent = 1;
        this.iCommand = 0;
        this.tokLastMath = 0;
        this.lastToken = Token.tokenOff;
        this.vBraces = new Vector<E>();
        this.iBrace = 0;
        this.braceCount = 0;
        this.parenCount = 0;
        this.ptSemi = -10;
        this.cchToken = 0;
        this.lnLength = 8;
        this.lineNumbers = new short[this.lnLength];
        this.lineIndices = new int[this.lnLength][2];
        this.isSetBrace = false;
        this.isNewSet = false;
        this.ptNewSetModifier = 1;
        this.isShowScriptOutput = false;
        this.iHaveQuotedString = false;
        this.lltoken = new Vector<E>();
        this.ltoken = new Vector<E>();
        this.tokCommand = 0;
        this.lastFlowCommand = null;
        this.tokenAndEquals = null;
        this.setBraceCount = 0;
        this.bracketCount = 0;
        this.forPoint3 = -1;
        this.setEqualPt = 0x7FFFFFFF;
        this.endOfLine = false;
        this.comment = null;
        this.isEndOfCommand = false;
        this.needRightParen = false;
        this.theTok = 0;
        iLine = 1;
        while (true) {
            block27: {
                block29: {
                    block28: {
                        if ((this.nTokens = this.ltoken.size()) == 0) {
                            if (this.thisFunction != null && this.thisFunction.chpt0 == 0) {
                                this.thisFunction.chpt0 = this.ichToken;
                            }
                            this.ichCurrentCommand = this.ichToken;
                            iLine = this.lineCurrent;
                        }
                        if (this.lookingAtLeadingWhitespace()) break block27;
                        this.endOfLine = false;
                        if (this.isEndOfCommand) break block28;
                        this.endOfLine = this.lookingAtEndOfLine();
                        switch (this.endOfLine != false ? 0 : this.lookingAtComment()) {
                            case 2: {
                                break block27;
                            }
                            case 3: {
                                this.isEndOfCommand = true;
                                break block27;
                            }
                            case 1: {
                                this.isEndOfCommand = true;
                                this.comment = this.script.substring(this.ichToken, this.ichToken + this.cchToken).trim();
                            }
                            default: {
                                v0 = this.isEndOfCommand = this.isEndOfCommand != false || this.endOfLine != false || this.lookingAtEndOfStatement() != false;
                            }
                        }
                    }
                    if (!this.isEndOfCommand) break block29;
                    this.isEndOfCommand = false;
                    switch (this.processTokenList(iLine, isFull)) {
                        case 2: {
                            break block27;
                        }
                        case 4: {
                            return false;
                        }
                        default: {
                            if (this.ichToken >= this.cchScript) {
                                this.setAaTokenCompiled();
                                return this.flowContext == null || this.error(11, Token.nameOf(this.flowContext.token.tok)) != false;
                            }
                            break block27;
                        }
                    }
                }
                if (this.nTokens <= 0) ** GOTO lbl-1000
                block9 : switch (this.checkSpecialParameterSyntax()) {
                    case 2: {
                        break;
                    }
                    case 4: {
                        return false;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        if (this.lookingAtLookupToken(this.ichToken)) {
                            ident = this.getPrefixToken();
                            switch (this.parseKnownToken(ident)) {
                                case 2: {
                                    break block9;
                                }
                                case 4: {
                                    return false;
                                }
                            }
                            switch (this.parseCommandParameter(ident)) {
                                case 2: {
                                    break block9;
                                }
                                case 4: {
                                    return false;
                                }
                            }
                            this.addTokenToPrefix(this.theToken);
                            break;
                        }
                        if (this.nTokens == 0 || (this.isNewSet || this.isSetBrace) && this.nTokens == this.ptNewSetModifier) {
                            return this.commandExpected();
                        }
                        return this.error(19, this.script.substring(this.ichToken, this.ichToken + 1));
                    }
                }
            }
            this.ichToken += this.cchToken;
        }
    }

    private void setAaTokenCompiled() {
        this.aatokenCompiled = new Token[this.lltoken.size()][];
        this.lltoken.copyInto((Object[])this.aatokenCompiled);
    }

    private boolean lookingAtLeadingWhitespace() {
        int ichT;
        for (ichT = this.ichToken; ichT < this.cchScript && ScriptCompiler.isSpaceOrTab(this.script.charAt(ichT)); ++ichT) {
        }
        if (this.isLineContinuation(ichT, true)) {
            ichT += 1 + this.nCharNewLine(ichT + 1);
        }
        this.cchToken = ichT - this.ichToken;
        return this.cchToken > 0;
    }

    private boolean isLineContinuation(int ichT, boolean checkMathop) {
        boolean isEscaped;
        boolean bl = isEscaped = ichT + 2 < this.cchScript && this.script.charAt(ichT) == '\\' && this.nCharNewLine(ichT + 1) > 0 || checkMathop && this.lookingAtMathContinuation(ichT);
        if (isEscaped) {
            this.lineCurrent = (short)(this.lineCurrent + 1);
        }
        return isEscaped;
    }

    private boolean lookingAtMathContinuation(int ichT) {
        int n;
        if (ichT >= this.cchScript || (n = this.nCharNewLine(ichT)) == 0 || this.lastToken.tok == 0x10000A) {
            return false;
        }
        if (this.parenCount > 0 || this.bracketCount > 0) {
            return true;
        }
        if (this.tokCommand != 36867 && this.tokCommand != 36865) {
            return false;
        }
        if (this.lastToken.tok == this.tokLastMath) {
            return true;
        }
        ichT += n;
        while (ichT < this.cchScript && ScriptCompiler.isSpaceOrTab(this.script.charAt(ichT))) {
            ++ichT;
        }
        return this.lookingAtLookupToken(ichT) && this.tokLastMath != 0;
    }

    private boolean lookingAtEndOfLine() {
        if (this.ichToken >= this.cchScript) {
            return true;
        }
        int ichT = this.ichToken;
        int n = this.nCharNewLine(ichT);
        if (n == 0) {
            return false;
        }
        this.ichEnd = this.ichToken;
        this.cchToken = n;
        return true;
    }

    private int nCharNewLine(int ichT) {
        char ch = this.script.charAt(ichT);
        return ch != '\r' ? (ch == '\n' ? 1 : 0) : (++ichT < this.cchScript && this.script.charAt(ichT) == '\n' ? 2 : 1);
    }

    private boolean lookingAtEndOfStatement() {
        boolean isSemi;
        boolean bl = isSemi = this.script.charAt(this.ichToken) == ';';
        if (isSemi && this.nTokens > 0) {
            this.ptSemi = this.nTokens;
        }
        if (!isSemi || this.nSemiSkip-- > 0) {
            return false;
        }
        this.cchToken = 1;
        return true;
    }

    private int lookingAtComment() {
        boolean isSharp;
        int ichT;
        char ch = this.script.charAt(this.ichToken);
        int ichFirstSharp = -1;
        if (this.ichToken == this.ichCurrentCommand && ch == '$') {
            this.isShowScriptOutput = true;
            this.isShowCommand = true;
            for (ichT = this.ichToken; ch != ']' && ichT < this.cchScript && !this.eol(ch = this.script.charAt(ichT)); ++ichT) {
            }
            this.cchToken = ichT - this.ichToken;
            return 2;
        }
        if (this.isShowScriptOutput && !this.isShowCommand) {
            ichFirstSharp = ichT;
        }
        if (ch == '/' && ichT + 1 < this.cchScript) {
            switch (this.script.charAt(++ichT)) {
                case '/': {
                    ichFirstSharp = this.ichToken;
                    this.ichEnd = ichT - 1;
                    break;
                }
                case '*': {
                    this.ichEnd = ichT - 1;
                    String terminator = ++ichT < this.cchScript && (ch = this.script.charAt(ichT)) == '*' ? "**/" : "*/";
                    ichT = this.script.indexOf(terminator, this.ichToken + 2);
                    if (ichT < 0) {
                        this.ichToken = this.cchScript;
                        return 3;
                    }
                    this.incrementLineCount(this.script.substring(this.ichToken, ichT));
                    this.cchToken = ichT + (ch == '*' ? 3 : 2) - this.ichToken;
                    return 2;
                }
                default: {
                    return 0;
                }
            }
        }
        boolean bl = isSharp = ichFirstSharp < 0;
        if (isSharp && !this.haveComments) {
            return 0;
        }
        if (this.ichComment > ichT) {
            ichT = this.ichComment;
        }
        while (ichT < this.cchScript) {
            ch = this.script.charAt(ichT);
            if (this.eol(ch)) {
                this.ichEnd = ichT;
                if (this.isLineContinuation(ichT - 1, false)) {
                    ichT += this.nCharNewLine(ichT);
                } else if (isSharp || ch != ';') break;
            } else if (ichFirstSharp <= 0 && ch == '#') {
                ichFirstSharp = ichT;
            }
            ++ichT;
        }
        if (ichFirstSharp < 0) {
            return 0;
        }
        this.ichComment = ichFirstSharp;
        if (isSharp && this.nTokens == 0 && this.cchScript - ichFirstSharp >= 3 && this.script.charAt(ichFirstSharp + 1) == 'j' && this.script.charAt(ichFirstSharp + 2) == 'c') {
            this.cchToken = ichT - this.ichToken;
            return 2;
        }
        if (ichFirstSharp != this.ichToken) {
            return 0;
        }
        if (isSharp && this.cchScript > this.ichToken + 3 && this.script.charAt(this.ichToken + 1) == 'j' && this.script.charAt(this.ichToken + 2) == 'x' && ScriptCompiler.isSpaceOrTab(this.script.charAt(this.ichToken + 3))) {
            this.cchToken = 4;
            return 2;
        }
        if (ichT == this.ichToken) {
            return 0;
        }
        this.cchToken = ichT - this.ichToken;
        return this.nTokens == 0 ? 1 : 2;
    }

    private int processTokenList(short iLine, boolean doCompile) {
        if (this.nTokens > 0 || this.comment != null) {
            if (this.nTokens == 0) {
                this.ichCurrentCommand = this.ichToken;
                if (this.comment != null) {
                    this.addTokenToPrefix(new Token(0, this.comment.length() == 1 ? this.comment : this.comment.substring(1)));
                }
            }
            this.iCommand = this.lltoken.size();
            if (this.thisFunction != null && this.thisFunction.cmdpt0 < 0) {
                this.thisFunction.cmdpt0 = this.iCommand;
            }
            if (this.nTokens == 1 && this.tokenCommand.value.equals("{") && this.lastFlowCommand != null) {
                this.setBraceCount = 0;
                this.parenCount = 0;
                this.tokCommand = this.lastFlowCommand.tok;
                this.tokenCommand = this.lastFlowCommand;
                this.ltoken.removeElementAt(0);
            }
            if (this.bracketCount > 0 || this.setBraceCount > 0 || this.parenCount > 0 || this.braceCount == 1 && !this.checkFlowStartBrace(true)) {
                this.error(this.nTokens == 1 ? 2 : 4);
                return 4;
            }
            if (this.needRightParen) {
                this.addTokenToPrefix(Token.tokenRightParen);
                this.needRightParen = false;
            }
            if (this.ltoken.size() > 0) {
                if (doCompile && !this.compileCommand()) {
                    return 4;
                }
                if (this.logMessages) {
                    Logger.debug("-------------------------------------");
                }
                if (!Token.tokAttr(this.tokCommand, 131072) || this.atokenInfix.length > 0 && this.atokenInfix[0].intValue <= 0) {
                    if (this.iCommand == this.lnLength) {
                        short[] lnT = new short[this.lnLength * 2];
                        System.arraycopy(this.lineNumbers, 0, lnT, 0, this.lnLength);
                        this.lineNumbers = lnT;
                        int[][] lnI = new int[this.lnLength * 2][2];
                        System.arraycopy(this.lineIndices, 0, lnI, 0, this.lnLength);
                        this.lineIndices = lnI;
                        this.lnLength *= 2;
                    }
                    this.lineNumbers[this.iCommand] = iLine;
                    this.lineIndices[this.iCommand][0] = this.ichCurrentCommand;
                    this.lineIndices[this.iCommand][1] = Math.max(this.ichCurrentCommand, Math.min(this.cchScript, this.ichEnd == this.ichCurrentCommand ? this.ichToken : this.ichEnd));
                    this.lltoken.addElement(this.atokenInfix);
                    this.iCommand = this.lltoken.size();
                }
                if (this.tokCommand == 36867) {
                    this.lastFlowCommand = null;
                }
            }
            this.tokenCommand = null;
            this.tokenAndEquals = null;
            this.comment = null;
            this.tokCommand = 0;
            this.needRightParen = false;
            this.isSetBrace = false;
            this.isNewSet = false;
            this.iHaveQuotedString = false;
            this.ptNewSetModifier = 1;
            this.ltoken.setSize(0);
            this.nSemiSkip = 0;
            this.nTokens = 0;
            this.ptSemi = -10;
            this.forPoint3 = -1;
            this.setEqualPt = Integer.MAX_VALUE;
            if (this.endOfLine && this.flowContext != null && this.flowContext.checkForceEndIf(1)) {
                this.forceFlowEnd(this.flowContext.token);
                this.isEndOfCommand = true;
                this.cchToken = 0;
                this.ichCurrentCommand = this.ichToken;
                this.lineCurrent = (short)(this.lineCurrent - 1);
                return 2;
            }
        }
        if (this.endOfLine) {
            this.isShowCommand = false;
            this.lineCurrent = (short)(this.lineCurrent + 1);
        }
        if (this.ichToken >= this.cchScript) {
            this.tokenCommand = Token.tokenAll;
            this.tokCommand = 1;
            switch (this.checkFlowEndBrace()) {
                case 4: {
                    return 4;
                }
                case 2: {
                    this.isEndOfCommand = true;
                    this.cchToken = 0;
                    return 2;
                }
            }
            this.ichToken = this.cchScript;
            return 0;
        }
        return 0;
    }

    private boolean compileCommand() {
        int i;
        int size;
        block15: {
            int tok;
            int pt;
            block16: {
                block14: {
                    if (this.ltoken.size() == 0) {
                        this.atokenInfix = new Token[0];
                        this.ltoken.copyInto(this.atokenInfix);
                        return true;
                    }
                    this.tokenCommand = (Token)this.ltoken.firstElement();
                    this.tokCommand = this.tokenCommand.tok;
                    this.isImplicitExpression = Token.tokAttr(this.tokCommand, 36864);
                    this.isSetOrDefine = this.tokCommand == 36867 || this.tokCommand == 537931778;
                    this.isCommaAsOrAllowed = Token.tokAttr(this.tokCommand, 12288);
                    size = this.ltoken.size();
                    pt = size - 1;
                    if (size != 1 || !Token.tokAttr(this.tokCommand, 524288)) break block14;
                    this.addTokenToPrefix(Token.tokenOn);
                    break block15;
                }
                if (this.tokCommand != 36867 || size <= 2) break block15;
                tok = ((Token)this.ltoken.get((int)pt)).tok;
                if (tok == 269484210 || tok == 0x101000B1) break block16;
                pt = 1;
                tok = ((Token)this.ltoken.get((int)1)).tok;
                if (tok != 269484210 && tok != 0x101000B1) break block15;
            }
            this.ltoken.removeElementAt(pt);
            this.addTokenToPrefix(Token.tokenEquals);
            for (i = 1; i < size - 1; ++i) {
                this.addTokenToPrefix((Token)this.ltoken.elementAt(i));
            }
            this.addTokenToPrefix(tok == 0x101000B1 ? Token.tokenMinus : Token.tokenPlus);
            this.addTokenToPrefix(Token.intToken(1));
            if (((Token)this.ltoken.get((int)2)).tok == 0x10100040) {
                this.ltoken.setElementAt(Token.tokenSetArray, 0);
            }
        }
        if (this.tokenAndEquals != null) {
            int j;
            int i2 = 0;
            for (i2 = 1; i2 < size && (j = ((Token)this.ltoken.elementAt((int)i2)).tok) != 269484226; ++i2) {
            }
            size = i2++;
            if (this.ltoken.size() < i2) {
                System.out.println("COMPILER ERROR! - andEquals ");
            } else {
                j = 1;
                while (j < size) {
                    this.ltoken.insertElementAt((Token)this.ltoken.elementAt(j), i2);
                    ++j;
                    ++i2;
                }
                this.ltoken.setElementAt(Token.tokenEquals, size);
                this.ltoken.insertElementAt(this.tokenAndEquals, i2);
                this.ltoken.insertElementAt(Token.tokenLeftParen, ++i2);
                this.addTokenToPrefix(Token.tokenRightParen);
            }
        }
        size = this.ltoken.size();
        this.atokenInfix = new Token[size];
        this.ltoken.copyInto(this.atokenInfix);
        if (this.logMessages) {
            Logger.debug("token list:");
            for (i = 0; i < this.atokenInfix.length; ++i) {
                Logger.debug(i + ": " + this.atokenInfix[i]);
            }
            Logger.debug("vBraces list:");
            for (i = 0; i < this.vBraces.size(); ++i) {
                Logger.debug(i + ": " + this.vBraces.get(i));
            }
            Logger.debug("-------------------------------------");
        }
        return this.compileExpressions();
    }

    private String getPrefixToken() {
        String ident = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
        if (ident.length() == 1) {
            this.theToken = Token.getTokenFromName(ident);
            if (this.theToken == null && (this.theToken = Token.getTokenFromName(ident.toLowerCase())) != null) {
                this.theToken = new Token(this.theToken.tok, this.theToken.intValue, ident);
            }
        } else {
            ident = ident.toLowerCase();
            this.theToken = Token.getTokenFromName(ident);
        }
        if (this.theToken == null) {
            this.theToken = ident.indexOf("property_") == 0 ? new Token(642777357, ident.toLowerCase()) : new Token(1, ident);
        }
        this.theTok = this.theToken.tok;
        return ident;
    }

    private int checkSpecialParameterSyntax() {
        char ch;
        if (this.nTokens == this.ptNewSetModifier && (this.tokCommand == 36867 || Token.tokAttr(this.tokCommand, 0x20000000))) {
            boolean isAndEquals;
            ch = this.script.charAt(this.ichToken);
            if (ch == '=') {
                this.setEqualPt = this.ichToken;
            }
            boolean bl = isAndEquals = "+-\\*/&|=".indexOf(ch) >= 0;
            if (Token.tokAttr(this.tokCommand, 0x20000000) && ch == '=' || (this.isNewSet || this.isSetBrace) && (isAndEquals || ch == '.' || ch == '[')) {
                this.tokenCommand = isAndEquals ? Token.tokenSet : (ch == '[' && !this.isSetBrace ? Token.tokenSetArray : Token.tokenSetProperty);
                this.tokCommand = 36867;
                this.ltoken.insertElementAt(this.tokenCommand, 0);
                this.cchToken = 1;
                switch (ch) {
                    case '[': {
                        this.addTokenToPrefix(new Token(0x10100040, "["));
                        ++this.bracketCount;
                        return 2;
                    }
                    case '.': {
                        this.addTokenToPrefix(new Token(0x100008, "."));
                        return 2;
                    }
                    case '&': 
                    case '*': 
                    case '+': 
                    case '-': 
                    case '/': 
                    case '\\': 
                    case '|': {
                        if (this.ichToken + 1 >= this.cchScript) {
                            return this.ERROR(4);
                        }
                        if (this.script.charAt(this.ichToken + 1) == ch || this.script.charAt(this.ichToken + 1) == '=') break;
                        return this.ERROR(1, "" + ch);
                    }
                    default: {
                        this.lastToken = Token.tokenMinus;
                        return 2;
                    }
                }
            }
        }
        if (this.lookingAtString(!Token.tokAttr(this.tokCommand, 20480))) {
            if (this.cchToken < 0) {
                return this.ERROR(4);
            }
            String str = (this.tokCommand == 135271427 || this.tokCommand == 536875012 || this.tokCommand == 135271429) && !this.iHaveQuotedString ? this.script.substring(this.ichToken + 1, this.ichToken + this.cchToken - 1) : this.getUnescapedStringLiteral();
            this.addTokenToPrefix(new Token(4, str));
            this.iHaveQuotedString = true;
            if (this.tokCommand == 135272450 && str.indexOf("@") < 0 && !this.getData(str)) {
                return this.ERROR(11, "data");
            }
            return 2;
        }
        if (this.tokCommand == 4156 && this.nTokens == 1 && this.charToken()) {
            String ident = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
            this.addTokenToPrefix(new Token(1, ident));
            return 2;
        }
        if (this.tokCommand == 135271427) {
            if (this.script.charAt(this.ichToken) == '@') {
                this.iHaveQuotedString = true;
                return 0;
            }
            if (this.nTokens == 1 && this.lookingAtLoadFormat()) {
                String strFormat = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                if (Parser.isOneOf(strFormat = strFormat.toLowerCase(), LOAD_TYPES)) {
                    this.addTokenToPrefix(new Token(1, strFormat));
                } else if (strFormat.indexOf("=") == 0) {
                    this.addTokenToPrefix(new Token(4, strFormat));
                }
                return 2;
            }
            if (this.script.charAt(this.ichToken) != '{' && this.parenCount <= 0) {
                BitSet bs = this.lookingAtBitset();
                if (bs != null) {
                    this.addTokenToPrefix(new Token(0x40000007, bs));
                    return 2;
                }
                if (!this.iHaveQuotedString && this.lookingAtImpliedString()) {
                    String str = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                    int pt = str.indexOf(" ");
                    if (pt > 0) {
                        this.cchToken = pt;
                        str = str.substring(0, pt);
                    }
                    this.addTokenToPrefix(new Token(4, str));
                    this.iHaveQuotedString = true;
                    return 2;
                }
            }
        } else if (this.tokCommand == 135271429) {
            if (!this.iHaveQuotedString && this.lookingAtImpliedString()) {
                String str = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                int pt = str.indexOf(" ");
                if (pt > 0) {
                    this.cchToken = pt;
                    str = str.substring(0, pt);
                }
                this.addTokenToPrefix(new Token(4, str));
                this.iHaveQuotedString = true;
                return 2;
            }
        } else if (this.tokCommand == 135270406) {
            int pt = this.cchToken;
            if (this.nTokens == 2 && this.lastToken.tok == 4116) {
                this.iHaveQuotedString = true;
            }
            if (this.nTokens > 2 && !this.iHaveQuotedString && this.lookingAtImpliedString()) {
                String str = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                if (str.startsWith("@{")) {
                    this.iHaveQuotedString = true;
                } else if (str.indexOf(" ") < 0) {
                    this.addTokenToPrefix(new Token(4, str));
                    this.iHaveQuotedString = true;
                    return 2;
                }
                this.cchToken = pt;
            }
        }
        if (Token.tokAttr(this.tokCommand, 20480) && (this.tokCommand != 135271429 || !this.iHaveQuotedString) && this.lookingAtImpliedString()) {
            String str = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
            this.addTokenToPrefix(new Token(4, str));
            return 2;
        }
        float value = this.lookingAtExponential();
        if (!Float.isNaN(value)) {
            this.addTokenToPrefix(new Token(3, new Float(value)));
            return 2;
        }
        if (this.lookingAtObjectID(this.nTokens == 1)) {
            this.addTokenToPrefix(Token.getTokenFromName("$"));
            this.addTokenToPrefix(new Token(1, this.script.substring(this.ichToken, this.ichToken + this.cchToken)));
            return 2;
        }
        if (this.lookingAtDecimal()) {
            value = Float.valueOf(this.script.substring(this.ichToken, this.ichToken + this.cchToken)).floatValue();
            int intValue = JmolConstants.modelValue(this.script.substring(this.ichToken, this.ichToken + this.cchToken));
            this.addTokenToPrefix(new Token(3, intValue, new Float(value)));
            return 2;
        }
        if (this.lookingAtSeqcode()) {
            ch = this.script.charAt(this.ichToken);
            try {
                int seqNum = ch == '*' || ch == '^' ? Integer.MAX_VALUE : Integer.parseInt(this.script.substring(this.ichToken, this.ichToken + this.cchToken - 2));
                char insertionCode = this.script.charAt(this.ichToken + this.cchToken - 1);
                if (insertionCode == '^') {
                    insertionCode = ' ';
                }
                if (seqNum < 0) {
                    seqNum = -seqNum;
                    this.addTokenToPrefix(Token.tokenMinus);
                }
                int seqcode = Group.getSeqcode(seqNum, insertionCode);
                this.addTokenToPrefix(new Token(5, seqcode, "seqcode"));
                return 2;
            }
            catch (NumberFormatException nfe) {
                return this.ERROR(9, "" + ch);
            }
        }
        if (this.lookingAtInteger()) {
            String intString = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
            int val = Integer.parseInt(intString);
            if (this.tokCommand == 102407 || this.tokCommand == 102408) {
                ScriptFlowContext f;
                ScriptFlowContext scriptFlowContext;
                if (this.nTokens != 1) {
                    return this.ERROR(0);
                }
                if (this.flowContext == null) {
                    scriptFlowContext = null;
                } else {
                    val = Math.abs(val);
                    scriptFlowContext = f = this.flowContext.getBreakableContext(val);
                }
                if (f == null) {
                    return this.ERROR(1, (String)this.tokenCommand.value);
                }
                ((Token)this.ltoken.get((int)0)).intValue = f.getPt0();
            }
            this.addTokenToPrefix(new Token(2, val, intString));
            return 2;
        }
        if (this.tokCommand == 30412803 && this.nTokens == 2 || this.tokCommand == 4116 && this.nTokens == 2 || this.lastToken.tok == 135280129 || this.lastToken.tok == 135268865 || this.lastToken.tok != 1 && !ScriptCompiler.tokenAttr(this.lastToken, 0x8100000)) {
            boolean isBond = this.script.charAt(this.ichToken) == '[';
            BitSet bs = this.lookingAtBitset();
            if (bs != null) {
                if (isBond) {
                    this.addTokenToPrefix(new Token(0x40000007, new Bond.BondSet(bs)));
                } else {
                    this.addTokenToPrefix(new Token(0x40000007, bs));
                }
                return 2;
            }
        }
        return 0;
    }

    private int parseKnownToken(String ident) {
        if (this.tokLastMath != 0) {
            this.tokLastMath = this.theTok;
        }
        switch (this.theTok) {
            case 269484226: {
                if (this.theTok != 269484226) break;
                if (this.nSemiSkip == this.forPoint3 && this.nTokens == this.ptSemi + 2) {
                    Token token = this.lastToken;
                    this.addTokenToPrefix(Token.tokenEquals);
                    this.addTokenToPrefix(token);
                    token = Token.getTokenFromName(ident.substring(0, 1));
                    this.addTokenToPrefix(token);
                    this.addTokenToPrefix(Token.tokenLeftParen);
                    this.needRightParen = true;
                    return 2;
                }
                if (this.tokCommand == 36867) {
                    this.tokenAndEquals = Token.getTokenFromName(ident.substring(0, 1));
                    this.setEqualPt = this.ichToken;
                    return 0;
                }
                return 2;
            }
            case 233481: 
            case 364548: {
                if (this.flowContext != null) {
                    this.flowContext.forceEndIf = false;
                }
            }
            case 364547: {
                if (this.nTokens <= 0) break;
                this.isEndOfCommand = true;
                this.cchToken = 0;
                return 2;
            }
            case 102402: 
            case 102406: 
            case 135369224: 
            case 135369225: {
                if (this.nTokens <= 1 || this.tokCommand == 36867) break;
                this.isEndOfCommand = true;
                if (this.flowContext != null) {
                    this.flowContext.forceEndIf = true;
                }
                this.cchToken = 0;
                return 2;
            }
            case 0x101000B1: 
            case 269484210: {
                if (this.isNewSet && this.parenCount == 0 && this.bracketCount == 0 && this.ichToken <= this.setEqualPt) {
                    this.nTokens = this.ltoken.size();
                    this.addTokenToPrefix(Token.tokenEquals);
                    this.setEqualPt = 0;
                    for (int i = 1; i < this.nTokens; ++i) {
                        this.addTokenToPrefix((Token)this.ltoken.elementAt(i));
                    }
                    this.addTokenToPrefix(this.theTok == 0x101000B1 ? Token.tokenMinus : Token.tokenPlus);
                    this.addTokenToPrefix(Token.intToken(1));
                    return 2;
                }
                if (this.nSemiSkip != this.forPoint3 || this.nTokens != this.ptSemi + 2) break;
                Token token = this.lastToken;
                this.addTokenToPrefix(Token.tokenEquals);
                this.addTokenToPrefix(token);
                this.addTokenToPrefix(this.theTok == 0x101000B1 ? Token.tokenMinus : Token.tokenPlus);
                this.addTokenToPrefix(Token.intToken(1));
                return 2;
            }
            case 269484420: {
                if (this.parenCount != 0 || this.bracketCount != 0) break;
                this.setEqualPt = this.ichToken;
                break;
            }
            case 0x100008: {
                if (this.tokCommand != 36867 || this.parenCount != 0 || this.bracketCount != 0 || this.ichToken >= this.setEqualPt) break;
                this.ltoken.insertElementAt(Token.tokenExpressionBegin, 1);
                this.addTokenToPrefix(Token.tokenExpressionEnd);
                this.ltoken.setElementAt(Token.tokenSetProperty, 0);
                this.setEqualPt = 0;
                break;
            }
            case 0x10000A: {
                ++this.braceCount;
                if (this.braceCount == 1 && this.parenCount == 0 && this.checkFlowStartBrace(false)) {
                    this.isEndOfCommand = true;
                    if (this.flowContext != null) {
                        this.flowContext.forceEndIf = false;
                    }
                    return 2;
                }
            }
            case 0x10100010: {
                ++this.parenCount;
                if (this.nTokens <= 1 || this.lastToken.tok != 135280129 && this.lastToken.tok != 135369224 && this.lastToken.tok != 135369225) break;
                this.nSemiSkip += 2;
                break;
            }
            case 0x10000E: {
                if (this.iBrace > 0 && this.parenCount == 0 && this.braceCount == 0) {
                    this.ichBrace = this.ichToken;
                    if (this.nTokens == 0) {
                        this.parenCount = 1;
                        this.braceCount = 1;
                    } else {
                        this.nSemiSkip = 0;
                        this.parenCount = 0;
                        this.braceCount = 0;
                        this.vBraces.add(this.theToken);
                        ++this.iBrace;
                        this.isEndOfCommand = true;
                        return 2;
                    }
                }
                --this.braceCount;
            }
            case 0x10100011: {
                --this.parenCount;
                if (this.parenCount < 0) {
                    return this.ERROR(16, ident);
                }
                if (this.parenCount == 0) {
                    this.nSemiSkip = 0;
                }
                if (!this.needRightParen) break;
                this.addTokenToPrefix(Token.tokenRightParen);
                this.needRightParen = false;
                break;
            }
            case 0x10100040: {
                ++this.bracketCount;
                break;
            }
            case 0x10100041: {
                --this.bracketCount;
                if (this.bracketCount >= 0) break;
                return this.ERROR(16, "]");
            }
        }
        return 0;
    }

    private int parseCommandParameter(String ident) {
        this.nTokens = this.ltoken.size();
        switch (this.tokCommand) {
            case 0: {
                int ret;
                this.lastToken = Token.tokenOff;
                this.ichCurrentCommand = this.ichEnd = this.ichToken;
                this.tokenCommand = this.theToken;
                this.tokCommand = this.theTok;
                if (Token.tokAttr(this.tokCommand, 102400)) {
                    this.lastFlowCommand = this.tokenCommand;
                    if (this.iBrace > 0 && (this.tokCommand == 364547 || this.tokCommand == 102402) && ((Token)this.vBraces.get((int)(this.iBrace - 1))).tok == 0x10000E) {
                        this.vBraces.remove(--this.iBrace);
                        this.vBraces.remove(--this.iBrace);
                    }
                }
                if ((ret = this.checkFlowEndBrace()) == 4) {
                    return 4;
                }
                if (ret == 2) {
                    this.isEndOfCommand = true;
                    this.cchToken = 0;
                    return 2;
                }
                if (Token.tokAttr(this.tokCommand, 102400)) {
                    if (!this.checkFlowCommand((String)this.tokenCommand.value)) {
                        return 4;
                    }
                    this.theToken = this.tokenCommand;
                    break;
                }
                if (this.theTok == 0x10000E) {
                    this.vBraces.add(this.tokenCommand);
                    ++this.iBrace;
                    this.tokCommand = 0;
                    return 2;
                }
                if (this.theTok != 0x10000A) {
                    this.lastFlowCommand = null;
                }
                if (Token.tokAttr(this.tokCommand, 4096)) break;
                boolean bl = this.isSetBrace = this.theTok == 0x10000A;
                if (this.isSetBrace && !this.lookingAtBraceSyntax()) {
                    this.isEndOfCommand = true;
                    if (this.flowContext != null) {
                        this.flowContext.forceEndIf = false;
                    }
                }
                if (!(this.isSetBrace || this.theTok == 269484210 || this.theTok == 0x101000B1 || Token.tokAttr(this.theTok, 1) || Token.tokAttr(this.theTok, 0x20000000))) {
                    this.commandExpected();
                    return 4;
                }
                this.tokCommand = 36867;
                this.isNewSet = !this.isSetBrace;
                this.setBraceCount = this.isSetBrace ? 1 : 0;
                this.bracketCount = 0;
                this.setEqualPt = Integer.MAX_VALUE;
                this.ptNewSetModifier = this.isNewSet ? 1 : Integer.MAX_VALUE;
                break;
            }
            case 135499780: {
                if (this.tokenCommand.intValue == 0) {
                    if (this.nTokens != 1) break;
                    this.tokenCommand.value = ident;
                    return 2;
                }
                if (this.nTokens == 1) {
                    this.thisFunction = new ScriptFunction(ident);
                    this.flowContext.setFunction(this.thisFunction);
                    break;
                }
                if (this.nTokens == 2) {
                    if (this.theTok == 0x10100010) break;
                    return this.ERROR(15, "(");
                }
                if (this.nTokens == 3 && this.theTok == 0x10100011) break;
                if (this.nTokens % 2 == 0) {
                    if (this.theTok == 0x10100030 || this.theTok == 0x10100011) break;
                    return this.ERROR(15, ", )");
                }
                this.thisFunction.addVariable(ident, true);
                break;
            }
            case 364547: {
                if (this.nTokens == 1 && this.theTok != 135369225) {
                    this.isEndOfCommand = true;
                    this.cchToken = 0;
                    return 2;
                }
                if (this.nTokens != 1 || this.theTok != 135369225 && this.theTok != 0x10000A) {
                    return this.ERROR(0);
                }
                this.ltoken.removeElementAt(0);
                this.flowContext.token = new Token(102402, "elseif");
                this.ltoken.addElement(this.flowContext.token);
                this.tokCommand = 102402;
                return 2;
            }
            case 537038852: {
                if (this.nTokens != 1) break;
                this.addContextVariable(ident);
                this.ltoken.removeElementAt(0);
                this.ltoken.addElement(Token.tokenSetVar);
                this.tokCommand = 36867;
                break;
            }
            case 233481: {
                if (this.nTokens != 1) {
                    return this.ERROR(0);
                }
                if (!this.checkFlowEnd(this.theTok, ident, this.ichCurrentCommand)) {
                    return 4;
                }
                if (this.theTok != 135499780) break;
                return 2;
            }
            case 102406: {
                if (this.nTokens <= 2 || this.braceCount != 0 || this.parenCount != 0) break;
                this.isEndOfCommand = true;
                this.flowContext.setLine();
                break;
            }
            case 102402: 
            case 135369225: {
                if (this.nTokens <= 2 || this.braceCount != 0 || this.parenCount != 0) break;
                this.isEndOfCommand = true;
                this.flowContext.setLine();
                break;
            }
            case 135369224: {
                if (this.nTokens == 1) {
                    if (this.theTok != 0x10100010) {
                        return this.ERROR(19, ident);
                    }
                    this.nSemiSkip = 0;
                    this.forPoint3 = 0;
                    this.nSemiSkip += 2;
                    break;
                }
                if (this.nTokens == 3 && ((Token)this.ltoken.get((int)2)).tok == 537038852) {
                    this.addContextVariable(ident);
                    break;
                }
                if (this.braceCount != 0 || this.parenCount != 0) break;
                this.isEndOfCommand = true;
                this.flowContext.setLine();
                break;
            }
            case 36867: {
                if (this.theTok == 0x10000A) {
                    ++this.setBraceCount;
                } else if (this.theTok == 0x10000E) {
                    --this.setBraceCount;
                    if (this.isSetBrace && this.setBraceCount == 0 && this.ptNewSetModifier == Integer.MAX_VALUE) {
                        this.ptNewSetModifier = this.nTokens + 1;
                    }
                }
                if (this.nTokens != this.ptNewSetModifier) break;
                boolean isSetArray = false;
                if (this.theTok == 0x10100010) {
                    Token token = (Token)this.ltoken.get(0);
                    this.tokenCommand = new Token(135499780, 0, token.value);
                    this.ltoken.setElementAt(this.tokenCommand, 0);
                    this.tokCommand = 135499780;
                    break;
                }
                if (this.theTok != 1 && this.theTok != 269484226 && !Token.tokAttr(this.theTok, 0x20000000)) {
                    if (this.isNewSet) {
                        this.commandExpected();
                    } else {
                        this.error(18, "SET", ": " + ident);
                    }
                    return 4;
                }
                if (isSetArray) {
                    this.addTokenToPrefix(this.theToken);
                    break;
                }
                if (this.nTokens != 1 || this.lastToken.tok != 269484210 && this.lastToken.tok != 0x101000B1) break;
                this.ltoken.removeElementAt(0);
                this.tokenCommand = Token.tokenSet;
                this.tokCommand = 36867;
                this.ltoken.insertElementAt(this.tokenCommand, 0);
                this.addTokenToPrefix(this.lastToken);
                break;
            }
            case 12291: 
            case 12293: 
            case 12294: 
            case 135280129: 
            case 536883204: 
            case 537931778: {
                if (this.tokCommand == 537931778) {
                    if (this.nTokens == 1) {
                        if (this.theTok != 1) {
                            if (this.preDefining) {
                                if (!Token.tokAttr(this.theTok, 0x300000)) {
                                    this.error("ERROR IN Token.java or JmolConstants.java -- the following term was used in JmolConstants.java but not listed as predefinedset in Token.java: " + ident, null);
                                    return 4;
                                }
                            } else if (Token.tokAttr(this.theTok, 0x300000)) {
                                Logger.warn("WARNING: predefined term '" + ident + "' has been redefined by the user until the next file load.");
                            } else if (!this.isCheckOnly && ident.length() > 1) {
                                Logger.warn("WARNING: redefining " + ident + "; was " + this.theToken + "not all commands may continue to be functional for the life of the applet!");
                                this.theToken.tok = 1;
                                this.theTok = 1;
                                Token.addToken(ident, this.theToken);
                            }
                        }
                        this.addTokenToPrefix(this.theToken);
                        this.lastToken = Token.tokenComma;
                        return 2;
                    }
                    if (this.nTokens == 2 && this.theTok == 269484420) {
                        this.ltoken.insertElementAt(Token.tokenSet, 0);
                        return 2;
                    }
                }
                if (this.bracketCount != 0 || this.theTok == 1 || Token.tokAttr(this.theTok, 0x100000) || this.theTok == 32 || this.theTok == 64 || this.theTok == 96 || this.theTok == 128) break;
                return this.ERROR(9, ident);
            }
            case 12289: {
                if (this.theTok == 1 || this.theTok == 0x100007 || Token.tokAttr(this.theTok, 0x100000)) break;
                return this.ERROR(9, ident);
            }
        }
        return 0;
    }

    private boolean checkFlowStartBrace(boolean atEnd) {
        if (!Token.tokAttr(this.tokCommand, 102400) || this.tokCommand == 102407 || this.tokCommand == 102408) {
            return false;
        }
        if (atEnd) {
            this.vBraces.add(this.tokenCommand);
            ++this.iBrace;
            this.braceCount = 0;
            this.parenCount = 0;
        }
        return true;
    }

    private int checkFlowEndBrace() {
        if (this.iBrace <= 0 || ((Token)this.vBraces.get((int)(this.iBrace - 1))).tok != 0x10000E) {
            return 0;
        }
        this.vBraces.remove(--this.iBrace);
        Token token = (Token)this.vBraces.remove(--this.iBrace);
        return this.forceFlowEnd(token);
    }

    private int forceFlowEnd(Token token) {
        Token t0 = this.tokenCommand;
        this.tokenCommand = new Token(233481, "end");
        this.tokCommand = this.tokenCommand.tok;
        if (!this.checkFlowCommand("end")) {
            return 0;
        }
        this.addTokenToPrefix(this.tokenCommand);
        switch (token.tok) {
            case 102402: 
            case 364547: 
            case 135369225: {
                token = Token.tokenIf;
                break;
            }
            default: {
                token = Token.getTokenFromName((String)token.value);
            }
        }
        if (!this.checkFlowEnd(token.tok, (String)token.value, this.ichBrace)) {
            return 4;
        }
        if (token.tok != 135499780) {
            this.addTokenToPrefix(token);
        }
        this.tokenCommand = t0;
        if (this.tokenCommand != null) {
            this.tokCommand = this.tokenCommand.tok;
        }
        return 2;
    }

    private boolean checkFlowCommand(String ident) {
        int pt = this.lltoken.size();
        boolean isEnd = false;
        boolean isNew = true;
        switch (this.tokCommand) {
            case 233481: {
                if (this.flowContext == null) {
                    return this.error(1, ident);
                }
                isEnd = true;
                if (this.flowContext.token.tok == 135499780) break;
                this.tokenCommand = new Token(this.tokCommand, -this.flowContext.getPt0(), ident);
                break;
            }
            case 102406: 
            case 135369224: 
            case 135369225: {
                break;
            }
            case 364548: {
                isEnd = true;
                if (this.flowContext != null && (this.flowContext.token.tok == 135369225 || this.flowContext.token.tok == 364547 || this.flowContext.token.tok == 102402)) break;
                return this.error(1, ident);
            }
            case 364547: {
                if (this.flowContext == null || this.flowContext.token.tok != 135369225 && this.flowContext.token.tok != 102402) {
                    return this.error(1, ident);
                }
                this.flowContext.token.intValue = this.flowContext.setPt0(pt);
                break;
            }
            case 102407: 
            case 102408: {
                ScriptFlowContext f;
                isNew = false;
                ScriptFlowContext scriptFlowContext = f = this.flowContext == null ? null : this.flowContext.getBreakableContext(0);
                if (f == null) {
                    return this.error(1, ident);
                }
                this.tokenCommand = new Token(this.tokCommand, f.getPt0(), ident);
                break;
            }
            case 102402: {
                if (this.flowContext == null || this.flowContext.token.tok != 135369225 && this.flowContext.token.tok != 102402 && this.flowContext.token.tok != 364547) {
                    return this.error(1, "elseif");
                }
                this.flowContext.token.intValue = this.flowContext.setPt0(pt);
                break;
            }
            case 135499780: {
                if (this.flowContext == null) break;
                return this.error(1, "function");
            }
        }
        if (isEnd) {
            this.flowContext.token.intValue = pt;
            if (this.tokCommand == 364548) {
                this.flowContext = this.flowContext.getParent();
            }
        } else if (isNew) {
            this.tokenCommand = new Token(this.tokCommand, this.tokenCommand.value);
            if (this.tokCommand == 364547 || this.tokCommand == 102402) {
                this.flowContext.token = this.tokenCommand;
            } else {
                this.flowContext = new ScriptFlowContext(this, this.tokenCommand, pt, this.flowContext);
            }
        }
        this.tokCommand = this.tokenCommand.tok;
        return true;
    }

    private boolean checkFlowEnd(int tok, String ident, int pt1) {
        if ((this.flowContext == null || this.flowContext.token.tok != tok) && (tok != 135369225 || this.flowContext.token.tok != 364547 && this.flowContext.token.tok != 102402)) {
            return this.error(1, "end " + ident);
        }
        switch (tok) {
            case 102406: 
            case 135369224: 
            case 135369225: {
                break;
            }
            case 135499780: {
                if (!this.isCheckOnly) {
                    this.addTokenToPrefix(new Token(135499780, this.thisFunction));
                    ScriptFunction.setFunction(this.thisFunction, this.script, pt1, this.lltoken.size(), this.lineNumbers, this.lineIndices, this.lltoken);
                }
                this.thisFunction = null;
                this.tokenCommand.intValue = 0;
                this.flowContext = this.flowContext.getParent();
                return true;
            }
            default: {
                return this.error(19, "end " + ident);
            }
        }
        this.flowContext = this.flowContext.getParent();
        return true;
    }

    private boolean getData(String key) {
        int i;
        this.ichToken += key.length() + 2;
        if (this.script.length() > this.ichToken && this.script.charAt(this.ichToken) == '\r') {
            this.lineCurrent = (short)(this.lineCurrent + 1);
            ++this.ichToken;
        }
        if (this.script.length() > this.ichToken && this.script.charAt(this.ichToken) == '\n') {
            this.lineCurrent = (short)(this.lineCurrent + 1);
            ++this.ichToken;
        }
        if ((i = this.script.indexOf(this.chFirst + key + this.chFirst, this.ichToken) - 4) < 0 || !this.script.substring(i, i + 4).equalsIgnoreCase("END ")) {
            return false;
        }
        String str = this.script.substring(this.ichToken, i);
        this.incrementLineCount(str);
        this.addTokenToPrefix(new Token(135272450, str));
        this.addTokenToPrefix(new Token(1, "end"));
        this.addTokenToPrefix(new Token(4, key));
        this.cchToken = i - this.ichToken + key.length() + 6;
        return true;
    }

    private int incrementLineCount(String str) {
        int pt = str.indexOf(13);
        int pt2 = str.indexOf(10);
        if (pt < 0 && pt2 < 0) {
            return 0;
        }
        short n = this.lineCurrent;
        if (pt < 0 || pt2 < pt) {
            pt = pt2;
        }
        int i = str.length();
        while (--i >= pt) {
            char ch = str.charAt(i);
            if (ch != '\n' && ch != '\r') continue;
            this.lineCurrent = (short)(this.lineCurrent + 1);
        }
        return this.lineCurrent - n;
    }

    private static boolean isSpaceOrTab(char ch) {
        return ch == ' ' || ch == '\t';
    }

    private boolean eol(char ch) {
        return ScriptCompiler.eol(ch, this.nSemiSkip);
    }

    static boolean eol(char ch, int nSkip) {
        return ch == '\r' || ch == '\n' || ch == ';' && nSkip <= 0;
    }

    private boolean lookingAtBraceSyntax() {
        int ichT = this.ichToken;
        int nParen = 1;
        while (++ichT < this.cchScript && nParen > 0) {
            switch (this.script.charAt(ichT)) {
                case '{': {
                    ++nParen;
                    break;
                }
                case '}': {
                    --nParen;
                }
            }
        }
        if (ichT < this.cchScript && this.script.charAt(ichT) == '[' && ++nParen == 1) {
            while (++ichT < this.cchScript && nParen > 0) {
                switch (this.script.charAt(ichT)) {
                    case '[': {
                        ++nParen;
                        break;
                    }
                    case ']': {
                        --nParen;
                    }
                }
            }
        }
        return ichT < this.cchScript && this.script.charAt(ichT) == '.' && nParen == 0;
    }

    private boolean lookingAtString(boolean allowPrime) {
        char ch;
        if (this.ichToken == this.cchScript) {
            return false;
        }
        this.chFirst = this.script.charAt(this.ichToken);
        if (!(this.chFirst == '\"' || allowPrime && this.chFirst == '\'')) {
            return false;
        }
        int ichT = this.ichToken;
        boolean previousCharBackslash = false;
        while (++ichT < this.cchScript && ((ch = this.script.charAt(ichT)) != this.chFirst || previousCharBackslash)) {
            previousCharBackslash = ch == '\\' ? !previousCharBackslash : false;
        }
        this.cchToken = ichT == this.cchScript ? -1 : ++ichT - this.ichToken;
        return true;
    }

    String getUnescapedStringLiteral() {
        if (this.cchToken < 2) {
            return "";
        }
        StringBuffer sb = new StringBuffer(this.cchToken - 2);
        int ichMax = this.ichToken + this.cchToken - 1;
        int ich = this.ichToken + 1;
        while (ich < ichMax) {
            int ch;
            if ((ch = this.script.charAt(ich++)) == 92 && ich < ichMax) {
                ch = this.script.charAt(ich++);
                switch (ch) {
                    case 98: {
                        ch = 8;
                        break;
                    }
                    case 110: {
                        ch = 10;
                        break;
                    }
                    case 116: {
                        ch = 9;
                        break;
                    }
                    case 114: {
                        ch = 13;
                    }
                    case 34: 
                    case 39: 
                    case 92: {
                        break;
                    }
                    case 117: 
                    case 120: {
                        char chT;
                        int hexit;
                        int digitCount;
                        int n = digitCount = ch == 120 ? 2 : 4;
                        if (ich >= ichMax) break;
                        int unicode = 0;
                        int k = digitCount;
                        while (--k >= 0 && ich < ichMax && (hexit = ScriptCompiler.getHexitValue(chT = this.script.charAt(ich))) >= 0) {
                            unicode <<= 4;
                            unicode += hexit;
                            ++ich;
                        }
                        ch = (char)unicode;
                    }
                }
            }
            sb.append((char)ch);
        }
        return sb.toString();
    }

    static int getHexitValue(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'a' && ch <= 'f') {
            return 10 + ch - 97;
        }
        if (ch >= 'A' && ch <= 'F') {
            return 10 + ch - 65;
        }
        return -1;
    }

    private boolean lookingAtLoadFormat() {
        int ichT;
        char ch = '\u0000';
        for (ichT = this.ichToken; ichT < this.cchScript && ((ch = this.script.charAt(ichT)) == '=' && ichT == this.ichToken || Character.isLetterOrDigit(ch)); ++ichT) {
        }
        if (ichT == this.ichToken || !this.eol(ch) && !ScriptCompiler.isSpaceOrTab(ch)) {
            return false;
        }
        this.cchToken = ichT - this.ichToken;
        return true;
    }

    private boolean lookingAtImpliedString() {
        char ch;
        int ichT;
        for (ichT = this.ichToken; ichT < this.cchScript && !this.eol(ch = this.script.charAt(ichT)) && ch != '}'; ++ichT) {
        }
        boolean isMath = false;
        if (!(ichT <= this.ichToken || this.script.charAt(this.ichToken) != '@' || ichT > this.ichToken + 1 && (isMath = this.script.charAt(this.ichToken + 1) == '{'))) {
            return false;
        }
        if (isMath) {
            ichT = ScriptCompiler.ichMathTerminator(this.script, this.ichToken + 1, this.cchScript);
            if (ichT == this.cchScript) {
                return false;
            }
            this.cchToken = ichT + 1 - this.ichToken;
            return this.cchToken > 0;
        }
        while (--ichT > this.ichToken && Character.isWhitespace(this.script.charAt(ichT))) {
        }
        return (this.cchToken = ++ichT - this.ichToken) > 0;
    }

    static int ichMathTerminator(String script, int ichT, int len) {
        int nP = 1;
        char chFirst = '\u0000';
        int chLast = 0;
        while (nP > 0 && ++ichT < len) {
            char ch = script.charAt(ichT);
            if (chFirst != '\u0000') {
                if (chLast == 92) {
                    ch = '\u0000';
                } else if (ch == chFirst) {
                    chFirst = '\u0000';
                }
                chLast = ch;
                continue;
            }
            switch (ch) {
                case '\"': 
                case '\'': {
                    chFirst = ch;
                    break;
                }
                case '{': {
                    ++nP;
                    break;
                }
                case '}': {
                    --nP;
                }
            }
        }
        return ichT;
    }

    private float lookingAtExponential() {
        boolean isExponential;
        boolean isNegative;
        if (this.ichToken == this.cchScript) {
            return Float.NaN;
        }
        int ichT = this.ichToken;
        boolean bl = isNegative = this.script.charAt(ichT) == '-';
        if (isNegative) {
            ++ichT;
        }
        int pt0 = ichT;
        boolean digitSeen = false;
        int ch = 88;
        while (ichT < this.cchScript) {
            char c = this.script.charAt(ichT);
            ch = c;
            if (!Character.isDigit(c)) break;
            ++ichT;
            digitSeen = true;
        }
        if (ichT < this.cchScript && ch == 46) {
            ++ichT;
        }
        while (ichT < this.cchScript) {
            char c = this.script.charAt(ichT);
            ch = c;
            if (!Character.isDigit(c)) break;
            ++ichT;
            digitSeen = true;
        }
        if (ichT == this.cchScript || !digitSeen) {
            return Float.NaN;
        }
        int ptE = ichT;
        int factor = 1;
        int exp = 0;
        boolean bl2 = isExponential = ch == 69 || ch == 101;
        if (!isExponential || ++ichT == this.cchScript) {
            return Float.NaN;
        }
        ch = this.script.charAt(ichT);
        if (ch == 45 || ch == 43) {
            ++ichT;
            int n = factor = ch == 45 ? -1 : 1;
        }
        while (ichT < this.cchScript) {
            char c = this.script.charAt(ichT);
            ch = c;
            if (!Character.isDigit(c)) break;
            ++ichT;
            exp = exp * 10 + ch - 48;
        }
        if (exp == 0) {
            return Float.NaN;
        }
        this.cchToken = ichT - this.ichToken;
        double value = Float.valueOf(this.script.substring(pt0, ptE)).doubleValue();
        return (float)(value *= (double)(isNegative ? -1 : 1) * Math.pow(10.0, factor * exp));
    }

    private boolean lookingAtDecimal() {
        char ch1;
        if (this.ichToken == this.cchScript) {
            return false;
        }
        int ichT = this.ichToken;
        if (this.script.charAt(ichT) == '-') {
            ++ichT;
        }
        boolean digitSeen = false;
        int ch = 88;
        while (ichT < this.cchScript) {
            char c = this.script.charAt(ichT++);
            ch = c;
            if (!Character.isDigit(c)) break;
            digitSeen = true;
        }
        if (ch != 46) {
            return false;
        }
        if (ichT < this.cchScript && !this.eol(ch1 = this.script.charAt(ichT))) {
            if (Character.isLetter(ch1) || ch1 == '?') {
                return false;
            }
            if (ichT + 1 < this.cchScript && (Character.isLetter(ch1 = this.script.charAt(ichT + 1)) || ch1 == '?')) {
                return false;
            }
        }
        while (ichT < this.cchScript && Character.isDigit(this.script.charAt(ichT))) {
            ++ichT;
            digitSeen = true;
        }
        this.cchToken = ichT - this.ichToken;
        return digitSeen;
    }

    private boolean lookingAtSeqcode() {
        int ichT = this.ichToken;
        char ch = ' ';
        if (ichT + 1 < this.cchScript && this.script.charAt(ichT) == '*' && this.script.charAt(ichT + 1) == '^') {
            ch = '^';
            ++ichT;
        } else {
            if (this.script.charAt(ichT) == '-') {
                ++ichT;
            }
            while (ichT < this.cchScript) {
                char c = this.script.charAt(ichT);
                ch = c;
                if (!Character.isDigit(c)) break;
                ++ichT;
            }
        }
        if (ch != '^') {
            return false;
        }
        if ((ch = ++ichT == this.cchScript ? (char)' ' : (char)this.script.charAt(ichT++)) != ' ' && ch != '*' && ch != '?' && !Character.isLetter(ch)) {
            return false;
        }
        this.cchToken = ichT - this.ichToken;
        return true;
    }

    private boolean lookingAtInteger() {
        if (this.ichToken == this.cchScript) {
            return false;
        }
        int ichT = this.ichToken;
        if (this.script.charAt(this.ichToken) == '-') {
            ++ichT;
        }
        int ichBeginDigits = ichT;
        while (ichT < this.cchScript && Character.isDigit(this.script.charAt(ichT))) {
            ++ichT;
        }
        if (ichBeginDigits == ichT) {
            return false;
        }
        this.cchToken = ichT - this.ichToken;
        return true;
    }

    BitSet lookingAtBitset() {
        int ichT;
        if (this.script.indexOf("({null})", this.ichToken) == this.ichToken) {
            this.cchToken = 8;
            return new BitSet();
        }
        if (this.ichToken + 4 > this.cchScript || this.script.charAt(this.ichToken + 1) != '{' || this.script.charAt(this.ichToken) != '(' && this.script.charAt(this.ichToken) != '[') {
            return null;
        }
        char chEnd = this.script.charAt(this.ichToken) == '(' ? (char)')' : ']';
        char ch = ' ';
        for (ichT = this.ichToken + 2; ichT < this.cchScript; ++ichT) {
            char c = this.script.charAt(ichT);
            ch = c;
            if (c == '}' || !Character.isDigit(ch) && !ScriptCompiler.isSpaceOrTab(ch) && ch != 58) break;
        }
        if (ch != '}' || ichT + 1 == this.cchScript || this.script.charAt(ichT + 1) != chEnd) {
            return null;
        }
        int iprev = -1;
        int ipt = 0;
        BitSet bs = new BitSet();
        int ich = this.ichToken + 2;
        while (ich < ichT) {
            while (ScriptCompiler.isSpaceOrTab(ch = this.script.charAt(ich))) {
                ++ich;
            }
            ipt = ich;
            while (Character.isDigit(ch = this.script.charAt(ipt))) {
                ++ipt;
            }
            if (ipt == ich) {
                return null;
            }
            int val = Integer.parseInt(this.script.substring(ich, ipt));
            if (ch == ':') {
                iprev = val;
            } else {
                if (iprev >= 0) {
                    if (iprev > val) {
                        return null;
                    }
                    for (int i = iprev; i <= val; ++i) {
                        bs.set(i);
                    }
                } else {
                    bs.set(val);
                }
                iprev = -1;
            }
            ich = ++ipt;
        }
        if (iprev >= 0) {
            return null;
        }
        this.cchToken = ichT + 2 - this.ichToken;
        return bs;
    }

    private boolean lookingAtObjectID(boolean allowWildID) {
        int ichT = this.ichToken;
        if (ichT == this.cchScript || this.script.charAt(ichT) != '$') {
            return false;
        }
        if (++ichT != this.cchScript && this.script.charAt(ichT) == '\"') {
            return false;
        }
        while (ichT < this.cchScript) {
            char ch = this.script.charAt(ichT);
            if (Character.isWhitespace(ch)) {
                if (ichT != this.ichToken + 1) break;
                return false;
            }
            if (!Character.isLetterOrDigit(ch)) {
                switch (ch) {
                    default: {
                        return false;
                    }
                    case '*': {
                        if (allowWildID) break;
                        return false;
                    }
                    case '_': 
                    case '~': 
                }
            }
            ++ichT;
        }
        this.cchToken = ichT - ++this.ichToken;
        return true;
    }

    private boolean lookingAtLookupToken(int ichT) {
        if (ichT == this.cchScript) {
            return false;
        }
        int ichT0 = ichT;
        this.tokLastMath = 0;
        char ch = this.script.charAt(ichT++);
        switch (ch) {
            case '&': 
            case '+': 
            case '-': 
            case '|': {
                if (ichT < this.cchScript) {
                    if (this.script.charAt(ichT) == ch) {
                        ++ichT;
                        if (ch == '-' || ch == '+') {
                            break;
                        }
                    } else if (this.script.charAt(ichT) == '=') {
                        ++ichT;
                    }
                }
                ++this.tokLastMath;
                break;
            }
            case '/': {
                if (ichT < this.cchScript && this.script.charAt(ichT) == '/') break;
            }
            case '!': 
            case '*': 
            case '\\': {
                if (ichT < this.cchScript && this.script.charAt(ichT) == '=') {
                    ++ichT;
                }
                ++this.tokLastMath;
                break;
            }
            case ')': 
            case '.': 
            case ']': 
            case '}': {
                break;
            }
            case '$': 
            case '%': 
            case '(': 
            case ',': 
            case ':': 
            case ';': 
            case '@': 
            case '[': 
            case '{': {
                this.tokLastMath = 1;
                break;
            }
            case '<': 
            case '=': 
            case '>': {
                if (ichT < this.cchScript && ((ch = this.script.charAt(ichT)) == '<' || ch == '=' || ch == '>')) {
                    ++ichT;
                }
                this.tokLastMath = 1;
                break;
            }
            default: {
                if (!Character.isLetter(ch)) {
                    return false;
                }
            }
            case '\'': 
            case '?': 
            case '_': 
            case '~': {
                if (ch == '?') {
                    this.tokLastMath = 1;
                }
                while (ichT < this.cchScript && (Character.isLetterOrDigit(ch = this.script.charAt(ichT)) || ch == '_' || ch == '?' || ch == '~' || ch == '\'') || ch == '^' && ichT > ichT0 && Character.isDigit(this.script.charAt(ichT - 1)) || ch == '\\' && ichT + 1 < this.cchScript && this.script.charAt(ichT + 1) == '?') {
                    ++ichT;
                }
                break block0;
            }
        }
        this.cchToken = ichT - ichT0;
        return true;
    }

    private boolean charToken() {
        int ichT;
        char ch;
        if (this.ichToken == this.cchScript || (ch = this.script.charAt(this.ichToken)) == '\"' || ch == '@') {
            return false;
        }
        for (ichT = this.ichToken; ichT < this.cchScript && !ScriptCompiler.isSpaceOrTab(ch = this.script.charAt(ichT)) && ch != '#' && ch != '}' && !this.eol(ch); ++ichT) {
        }
        this.cchToken = ichT - this.ichToken;
        return true;
    }

    private int ERROR(int error) {
        this.error(error, null, null);
        return 4;
    }

    private int ERROR(int error, String value) {
        this.error(error, value);
        return 4;
    }

    private boolean handleError() {
        this.errorType = this.errorMessage;
        this.errorLine = this.script.substring(this.ichCurrentCommand, this.ichEnd <= this.ichCurrentCommand ? this.ichToken : this.ichEnd);
        String lineInfo = (this.ichToken < this.ichEnd ? this.errorLine.substring(0, this.ichToken - this.ichCurrentCommand) + " >>>> " + this.errorLine.substring(this.ichToken - this.ichCurrentCommand) : this.errorLine) + " <<<<";
        this.errorMessage = GT._("script compiler ERROR: ") + this.errorMessage + ScriptEvaluator.setErrorLineMessage(null, this.filename, this.lineCurrent, this.iCommand, lineInfo);
        if (!this.isSilent) {
            this.viewer.addCommand(this.errorLine + "#??");
            Logger.error(this.errorMessage);
        }
        return false;
    }
}

