/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import org.jmol.viewer.ScriptCompiler;
import org.jmol.viewer.ScriptFunction;
import org.jmol.viewer.Token;

class ScriptFlowContext {
    private ScriptCompiler compiler;
    Token token;
    private int pt0;
    ScriptFunction function;
    private ScriptFlowContext parent;
    int lineStart;
    int commandStart;
    int ptLine;
    int ptCommand;
    boolean forceEndIf = true;
    String ident;

    ScriptFlowContext(ScriptCompiler compiler, Token token, int pt0, ScriptFlowContext parent) {
        this.compiler = compiler;
        this.token = token;
        this.ident = (String)token.value;
        this.pt0 = pt0;
        this.parent = parent;
        short s = this.compiler.lineCurrent;
        this.ptLine = s;
        this.lineStart = s;
        this.commandStart = this.ptCommand = this.compiler.iCommand;
    }

    ScriptFlowContext getBreakableContext(int nLevelsUp) {
        ScriptFlowContext f;
        for (f = this; f != null && (f.token.tok != 135369224 && f.token.tok != 102406 || nLevelsUp-- > 0); f = f.getParent()) {
        }
        return f;
    }

    boolean checkForceEndIf(int pt) {
        boolean test;
        boolean bl = test = this.forceEndIf && this.ptCommand < this.compiler.iCommand && this.ptLine == this.compiler.lineCurrent;
        if (test) {
            this.forceEndIf = false;
        }
        return test;
    }

    int getPt0() {
        return this.pt0;
    }

    int setPt0(int pt0) {
        this.pt0 = pt0;
        this.setLine();
        return pt0;
    }

    public void setLine() {
        this.ptLine = this.compiler.lineCurrent;
        this.ptCommand = this.compiler.iCommand + 1;
    }

    public String toString() {
        return "ident " + this.ident + " line " + this.lineStart + " command " + this.commandStart;
    }

    ScriptFlowContext getParent() {
        return this.parent;
    }

    String path() {
        String s = "";
        ScriptFlowContext f = this;
        while (f != null) {
            s = f.ident + "-" + s;
            f = f.parent;
        }
        return "[" + s + "]";
    }

    void setFunction(ScriptFunction function) {
        this.function = function;
    }
}

