/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Vector;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Viewer;

class ScriptManager {
    Viewer viewer;
    Thread[] queueThreads = new Thread[2];
    boolean[] scriptQueueRunning = new boolean[2];
    Vector scriptQueue = new Vector();
    boolean useQueue = true;
    Thread commandWatcherThread;
    boolean useCommandWatcherThread = false;
    static final String SCRIPT_COMPLETED = "Script completed";

    ScriptManager(Viewer viewer) {
        this.viewer = viewer;
    }

    void clear() {
        this.startCommandWatcher(false);
    }

    public void setQueue(boolean TF) {
        this.useQueue = TF;
        if (!TF) {
            this.clearQueue();
        }
    }

    public String addScript(String strScript) {
        return (String)this.addScript("string", strScript, "", false, false);
    }

    public String addScript(String strScript, boolean isScriptFile, boolean isQuiet) {
        return (String)this.addScript("String", strScript, "", isScriptFile, isQuiet);
    }

    public Object addScript(String returnType, String strScript, String statusList, boolean isScriptFile, boolean isQuiet) {
        if (!this.useQueue) {
            this.clearQueue();
            this.viewer.haltScriptExecution();
        }
        if (this.commandWatcherThread == null && this.useCommandWatcherThread) {
            this.startCommandWatcher(true);
        }
        if (this.commandWatcherThread != null && strScript.indexOf("/*SPLIT*/") >= 0) {
            String[] scripts = TextFormat.split(strScript, "/*SPLIT*/");
            for (int i = 0; i < scripts.length; ++i) {
                this.addScript(returnType, scripts[i], statusList, isScriptFile, isQuiet);
            }
            return "split into " + scripts.length + " sections for processing";
        }
        boolean useCommandThread = this.commandWatcherThread != null && (strScript.indexOf("javascript") < 0 || strScript.indexOf("#javascript ") >= 0);
        Vector<Object> scriptItem = new Vector<Object>();
        scriptItem.addElement(strScript);
        scriptItem.addElement(statusList);
        scriptItem.addElement(returnType);
        scriptItem.addElement(isScriptFile ? Boolean.TRUE : Boolean.FALSE);
        scriptItem.addElement(isQuiet ? Boolean.TRUE : Boolean.FALSE);
        scriptItem.addElement(new Integer(useCommandThread ? -1 : 1));
        this.scriptQueue.addElement(scriptItem);
        if (Logger.debugging) {
            Logger.info(this.scriptQueue.size() + " scripts; added: " + strScript);
        }
        this.startScriptQueue(false);
        return "pending";
    }

    public int getScriptCount() {
        return this.scriptQueue.size();
    }

    public void clearQueue() {
        this.scriptQueue.clear();
    }

    public void waitForQueue() {
        int n = 0;
        while (this.queueThreads[0] != null || this.queueThreads[1] != null) {
            try {
                Thread.sleep(100L);
                if (n++ % 10 != 0 || !Logger.debugging) continue;
                Logger.debug("...scriptManager waiting for queue: " + this.scriptQueue.size());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void flushQueue(String command) {
        int i = this.scriptQueue.size();
        while (--i >= 0) {
            String strScript = (String)((Vector)this.scriptQueue.elementAt(i)).elementAt(0);
            if (strScript.indexOf(command) != 0) continue;
            this.scriptQueue.removeElementAt(i);
            if (!Logger.debugging) continue;
            Logger.debug(this.scriptQueue.size() + " scripts; removed: " + strScript);
        }
    }

    void startScriptQueue(boolean startedByCommandWatcher) {
        int pt;
        int n = pt = startedByCommandWatcher ? 1 : 0;
        if (this.scriptQueueRunning[pt]) {
            return;
        }
        this.scriptQueueRunning[pt] = true;
        this.queueThreads[pt] = new Thread(new ScriptQueueRunnable(startedByCommandWatcher, pt));
        this.queueThreads[pt].setName("QueueThread" + pt);
        this.queueThreads[pt].start();
    }

    Vector getScriptItem(boolean watching, boolean isByCommandWatcher) {
        Vector scriptItem = (Vector)this.scriptQueue.elementAt(0);
        int flag = (Integer)scriptItem.elementAt(5);
        boolean isOK = watching ? flag < 0 : (isByCommandWatcher ? flag == 0 : flag == 1);
        return isOK ? scriptItem : null;
    }

    synchronized void startCommandWatcher(boolean isStart) {
        this.useCommandWatcherThread = isStart;
        if (isStart) {
            if (this.commandWatcherThread != null) {
                return;
            }
            this.commandWatcherThread = new Thread(new CommandWatcher());
            this.commandWatcherThread.setName("CommmandWatcherThread");
            this.commandWatcherThread.start();
        } else {
            if (this.commandWatcherThread == null) {
                return;
            }
            this.commandWatcherThread.interrupt();
            this.commandWatcherThread = null;
        }
        if (Logger.debugging) {
            Logger.info("command watcher " + (isStart ? "started" : "stopped") + this.commandWatcherThread);
        }
    }

    void interruptQueueThreads() {
        for (int i = 0; i < this.queueThreads.length; ++i) {
            if (this.queueThreads[i] == null) continue;
            this.queueThreads[i].interrupt();
        }
    }

    class CommandWatcher
    implements Runnable {
        CommandWatcher() {
        }

        public void run() {
            Thread.currentThread().setPriority(1);
            int commandDelay = 200;
            while (ScriptManager.this.commandWatcherThread != null) {
                try {
                    Vector scriptItem;
                    Thread.sleep(commandDelay);
                    if (ScriptManager.this.commandWatcherThread == null || ScriptManager.this.scriptQueue.size() <= 0 || (scriptItem = ScriptManager.this.getScriptItem(true, true)) == null) continue;
                    scriptItem.setElementAt(new Integer(0), 5);
                    ScriptManager.this.startScriptQueue(true);
                }
                catch (InterruptedException ie) {
                    Logger.warn("CommandWatcher InterruptedException! " + this);
                    break;
                }
                catch (Exception ie) {
                    String s = "script processing ERROR:\n\n" + ie.toString();
                    for (int i = 0; i < ie.getStackTrace().length; ++i) {
                        s = s + "\n" + ie.getStackTrace()[i].toString();
                    }
                    Logger.warn("CommandWatcher Exception! " + s);
                    break;
                }
            }
            ScriptManager.this.commandWatcherThread = null;
        }
    }

    class ScriptQueueRunnable
    implements Runnable {
        boolean startedByCommandThread = false;
        int pt;

        public ScriptQueueRunnable(boolean startedByCommandThread, int pt) {
            this.startedByCommandThread = startedByCommandThread;
            this.pt = pt;
        }

        public void run() {
            while (ScriptManager.this.scriptQueue.size() != 0) {
                if (this.runNextScript()) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    System.out.println(this + " Exception " + e.getMessage());
                    break;
                }
            }
            ScriptManager.this.queueThreads[this.pt].interrupt();
            this.stop();
        }

        public void stop() {
            ScriptManager.this.scriptQueueRunning[this.pt] = false;
            ScriptManager.this.queueThreads[this.pt] = null;
            ScriptManager.this.viewer.setSyncDriver(4);
        }

        private boolean runNextScript() {
            if (ScriptManager.this.scriptQueue.size() == 0) {
                return false;
            }
            Vector scriptItem = ScriptManager.this.getScriptItem(false, this.startedByCommandThread);
            if (scriptItem == null) {
                return false;
            }
            String script = (String)scriptItem.elementAt(0);
            String statusList = (String)scriptItem.elementAt(1);
            String returnType = (String)scriptItem.elementAt(2);
            boolean isScriptFile = (Boolean)scriptItem.elementAt(3);
            boolean isQuiet = (Boolean)scriptItem.elementAt(4);
            if (Logger.debugging) {
                Logger.info("Queue[" + this.pt + "][" + ScriptManager.this.scriptQueue.size() + "] scripts; running: " + script);
            }
            ScriptManager.this.scriptQueue.removeElementAt(0);
            this.runScript(returnType, script, statusList, isScriptFile, isQuiet);
            return ScriptManager.this.scriptQueue.size() != 0;
        }

        private void runScript(String returnType, String strScript, String statusList, boolean isScriptFile, boolean isQuiet) {
            ScriptManager.this.viewer.evalStringWaitStatus(returnType, strScript, statusList, isScriptFile, isQuiet, true);
        }
    }
}

