/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Bond;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Parser;
import org.jmol.util.Quaternion;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Token;

class ScriptVariable
extends Token {
    private static final ScriptVariable vT = new ScriptVariable(0x10000D, 1, "true");
    private static final ScriptVariable vF = new ScriptVariable(0x10000C, 0, "false");
    static ScriptVariable vAll = new ScriptVariable(0x100003, "all");
    int index = Integer.MAX_VALUE;
    String name;
    private static final int FLAG_CANINCREMENT = 1;
    private static final int FLAG_LOCALVAR = 2;
    int flags = 2;
    static final Point3f pt0 = new Point3f();

    ScriptVariable() {
        this.tok = 4;
        this.value = "";
    }

    ScriptVariable(int tok) {
        this.tok = tok;
    }

    ScriptVariable(int tok, int intValue, Object value) {
        super(tok, intValue, value);
    }

    ScriptVariable(int tok, Object value) {
        super(tok, value);
    }

    ScriptVariable(int tok, int intValue) {
        super(tok, intValue);
    }

    ScriptVariable(BitSet bs, int index) {
        this.value = bs;
        this.index = index;
        this.tok = 0x40000007;
    }

    ScriptVariable(Token theToken) {
        this.tok = theToken.tok;
        this.intValue = theToken.intValue;
        this.value = theToken.value;
    }

    static ScriptVariable getVariable(Object x) {
        if (x == null) {
            return new ScriptVariable();
        }
        if (x instanceof ScriptVariable) {
            return (ScriptVariable)x;
        }
        if (x instanceof String) {
            if ((x = ScriptVariable.unescapePointOrBitsetAsVariable((String)x)) instanceof ScriptVariable) {
                return (ScriptVariable)x;
            }
            return new ScriptVariable(4, x);
        }
        if (x instanceof Boolean) {
            return ScriptVariable.getBoolean((Boolean)x);
        }
        if (x instanceof Integer) {
            return new ScriptVariable(2, (int)((Integer)x));
        }
        if (x instanceof Float) {
            return new ScriptVariable(3, x);
        }
        if (x instanceof float[]) {
            float[] f = (float[])x;
            String[] s = new String[f.length];
            int i = f.length;
            while (--i >= 0) {
                s[i] = "" + f[i];
            }
            return new ScriptVariable(6, s);
        }
        if (x instanceof String[]) {
            return new ScriptVariable(6, x);
        }
        if (x instanceof String) {
            return new ScriptVariable(4, x);
        }
        if (x instanceof Vector3f) {
            return new ScriptVariable(7, new Point3f((Vector3f)x));
        }
        if (x instanceof Point3f) {
            return new ScriptVariable(7, x);
        }
        if (x instanceof Point4f) {
            return new ScriptVariable(8, x);
        }
        if (x instanceof BitSet) {
            return new ScriptVariable(0x40000007, x);
        }
        if (x instanceof Quaternion) {
            return new ScriptVariable(8, ((Quaternion)x).toPoint4f());
        }
        return null;
    }

    ScriptVariable set(ScriptVariable v) {
        this.index = v.index;
        this.intValue = v.intValue;
        this.tok = v.tok;
        if (this.tok == 6) {
            int n = ((String[])v.value).length;
            this.value = new String[n];
            System.arraycopy(v.value, 0, this.value, 0, n);
        } else {
            this.value = v.value;
        }
        return this;
    }

    ScriptVariable setName(String name) {
        this.name = name;
        this.flags |= 1;
        return this;
    }

    ScriptVariable setGlobal() {
        this.flags &= 0xFFFFFFFD;
        return this;
    }

    boolean canIncrement() {
        return ScriptVariable.tokAttr(this.flags, 1);
    }

    boolean increment(int n) {
        if (!this.canIncrement()) {
            return false;
        }
        switch (this.tok) {
            case 2: {
                this.intValue += n;
                break;
            }
            case 3: {
                this.value = new Float(((Float)this.value).floatValue() + (float)n);
                break;
            }
            default: {
                this.value = ScriptVariable.nValue(this);
                if (this.value instanceof Integer) {
                    this.tok = 2;
                    this.intValue = (Integer)this.value;
                    break;
                }
                this.tok = 3;
            }
        }
        return true;
    }

    static ScriptVariable getVariableSelected(int index, Object value) {
        ScriptVariable v = new ScriptVariable(0x40000007, value);
        v.index = index;
        return v;
    }

    boolean asBoolean() {
        return ScriptVariable.bValue(this);
    }

    int asInt() {
        return ScriptVariable.iValue(this);
    }

    float asFloat() {
        return ScriptVariable.fValue(this);
    }

    String asString() {
        return ScriptVariable.sValue(this);
    }

    Object getValAsObj() {
        return this.tok == 2 ? new Integer(this.intValue) : this.value;
    }

    static final ScriptVariable intVariable(int intValue) {
        return new ScriptVariable(2, intValue);
    }

    static Object oValue(ScriptVariable x) {
        switch (x == null ? 0 : x.tok) {
            case 0x10000D: {
                return Boolean.TRUE;
            }
            case 0: 
            case 0x10000C: {
                return Boolean.FALSE;
            }
            case 2: {
                return new Integer(x.intValue);
            }
        }
        return x.value;
    }

    static Object nValue(Token x) {
        int iValue = 0;
        switch (x == null ? 0 : x.tok) {
            case 2: {
                iValue = x.intValue;
                break;
            }
            case 3: {
                return x.value;
            }
            case 4: {
                if (((String)x.value).indexOf(".") >= 0) {
                    return new Float(ScriptVariable.toFloat((String)x.value));
                }
                iValue = (int)ScriptVariable.toFloat((String)x.value);
            }
        }
        return new Integer(iValue);
    }

    static boolean bValue(Token x) {
        switch (x == null ? 0 : x.tok) {
            case 0x10000D: {
                return true;
            }
            case 0x10000C: {
                return false;
            }
            case 2: {
                return x.intValue != 0;
            }
            case 3: 
            case 4: 
            case 6: {
                return ScriptVariable.fValue(x) != 0.0f;
            }
            case 0x40000007: {
                return ScriptVariable.iValue(x) != 0;
            }
            case 7: 
            case 8: {
                return Math.abs(ScriptVariable.fValue(x)) > 1.0E-4f;
            }
        }
        return false;
    }

    static int iValue(Token x) {
        switch (x == null ? 0 : x.tok) {
            case 0x10000D: {
                return 1;
            }
            case 0x10000C: {
                return 0;
            }
            case 2: {
                return x.intValue;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                return (int)ScriptVariable.fValue(x);
            }
            case 0x40000007: {
                return BitSetUtil.cardinalityOf(ScriptVariable.bsSelect(x));
            }
        }
        return 0;
    }

    static float fValue(Token x) {
        switch (x == null ? 0 : x.tok) {
            case 0x10000D: {
                return 1.0f;
            }
            case 0x10000C: {
                return 0.0f;
            }
            case 2: {
                return x.intValue;
            }
            case 3: {
                return ((Float)x.value).floatValue();
            }
            case 6: {
                int i = x.intValue;
                String[] list = (String[])x.value;
                if (i == Integer.MAX_VALUE) {
                    return list.length;
                }
            }
            case 4: {
                return ScriptVariable.toFloat(ScriptVariable.sValue(x));
            }
            case 0x40000007: {
                return ScriptVariable.iValue(x);
            }
            case 7: {
                return ((Point3f)x.value).distance(pt0);
            }
            case 8: {
                return Graphics3D.distanceToPlane((Point4f)x.value, pt0);
            }
        }
        return 0.0f;
    }

    static float toFloat(String s) {
        if (s.equalsIgnoreCase("true")) {
            return 1.0f;
        }
        if (s.equalsIgnoreCase("false") || s.length() == 0) {
            return 0.0f;
        }
        return Parser.parseFloatStrict(s);
    }

    static String sValue(Token x) {
        if (x == null) {
            return "";
        }
        switch (x.tok) {
            case 0x10000D: {
                return "true";
            }
            case 0x10000C: {
                return "false";
            }
            case 2: {
                return "" + x.intValue;
            }
            case 7: {
                return Escape.escape((Point3f)x.value);
            }
            case 8: {
                return Escape.escape((Point4f)x.value);
            }
            case 0x40000007: {
                return Escape.escape(ScriptVariable.bsSelect(x), !(x.value instanceof Bond.BondSet));
            }
            case 6: {
                String[] list = (String[])x.value;
                int i = x.intValue;
                if (i <= 0) {
                    i = list.length - i;
                }
                if (i != Integer.MAX_VALUE) {
                    return i < 1 || i > list.length ? "" : list[i - 1];
                }
                StringBuffer sb = new StringBuffer();
                for (i = 0; i < list.length; ++i) {
                    sb.append(list[i]).append("\n");
                }
                return sb.toString();
            }
            case 4: {
                String s = (String)x.value;
                int i = x.intValue;
                if (i <= 0) {
                    i = s.length() - i;
                }
                if (i == Integer.MAX_VALUE) {
                    return s;
                }
                if (i < 1 || i > s.length()) {
                    return "";
                }
                return "" + s.charAt(i - 1);
            }
        }
        return "" + x.value;
    }

    static String sValue(ScriptVariable x) {
        if (x == null) {
            return "";
        }
        switch (x.tok) {
            case 0x10000D: {
                return "true";
            }
            case 0x10000C: {
                return "false";
            }
            case 2: {
                return "" + x.intValue;
            }
            case 7: {
                return Escape.escape((Point3f)x.value);
            }
            case 8: {
                return Escape.escape((Point4f)x.value);
            }
            case 0x40000007: {
                return Escape.escape(ScriptVariable.bsSelect(x), !(x.value instanceof Bond.BondSet));
            }
            case 6: {
                String[] list = (String[])x.value;
                int i = x.intValue;
                if (i <= 0) {
                    i = list.length - i;
                }
                if (i != Integer.MAX_VALUE) {
                    return i < 1 || i > list.length ? "" : list[i - 1];
                }
                StringBuffer sb = new StringBuffer();
                for (i = 0; i < list.length; ++i) {
                    sb.append(list[i]).append("\n");
                }
                return sb.toString();
            }
            case 4: {
                String s = (String)x.value;
                int i = x.intValue;
                if (i <= 0) {
                    i = s.length() - i;
                }
                if (i == Integer.MAX_VALUE) {
                    return s;
                }
                if (i < 1 || i > s.length()) {
                    return "";
                }
                return "" + s.charAt(i - 1);
            }
        }
        return "" + x.value;
    }

    static int sizeOf(Token x) {
        switch (x == null ? 0 : x.tok) {
            case 0x10000C: 
            case 0x10000D: {
                return -1;
            }
            case 2: {
                return -2;
            }
            case 3: {
                return -4;
            }
            case 7: {
                return -8;
            }
            case 8: {
                return -16;
            }
            case 4: {
                return ((String)x.value).length();
            }
            case 6: {
                return x.intValue == Integer.MAX_VALUE ? ((String[])x.value).length : ScriptVariable.sizeOf(ScriptVariable.selectItem(x));
            }
            case 0x40000007: {
                return BitSetUtil.cardinalityOf(ScriptVariable.bsSelect(x));
            }
        }
        return 0;
    }

    static String typeOf(ScriptVariable x) {
        switch (x == null ? 0 : x.tok) {
            case 0x10000C: 
            case 0x10000D: {
                return "boolean";
            }
            case 2: {
                return "integer";
            }
            case 3: {
                return "decimal";
            }
            case 7: {
                return "point";
            }
            case 8: {
                return "plane";
            }
            case 4: {
                return "string";
            }
            case 6: {
                return "array";
            }
            case 0x40000007: {
                return "bitset";
            }
        }
        return "?";
    }

    static String[] concatList(ScriptVariable x1, ScriptVariable x2) {
        int i;
        String[] list1 = x1.tok == 6 ? (String[])x1.value : TextFormat.split(ScriptVariable.sValue(x1), "\n");
        String[] list2 = x2.tok == 6 ? (String[])x2.value : TextFormat.split(ScriptVariable.sValue(x2), "\n");
        String[] list = new String[list1.length + list2.length];
        int pt = 0;
        for (i = 0; i < list1.length; ++i) {
            list[pt++] = list1[i];
        }
        for (i = 0; i < list2.length; ++i) {
            list[pt++] = list2[i];
        }
        return list;
    }

    static BitSet bsSelect(Token token) {
        token = ScriptVariable.selectItem(token, Integer.MIN_VALUE);
        return (BitSet)token.value;
    }

    static BitSet bsSelect(ScriptVariable var) {
        if (var.index == Integer.MAX_VALUE) {
            var = ScriptVariable.selectItem(var);
        }
        return (BitSet)var.value;
    }

    static BitSet bsSelect(Token token, int n) {
        token = ScriptVariable.selectItem(token);
        token = ScriptVariable.selectItem(token, 1);
        token = ScriptVariable.selectItem(token, n);
        return (BitSet)token.value;
    }

    static ScriptVariable selectItem(ScriptVariable var) {
        if (var.index != Integer.MAX_VALUE) {
            return var;
        }
        return ScriptVariable.selectItem(var, Integer.MIN_VALUE);
    }

    static Token selectItem(Token var) {
        return ScriptVariable.selectItem(var, Integer.MIN_VALUE);
    }

    static ScriptVariable selectItem(ScriptVariable var, int i2) {
        return (ScriptVariable)ScriptVariable.selectItem((Token)var, i2);
    }

    static Token selectItem(Token tokenIn, int i2) {
        if (tokenIn.tok != 0x40000007 && tokenIn.tok != 6 && tokenIn.tok != 4) {
            return tokenIn;
        }
        BitSet bs = null;
        String[] st = null;
        String s = null;
        int i1 = tokenIn.intValue;
        if (i1 == Integer.MAX_VALUE) {
            if (i2 == Integer.MIN_VALUE) {
                i2 = i1;
            }
            return new ScriptVariable(tokenIn.tok, i2, tokenIn.value);
        }
        int len = 0;
        boolean isInputSelected = tokenIn instanceof ScriptVariable && ((ScriptVariable)tokenIn).index != Integer.MAX_VALUE;
        ScriptVariable tokenOut = new ScriptVariable(tokenIn.tok, Integer.MAX_VALUE);
        switch (tokenIn.tok) {
            case 0x40000007: {
                if (tokenIn.value instanceof Bond.BondSet) {
                    tokenOut.value = new Bond.BondSet((BitSet)tokenIn.value, ((Bond.BondSet)tokenIn.value).getAssociatedAtoms());
                    bs = (BitSet)tokenOut.value;
                    len = BitSetUtil.cardinalityOf(bs);
                    break;
                }
                bs = BitSetUtil.copy((BitSet)tokenIn.value);
                len = isInputSelected ? 1 : BitSetUtil.cardinalityOf(bs);
                tokenOut.value = bs;
                break;
            }
            case 6: {
                st = (String[])tokenIn.value;
                len = st.length;
                break;
            }
            case 4: {
                s = (String)tokenIn.value;
                len = s.length();
            }
        }
        if (i1 <= 0) {
            i1 = len + i1;
        }
        if (i1 < 1) {
            i1 = 1;
        }
        if (i2 == 0) {
            i2 = len;
        } else if (i2 < 0) {
            i2 = len + i2;
        }
        if (i2 > len) {
            i2 = len;
        } else if (i2 < i1) {
            i2 = i1;
        }
        switch (tokenIn.tok) {
            case 0x40000007: {
                if (isInputSelected) {
                    if (i1 <= 1) break;
                    bs.clear();
                    break;
                }
                len = BitSetUtil.length(bs);
                int n = 0;
                for (int j = 0; j < len; ++j) {
                    if (!bs.get(j) || ++n >= i1 && n <= i2) continue;
                    bs.clear(j);
                }
                break;
            }
            case 4: {
                if (i1 < 1 || i1 > len) {
                    tokenOut.value = "";
                    break;
                }
                tokenOut.value = s.substring(i1 - 1, i2);
                break;
            }
            case 6: {
                if (i1 < 1 || i1 > len || i2 > len) {
                    return new ScriptVariable(4, "");
                }
                if (i2 == i1) {
                    return ScriptVariable.tValue(st[i1 - 1]);
                }
                String[] list = new String[i2 - i1 + 1];
                for (int i = 0; i < list.length; ++i) {
                    list[i] = st[i + i1 - 1];
                }
                tokenOut.value = list;
            }
        }
        return tokenOut;
    }

    static ScriptVariable tValue(String str) {
        Object v = ScriptVariable.unescapePointOrBitsetAsVariable(str);
        if (!(v instanceof String)) {
            return (ScriptVariable)v;
        }
        String s = (String)v;
        if (s.toLowerCase() == "true") {
            return ScriptVariable.getBoolean(true);
        }
        if (s.toLowerCase() == "false") {
            return ScriptVariable.getBoolean(false);
        }
        float f = Parser.parseFloatStrict(s);
        return Float.isNaN(f) ? new ScriptVariable(4, v) : (s.indexOf(".") < 0 ? new ScriptVariable(2, (int)f) : new ScriptVariable(3, new Float(f)));
    }

    boolean setSelectedValue(int selector, ScriptVariable var) {
        if (selector == Integer.MAX_VALUE || this.tok != 4 && this.tok != 6) {
            return false;
        }
        String s = ScriptVariable.sValue(var);
        switch (this.tok) {
            case 6: {
                String[] arrayNew;
                String[] array = (String[])this.value;
                if (selector <= 0) {
                    selector = array.length + selector;
                }
                if (--selector < 0) {
                    selector = 0;
                }
                if ((arrayNew = array).length <= selector) {
                    arrayNew = ArrayUtil.ensureLength(array, selector + 1);
                    this.value = arrayNew;
                    for (int i = array.length; i <= selector; ++i) {
                        arrayNew[i] = "";
                    }
                }
                arrayNew[selector] = s;
                break;
            }
            case 4: {
                String str = (String)this.value;
                int pt = str.length();
                if (selector <= 0) {
                    selector = pt + selector;
                }
                if (--selector < 0) {
                    selector = 0;
                }
                while (selector >= str.length()) {
                    str = str + " ";
                }
                this.value = str.substring(0, selector) + s + str.substring(selector + 1);
            }
        }
        return true;
    }

    String escape() {
        switch (this.tok) {
            case 0x10000D: {
                return "true";
            }
            case 0x10000C: {
                return "false";
            }
            case 2: {
                return "" + this.intValue;
            }
            case 0x40000007: {
                return Escape.escape((BitSet)this.value);
            }
            case 6: {
                return Escape.escape((String[])this.value);
            }
            case 7: {
                return Escape.escape((Point3f)this.value);
            }
            case 8: {
                return Escape.escape((Point4f)this.value);
            }
        }
        return Escape.escape(this.value);
    }

    static Object unescapePointOrBitsetAsVariable(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        Object v = Escape.unescapePointOrBitset(s);
        if (v instanceof Point3f) {
            return new ScriptVariable(7, v);
        }
        if (v instanceof Point4f) {
            return new ScriptVariable(8, v);
        }
        if (v instanceof BitSet) {
            return new ScriptVariable(0x40000007, v);
        }
        return s;
    }

    static ScriptVariable getBoolean(boolean value) {
        return new ScriptVariable(value ? vT : vF);
    }

    static Object sprintf(String strFormat, ScriptVariable var) {
        if (var == null) {
            return strFormat;
        }
        int[] vd = (int[])(strFormat.indexOf("d") >= 0 || strFormat.indexOf("i") >= 0 ? new int[1] : null);
        float[] vf = strFormat.indexOf("f") >= 0 ? new float[1] : null;
        double[] ve = strFormat.indexOf("e") >= 0 ? new double[1] : null;
        boolean getS = strFormat.indexOf("s") >= 0;
        boolean getP = strFormat.indexOf("p") >= 0 && var.tok == 7 || strFormat.indexOf("q") >= 0 && var.tok == 8;
        Object[] of = new Object[]{vd, vf, ve, null, null};
        if (var.tok != 6) {
            return ScriptVariable.sprintf(strFormat, var, of, vd, vf, ve, getS, getP);
        }
        String[] list = (String[])var.value;
        String[] list2 = new String[list.length];
        for (int i = 0; i < list.length; ++i) {
            String s = strFormat;
            list2[i] = ScriptVariable.sprintf(s, ScriptVariable.tValue(list[i]), of, vd, vf, ve, getS, getP);
        }
        return list2;
    }

    private static String sprintf(String strFormat, ScriptVariable var, Object[] of, int[] vd, float[] vf, double[] ve, boolean getS, boolean getP) {
        if (vd != null) {
            vd[0] = ScriptVariable.iValue(var);
        }
        if (vf != null) {
            vf[0] = ScriptVariable.fValue(var);
        }
        if (ve != null) {
            ve[0] = ScriptVariable.fValue(var);
        }
        if (getS) {
            of[3] = ScriptVariable.sValue(var);
        }
        if (getP) {
            of[4] = var.value;
        }
        return TextFormat.sprintf(strFormat, of);
    }

    static String sprintf(ScriptVariable[] args) {
        switch (args.length) {
            case 0: {
                return "";
            }
            case 1: {
                return ScriptVariable.sValue(args[0]);
            }
        }
        String[] format = TextFormat.split(TextFormat.simpleReplace(ScriptVariable.sValue(args[0]), "%%", "\u0001"), '%');
        StringBuffer sb = new StringBuffer();
        sb.append(format[0]);
        for (int i = 1; i < format.length; ++i) {
            sb.append(ScriptVariable.sprintf(TextFormat.formatCheck("%" + format[i]), i < args.length ? args[i] : null));
        }
        return sb.toString();
    }

    public String toString() {
        return super.toString() + "[" + this.name + "] index =" + this.index + " hashcode=" + this.hashCode();
    }
}

