/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Bond;
import org.jmol.modelset.ModelSet;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.TextFormat;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.ScriptFunction;
import org.jmol.viewer.ScriptVariable;
import org.jmol.viewer.Viewer;

public class StateManager {
    public static final int OBJ_BACKGROUND = 0;
    public static final int OBJ_AXIS1 = 1;
    public static final int OBJ_AXIS2 = 2;
    public static final int OBJ_AXIS3 = 3;
    public static final int OBJ_BOUNDBOX = 4;
    public static final int OBJ_UNITCELL = 5;
    public static final int OBJ_FRANK = 6;
    public static final int OBJ_MAX = 7;
    private static final String objectNameList = "background axis1      axis2      axis3      boundbox   unitcell   frank      ";
    Viewer viewer;
    Hashtable saved = new Hashtable();
    String lastOrientation = "";
    String lastConnections = "";
    String lastSelected = "";
    String lastState = "";
    String lastShape = "";
    String lastCoordinates = "";
    static final Hashtable globalFunctions = new Hashtable();
    Hashtable localFunctions = new Hashtable();
    protected static final String unreportedProperties = ";ambientpercent;animationfps;antialiasdisplay;antialiasimages;antialiastranslucent;appendnew;axescolor;axesposition;axesmolecular;axesorientationrasmol;axesunitcell;axeswindow;axis1color;axis2color;axis3color;backgroundcolor;backgroundmodel;bondsymmetryatoms;boundboxcolor;cameradepth;debugscript;defaultlatttice;defaults;diffusepercent;exportdrivers;fontscaling;language;loglevel;measureStyleChime;minimizationsteps;minimizationrefresh;minimizationcriterion;navigationmode;perspectivedepth;visualrange;perspectivemodel;refreshing;rotationradius;showaxes;showaxis1;showaxis2;showaxis3;showboundbox;showfrank;showunitcell;slabenabled;specular;specularexponent;specularpercent;specularpower;stateversion;statusreporting;stereo;stereostate;unitcellcolor;windowcentered;zerobasedxyzrasmol;zoomenabled;scriptqueue;scriptreportinglevel;syncscript;syncmouse;syncstereo;currentlocalpath;defaultdirectorylocal;ambient;bonds;colorrasmol;diffuse;frank;hetero;hidenotselected;hoverlabel;hydrogen;languagetranslation;measurementunits;navigationdepth;navigationslab;picking;pickingstyle;propertycolorschemeoverload;radius;rgbblue;rgbgreen;rgbred;scaleangstromsperinch;selectionhalos;showscript;showselections;solvent;strandcount;spinx;spiny;spinz;spinfps;" + JmolConstants.getCallbackName(-1) + ";undo;";

    static String getVariableList(Hashtable htVariables, int nMax) {
        StringBuffer sb = new StringBuffer();
        int n = 0;
        Enumeration e = htVariables.keys();
        Object[] list = new String[htVariables.size()];
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            ScriptVariable var = (ScriptVariable)htVariables.get(key);
            list[n++] = key + (key.charAt(0) == '@' ? " " + ScriptVariable.sValue(var) : " = " + StateManager.varClip(key, var.escape(), nMax));
        }
        Arrays.sort(list, 0, n);
        for (int i = 0; i < n; ++i) {
            if (list[i] == null) continue;
            StateManager.appendCmd(sb, (String)list[i]);
        }
        if (n == 0) {
            sb.append("# --no global user variables defined--;\n");
        }
        return sb.toString();
    }

    static int getObjectIdFromName(String name) {
        if (name == null) {
            return -1;
        }
        int objID = objectNameList.indexOf(name.toLowerCase());
        return objID < 0 ? objID : objID / 11;
    }

    static String getObjectNameFromId(int objId) {
        if (objId < 0 || objId >= 7) {
            return null;
        }
        return objectNameList.substring(objId * 11, objId * 11 + 11).trim();
    }

    StateManager(Viewer viewer) {
        this.viewer = viewer;
    }

    GlobalSettings getGlobalSettings(GlobalSettings gsOld) {
        GlobalSettings g = new GlobalSettings();
        g.registerAllValues(gsOld);
        return g;
    }

    void clear() {
        this.viewer.setShowAxes(false);
        this.viewer.setShowBbcage(false);
        this.viewer.setShowUnitCell(false);
    }

    void setCrystallographicDefaults() {
        this.viewer.setAxesModeUnitCell(true);
        this.viewer.setShowAxes(true);
        this.viewer.setShowUnitCell(true);
        this.viewer.setBooleanProperty("perspectiveDepth", false);
    }

    private void setCommonDefaults() {
        this.viewer.setBooleanProperty("perspectiveDepth", true);
        this.viewer.setFloatProperty("bondTolerance", 0.45f);
        this.viewer.setFloatProperty("minBondDistance", 0.4f);
    }

    void setJmolDefaults() {
        this.setCommonDefaults();
        this.viewer.setStringProperty("defaultColorScheme", "Jmol");
        this.viewer.setBooleanProperty("axesOrientationRasmol", false);
        this.viewer.setBooleanProperty("zeroBasedXyzRasmol", false);
        this.viewer.setIntProperty("percentVdwAtom", 20);
        this.viewer.setIntProperty("bondRadiusMilliAngstroms", 150);
        this.viewer.setDefaultVdw("Jmol");
    }

    void setRasMolDefaults() {
        this.setCommonDefaults();
        this.viewer.setStringProperty("defaultColorScheme", "RasMol");
        this.viewer.setBooleanProperty("axesOrientationRasmol", true);
        this.viewer.setBooleanProperty("zeroBasedXyzRasmol", true);
        this.viewer.setIntProperty("percentVdwAtom", 0);
        this.viewer.setIntProperty("bondRadiusMilliAngstroms", 1);
        this.viewer.setDefaultVdw("Rasmol");
    }

    String getStandardLabelFormat() {
        String strLabel = "%[identify]";
        return strLabel;
    }

    String listSavedStates() {
        String names = "";
        Enumeration e = this.saved.keys();
        while (e.hasMoreElements()) {
            names = names + "\n" + e.nextElement();
        }
        return names;
    }

    private void deleteSaved(String type) {
        Enumeration e = this.saved.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith(type)) continue;
            this.saved.remove(name);
            Logger.debug("deleted " + name);
        }
    }

    void saveSelection(String saveName, BitSet bsSelected) {
        if (saveName.equalsIgnoreCase("DELETE")) {
            this.deleteSaved("Selected_");
            return;
        }
        saveName = this.lastSelected = "Selected_" + saveName;
        this.saved.put(saveName, BitSetUtil.copy(bsSelected));
    }

    boolean restoreSelection(String saveName) {
        String name = saveName.length() > 0 ? "Selected_" + saveName : this.lastSelected;
        BitSet bsSelected = (BitSet)this.saved.get(name);
        if (bsSelected == null) {
            this.viewer.select(new BitSet(), false);
            return false;
        }
        this.viewer.select(bsSelected, false);
        return true;
    }

    void saveState(String saveName) {
        if (saveName.equalsIgnoreCase("DELETE")) {
            this.deleteSaved("State_");
            return;
        }
        saveName = this.lastState = "State_" + saveName;
        this.saved.put(saveName, this.viewer.getStateInfo());
    }

    String getSavedState(String saveName) {
        String name = saveName.length() > 0 ? "State_" + saveName : this.lastState;
        String script = (String)this.saved.get(name);
        return script == null ? "" : script;
    }

    void saveStructure(String saveName) {
        if (saveName.equalsIgnoreCase("DELETE")) {
            this.deleteSaved("Shape_");
            return;
        }
        saveName = this.lastShape = "Shape_" + saveName;
        this.saved.put(saveName, this.viewer.getStructureState());
    }

    String getSavedStructure(String saveName) {
        String name = saveName.length() > 0 ? "Shape_" + saveName : this.lastShape;
        String script = (String)this.saved.get(name);
        return script == null ? "" : script;
    }

    void saveCoordinates(String saveName, BitSet bsSelected) {
        if (saveName.equalsIgnoreCase("DELETE")) {
            this.deleteSaved("Coordinates_");
            return;
        }
        saveName = this.lastCoordinates = "Coordinates_" + saveName;
        this.saved.put(saveName, this.viewer.getCoordinateState(bsSelected));
    }

    String getSavedCoordinates(String saveName) {
        String name = saveName.length() > 0 ? "Coordinates_" + saveName : this.lastCoordinates;
        String script = (String)this.saved.get(name);
        return script == null ? "" : script;
    }

    Orientation getOrientation() {
        return new Orientation(false);
    }

    void saveOrientation(String saveName) {
        if (saveName.equalsIgnoreCase("DELETE")) {
            this.deleteSaved("Orientation_");
            return;
        }
        Orientation o = new Orientation(saveName.equals("default"));
        o.saveName = this.lastOrientation = "Orientation_" + saveName;
        this.saved.put(o.saveName, o);
    }

    boolean restoreOrientation(String saveName, float timeSeconds, boolean isAll) {
        String name = saveName.length() > 0 ? "Orientation_" + saveName : this.lastOrientation;
        Orientation o = (Orientation)this.saved.get(name);
        if (o == null) {
            return false;
        }
        o.restore(timeSeconds, isAll);
        return true;
    }

    void saveBonds(String saveName) {
        if (saveName.equalsIgnoreCase("DELETE")) {
            this.deleteSaved("Bonds_");
            return;
        }
        Connections b = new Connections();
        b.saveName = this.lastConnections = "Bonds_" + saveName;
        this.saved.put(b.saveName, b);
    }

    boolean restoreBonds(String saveName) {
        String name = saveName.length() > 0 ? "Bonds_" + saveName : this.lastConnections;
        Connections c = (Connections)this.saved.get(name);
        if (c == null) {
            return false;
        }
        c.restore();
        return true;
    }

    static boolean isMeasurementUnit(String units) {
        return Parser.isOneOf(units.toLowerCase(), "angstroms;au;bohr;nanometers;nm;picometers;pm");
    }

    boolean isFunction(String name) {
        return (name.indexOf("_") == 0 ? globalFunctions : this.localFunctions).containsKey(name);
    }

    void addFunction(ScriptFunction function) {
        (function.name.indexOf("_") == 0 ? globalFunctions : this.localFunctions).put(function.name, function);
    }

    ScriptFunction getFunction(String name) {
        if (name == null) {
            return null;
        }
        ScriptFunction function = (ScriptFunction)(name.indexOf("_") == 0 ? globalFunctions : this.localFunctions).get(name);
        return function == null || function.aatoken == null ? null : function;
    }

    public static void setStateInfo(Hashtable ht, int i1, int i2, String key) {
        BitSet bs;
        if (ht.containsKey(key)) {
            bs = (BitSet)ht.get(key);
        } else {
            bs = new BitSet();
            ht.put(key, bs);
        }
        for (int i = i1; i <= i2; ++i) {
            bs.set(i);
        }
    }

    public static String varClip(String name, String sv, int nMax) {
        if (nMax > 0 && sv.length() > nMax) {
            sv = sv.substring(0, nMax) + " #...more (" + sv.length() + " bytes -- use SHOW " + name + " or MESSAGE @" + name + " to view)";
        }
        return sv;
    }

    public static String getCommands(Hashtable ht) {
        return StateManager.getCommands(ht, null, -1, "select");
    }

    public static String getCommands(Hashtable htDefine, Hashtable htMore, int nAll) {
        return StateManager.getCommands(htDefine, htMore, nAll, "select");
    }

    public static String getCommands(Hashtable htDefine, Hashtable htMore, int nAll, String selectCmd) {
        StringBuffer s = new StringBuffer();
        String setPrev = StateManager.getCommands(htDefine, s, null, nAll, selectCmd);
        if (htMore != null) {
            StateManager.getCommands(htMore, s, setPrev, nAll, "select");
        }
        return s.toString();
    }

    public static String getCommands(Hashtable ht, StringBuffer s, String setPrev, int nAll, String selectCmd) {
        if (ht == null) {
            return "";
        }
        String strAll = "({0:" + (nAll - 1) + "})";
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String set = Escape.escape((BitSet)ht.get(key));
            if (set.length() < 5) continue;
            StringBuffer stringBuffer = new StringBuffer().append(selectCmd).append(" ");
            if (set.equals(strAll)) {
                // empty if block
            }
            if (!(set = stringBuffer.append(set).toString()).equals(setPrev)) {
                StateManager.appendCmd(s, set);
            }
            setPrev = set;
            if (key.indexOf("-") == 0) continue;
            StateManager.appendCmd(s, key);
        }
        return setPrev;
    }

    public static void appendCmd(StringBuffer s, String cmd) {
        if (cmd.length() == 0) {
            return;
        }
        s.append("  ").append(cmd).append(";\n");
    }

    class GlobalSettings {
        Hashtable htUserVariables = new Hashtable();
        int ambientPercent = 45;
        int diffusePercent = 84;
        boolean specular = true;
        int specularExponent = 6;
        int specularPercent = 22;
        int specularPower = 40;
        boolean allowEmbeddedScripts = true;
        boolean appendNew = true;
        String appletProxy = "";
        boolean applySymmetryToBonds = false;
        String atomTypes = "";
        boolean autoBond = true;
        boolean autoLoadOrientation = false;
        short bondRadiusMilliAngstroms = (short)150;
        float bondTolerance = 0.45f;
        String defaultLoadScript = "";
        String defaultDirectory = "";
        boolean forceAutoBond = false;
        char inlineNewlineChar = (char)124;
        String loadFormat = "http://www.rcsb.org/pdb/files/%FILE.pdb";
        float minBondDistance = 0.4f;
        boolean pdbGetHeader = false;
        boolean pdbSequential = false;
        int percentVdwAtom = 20;
        boolean smartAromatic = true;
        boolean zeroBasedXyzRasmol = false;
        private final Point3f ptDefaultLattice = new Point3f();
        boolean allowRotateSelected = false;
        boolean perspectiveDepth = true;
        float visualRange = 5.0f;
        boolean solventOn = false;
        String defaultAngleLabel = "%VALUE %UNITS";
        String defaultDistanceLabel = "%VALUE %UNITS";
        String defaultTorsionLabel = "%VALUE %UNITS";
        boolean justifyMeasurements = false;
        boolean measureAllModels = false;
        int minimizationSteps = 100;
        boolean minimizationRefresh = true;
        float minimizationCriterion = 0.001f;
        boolean antialiasDisplay = false;
        boolean antialiasImages = true;
        boolean antialiasTranslucent = true;
        boolean displayCellParameters = true;
        boolean dotsSelectedOnly = false;
        boolean dotSurface = true;
        int dotDensity = 3;
        boolean dynamicMeasurements = false;
        boolean greyscaleRendering = false;
        boolean isosurfacePropertySmoothing = true;
        boolean showHiddenSelectionHalos = false;
        boolean allowKeyStrokes = false;
        boolean showKeyStrokes = true;
        boolean showMeasurements = true;
        boolean zoomLarge = true;
        boolean zShade = false;
        String backgroundImageFileName;
        boolean bondModeOr = false;
        boolean hbondsBackbone = false;
        float hbondsAngleMinimum = 90.0f;
        float hbondsDistanceMaximum = 3.25f;
        boolean hbondsSolid = false;
        byte modeMultipleBond = (byte)2;
        boolean showHydrogens = true;
        boolean showMultipleBonds = true;
        boolean ssbondsBackbone = false;
        boolean cartoonRockets = false;
        boolean chainCaseSensitive = false;
        int hermiteLevel = 0;
        boolean highResolutionFlag = false;
        boolean rangeSelected = false;
        boolean rasmolHydrogenSetting = true;
        boolean rasmolHeteroSetting = true;
        int ribbonAspectRatio = 16;
        boolean ribbonBorder = false;
        boolean rocketBarrels = false;
        float sheetSmoothing = 1.0f;
        boolean traceAlpha = true;
        int animationFps = 10;
        boolean autoFps = false;
        boolean axesOrientationRasmol = false;
        int axesMode = 0;
        float axesScale = 2.0f;
        float cameraDepth = 3.0f;
        String dataSeparator = "~~~";
        boolean debugScript = false;
        float defaultDrawArrowScale = 0.5f;
        float defaultTranslucent = 0.5f;
        int delayMaximumMs = 0;
        float dipoleScale = 1.0f;
        boolean disablePopupMenu = false;
        boolean drawPicking = false;
        boolean bondPicking = false;
        boolean atomPicking = true;
        String helpPath = "http://chemapps.stolaf.edu/jmol/docs/index.htm";
        boolean fontScaling = false;
        boolean fontCaching = true;
        boolean hideNameInPopup = false;
        int hoverDelayMs = 500;
        float loadAtomDataTolerance = 0.01f;
        boolean measurementLabels = true;
        boolean messageStyleChime = false;
        int pickingSpinRate = 10;
        String pickLabel = "";
        float pointGroupDistanceTolerance = 0.2f;
        float pointGroupLinearTolerance = 8.0f;
        String propertyColorScheme = "roygb";
        String quaternionFrame = "c";
        float solventProbeRadius = 1.2f;
        int scriptDelay = 0;
        boolean selectAllModels = true;
        boolean statusReporting = true;
        int strandCountForStrands = 5;
        int strandCountForMeshRibbon = 7;
        boolean useMinimizationThread = true;
        boolean useNumberLocalization = true;
        float vectorScale = 1.0f;
        float vibrationPeriod = 1.0f;
        float vibrationScale = 1.0f;
        boolean wireframeRotation = false;
        boolean hideNavigationPoint = false;
        boolean navigationMode = false;
        boolean navigationPeriodic = false;
        float navigationSpeed = 5.0f;
        boolean showNavigationPointAlways = false;
        String stereoState = null;
        int[] objColors = new int[7];
        boolean[] objStateOn = new boolean[7];
        int[] objMad = new int[7];
        boolean ellipsoidAxes = false;
        boolean ellipsoidDots = false;
        boolean ellipsoidArcs = false;
        boolean ellipsoidFill = false;
        boolean ellipsoidBall = true;
        int ellipsoidDotCount = 200;
        float ellipsoidAxisDiameter = 0.02f;
        boolean testFlag1 = false;
        boolean testFlag2 = false;
        boolean testFlag3 = false;
        boolean testFlag4 = false;
        private String measureDistanceUnits = "nanometers";
        Hashtable htParameterValues;
        Hashtable htPropertyFlags;
        Hashtable htPropertyFlagsRemoved;

        GlobalSettings() {
        }

        void clear() {
            Enumeration e = this.htUserVariables.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (key.charAt(0) != '@' && !key.startsWith("site_")) continue;
                this.htUserVariables.remove(key);
            }
            this.setParameterValue("_atompicked", -1);
            this.setParameterValue("_atomhovered", -1);
            this.setParameterValue("_pickinfo", "");
            this.setParameterValue("selectionhalos", false);
            this.setParameterValue("hidenotselected", false);
            this.measurementLabels = true;
            this.setParameterValue("measurementlabels", true);
        }

        String getLoadState() {
            StringBuffer str = new StringBuffer();
            StateManager.appendCmd(str, "set allowEmbeddedScripts false");
            if (this.allowEmbeddedScripts) {
                this.setParameterValue("allowEmbeddedScripts", true);
            }
            StateManager.appendCmd(str, "set autoBond " + this.autoBond);
            StateManager.appendCmd(str, "set appendNew " + this.appendNew);
            StateManager.appendCmd(str, "set appletProxy " + Escape.escape(this.appletProxy));
            StateManager.appendCmd(str, "set applySymmetryToBonds " + this.applySymmetryToBonds);
            if (this.atomTypes.length() > 0) {
                StateManager.appendCmd(str, "set atomTypes " + Escape.escape(this.atomTypes));
            }
            if (this.axesOrientationRasmol) {
                StateManager.appendCmd(str, "set axesOrientationRasmol true");
            }
            StateManager.appendCmd(str, "set bondRadiusMilliAngstroms " + this.bondRadiusMilliAngstroms);
            StateManager.appendCmd(str, "set bondTolerance " + this.bondTolerance);
            StateManager.appendCmd(str, "set defaultDirectory " + Escape.escape(this.defaultDirectory));
            StateManager.appendCmd(str, "set defaultLattice " + Escape.escape(this.ptDefaultLattice));
            StateManager.appendCmd(str, "set defaultLoadScript \"\"");
            if (this.defaultLoadScript.length() > 0) {
                this.setParameterValue("defaultLoadScript", this.defaultLoadScript);
            }
            String sMode = StateManager.this.viewer.getDefaultVdw(Integer.MIN_VALUE);
            StateManager.appendCmd(str, "set defaultVDW " + sMode);
            if (sMode.equals("User")) {
                StateManager.appendCmd(str, StateManager.this.viewer.getDefaultVdw(Integer.MAX_VALUE));
            }
            StateManager.appendCmd(str, "set forceAutoBond " + this.forceAutoBond);
            StateManager.appendCmd(str, "set loadFormat " + Escape.escape(this.loadFormat));
            if (this.autoLoadOrientation) {
                StateManager.appendCmd(str, "set autoLoadOrientation true");
            }
            StateManager.appendCmd(str, "set minBondDistance " + this.minBondDistance);
            StateManager.appendCmd(str, "set pdbSequential " + this.pdbSequential);
            StateManager.appendCmd(str, "set pdbGetHeader " + this.pdbGetHeader);
            StateManager.appendCmd(str, "set percentVdwAtom " + this.percentVdwAtom);
            StateManager.appendCmd(str, "set smartAromatic " + this.smartAromatic);
            if (this.zeroBasedXyzRasmol) {
                StateManager.appendCmd(str, "set zeroBasedXyzRasmol true");
            }
            return str.toString();
        }

        void setDefaultLattice(Point3f ptLattice) {
            this.ptDefaultLattice.set(ptLattice);
        }

        Point3f getDefaultLattice() {
            return this.ptDefaultLattice;
        }

        String getWindowState(StringBuffer sfunc) {
            StringBuffer str = new StringBuffer();
            if (sfunc != null) {
                sfunc.append("  initialize;\n  set refreshing false;\n  _setWindowState;\n");
                str.append("\nfunction _setWindowState() {\n");
            }
            str.append("# height " + StateManager.this.viewer.getScreenHeight() + ";\n# width " + StateManager.this.viewer.getScreenWidth() + ";\n");
            StateManager.appendCmd(str, "stateVersion = " + this.getParameter("_version"));
            for (int i = 0; i < 7; ++i) {
                if (this.objColors[i] == 0) continue;
                StateManager.appendCmd(str, StateManager.getObjectNameFromId(i) + "Color = \"" + Escape.escapeColor(this.objColors[i]) + '\"');
            }
            if (this.backgroundImageFileName != null) {
                StateManager.appendCmd(str, "background IMAGE /*file*/" + Escape.escape(this.backgroundImageFileName));
            }
            str.append(this.getSpecularState());
            StateManager.appendCmd(str, "statusReporting  = " + this.statusReporting);
            if (sfunc != null) {
                str.append("}\n\n");
            }
            return str.toString();
        }

        String getSpecularState() {
            StringBuffer str = new StringBuffer("");
            StateManager.appendCmd(str, "ambientPercent = " + Graphics3D.getAmbientPercent());
            StateManager.appendCmd(str, "diffusePercent = " + Graphics3D.getDiffusePercent());
            StateManager.appendCmd(str, "specular = " + Graphics3D.getSpecular());
            StateManager.appendCmd(str, "specularPercent = " + Graphics3D.getSpecularPercent());
            StateManager.appendCmd(str, "specularPower = " + Graphics3D.getSpecularPower());
            StateManager.appendCmd(str, "specularExponent = " + Graphics3D.getSpecularExponent());
            return str.toString();
        }

        void setMeasureDistanceUnits(String units) {
            if (units.equalsIgnoreCase("angstroms")) {
                this.measureDistanceUnits = "angstroms";
            } else if (units.equalsIgnoreCase("nanometers") || units.equalsIgnoreCase("nm")) {
                this.measureDistanceUnits = "nanometers";
            } else if (units.equalsIgnoreCase("picometers") || units.equalsIgnoreCase("pm")) {
                this.measureDistanceUnits = "picometers";
            } else if (units.equalsIgnoreCase("bohr") || units.equalsIgnoreCase("au")) {
                this.measureDistanceUnits = "au";
            }
            this.setParameterValue("measurementUnits", this.measureDistanceUnits);
        }

        String getMeasureDistanceUnits() {
            return this.measureDistanceUnits;
        }

        boolean isJmolVariable(String key) {
            return key.charAt(0) == '_' || this.htParameterValues.containsKey(key = key.toLowerCase()) || this.htPropertyFlags.containsKey(key) || unreportedProperties.indexOf(";" + key + ";") >= 0;
        }

        private void resetParameterStringValue(String name, GlobalSettings g) {
            this.setParameterValue(name, g == null ? "" : (String)g.getParameter(name));
        }

        void setParameterValue(String name, boolean value) {
            if (this.htParameterValues.containsKey(name = name.toLowerCase())) {
                return;
            }
            this.htPropertyFlags.put(name, value ? Boolean.TRUE : Boolean.FALSE);
        }

        void setParameterValue(String name, int value) {
            if (this.htPropertyFlags.containsKey(name = name.toLowerCase())) {
                return;
            }
            this.htParameterValues.put(name, new Integer(value));
        }

        void setParameterValue(String name, float value) {
            name = name.toLowerCase();
            if (Float.isNaN(value)) {
                this.htParameterValues.remove(name);
                this.htPropertyFlags.remove(name);
                return;
            }
            if (this.htPropertyFlags.containsKey(name)) {
                return;
            }
            this.htParameterValues.put(name, new Float(value));
        }

        void setParameterValue(String name, String value) {
            name = name.toLowerCase();
            if (value == null || this.htPropertyFlags.containsKey(name)) {
                return;
            }
            this.htParameterValues.put(name, value);
        }

        void removeJmolParameter(String key) {
            if (this.htPropertyFlags.containsKey(key)) {
                this.htPropertyFlags.remove(key);
                if (!this.htPropertyFlagsRemoved.containsKey(key)) {
                    this.htPropertyFlagsRemoved.put(key, Boolean.FALSE);
                }
                return;
            }
            if (this.htParameterValues.containsKey(key)) {
                this.htParameterValues.remove(key);
            }
        }

        ScriptVariable setUserVariable(String key, ScriptVariable var) {
            if (var == null) {
                return null;
            }
            key = key.toLowerCase();
            this.htUserVariables.put(key, var.setName(key).setGlobal());
            return var;
        }

        void unsetUserVariable(String key) {
            if ((key = key.toLowerCase()).equals("all") || key.equals("variables")) {
                this.htUserVariables.clear();
                Logger.info("all user-defined variables deleted");
            } else if (this.htUserVariables.containsKey(key)) {
                Logger.info("variable " + key + " deleted");
                this.htUserVariables.remove(key);
            }
        }

        void removeUserVariable(String key) {
            this.htUserVariables.remove(key);
        }

        ScriptVariable getUserVariable(String name) {
            if (name == null) {
                return null;
            }
            name = name.toLowerCase();
            return (ScriptVariable)this.htUserVariables.get(name);
        }

        String getParameterEscaped(String name, int nMax) {
            if (this.htParameterValues.containsKey(name = name.toLowerCase())) {
                Object v = this.htParameterValues.get(name);
                return StateManager.varClip(name, Escape.escape(v), nMax);
            }
            if (this.htPropertyFlags.containsKey(name)) {
                return this.htPropertyFlags.get(name).toString();
            }
            if (this.htUserVariables.containsKey(name)) {
                return ((ScriptVariable)this.htUserVariables.get(name)).escape();
            }
            if (this.htPropertyFlagsRemoved.containsKey(name)) {
                return "false";
            }
            return "<not defined>";
        }

        Object getParameter(String name) {
            Object v = this.getParameter(name, false);
            return v == null ? "" : v;
        }

        ScriptVariable getOrSetNewVariable(String name, boolean doSet) {
            Object v;
            if (name == null || name.length() == 0) {
                name = "x";
            }
            return (v = this.getParameter(name, true)) == null && doSet && name.charAt(0) != '_' ? this.setUserVariable(name, new ScriptVariable()) : ScriptVariable.getVariable(v);
        }

        Object getParameter(String name, boolean asVariable) {
            if ((name = name.toLowerCase()).equals("_memory")) {
                Runtime runtime = Runtime.getRuntime();
                float bTotal = (float)runtime.totalMemory() / 1000000.0f;
                float bFree = (float)runtime.freeMemory() / 1000000.0f;
                String value = TextFormat.formatDecimal(bTotal - bFree, 1) + "/" + TextFormat.formatDecimal(bTotal, 1);
                this.htParameterValues.put("_memory", value);
            }
            if (this.htParameterValues.containsKey(name)) {
                return this.htParameterValues.get(name);
            }
            if (this.htPropertyFlags.containsKey(name)) {
                return this.htPropertyFlags.get(name);
            }
            if (this.htPropertyFlagsRemoved.containsKey(name)) {
                return Boolean.FALSE;
            }
            if (this.htUserVariables.containsKey(name)) {
                ScriptVariable v = (ScriptVariable)this.htUserVariables.get(name);
                return asVariable ? v : ScriptVariable.oValue(v);
            }
            return null;
        }

        String getAllSettings(String prefix) {
            String key;
            StringBuffer commands = new StringBuffer("");
            Object[] list = new String[this.htPropertyFlags.size() + this.htParameterValues.size()];
            int n = 0;
            String _prefix = "_" + prefix;
            Enumeration e = this.htPropertyFlags.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                if (prefix != null && key.indexOf(prefix) != 0 && key.indexOf(_prefix) != 0) continue;
                list[n++] = (key.indexOf("_") == 0 ? key + " = " : "set " + key + " ") + this.htPropertyFlags.get(key);
            }
            e = this.htParameterValues.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                if (key.charAt(0) == '@' || prefix != null && key.indexOf(prefix) != 0 && key.indexOf(_prefix) != 0) continue;
                Object value = this.htParameterValues.get(key);
                if (value instanceof String) {
                    value = Escape.escape((String)value);
                }
                list[n++] = (key.indexOf("_") == 0 ? key + " = " : "set " + key + " ") + value;
            }
            Arrays.sort(list, 0, n);
            for (int i = 0; i < n; ++i) {
                if (list[i] == null) continue;
                StateManager.appendCmd(commands, (String)list[i]);
            }
            commands.append("\n");
            return commands.toString();
        }

        String getState(StringBuffer sfunc) {
            String key;
            Object[] list = new String[this.htPropertyFlags.size() + this.htParameterValues.size()];
            StringBuffer commands = new StringBuffer();
            if (sfunc != null) {
                sfunc.append("  _setVariableState;\n");
                commands.append("function _setVariableState() {\n\n");
            }
            int n = 0;
            Enumeration e = this.htPropertyFlags.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                if (!this.doReportProperty(key)) continue;
                list[n++] = "set " + key + " " + this.htPropertyFlags.get(key);
            }
            e = this.htParameterValues.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                if (key.charAt(0) == '@' || !this.doReportProperty(key)) continue;
                Object value = this.htParameterValues.get(key);
                if (key.charAt(0) == '=') {
                    key = key.substring(1);
                } else {
                    key = key.indexOf("default") == 0 ? " set " + key : "set " + key;
                    value = Escape.escape(value);
                }
                list[n++] = key + " " + value;
            }
            switch (this.axesMode) {
                case 2: {
                    list[n++] = "set axes unitcell";
                    break;
                }
                case 0: {
                    list[n++] = "set axes window";
                    break;
                }
                default: {
                    list[n++] = "set axes molecular";
                }
            }
            e = this.htParameterValues.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                if (key.charAt(0) != '@') continue;
                list[n++] = key + " " + this.htParameterValues.get(key);
            }
            Arrays.sort(list, 0, n);
            for (int i = 0; i < n; ++i) {
                if (list[i] == null) continue;
                StateManager.appendCmd(commands, (String)list[i]);
            }
            commands.append("\n#user-defined variables; \n");
            commands.append(StateManager.getVariableList(this.htUserVariables, 0));
            StateManager.this.viewer.loadShape(4);
            commands.append(StateManager.this.viewer.getShapeProperty(4, "defaultState"));
            if (sfunc != null) {
                commands.append("\n}\n\n");
            }
            return commands.toString();
        }

        private boolean doReportProperty(String name) {
            return name.charAt(0) != '_' && unreportedProperties.indexOf(";" + name + ";") < 0;
        }

        void registerAllValues(GlobalSettings g) {
            this.htParameterValues = new Hashtable();
            this.htPropertyFlags = new Hashtable();
            this.htPropertyFlagsRemoved = new Hashtable();
            if (g != null) {
                this.debugScript = g.debugScript;
                this.disablePopupMenu = g.disablePopupMenu;
                this.messageStyleChime = g.messageStyleChime;
                this.zShade = g.zShade;
            }
            this.resetParameterStringValue("animFrameCallback", g);
            this.resetParameterStringValue("echoCallback", g);
            this.resetParameterStringValue("evalCallback", g);
            this.resetParameterStringValue("hoverCallback", g);
            this.resetParameterStringValue("loadStructCallback", g);
            this.resetParameterStringValue("measureCallback", g);
            this.resetParameterStringValue("messageCallback", g);
            this.resetParameterStringValue("minimizationCallback", g);
            this.resetParameterStringValue("pickCallback", g);
            this.resetParameterStringValue("resizeCallback", g);
            this.resetParameterStringValue("scriptCallback", g);
            this.resetParameterStringValue("syncCallback", g);
            this.setParameterValue("hoverLabel", "");
            this.setParameterValue("rotationRadius", 0);
            this.setParameterValue("scriptqueue", true);
            this.setParameterValue("_version", 0);
            this.setParameterValue("stateversion", 0);
            this.setParameterValue("allowEmbeddedScripts", this.allowEmbeddedScripts);
            this.setParameterValue("allowKeyStrokes", this.allowKeyStrokes);
            this.setParameterValue("allowRotateSelected", this.allowRotateSelected);
            this.setParameterValue("ambientPercent", this.ambientPercent);
            this.setParameterValue("animationFps", this.animationFps);
            this.setParameterValue("antialiasImages", this.antialiasImages);
            this.setParameterValue("antialiasDisplay", this.antialiasDisplay);
            this.setParameterValue("antialiasTranslucent", this.antialiasTranslucent);
            this.setParameterValue("appendNew", this.appendNew);
            this.setParameterValue("appletProxy", this.appletProxy);
            this.setParameterValue("applySymmetryToBonds", this.applySymmetryToBonds);
            this.setParameterValue("atomPicking", this.atomPicking);
            this.setParameterValue("atomTypes", this.atomTypes);
            this.setParameterValue("autoBond", this.autoBond);
            this.setParameterValue("autoFps", this.autoFps);
            this.setParameterValue("autoLoadOrientation", this.autoLoadOrientation);
            this.setParameterValue("axesMode", this.axesMode);
            this.setParameterValue("axesScale", this.axesScale);
            this.setParameterValue("axesWindow", true);
            this.setParameterValue("axesMolecular", false);
            this.setParameterValue("axesPosition", false);
            this.setParameterValue("axesUnitcell", false);
            this.setParameterValue("axesOrientationRasmol", this.axesOrientationRasmol);
            this.setParameterValue("backgroundModel", 0);
            this.setParameterValue("bondModeOr", this.bondModeOr);
            this.setParameterValue("bondPicking", this.bondPicking);
            this.setParameterValue("bondRadiusMilliAngstroms", this.bondRadiusMilliAngstroms);
            this.setParameterValue("bondTolerance", this.bondTolerance);
            this.setParameterValue("cameraDepth", this.cameraDepth);
            this.setParameterValue("cartoonRockets", this.cartoonRockets);
            this.setParameterValue("chainCaseSensitive", this.chainCaseSensitive);
            this.setParameterValue("colorRasmol", false);
            this.setParameterValue("currentLocalPath", "");
            this.setParameterValue("dataSeparator", this.dataSeparator);
            this.setParameterValue("debugScript", this.debugScript);
            this.setParameterValue("defaultLattice", "{0 0 0}");
            this.setParameterValue("defaultAngleLabel", this.defaultAngleLabel);
            this.setParameterValue("defaultColorScheme", "Jmol");
            this.setParameterValue("defaultDrawArrowScale", this.defaultDrawArrowScale);
            this.setParameterValue("defaultDirectory", this.defaultDirectory);
            this.setParameterValue("defaultDirectoryLocal", "");
            this.setParameterValue("defaultDistanceLabel", this.defaultDistanceLabel);
            this.setParameterValue("defaultLoadScript", this.defaultLoadScript);
            this.setParameterValue("defaults", "Jmol");
            this.setParameterValue("defaultVDW", "Jmol");
            this.setParameterValue("defaultTorsionLabel", this.defaultTorsionLabel);
            this.setParameterValue("defaultTranslucent", this.defaultTranslucent);
            this.setParameterValue("delayMaximumMs", this.delayMaximumMs);
            this.setParameterValue("diffusePercent", this.diffusePercent);
            this.setParameterValue("dipoleScale", this.dipoleScale);
            this.setParameterValue("disablePopupMenu", this.disablePopupMenu);
            this.setParameterValue("displayCellParameters", this.displayCellParameters);
            this.setParameterValue("dotDensity", this.dotDensity);
            this.setParameterValue("dotsSelectedOnly", this.dotsSelectedOnly);
            this.setParameterValue("dotSurface", this.dotSurface);
            this.setParameterValue("dragSelected", false);
            this.setParameterValue("drawHover", false);
            this.setParameterValue("drawPicking", this.drawPicking);
            this.setParameterValue("dynamicMeasurements", this.dynamicMeasurements);
            this.setParameterValue("ellipsoidArcs", this.ellipsoidArcs);
            this.setParameterValue("ellipsoidAxes", this.ellipsoidAxes);
            this.setParameterValue("ellipsoidAxisDiameter", this.ellipsoidAxisDiameter);
            this.setParameterValue("ellipsoidBall", this.ellipsoidBall);
            this.setParameterValue("ellipsoidDotCount", this.ellipsoidDotCount);
            this.setParameterValue("ellipsoidDots", this.ellipsoidDots);
            this.setParameterValue("ellipsoidFill", this.ellipsoidFill);
            this.setParameterValue("exportDrivers", "Maya;Vrml;Povray");
            this.setParameterValue("fontScaling", this.fontScaling);
            this.setParameterValue("fontCaching", this.fontCaching);
            this.setParameterValue("forceAutoBond", this.forceAutoBond);
            this.setParameterValue("greyscaleRendering", this.greyscaleRendering);
            this.setParameterValue("hbondsAngleMinimum", this.hbondsAngleMinimum);
            this.setParameterValue("hbondsDistanceMaximum", this.hbondsDistanceMaximum);
            this.setParameterValue("hbondsBackbone", this.hbondsBackbone);
            this.setParameterValue("hbondsSolid", this.hbondsSolid);
            this.setParameterValue("helpPath", this.helpPath);
            this.setParameterValue("hermiteLevel", this.hermiteLevel);
            this.setParameterValue("hideNameInPopup", this.hideNameInPopup);
            this.setParameterValue("hideNavigationPoint", this.hideNavigationPoint);
            this.setParameterValue("hideNotSelected", false);
            this.setParameterValue("highResolution", this.highResolutionFlag);
            this.setParameterValue("historyLevel", 0);
            this.setParameterValue("hoverDelay", (float)this.hoverDelayMs / 1000.0f);
            this.setParameterValue("isosurfacePropertySmoothing", this.isosurfacePropertySmoothing);
            this.setParameterValue("justifyMeasurements", this.justifyMeasurements);
            this.setParameterValue("loadAtomDataTolerance", this.loadAtomDataTolerance);
            this.setParameterValue("loadFormat", this.loadFormat);
            this.setParameterValue("measureAllModels", this.measureAllModels);
            this.measurementLabels = true;
            this.setParameterValue("measurementLabels", true);
            this.setParameterValue("measurementUnits", this.measureDistanceUnits);
            this.setParameterValue("messageStyleChime", this.messageStyleChime);
            this.setParameterValue("minBondDistance", this.minBondDistance);
            this.setParameterValue("minimizationSteps", this.minimizationSteps);
            this.setParameterValue("minimizationRefresh", this.minimizationRefresh);
            this.setParameterValue("minimizationCriterion", this.minimizationCriterion);
            this.setParameterValue("navigationMode", this.navigationMode);
            this.setParameterValue("navigationPeriodic", this.navigationPeriodic);
            this.setParameterValue("navigationDepth", 0);
            this.setParameterValue("navigationSlab", 0);
            this.setParameterValue("navigationSpeed", this.navigationSpeed);
            this.setParameterValue("pdbGetHeader", this.pdbGetHeader);
            this.setParameterValue("pdbSequential", this.pdbSequential);
            this.setParameterValue("perspectiveModel", 11);
            this.setParameterValue("perspectiveDepth", this.perspectiveDepth);
            this.setParameterValue("percentVdwAtom", this.percentVdwAtom);
            this.setParameterValue("picking", "ident");
            this.setParameterValue("pickingSpinRate", this.pickingSpinRate);
            this.setParameterValue("pickingStyle", "toggle");
            this.setParameterValue("pickLabel", this.pickLabel);
            this.setParameterValue("pointGroupLinearTolerance", this.pointGroupLinearTolerance);
            this.setParameterValue("pointGroupDistanceTolerance", this.pointGroupDistanceTolerance);
            this.setParameterValue("propertyColorScheme", this.propertyColorScheme);
            this.setParameterValue("propertyAtomNumberColumnCount", 0);
            this.setParameterValue("propertyAtomNumberField", 0);
            this.setParameterValue("propertyDataColumnCount", 0);
            this.setParameterValue("propertyDataField", 0);
            this.setParameterValue("quaternionFrame", this.quaternionFrame);
            this.setParameterValue("rangeSelected", this.rangeSelected);
            this.setParameterValue("refreshing", true);
            this.setParameterValue("ribbonAspectRatio", this.ribbonAspectRatio);
            this.setParameterValue("ribbonBorder", this.ribbonBorder);
            this.setParameterValue("rocketBarrels", this.rocketBarrels);
            this.setParameterValue("scaleAngstromsPerInch", 0);
            this.setParameterValue("scriptReportingLevel", 0);
            this.setParameterValue("selectAllModels", this.selectAllModels);
            this.setParameterValue("selectionHalos", false);
            this.setParameterValue("selectHetero", this.rasmolHeteroSetting);
            this.setParameterValue("selectHydrogen", this.rasmolHydrogenSetting);
            this.setParameterValue("sheetSmoothing", this.sheetSmoothing);
            this.setParameterValue("showaxes", false);
            this.setParameterValue("showboundbox", false);
            this.setParameterValue("showfrank", false);
            this.setParameterValue("showHiddenSelectionHalos", this.showHiddenSelectionHalos);
            this.setParameterValue("showHydrogens", this.showHydrogens);
            this.setParameterValue("showKeyStrokes", this.showKeyStrokes);
            this.setParameterValue("showMeasurements", this.showMeasurements);
            this.setParameterValue("showMultipleBonds", this.showMultipleBonds);
            this.setParameterValue("showNavigationPointAlways", this.showNavigationPointAlways);
            this.setParameterValue("showScript", this.scriptDelay);
            this.setParameterValue("showUnitcell", false);
            this.setParameterValue("slabEnabled", false);
            this.setParameterValue("smartAromatic", this.smartAromatic);
            this.setParameterValue("solventProbe", this.solventOn);
            this.setParameterValue("solventProbeRadius", this.solventProbeRadius);
            this.setParameterValue("specular", this.specular);
            this.setParameterValue("specularExponent", this.specularExponent);
            this.setParameterValue("specularPercent", this.specularPercent);
            this.setParameterValue("specularPower", this.specularPower);
            this.setParameterValue("spinX", 0);
            this.setParameterValue("spinY", 30);
            this.setParameterValue("spinZ", 0);
            this.setParameterValue("spinFps", 30);
            this.setParameterValue("ssbondsBackbone", this.ssbondsBackbone);
            this.setParameterValue("stereoDegrees", -5);
            this.setParameterValue("statusReporting", this.statusReporting);
            this.setParameterValue("strandCount", this.strandCountForStrands);
            this.setParameterValue("strandCountForStrands", this.strandCountForStrands);
            this.setParameterValue("strandCountForMeshRibbon", this.strandCountForMeshRibbon);
            this.setParameterValue("syncMouse", false);
            this.setParameterValue("syncScript", false);
            this.setParameterValue("syncStereo", false);
            this.setParameterValue("testFlag1", this.testFlag1);
            this.setParameterValue("testFlag2", this.testFlag2);
            this.setParameterValue("testFlag3", this.testFlag3);
            this.setParameterValue("testFlag4", this.testFlag4);
            this.setParameterValue("traceAlpha", this.traceAlpha);
            this.setParameterValue("undo", true);
            this.setParameterValue("useMinimizationThread", this.useMinimizationThread);
            this.setParameterValue("useNumberLocalization", this.useNumberLocalization);
            this.setParameterValue("vectorScale", this.vectorScale);
            this.setParameterValue("vibrationPeriod", this.vibrationPeriod);
            this.setParameterValue("vibrationScale", this.vibrationScale);
            this.setParameterValue("visualRange", this.visualRange);
            this.setParameterValue("windowCentered", true);
            this.setParameterValue("wireframeRotation", this.wireframeRotation);
            this.setParameterValue("zoomEnabled", true);
            this.setParameterValue("zoomLarge", this.zoomLarge);
            this.setParameterValue("zShade", this.zShade);
            this.setParameterValue("zeroBasedXyzRasmol", this.zeroBasedXyzRasmol);
        }

        String getVariableList() {
            return StateManager.getVariableList(this.htUserVariables, 0);
        }
    }

    static class Connection {
        int atomIndex1;
        int atomIndex2;
        short mad;
        short colix;
        short order;
        int shapeVisibilityFlags;

        Connection(int atom1, int atom2, short mad, short colix, short order, int shapeVisibilityFlags) {
            this.atomIndex1 = atom1;
            this.atomIndex2 = atom2;
            this.mad = mad;
            this.colix = colix;
            this.order = order;
            this.shapeVisibilityFlags = shapeVisibilityFlags;
        }
    }

    class Connections {
        String saveName;
        int bondCount;
        Connection[] connections;

        Connections() {
            ModelSet modelSet = StateManager.this.viewer.getModelSet();
            if (modelSet == null) {
                return;
            }
            this.bondCount = modelSet.getBondCount();
            this.connections = new Connection[this.bondCount + 1];
            Bond[] bonds = modelSet.getBonds();
            int i = this.bondCount;
            while (--i >= 0) {
                Bond b = bonds[i];
                this.connections[i] = new Connection(b.getAtomIndex1(), b.getAtomIndex2(), b.getMad(), b.getColix(), b.getOrder(), b.getShapeVisibilityFlags());
            }
        }

        void restore() {
            ModelSet modelSet = StateManager.this.viewer.getModelSet();
            if (modelSet == null) {
                return;
            }
            modelSet.deleteAllBonds();
            int i = this.bondCount;
            while (--i >= 0) {
                Connection c = this.connections[i];
                int atomCount = modelSet.getAtomCount();
                if (c.atomIndex1 >= atomCount || c.atomIndex2 >= atomCount) continue;
                Bond b = modelSet.bondAtoms(modelSet.atoms[c.atomIndex1], modelSet.atoms[c.atomIndex2], c.order, c.mad, null);
                b.setColix(c.colix);
                b.setShapeVisibilityFlags(c.shapeVisibilityFlags);
            }
            i = this.bondCount;
            while (--i >= 0) {
                modelSet.getBondAt(i).setIndex(i);
            }
            StateManager.this.viewer.setShapeProperty(1, "reportAll", null);
        }
    }

    public class Orientation {
        String saveName;
        Matrix3f rotationMatrix = new Matrix3f();
        float xTrans;
        float yTrans;
        float zoom;
        float rotationRadius;
        Point3f center = new Point3f();
        Point3f navCenter = new Point3f();
        float xNav = Float.NaN;
        float yNav = Float.NaN;
        float navDepth = Float.NaN;
        boolean windowCenteredFlag;
        boolean navigationMode;
        String moveToText;

        Orientation(boolean asDefault) {
            if (asDefault) {
                Matrix3f rotationMatrix = (Matrix3f)StateManager.this.viewer.getModelSetAuxiliaryInfo("defaultOrientationMatrix");
                if (rotationMatrix == null) {
                    this.rotationMatrix.setIdentity();
                } else {
                    this.rotationMatrix.set(rotationMatrix);
                }
            } else {
                StateManager.this.viewer.getRotation(this.rotationMatrix);
            }
            this.xTrans = StateManager.this.viewer.getTranslationXPercent();
            this.yTrans = StateManager.this.viewer.getTranslationYPercent();
            this.zoom = StateManager.this.viewer.getZoomSetting();
            this.center.set(StateManager.this.viewer.getRotationCenter());
            this.windowCenteredFlag = StateManager.this.viewer.isWindowCentered();
            this.rotationRadius = StateManager.this.viewer.getRotationRadius();
            this.navigationMode = StateManager.this.viewer.getNavigationMode();
            this.moveToText = StateManager.this.viewer.getMoveToText(-1.0f);
            if (this.navigationMode) {
                this.navCenter = StateManager.this.viewer.getNavigationOffset();
                this.xNav = StateManager.this.viewer.getNavigationOffsetPercent('X');
                this.yNav = StateManager.this.viewer.getNavigationOffsetPercent('Y');
                this.navDepth = StateManager.this.viewer.getNavigationDepthPercent();
                this.navCenter = StateManager.this.viewer.getNavigationCenter();
            }
        }

        public String getMoveToText() {
            return this.moveToText;
        }

        void restore(float timeSeconds, boolean isAll) {
            if (!isAll) {
                StateManager.this.viewer.moveTo(timeSeconds, this.rotationMatrix, null, Float.NaN, Float.NaN, Float.NaN, Float.NaN, null, Float.NaN, Float.NaN, Float.NaN);
                return;
            }
            StateManager.this.viewer.setBooleanProperty("windowCentered", this.windowCenteredFlag);
            StateManager.this.viewer.setBooleanProperty("navigationMode", this.navigationMode);
            StateManager.this.viewer.moveTo(timeSeconds, this.rotationMatrix, this.center, this.zoom, this.xTrans, this.yTrans, this.rotationRadius, this.navCenter, this.xNav, this.yNav, this.navDepth);
        }
    }
}

