/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.api.JmolCallbackListener;
import org.jmol.api.JmolStatusListener;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

class StatusManager {
    private boolean allowStatusReporting;
    private Viewer viewer;
    private JmolStatusListener jmolStatusListener;
    private JmolCallbackListener jmolCallbackListener;
    private String statusList = "";
    private Hashtable messageQueue = new Hashtable();
    private int statusPtr = 0;
    private static int MAXIMUM_QUEUE_LENGTH = 16;
    private boolean asVector = true;
    private String[] jmolScriptCallbacks = new String[13];
    private int minSyncRepeatMs = 100;
    boolean syncingScripts = false;
    boolean syncingMouse = false;
    boolean drivingSync = false;
    boolean isSynced = false;
    boolean syncDisabled = false;
    boolean stereoSync = false;
    static final int SYNC_OFF = 0;
    static final int SYNC_DRIVER = 1;
    static final int SYNC_SLAVE = 2;
    static final int SYNC_DISABLE = 3;
    static final int SYNC_ENABLE = 4;
    static final int SYNC_STEREO = 5;

    StatusManager(Viewer viewer) {
        this.viewer = viewer;
    }

    void setAllowStatusReporting(boolean TF) {
        this.allowStatusReporting = TF;
    }

    String getStatusList() {
        return this.statusList;
    }

    Hashtable getMessageQueue() {
        return this.messageQueue;
    }

    private boolean recordStatus(String statusName) {
        return this.allowStatusReporting && this.statusList.length() > 0 && (this.statusList.equals("all") || this.statusList.indexOf(statusName) >= 0);
    }

    private synchronized void setStatusChanged(String statusName, int intInfo, Object statusInfo, boolean isReplace) {
        Vector statusRecordSet;
        if (!this.recordStatus(statusName)) {
            return;
        }
        ++this.statusPtr;
        Vector<Object> msgRecord = new Vector<Object>();
        msgRecord.addElement(new Integer(this.statusPtr));
        msgRecord.addElement(statusName);
        msgRecord.addElement(new Integer(intInfo));
        msgRecord.addElement(statusInfo);
        if (isReplace && this.messageQueue.containsKey(statusName)) {
            this.messageQueue.remove(statusName);
        }
        if ((statusRecordSet = this.messageQueue.containsKey(statusName) ? (Vector)this.messageQueue.remove(statusName) : new Vector()).size() == MAXIMUM_QUEUE_LENGTH) {
            statusRecordSet.removeElementAt(0);
        }
        statusRecordSet.addElement(msgRecord);
        this.messageQueue.put(statusName, statusRecordSet);
    }

    synchronized Object getStatusChanged(String statusNameList) {
        if (statusNameList.indexOf("AS_") == 0) {
            this.asVector = statusNameList.indexOf("VECTOR") == 3;
            return statusNameList;
        }
        Cloneable msgList = this.asVector ? new Vector() : new Hashtable();
        if (this.resetMessageQueue(statusNameList)) {
            return msgList;
        }
        Enumeration e = this.messageQueue.keys();
        while (e.hasMoreElements()) {
            String statusName = (String)e.nextElement();
            Object record = this.messageQueue.remove(statusName);
            if (this.asVector) {
                ((Vector)msgList).addElement(record);
                continue;
            }
            ((Hashtable)msgList).put(statusName, record);
        }
        return msgList;
    }

    private synchronized boolean resetMessageQueue(String statusList) {
        boolean isRemove = statusList.length() > 0 && statusList.charAt(0) == '-';
        boolean isAdd = statusList.length() > 0 && statusList.charAt(0) == '+';
        String oldList = this.statusList;
        if (isRemove) {
            this.statusList = TextFormat.simpleReplace(oldList, statusList.substring(1, statusList.length()), "");
            this.messageQueue = new Hashtable();
            this.statusPtr = 0;
            return true;
        }
        if (oldList.equals(statusList = TextFormat.simpleReplace(statusList, "+", "")) || isAdd && oldList.indexOf(statusList) >= 0) {
            return false;
        }
        if (!isAdd) {
            this.messageQueue = new Hashtable();
            this.statusPtr = 0;
            this.statusList = "";
        }
        this.statusList = this.statusList + statusList;
        if (Logger.debugging) {
            Logger.debug(oldList + "\nmessageQueue = " + this.statusList);
        }
        return true;
    }

    synchronized void setJmolStatusListener(JmolStatusListener jmolStatusListener, JmolCallbackListener jmolCallbackListener) {
        this.jmolStatusListener = jmolStatusListener;
        this.jmolCallbackListener = jmolCallbackListener == null ? jmolStatusListener : jmolCallbackListener;
    }

    synchronized void setJmolCallbackListener(JmolCallbackListener jmolCallbackListener) {
        this.jmolCallbackListener = jmolCallbackListener;
    }

    private String jmolScriptCallback(int iCallback) {
        String s = this.jmolScriptCallbacks[iCallback];
        if (s != null) {
            this.viewer.evalStringQuiet(s, true, false);
        }
        return s;
    }

    synchronized void setCallbackFunction(String callbackType, String callbackFunction) {
        int iCallback = JmolConstants.getCallbackId(callbackType);
        if (iCallback >= 0) {
            int pt = callbackFunction == null ? 0 : (callbackFunction.length() > 7 && callbackFunction.toLowerCase().indexOf("script:") == 0 ? 7 : (callbackFunction.length() > 11 && callbackFunction.toLowerCase().indexOf("jmolscript:") == 0 ? 11 : 0));
            String string = this.jmolScriptCallbacks[iCallback] = pt == 0 ? null : callbackFunction.substring(pt).trim();
        }
        if (this.jmolCallbackListener != null) {
            this.jmolCallbackListener.setCallbackFunction(callbackType, callbackFunction);
        }
    }

    private boolean notifyEnabled(int type) {
        return this.jmolCallbackListener != null && this.jmolCallbackListener.notifyEnabled(type);
    }

    synchronized void setStatusAtomPicked(int atomIndex, String strInfo) {
        String sJmol = this.jmolScriptCallback(9);
        Logger.info("setStatusAtomPicked(" + atomIndex + "," + strInfo + ")");
        this.setStatusChanged("atomPicked", atomIndex, strInfo, false);
        if (this.notifyEnabled(9)) {
            this.jmolCallbackListener.notifyCallback(9, new Object[]{sJmol, strInfo, new Integer(atomIndex)});
        }
    }

    synchronized void setStatusResized(int width, int height) {
        String sJmol = this.jmolScriptCallback(10);
        if (this.notifyEnabled(10)) {
            this.jmolCallbackListener.notifyCallback(10, new Object[]{sJmol, new Integer(width), new Integer(height)});
        }
    }

    synchronized void setStatusAtomHovered(int iatom, String strInfo) {
        String sJmol = this.jmolScriptCallback(4);
        if (this.notifyEnabled(4)) {
            this.jmolCallbackListener.notifyCallback(4, new Object[]{sJmol, strInfo, new Integer(iatom)});
        }
    }

    synchronized void setFileLoadStatus(String fullPathName, String fileName, String modelName, String errorMsg, int ptLoad, boolean doCallback) {
        this.setStatusChanged("fileLoaded", ptLoad, fullPathName, false);
        if (errorMsg != null) {
            this.setStatusChanged("fileLoadError", ptLoad, errorMsg, false);
        }
        String sJmol = this.jmolScriptCallback(5);
        if (doCallback && this.notifyEnabled(5)) {
            this.jmolCallbackListener.notifyCallback(5, new Object[]{sJmol, fullPathName, fileName, modelName, errorMsg, new Integer(ptLoad)});
        }
    }

    synchronized void setStatusFrameChanged(int frameNo, int fileNo, int modelNo, int firstNo, int lastNo) {
        if (this.viewer.getModelSet() == null) {
            return;
        }
        boolean isAnimationRunning = frameNo <= -2;
        int f = frameNo;
        if (isAnimationRunning) {
            f = -2 - f;
        }
        this.setStatusChanged("frameChanged", frameNo, f >= 0 ? this.viewer.getModelNumberDotted(f) : "", false);
        String sJmol = this.jmolScriptCallback(0);
        if (this.notifyEnabled(0)) {
            this.jmolCallbackListener.notifyCallback(0, new Object[]{sJmol, new int[]{frameNo, fileNo, modelNo, firstNo, lastNo}});
        }
    }

    synchronized void setScriptEcho(String strEcho, boolean isScriptQueued) {
        if (strEcho == null) {
            return;
        }
        this.setStatusChanged("scriptEcho", 0, strEcho, false);
        String sJmol = this.jmolScriptCallback(1);
        if (this.notifyEnabled(1)) {
            this.jmolCallbackListener.notifyCallback(1, new Object[]{sJmol, strEcho, new Integer(isScriptQueued ? 1 : 0)});
        }
    }

    synchronized void setStatusMeasuring(String status, int intInfo, String strMeasure) {
        this.setStatusChanged(status, intInfo, strMeasure, false);
        String sJmol = null;
        if (status.equals("measureCompleted")) {
            Logger.info("measurement[" + intInfo + "] = " + strMeasure);
            sJmol = this.jmolScriptCallback(6);
        } else if (status.equals("measurePicked")) {
            this.setStatusChanged("measurePicked", intInfo, strMeasure, false);
            Logger.info("measurePicked " + intInfo + " " + strMeasure);
        }
        if (this.notifyEnabled(6)) {
            this.jmolCallbackListener.notifyCallback(6, new Object[]{sJmol, strMeasure, new Integer(intInfo), status});
        }
    }

    synchronized void notifyError(String errType, String errMsg, String errMsgUntranslated) {
        String sJmol = this.jmolScriptCallback(2);
        if (this.notifyEnabled(2)) {
            this.jmolCallbackListener.notifyCallback(2, new Object[]{sJmol, errType, errMsg, this.viewer.getShapeErrorState(), errMsgUntranslated});
        }
    }

    synchronized void notifyMinimizationStatus(String minStatus, Integer minSteps, Float minEnergy, Float minEnergyDiff) {
        String sJmol = this.jmolScriptCallback(8);
        if (this.notifyEnabled(8)) {
            this.jmolCallbackListener.notifyCallback(8, new Object[]{sJmol, minStatus, minSteps, minEnergy, minEnergyDiff});
        }
    }

    synchronized void setScriptStatus(String strStatus, String statusMessage, int msWalltime, String strErrorMessageUntranslated) {
        boolean isScriptCompletion;
        if (msWalltime < -1) {
            int iscript = -2 - msWalltime;
            this.setStatusChanged("scriptStarted", iscript, statusMessage, false);
            strStatus = "script " + iscript + " started";
        } else if (strStatus == null) {
            return;
        }
        String sJmol = msWalltime == 0 ? this.jmolScriptCallback(11) : null;
        boolean bl = isScriptCompletion = strStatus == "Script completed";
        if (this.recordStatus("script")) {
            boolean isError = strErrorMessageUntranslated != null;
            this.setStatusChanged(isError ? "scriptError" : "scriptStatus", 0, strStatus, false);
            if (isError || isScriptCompletion) {
                this.setStatusChanged("scriptTerminated", 1, "Jmol script terminated" + (isError ? " unsuccessfully: " + strStatus : " successfully"), false);
            }
        }
        if (this.jmolStatusListener != null) {
            if (isScriptCompletion && this.viewer.getMessageStyleChime() && this.viewer.getDebugScript()) {
                this.jmolCallbackListener.notifyCallback(11, new Object[]{null, "script <exiting>", statusMessage, new Integer(-1), strErrorMessageUntranslated});
                strStatus = "Jmol script completed.";
            }
            this.jmolCallbackListener.notifyCallback(11, new Object[]{sJmol, strStatus, statusMessage, new Integer(isScriptCompletion ? -1 : msWalltime), strErrorMessageUntranslated});
        }
    }

    boolean doSync() {
        return this.isSynced && this.drivingSync && !this.syncDisabled;
    }

    synchronized void setSync(String mouseCommand) {
        if (this.syncingMouse) {
            if (mouseCommand != null) {
                this.syncSend(mouseCommand, "*");
            }
        } else if (!this.syncingScripts) {
            this.syncSend("!" + this.viewer.getMoveToText((float)this.minSyncRepeatMs / 1000.0f), "*");
        }
    }

    synchronized void popupMenu(int x, int y) {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.handlePopupMenu(x, y);
        }
    }

    void setSyncDriver(int syncMode) {
        if (this.stereoSync && syncMode != 4) {
            this.syncSend("SET_GRAPHICS_OFF", "*");
            this.stereoSync = false;
        }
        switch (syncMode) {
            case 4: {
                if (!this.syncDisabled) {
                    return;
                }
                this.syncDisabled = false;
                break;
            }
            case 3: {
                this.syncDisabled = true;
                break;
            }
            case 5: {
                this.drivingSync = true;
                this.isSynced = true;
                this.stereoSync = true;
                break;
            }
            case 1: {
                this.drivingSync = true;
                this.isSynced = true;
                break;
            }
            case 2: {
                this.drivingSync = false;
                this.isSynced = true;
                break;
            }
            default: {
                this.drivingSync = false;
                this.isSynced = false;
            }
        }
        if (Logger.debugging) {
            Logger.debug(this.viewer.getHtmlName() + " sync mode=" + syncMode + "; synced? " + this.isSynced + "; driving? " + this.drivingSync + "; disabled? " + this.syncDisabled);
        }
    }

    void syncSend(String script, String appletName) {
        if (this.jmolStatusListener != null) {
            this.jmolCallbackListener.notifyCallback(12, new Object[]{null, script, appletName});
        }
    }

    int getSyncMode() {
        return !this.isSynced ? 0 : (this.drivingSync ? 1 : 2);
    }

    synchronized void showUrl(String urlString) {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.showUrl(urlString);
        }
    }

    synchronized void clearConsole() {
        if (this.jmolStatusListener != null) {
            this.jmolCallbackListener.notifyCallback(7, null);
        }
    }

    synchronized void showConsole(boolean showConsole) {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.showConsole(showConsole);
        }
    }

    synchronized void showEditor(String[] file_text) {
        if (file_text == null) {
            file_text = new String[]{null, null};
        }
        if (file_text[1] == null) {
            file_text[1] = "<no data>";
        }
        if (this.jmolStatusListener != null) {
            this.jmolCallbackListener.notifyCallback(14, new Object[]{null, file_text[1], file_text[0]});
        }
    }

    float[][] functionXY(String functionName, int nX, int nY) {
        return this.jmolStatusListener == null ? new float[Math.abs(nX)][Math.abs(nY)] : this.jmolStatusListener.functionXY(functionName, nX, nY);
    }

    float[][][] functionXYZ(String functionName, int nX, int nY, int nZ) {
        return this.jmolStatusListener == null ? new float[Math.abs(nX)][Math.abs(nY)][Math.abs(nY)] : this.jmolStatusListener.functionXYZ(functionName, nX, nY, nZ);
    }

    String jsEval(String strEval) {
        return this.jmolStatusListener == null ? "" : this.jmolStatusListener.eval(strEval);
    }

    String createImage(String fileName, String type, Object text_or_bytes, int quality) {
        if (this.jmolStatusListener == null) {
            return GT._("File creation failed.");
        }
        if (fileName != null && fileName.startsWith("?")) {
            fileName = fileName.substring(1);
            if (!this.viewer.isSignedApplet()) {
                fileName = this.dialogAsk(quality == Integer.MIN_VALUE ? "save" : "saveImage", fileName);
            }
        }
        if (fileName == null) {
            return null;
        }
        return this.jmolStatusListener.createImage(fileName, type, text_or_bytes, quality);
    }

    Hashtable getRegistryInfo() {
        return this.jmolStatusListener == null ? null : this.jmolStatusListener.getRegistryInfo();
    }

    String dialogAsk(String type, String fileName) {
        if (this.jmolStatusListener != null) {
            return this.jmolStatusListener.dialogAsk(type, fileName);
        }
        return "";
    }

    String getMenu(String type) {
        return this.jmolStatusListener == null ? "" : this.jmolStatusListener.eval("_GET_MENU|" + type);
    }
}

