/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Text3D;
import org.jmol.util.Escape;
import org.jmol.util.Quaternion;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.TransformManager11;
import org.jmol.viewer.Viewer;

abstract class TransformManager {
    Viewer viewer;
    static final float twoPI = (float)Math.PI * 2;
    static final float radiansPerDegree = (float)Math.PI / 180;
    static final float degreesPerRadian = 57.29578f;
    protected int perspectiveModel = 11;
    protected float cameraScaleFactor;
    protected float referencePlaneOffset;
    protected float modelCenterOffset;
    protected float modelRadius;
    protected float modelRadiusPixels;
    protected final Point3f navigationCenter = new Point3f();
    protected final Point3f navigationOffset = new Point3f();
    protected final Point3f navigationShiftXY = new Point3f();
    protected final Matrix4f matrixTemp = new Matrix4f();
    protected final Vector3f vectorTemp = new Vector3f();
    protected boolean haveNotifiedNaN = false;
    float spinX;
    float spinY = 30.0f;
    float spinZ;
    float spinFps = 30.0f;
    boolean isSpinInternal = false;
    boolean isSpinFixed = false;
    boolean isSpinSelected = false;
    protected final Point3f fixedRotationOffset = new Point3f();
    protected final Point3f fixedRotationCenter = new Point3f();
    private final Point3f rotationCenterDefault = new Point3f();
    private float rotationRadiusDefault;
    protected final AxisAngle4f fixedRotationAxis = new AxisAngle4f();
    protected final AxisAngle4f internalRotationAxis = new AxisAngle4f();
    private final Point3f internalRotationCenter = new Point3f(0.0f, 0.0f, 0.0f);
    private float internalRotationAngle = 0.0f;
    protected final Matrix3f matrixRotate = new Matrix3f();
    private final Matrix3f matrixTemp3 = new Matrix3f();
    private final Matrix4f matrixTemp4 = new Matrix4f();
    private final AxisAngle4f axisangleT = new AxisAngle4f();
    private final Vector3f vectorT = new Vector3f();
    private final Vector3f vectorT2 = new Vector3f();
    protected final Point3f pointT = new Point3f();
    private final Point3f pointT2 = new Point3f();
    static final int MAXIMUM_ZOOM_PERCENTAGE = 200000;
    static final int MAXIMUM_ZOOM_PERSPECTIVE_DEPTH = 10000;
    private boolean rotateMolecule;
    Vector3f rotationAxis = new Vector3f();
    float rotationRate = 0.0f;
    protected final Point3f fixedTranslation = new Point3f();
    float xTranslationFraction = 0.5f;
    float yTranslationFraction = 0.5f;
    boolean zoomEnabled = true;
    float zoomPercent = 100.0f;
    float zoomPercentSetting = 100.0f;
    float zoomRatio;
    boolean slabEnabled = false;
    boolean internalSlab = false;
    int slabPercentSetting;
    int depthPercentSetting;
    int slabValue;
    int depthValue;
    Point4f slabPlane = null;
    Point4f depthPlane = null;
    protected boolean perspectiveDepth = true;
    protected boolean scale3D = false;
    protected float cameraDepth = Float.NaN;
    protected float cameraDepthSetting = 3.0f;
    protected float visualRange;
    protected float cameraDistance = 1000.0f;
    int width;
    int height;
    int screenPixelCount;
    float scalePixelsPerAngstrom;
    float scaleDefaultPixelsPerAngstrom;
    float scale3DAngstromsPerInch;
    private boolean antialias;
    private boolean useZoomLarge;
    int screenWidth;
    int screenHeight;
    protected final Matrix4f matrixTransform = new Matrix4f();
    protected final Point3f point3fScreenTemp = new Point3f();
    protected final Point3i point3iScreenTemp = new Point3i();
    private final Point3f point3fVibrationTemp = new Point3f();
    protected boolean navigating = false;
    protected boolean isNavigationMode = false;
    protected final Point3f ptTest1 = new Point3f();
    protected final Point3f ptTest2 = new Point3f();
    protected final Point3f ptTest3 = new Point3f();
    protected final AxisAngle4f aaTest1 = new AxisAngle4f();
    protected final AxisAngle4f aaMoveTo = new AxisAngle4f();
    protected final AxisAngle4f aaStep = new AxisAngle4f();
    protected final AxisAngle4f aaTotal = new AxisAngle4f();
    protected final Matrix3f matrixStart = new Matrix3f();
    private final Matrix3f matrixStartInv = new Matrix3f();
    protected final Matrix3f matrixStep = new Matrix3f();
    protected final Matrix3f matrixTest = new Matrix3f();
    protected final Matrix3f matrixEnd = new Matrix3f();
    protected final Vector3f aaStepCenter = new Vector3f();
    protected final Vector3f aaStepNavCenter = new Vector3f();
    protected Point3f ptMoveToCenter;
    protected boolean spinOn;
    private SpinThread spinThread;
    boolean vibrationOn;
    private float vibrationPeriod;
    public int vibrationPeriodMs;
    private float vibrationAmplitude;
    private float vibrationRadians;
    private float vibrationScale;
    private VibrationThread vibrationThread;
    static final int DEFAULT_STEREO_DEGREES = -5;
    int stereoMode;
    int[] stereoColors;
    float stereoDegrees = Float.NaN;
    float stereoRadians;
    boolean stereoFrame;
    protected final Matrix3f matrixStereo = new Matrix3f();
    boolean windowCentered;
    Point3f[] frameOffsets;
    final Point3f frameOffset = new Point3f();

    protected abstract void calcCameraFactors();

    protected abstract float getPerspectiveFactor(float var1);

    abstract void adjustTemporaryScreenPoint();

    TransformManager() {
    }

    TransformManager(Viewer viewer) {
        this.viewer = viewer;
    }

    TransformManager(Viewer viewer, int width, int height) {
        this.setViewer(viewer, width, height);
    }

    private void setViewer(Viewer viewer, int width, int height) {
        this.viewer = viewer;
        this.setScreenParameters(width, height, true, false, true, true);
    }

    TransformManager getNavigationManager(Viewer viewer, int width, int height) {
        TransformManager11 t = new TransformManager11();
        super.setViewer(viewer, width, height);
        return t;
    }

    void homePosition() {
        Matrix3f m;
        this.rotationCenterDefault.set(this.viewer.getBoundBoxCenter());
        this.setFixedRotationCenter(this.rotationCenterDefault);
        this.rotationRadiusDefault = this.setRotationRadius(0.0f, true);
        this.windowCentered = true;
        this.setRotationCenterAndRadiusXYZ(null, true);
        this.matrixRotate.setIdentity();
        if (this.viewer.getBooleanProperty("autoLoadOrientation") && (m = (Matrix3f)this.viewer.getModelSetAuxiliaryInfo("defaultOrientationMatrix")) != null) {
            this.matrixRotate.set(m);
        }
        this.setZoomEnabled(true);
        this.zoomToPercent(100.0f);
        this.zoomPercent = this.zoomPercentSetting;
        this.slabReset();
        this.scaleFitToScreen(true);
        if (this.viewer.isJmolDataFrame()) {
            this.fixedRotationCenter.set(0.0f, 0.0f, 0.0f);
            this.rotationRadiusDefault = this.viewer.getJmolFrameType(this.viewer.getCurrentModelIndex()).equals("ramachandran") ? 250 : 12;
        } else if (this.viewer.getAxesOrientationRasmol()) {
            this.rotateX((float)Math.PI);
        }
        this.viewer.saveOrientation("default");
        if (this.isNavigationMode) {
            this.setNavigationMode(true);
        }
    }

    void clear() {
        this.clearVibration();
        this.clearSpin();
        this.fixedRotationCenter.set(0.0f, 0.0f, 0.0f);
        this.navigating = false;
        this.slabPlane = null;
        this.depthPlane = null;
        this.resetNavigationPoint(true);
    }

    String getState(StringBuffer sfunc) {
        StringBuffer commands = new StringBuffer("");
        if (sfunc != null) {
            sfunc.append("  _setPerspectiveState;\n");
            commands.append("function _setPerspectiveState() {\n");
        }
        StateManager.appendCmd(commands, "set perspectiveModel " + this.perspectiveModel);
        StateManager.appendCmd(commands, "set scaleAngstromsPerInch " + this.scale3DAngstromsPerInch);
        StateManager.appendCmd(commands, "set perspectiveDepth " + this.perspectiveDepth);
        StateManager.appendCmd(commands, "set visualRange " + this.visualRange);
        if (!this.isWindowCentered()) {
            StateManager.appendCmd(commands, "set windowCentered false");
        }
        StateManager.appendCmd(commands, "set cameraDepth " + this.cameraDepth);
        if (this.isNavigationMode) {
            StateManager.appendCmd(commands, "set navigationMode true");
        }
        StateManager.appendCmd(commands, this.viewer.getBoundBoxCommand(false));
        StateManager.appendCmd(commands, "center " + Escape.escape(this.fixedRotationCenter));
        StateManager.appendCmd(commands, this.getMoveToText(0.0f, false));
        if (this.stereoMode != 0) {
            StateManager.appendCmd(commands, "stereo " + (this.stereoColors == null ? JmolConstants.getStereoModeName(this.stereoMode) : Escape.escapeColor(this.stereoColors[0]) + " " + Escape.escapeColor(this.stereoColors[1])) + " " + this.stereoDegrees);
        }
        if (!this.isNavigationMode && !this.zoomEnabled) {
            StateManager.appendCmd(commands, "zoom off");
        }
        commands.append("  slab ").append(this.slabPercentSetting).append(";depth ").append(this.depthPercentSetting).append(this.slabEnabled && !this.isNavigationMode ? ";slab on" : "").append(";\n");
        if (this.slabPlane != null) {
            commands.append("  slab plane ").append(Escape.escape(this.slabPlane)).append(";\n");
        }
        if (this.depthPlane != null) {
            commands.append("  depth plane ").append(Escape.escape(this.depthPlane)).append(";\n");
        }
        commands.append(this.getSpinState(true)).append("\n");
        if (this.viewer.modelSetHasVibrationVectors() && this.vibrationOn) {
            StateManager.appendCmd(commands, "vibration ON");
        }
        if (this.isNavigationMode) {
            commands.append(this.getNavigationState());
            if (this.depthPlane != null || this.slabPlane != null) {
                commands.append("  slab on;\n");
            }
        }
        if (sfunc != null) {
            commands.append("}\n\n");
        }
        return commands.toString();
    }

    String getSpinState(boolean isAll) {
        String prefix;
        String s = "  set spinX " + (int)this.spinX + "; set spinY " + (int)this.spinY + "; set spinZ " + (int)this.spinZ + "; set spinFps " + (int)this.spinFps + ";";
        if (!this.spinOn) {
            return s;
        }
        String string = prefix = this.isSpinSelected ? "\n  select " + Escape.escape(this.viewer.getSelectionSet()) + ";\n  rotateSelected" : "\n ";
        if (this.isSpinInternal) {
            Point3f pt = new Point3f(this.internalRotationCenter);
            pt.sub(this.rotationAxis);
            s = s + prefix + " spin " + this.rotationRate + " " + Escape.escape(this.internalRotationCenter) + " " + Escape.escape(pt);
        } else {
            s = this.isSpinFixed ? s + prefix + " spin axisangle " + Escape.escape(this.rotationAxis) + " " + this.rotationRate : s + " spin on";
        }
        return s + ";";
    }

    void setRotateMolecule(boolean TF) {
        this.rotateMolecule = TF;
    }

    private void setFixedRotationCenter(Point3f center) {
        if (center == null) {
            return;
        }
        this.fixedRotationCenter.set(center);
    }

    void setRotationPointXY(Point3f center) {
        Point3i newCenterScreen = this.transformPoint(center);
        this.fixedTranslation.set(newCenterScreen.x, newCenterScreen.y, 0.0f);
    }

    float setRotateInternal(Point3f center, Vector3f axis, float degrees) {
        this.internalRotationCenter.set(center);
        this.rotationAxis.set(axis);
        float radians = degrees * ((float)Math.PI / 180);
        this.rotationRate = degrees;
        this.internalRotationAxis.set(axis, radians);
        return radians;
    }

    float setRotateFixed(Point3f center, Vector3f axis, float degrees) {
        this.setFixedRotationCenter(center);
        this.rotationAxis.set(axis);
        float radians = degrees * ((float)Math.PI / 180);
        this.rotationRate = degrees;
        this.fixedRotationAxis.set(axis, radians);
        return radians;
    }

    void rotateXYBy(int xDelta, int yDelta, BitSet bsAtoms) {
        this.rotateXRadians((float)yDelta * ((float)Math.PI / 180), bsAtoms);
        this.rotateYRadians((float)xDelta * ((float)Math.PI / 180), bsAtoms);
    }

    void rotateZBy(int zDelta) {
        this.rotateZRadians((float)Math.PI * (float)zDelta / 180.0f);
    }

    void rotateFront() {
        this.matrixRotate.setIdentity();
    }

    void rotateX(float angleRadians) {
        this.matrixRotate.rotX(angleRadians);
    }

    void rotateY(float angleRadians) {
        this.matrixRotate.rotY(angleRadians);
    }

    void rotateZ(float angleRadians) {
        this.matrixRotate.rotZ(angleRadians);
    }

    private void applyRotation(Matrix3f mNew, boolean isInternal, BitSet bsAtoms) {
        if (bsAtoms == null) {
            this.matrixRotate.mul(mNew, this.matrixRotate);
        } else {
            this.viewer.rotateAtoms(mNew, this.matrixRotate, this.rotateMolecule, this.internalRotationCenter, isInternal, bsAtoms);
        }
    }

    synchronized void rotateXRadians(float angleRadians, BitSet bsAtoms) {
        this.matrixTemp3.rotX(angleRadians);
        this.applyRotation(this.matrixTemp3, false, bsAtoms);
    }

    synchronized void rotateYRadians(float angleRadians, BitSet bsAtoms) {
        this.matrixTemp3.rotY(angleRadians);
        this.applyRotation(this.matrixTemp3, false, bsAtoms);
    }

    synchronized void rotateZRadians(float angleRadians) {
        this.matrixTemp3.rotZ(angleRadians);
        this.applyRotation(this.matrixTemp3, false, null);
    }

    protected void rotateAxisAngle(Vector3f rotAxis, float radians) {
        this.axisangleT.set(rotAxis, radians);
        this.rotateAxisAngle(this.axisangleT, null);
    }

    synchronized void rotateAxisAngle(AxisAngle4f axisAngle, BitSet bsAtoms) {
        this.matrixTemp3.setIdentity();
        this.matrixTemp3.set(axisAngle);
        this.applyRotation(this.matrixTemp3, false, bsAtoms);
    }

    void rotateAxisAngleAtCenter(Point3f rotCenter, Vector3f rotAxis, float degrees, float endDegrees, boolean isSpin, BitSet bsAtoms) {
        if (rotCenter != null) {
            this.moveRotationCenter(rotCenter, true);
        }
        this.setSpinOn(false);
        if (Float.isNaN(degrees) || degrees == 0.0f) {
            return;
        }
        if (rotCenter != null) {
            this.setRotationPointXY(rotCenter);
        }
        float angle = this.setRotateFixed(rotCenter, rotAxis, degrees);
        if (isSpin) {
            this.isSpinInternal = false;
            this.isSpinFixed = true;
            this.isSpinSelected = bsAtoms != null;
            this.setSpinOn(true, endDegrees, bsAtoms);
            return;
        }
        this.rotateAxisAngleRadiansFixed(angle, bsAtoms);
    }

    synchronized void rotateAxisAngleRadiansFixed(float angleRadians, BitSet bsAtoms) {
        this.axisangleT.set(this.fixedRotationAxis);
        this.axisangleT.angle = angleRadians;
        this.rotateAxisAngle(this.axisangleT, bsAtoms);
    }

    void rotateAboutPointsInternal(Point3f point1, Point3f point2, float degrees, float endDegrees, boolean isClockwise, boolean isSpin, BitSet bsAtoms) {
        boolean isSelected;
        this.setSpinOn(false);
        if (Float.isNaN(degrees) || degrees == 0.0f) {
            return;
        }
        Vector3f axis = new Vector3f(point1);
        axis.sub(point2);
        if (isClockwise) {
            axis.scale(-1.0f);
        }
        float angle = this.setRotateInternal(point1, axis, degrees);
        boolean bl = isSelected = bsAtoms != null;
        if (isSpin) {
            this.isSpinInternal = true;
            this.isSpinFixed = false;
            this.isSpinSelected = isSelected;
            this.setSpinOn(true, endDegrees, bsAtoms);
            return;
        }
        this.rotateAxisAngleRadiansInternal(angle, bsAtoms);
    }

    synchronized void rotateAxisAngleRadiansInternal(float radians, BitSet bsAtoms) {
        this.internalRotationAngle = radians;
        this.vectorT.set(this.internalRotationAxis.x, this.internalRotationAxis.y, this.internalRotationAxis.z);
        this.matrixRotate.transform(this.vectorT, this.vectorT2);
        this.axisangleT.set(this.vectorT2, radians);
        this.matrixTemp3.set(this.axisangleT);
        this.applyRotation(this.matrixTemp3, true, bsAtoms);
        if (bsAtoms == null) {
            this.getNewFixedRotationCenter();
        }
    }

    void getNewFixedRotationCenter() {
        this.axisangleT.set(this.internalRotationAxis);
        this.axisangleT.angle = -this.internalRotationAngle;
        this.matrixTemp4.set(this.axisangleT);
        this.vectorT.set(this.internalRotationCenter);
        this.pointT2.set(this.fixedRotationCenter);
        this.pointT2.sub(this.vectorT);
        this.matrixTemp4.transform(this.pointT2, this.pointT);
        this.pointT.add(this.vectorT);
        this.setRotationCenterAndRadiusXYZ(this.pointT, false);
    }

    void setTranslationFractions() {
        this.xTranslationFraction = this.fixedTranslation.x / (float)this.width;
        this.yTranslationFraction = this.fixedTranslation.y / (float)this.height;
    }

    void translateXYBy(int xDelta, int yDelta) {
        this.fixedTranslation.x += (float)xDelta;
        this.fixedTranslation.y += (float)yDelta;
        this.setTranslationFractions();
    }

    int percentToPixels(char xyz, float percent) {
        switch (xyz) {
            case 'x': {
                return (int)(percent / 100.0f * (float)this.width);
            }
            case 'y': {
                return (int)(percent / 100.0f * (float)this.height);
            }
            case 'z': {
                return (int)(percent / 100.0f * (float)this.screenPixelCount);
            }
        }
        return 0;
    }

    int angstromsToPixels(float distance) {
        return (int)(this.scalePixelsPerAngstrom * distance);
    }

    void translateToXPercent(float percent) {
        this.xTranslationFraction = 0.5f + percent / 100.0f;
        this.fixedTranslation.x = (float)this.width * this.xTranslationFraction;
    }

    void translateToYPercent(float percent) {
        this.yTranslationFraction = 0.5f + percent / 100.0f;
        this.fixedTranslation.y = (float)this.height * this.yTranslationFraction;
    }

    void translateToZPercent(float percent) {
        if (!this.isNavigationMode) {
            return;
        }
        this.setNavigationDepthPercent(0.0f, percent);
    }

    float getTranslationXPercent() {
        return (this.fixedTranslation.x - (float)(this.width / 2)) * 100.0f / (float)this.width;
    }

    float getTranslationYPercent() {
        return (this.fixedTranslation.y - (float)(this.height / 2)) * 100.0f / (float)this.height;
    }

    float getTranslationZPercent() {
        return 0.0f;
    }

    String getTranslationScript() {
        String info = "";
        float f = this.getTranslationXPercent();
        if ((double)f != 0.0) {
            info = info + "translate x " + f + ";";
        }
        if ((double)(f = this.getTranslationYPercent()) != 0.0) {
            info = info + "translate y " + f + ";";
        }
        return info;
    }

    String getOrientationText(int type) {
        switch (type) {
            case 4133: {
                return this.getMoveToText(1.0f, false);
            }
            case 1073741874: {
                return this.getRotationText(true);
            }
            case 1073741886: {
                StringBuffer sb = new StringBuffer();
                TransformManager.truncate2(sb, this.getTranslationXPercent());
                TransformManager.truncate2(sb, this.getTranslationYPercent());
                return sb.toString();
            }
        }
        return this.getMoveToText(1.0f, true) + "\n#OR\n" + this.getRotateZyzText(true);
    }

    Hashtable getOrientationInfo() {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("moveTo", this.getMoveToText(1.0f, false));
        info.put("center", "center " + this.getCenterText());
        info.put("rotateZYZ", this.getRotateZyzText(false));
        info.put("rotateXYZ", this.getRotateXyzText());
        info.put("transXPercent", new Float(this.getTranslationXPercent()));
        info.put("transYPercent", new Float(this.getTranslationYPercent()));
        info.put("zoom", new Float(this.zoomPercent));
        info.put("modelRadius", new Float(this.modelRadius));
        if (this.isNavigationMode) {
            info.put("navigationCenter", "navigate center " + Escape.escape(this.navigationCenter));
            info.put("navigationOffsetXPercent", new Float(this.getNavigationOffsetPercent('X')));
            info.put("navigationOffsetYPercent", new Float(this.getNavigationOffsetPercent('Y')));
            info.put("navigationDepthPercent", new Float(this.getNavigationDepthPercent()));
        }
        return info;
    }

    void getAxisAngle(AxisAngle4f axisAngle) {
        axisAngle.set(this.matrixRotate);
    }

    String getTransformText() {
        return this.matrixRotate.toString();
    }

    Matrix3f getMatrixRotate() {
        return this.matrixRotate;
    }

    void setRotation(Matrix3f matrixRotation) {
        this.matrixRotate.set(matrixRotation);
    }

    void getRotation(Matrix3f matrixRotation) {
        matrixRotation.set(this.matrixRotate);
    }

    protected void zoomBy(int pixels) {
        if (pixels > 20) {
            pixels = 20;
        } else if (pixels < -20) {
            pixels = -20;
        }
        float deltaPercent = (float)pixels * this.zoomPercentSetting / 50.0f;
        if (deltaPercent == 0.0f) {
            deltaPercent = pixels > 0 ? 1 : (deltaPercent < 0.0f ? -1 : 0);
        }
        this.zoomRatio = (deltaPercent + this.zoomPercentSetting) / this.zoomPercentSetting;
        this.zoomPercentSetting += deltaPercent;
    }

    float getZoomPercentFloat() {
        return this.zoomPercent;
    }

    void zoomToPercent(float percentZoom) {
        this.zoomPercentSetting = percentZoom;
        this.zoomRatio = 0.0f;
    }

    void translateZBy(int pixels) {
        if (pixels >= this.screenPixelCount) {
            return;
        }
        float sppa = this.scalePixelsPerAngstrom / (1.0f - (float)pixels * 1.0f / (float)this.screenPixelCount);
        if (sppa >= (float)this.screenPixelCount) {
            return;
        }
        float newZoomPercent = sppa / this.scaleDefaultPixelsPerAngstrom * 100.0f;
        this.zoomRatio = newZoomPercent / this.zoomPercentSetting;
        this.zoomPercentSetting = newZoomPercent;
    }

    void zoomByFactor(float factor) {
        if (factor <= 0.0f) {
            return;
        }
        this.zoomRatio = factor;
        this.zoomPercentSetting *= factor;
    }

    void zoomByPercent(float percentZoom) {
        float deltaPercent = percentZoom * this.zoomPercentSetting / 100.0f;
        if (deltaPercent == 0.0f) {
            deltaPercent = percentZoom < 0.0f ? -1.0f : 1.0f;
        }
        this.zoomRatio = (deltaPercent + this.zoomPercentSetting) / this.zoomPercentSetting;
        this.zoomPercentSetting += deltaPercent;
    }

    void setZoomEnabled(boolean zoomEnabled) {
        if (this.zoomEnabled != zoomEnabled) {
            this.zoomEnabled = zoomEnabled;
        }
    }

    void setScaleAngstromsPerInch(float angstromsPerInch) {
        boolean bl = this.scale3D = angstromsPerInch > 0.0f;
        if (this.scale3D) {
            this.scale3DAngstromsPerInch = angstromsPerInch;
        }
        this.perspectiveDepth = !this.scale3D;
    }

    void setSlabEnabled(boolean slabEnabled) {
        this.slabEnabled = slabEnabled;
        this.viewer.getGlobalSettings().setParameterValue("slabEnabled", slabEnabled);
    }

    void slabReset() {
        this.slabToPercent(100);
        this.depthToPercent(0);
        this.depthPlane = null;
        this.slabPlane = null;
        this.setSlabEnabled(false);
    }

    int getSlabPercentSetting() {
        return this.slabPercentSetting;
    }

    void slabByPercentagePoints(int percentage) {
        this.slabPlane = null;
        this.slabPercentSetting += percentage;
        if (this.depthPercentSetting >= this.slabPercentSetting) {
            this.depthPercentSetting = this.slabPercentSetting - 1;
        }
    }

    void depthByPercentagePoints(int percentage) {
        this.depthPlane = null;
        this.depthPercentSetting += percentage;
        if (this.slabPercentSetting <= this.depthPercentSetting) {
            this.slabPercentSetting = this.depthPercentSetting + 1;
        }
    }

    void slabDepthByPercentagePoints(int percentage) {
        this.slabPlane = null;
        this.depthPlane = null;
        this.slabPercentSetting += percentage;
        this.depthPercentSetting += percentage;
    }

    void slabToPercent(int percentSlab) {
        this.slabPercentSetting = percentSlab;
        this.slabPlane = null;
        if (this.depthPercentSetting >= this.slabPercentSetting) {
            this.depthPercentSetting = this.slabPercentSetting - 1;
        }
    }

    void depthToPercent(int percentDepth) {
        this.depthPercentSetting = percentDepth;
        if (this.slabPercentSetting <= this.depthPercentSetting) {
            this.slabPercentSetting = this.depthPercentSetting + 1;
        }
    }

    void slabInternal(Point4f plane, boolean isDepth) {
        if (isDepth) {
            this.depthPlane = plane;
            this.depthPercentSetting = 0;
        } else {
            this.slabPlane = plane;
            this.slabPercentSetting = 100;
        }
    }

    void setSlabDepthInternal(boolean isDepth) {
        this.finalizeTransformParameters();
        if (isDepth) {
            this.depthPlane = null;
        } else {
            this.slabPlane = null;
        }
        this.slabInternal(this.getSlabDepthPlane(isDepth), isDepth);
    }

    Point4f getSlabDepthPlane(boolean isDepth) {
        if (isDepth) {
            if (this.depthPlane != null) {
                return this.depthPlane;
            }
        } else if (this.slabPlane != null) {
            return this.slabPlane;
        }
        Matrix4f m = this.matrixTransform;
        return new Point4f(-m.m20, -m.m21, -m.m22, -m.m23 + (float)(isDepth ? this.depthValue : this.slabValue));
    }

    boolean checkInternalSlab(Point3f pt) {
        return this.slabPlane != null && pt.x * this.slabPlane.x + pt.y * this.slabPlane.y + pt.z * this.slabPlane.z + this.slabPlane.w > 0.0f || this.depthPlane != null && pt.x * this.depthPlane.x + pt.y * this.depthPlane.y + pt.z * this.depthPlane.z + this.depthPlane.w < 0.0f;
    }

    void setPerspectiveDepth(boolean perspectiveDepth) {
        if (this.perspectiveDepth == perspectiveDepth) {
            return;
        }
        this.perspectiveDepth = perspectiveDepth;
        this.scaleFitToScreen(false);
    }

    boolean getPerspectiveDepth() {
        return this.perspectiveDepth;
    }

    void setCameraDepthPercent(float percent) {
        float screenMultiples;
        this.resetNavigationPoint(true);
        float f = screenMultiples = percent < 0.0f ? -percent / 100.0f : percent;
        if (screenMultiples == 0.0f) {
            return;
        }
        this.cameraDepthSetting = screenMultiples;
        this.cameraDepth = Float.NaN;
    }

    void setVisualRange(float angstroms) {
        this.visualRange = angstroms;
    }

    Matrix4f getUnscaledTransformMatrix() {
        Matrix4f unscaled = new Matrix4f();
        unscaled.setIdentity();
        this.vectorTemp.set(this.fixedRotationCenter);
        this.matrixTemp.setZero();
        this.matrixTemp.setTranslation(this.vectorTemp);
        unscaled.sub(this.matrixTemp);
        this.matrixTemp.set(this.matrixRotate);
        unscaled.mul(this.matrixTemp, unscaled);
        return unscaled;
    }

    void setScreenParameters(int screenWidth, int screenHeight, boolean useZoomLarge, boolean antialias, boolean resetSlab, boolean resetZoom) {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.useZoomLarge = useZoomLarge;
        this.antialias = antialias;
        this.width = antialias ? screenWidth * 2 : screenWidth;
        this.height = antialias ? screenHeight * 2 : screenHeight;
        this.scaleFitToScreen(false, useZoomLarge, resetSlab, resetZoom);
        this.finalizeTransformParameters();
    }

    void setAntialias(boolean TF) {
        boolean isNew = this.antialias != TF;
        this.antialias = TF;
        this.width = this.antialias ? this.screenWidth * 2 : this.screenWidth;
        int n = this.height = this.antialias ? this.screenHeight * 2 : this.screenHeight;
        if (isNew) {
            this.scaleFitToScreen(false, this.useZoomLarge, false, false);
        }
    }

    private float defaultScaleToScreen(float radius) {
        return (float)this.screenPixelCount / 2.0f / radius;
    }

    void scaleFitToScreen(boolean andCenter) {
        this.scaleFitToScreen(andCenter, this.viewer.getZoomLarge(), true, true);
    }

    void scaleFitToScreen(boolean andCenter, boolean zoomLarge, boolean resetSlab, boolean resetZoom) {
        if (this.width == 0 || this.height == 0) {
            this.screenPixelCount = 1;
        } else {
            this.fixedTranslation.set((float)this.width * (andCenter ? 0.5f : this.xTranslationFraction), (float)this.height * (andCenter ? 0.5f : this.yTranslationFraction), 0.0f);
            this.setTranslationFractions();
            if (resetZoom) {
                this.resetNavigationPoint(resetSlab);
            }
            int n = this.screenPixelCount = zoomLarge == this.height > this.width ? this.height : this.width;
        }
        if (this.screenPixelCount > 2) {
            this.screenPixelCount -= 2;
        }
        this.scaleDefaultPixelsPerAngstrom = this.defaultScaleToScreen(this.modelRadius);
    }

    short scaleToScreen(int z, int milliAngstroms) {
        if (milliAngstroms == 0 || z < 2) {
            return 0;
        }
        int pixelSize = (int)this.scaleToPerspective(z, (float)milliAngstroms * this.scalePixelsPerAngstrom / 1000.0f);
        return (short)(pixelSize > 0 ? pixelSize : 1);
    }

    float scaleToPerspective(int z, float sizeAngstroms) {
        return this.perspectiveDepth ? sizeAngstroms * this.getPerspectiveFactor(z) : sizeAngstroms;
    }

    Matrix4f getMatrixtransform() {
        return this.matrixTransform;
    }

    void setNavigationMode(boolean TF) {
        this.isNavigationMode = TF && this.canNavigate();
        this.resetNavigationPoint(true);
    }

    boolean getNavigating() {
        return this.navigating;
    }

    synchronized void finalizeTransformParameters() {
        this.haveNotifiedNaN = false;
        this.fixedRotationOffset.set(this.fixedTranslation);
        this.internalSlab = this.slabEnabled && (this.slabPlane != null || this.depthPlane != null);
        float newZoom = this.getZoomSetting();
        if (this.zoomPercent != newZoom) {
            this.zoomPercent = newZoom;
            if (!this.viewer.getFontCaching()) {
                Text3D.clearFontCache();
            }
        }
        this.calcCameraFactors();
        this.calcTransformMatrix();
        if (this.isNavigationMode) {
            this.calcNavigationPoint();
        } else {
            this.calcSlabAndDepthValues();
        }
    }

    float getZoomSetting() {
        if (this.zoomPercentSetting < 5.0f) {
            this.zoomPercentSetting = 5.0f;
        }
        if (this.zoomPercentSetting > 200000.0f) {
            this.zoomPercentSetting = 200000.0f;
        }
        return this.zoomEnabled || this.isNavigationMode ? this.zoomPercentSetting : 100.0f;
    }

    protected void calcSlabAndDepthValues() {
        this.slabValue = this.zValueFromPercent(this.slabPercentSetting);
        this.depthValue = this.zValueFromPercent(this.depthPercentSetting);
        this.viewer.getGlobalSettings().setParameterValue("_slabPlane", Escape.escape(this.getSlabDepthPlane(false)));
        this.viewer.getGlobalSettings().setParameterValue("_depthPlane", Escape.escape(this.getSlabDepthPlane(true)));
        if (this.slabEnabled) {
            return;
        }
        this.slabValue = 0;
        this.depthValue = Integer.MAX_VALUE;
    }

    int zValueFromPercent(int zPercent) {
        return (int)((1.0f - (float)zPercent / 50.0f) * this.modelRadiusPixels + this.modelCenterOffset);
    }

    protected synchronized void calcTransformMatrix() {
        this.matrixTransform.setIdentity();
        this.vectorTemp.set(this.fixedRotationCenter);
        this.vectorTemp.sub(this.frameOffset);
        this.matrixTemp.setZero();
        this.matrixTemp.setTranslation(this.vectorTemp);
        this.matrixTransform.sub(this.matrixTemp);
        this.matrixTemp.set(this.stereoFrame ? this.matrixStereo : this.matrixRotate);
        this.matrixTransform.mul(this.matrixTemp, this.matrixTransform);
        this.matrixTemp.setZero();
        this.matrixTemp.set(this.scalePixelsPerAngstrom);
        this.matrixTemp.m11 = this.matrixTemp.m22 = -this.scalePixelsPerAngstrom;
        this.matrixTransform.mul(this.matrixTemp, this.matrixTransform);
        this.matrixTransform.m23 += this.modelCenterOffset;
    }

    void rotatePoint(Point3f pt, Point3f ptRot) {
        this.matrixRotate.transform(pt, ptRot);
        ptRot.y = -ptRot.y;
    }

    void transformPoints(int count, Point3f[] angstroms, Point3i[] screens) {
        int i = count;
        while (--i >= 0) {
            screens[i].set(this.transformPoint(angstroms[i]));
        }
    }

    void transformPoint(Point3f pointAngstroms, Point3i pointScreen) {
        pointScreen.set(this.transformPoint(pointAngstroms));
    }

    void transformPointNoClip(Point3f pointAngstroms, Point3f pointScreen) {
        pointScreen.set(this.transformPointNoClip(pointAngstroms));
    }

    synchronized Point3i transformPoint(Point3f pointAngstroms) {
        if (pointAngstroms.z == Float.MAX_VALUE || pointAngstroms.z == -3.4028235E38f) {
            return this.transformScreenPoint(pointAngstroms);
        }
        this.matrixTransform.transform(pointAngstroms, this.point3fScreenTemp);
        this.adjustTemporaryScreenPoint();
        if (this.internalSlab && this.checkInternalSlab(pointAngstroms)) {
            this.point3iScreenTemp.z = 1;
        }
        return this.point3iScreenTemp;
    }

    private Point3i transformScreenPoint(Point3f ptXyp) {
        if (ptXyp.z == -3.4028235E38f) {
            this.point3iScreenTemp.x = (int)(ptXyp.x / 100.0f * (float)this.screenWidth);
            this.point3iScreenTemp.y = (int)((1.0f - ptXyp.y / 100.0f) * (float)this.screenHeight);
        } else {
            this.point3iScreenTemp.x = (int)ptXyp.x;
            this.point3iScreenTemp.y = this.screenHeight - (int)ptXyp.y;
        }
        if (this.antialias) {
            this.point3iScreenTemp.x <<= 1;
            this.point3iScreenTemp.y <<= 1;
        }
        this.matrixTransform.transform(this.fixedRotationCenter, this.pointT);
        this.point3iScreenTemp.z = (int)this.pointT.z;
        return this.point3iScreenTemp;
    }

    synchronized Point3f transformPointNoClip(Point3f pointAngstroms) {
        this.matrixTransform.transform(pointAngstroms, this.point3fScreenTemp);
        this.adjustTemporaryScreenPoint();
        return this.point3fScreenTemp;
    }

    Point3i transformPoint(Point3f pointAngstroms, Vector3f vibrationVector) {
        this.point3fVibrationTemp.set(pointAngstroms);
        if (this.vibrationOn && vibrationVector != null) {
            this.point3fVibrationTemp.scaleAdd(this.vibrationAmplitude, vibrationVector, pointAngstroms);
        }
        this.matrixTransform.transform(this.point3fVibrationTemp, this.point3fScreenTemp);
        this.adjustTemporaryScreenPoint();
        if (this.internalSlab && this.checkInternalSlab(pointAngstroms)) {
            this.point3iScreenTemp.z = 1;
        }
        return this.point3iScreenTemp;
    }

    void transformPoint(Point3f pointAngstroms, Point3f screen) {
        this.matrixTransform.transform(pointAngstroms, this.point3fScreenTemp);
        this.adjustTemporaryScreenPoint();
        if (this.internalSlab && this.checkInternalSlab(pointAngstroms)) {
            this.point3fScreenTemp.z = 1.0f;
        }
        screen.set(this.point3fScreenTemp);
    }

    void transformVector(Vector3f vectorAngstroms, Vector3f vectorTransformed) {
        this.matrixTransform.transform(vectorAngstroms, vectorTransformed);
    }

    void unTransformPoint(Point3f screenPt, Point3f coordPt) {
        this.pointT.set(screenPt);
        if (this.isNavigationMode) {
            this.pointT.x -= this.navigationOffset.x;
            this.pointT.y -= this.navigationOffset.y;
        } else {
            this.pointT.x -= this.fixedRotationOffset.x;
            this.pointT.y -= this.fixedRotationOffset.y;
        }
        if (this.perspectiveDepth) {
            float factor = this.getPerspectiveFactor(this.pointT.z);
            this.pointT.x /= factor;
            this.pointT.y /= factor;
        }
        if (this.isNavigationMode) {
            this.pointT.x += this.navigationShiftXY.x;
            this.pointT.y += this.navigationShiftXY.y;
        }
        this.matrixUnTransform(this.pointT, coordPt);
    }

    protected void matrixUnTransform(Point3f screen, Point3f angstroms) {
        this.matrixTemp.invert(this.matrixTransform);
        this.matrixTemp.transform(screen, angstroms);
    }

    void move(Vector3f dRot, float dZoom, Vector3f dTrans, float dSlab, float floatSecondsTotal, int fps) {
        int slab = this.getSlabPercentSetting();
        float transX = this.getTranslationXPercent();
        float transY = this.getTranslationYPercent();
        float transZ = this.getTranslationZPercent();
        long timeBegin = System.currentTimeMillis();
        int timePerStep = 1000 / fps;
        int totalSteps = (int)((float)fps * floatSecondsTotal);
        if (totalSteps <= 0) {
            totalSteps = 1;
        }
        float radiansPerDegreePerStep = (float)Math.PI / 180 / (float)totalSteps;
        float radiansXStep = radiansPerDegreePerStep * dRot.x;
        float radiansYStep = radiansPerDegreePerStep * dRot.y;
        float radiansZStep = radiansPerDegreePerStep * dRot.z;
        if (floatSecondsTotal > 0.0f) {
            this.viewer.setInMotion(true);
        }
        float zoomPercent0 = this.zoomPercent;
        for (int i = 1; i <= totalSteps; ++i) {
            int timeAllowed;
            int timeSpent;
            if (dRot.x != 0.0f) {
                this.rotateXRadians(radiansXStep, null);
            }
            if (dRot.y != 0.0f) {
                this.rotateYRadians(radiansYStep, null);
            }
            if (dRot.z != 0.0f) {
                this.rotateZRadians(radiansZStep);
            }
            if (dZoom != 0.0f) {
                this.zoomToPercent(zoomPercent0 + dZoom * (float)i / (float)totalSteps);
            }
            if (dTrans.x != 0.0f) {
                this.translateToXPercent(transX + dTrans.x * (float)i / (float)totalSteps);
            }
            if (dTrans.y != 0.0f) {
                this.translateToYPercent(transY + dTrans.y * (float)i / (float)totalSteps);
            }
            if (dTrans.z != 0.0f) {
                this.translateToZPercent(transZ + dTrans.z * (float)i / (float)totalSteps);
            }
            if (dSlab != 0.0f) {
                this.slabToPercent((int)((float)slab + dSlab * (float)i / (float)totalSteps));
            }
            if ((timeSpent = (int)(System.currentTimeMillis() - timeBegin)) >= (timeAllowed = i * timePerStep)) continue;
            this.viewer.requestRepaintAndWait();
            if (!this.viewer.isScriptExecuting()) break;
            timeSpent = (int)(System.currentTimeMillis() - timeBegin);
            int timeToSleep = timeAllowed - timeSpent;
            if (timeToSleep <= 0) continue;
            try {
                Thread.sleep(timeToSleep);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.viewer.setInMotion(false);
    }

    boolean isInPosition(Point3f pt, float degrees) {
        this.aaTest1.set(new Vector3f(pt), degrees * (float)Math.PI / 180.0f);
        this.ptTest1.set(4.321f, 1.23456f, 3.14159f);
        this.getRotation(this.matrixTest);
        this.matrixTest.transform(this.ptTest1, this.ptTest2);
        this.matrixTest.set(this.aaTest1);
        this.matrixTest.transform(this.ptTest1, this.ptTest3);
        return (double)this.ptTest3.distance(this.ptTest2) < 0.1;
    }

    void moveTo(float floatSecondsTotal, Point3f center, Point3f pt, float degrees, float zoom, float xTrans, float yTrans, float newRotationRadius, Point3f navCenter, float xNav, float yNav, float navDepth) {
        Vector3f axis = new Vector3f(pt);
        if (Float.isNaN(degrees)) {
            this.getRotation(this.matrixEnd);
        } else if (degrees < 0.01f && degrees > -0.01f) {
            this.matrixEnd.setIdentity();
        } else {
            if (axis.x == 0.0f && axis.y == 0.0f && axis.z == 0.0f) {
                int sleepTime = (int)(floatSecondsTotal * 1000.0f) - 30;
                if (sleepTime > 0) {
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
                return;
            }
            this.aaMoveTo.set(axis, degrees * (float)Math.PI / 180.0f);
            this.matrixEnd.set(this.aaMoveTo);
        }
        this.moveTo(floatSecondsTotal, null, center, zoom, xTrans, yTrans, newRotationRadius, navCenter, xNav, yNav, navDepth);
    }

    void moveTo(float floatSecondsTotal, Matrix3f end, Point3f center, float zoom, float xTrans, float yTrans, float newRotationRadius, Point3f navCenter, float xNav, float yNav, float navDepth) {
        float targetPixelScale;
        if (end != null) {
            this.matrixEnd.set(end);
        }
        this.ptMoveToCenter = center == null ? this.fixedRotationCenter : center;
        float startRotationRadius = this.modelRadius;
        float targetRotationRadius = center == null ? this.modelRadius : (newRotationRadius <= 0.0f ? this.viewer.calcRotationRadius(center) : newRotationRadius);
        float startPixelScale = this.scaleDefaultPixelsPerAngstrom;
        float f = targetPixelScale = center == null ? startPixelScale : this.defaultScaleToScreen(targetRotationRadius);
        if (Float.isNaN(zoom)) {
            zoom = this.zoomPercent;
        }
        this.getRotation(this.matrixStart);
        this.matrixStartInv.invert(this.matrixStart);
        this.matrixStep.mul(this.matrixEnd, this.matrixStartInv);
        this.aaTotal.set(this.matrixStep);
        int fps = 30;
        int totalSteps = (int)(floatSecondsTotal * (float)fps);
        if (floatSecondsTotal > 0.0f) {
            this.viewer.setInMotion(true);
        }
        if (totalSteps > 1) {
            int frameTimeMillis = 1000 / fps;
            long targetTime = System.currentTimeMillis();
            float zoomStart = this.zoomPercent;
            float zoomDelta = zoom - zoomStart;
            float xTransStart = this.getTranslationXPercent();
            float xTransDelta = xTrans - xTransStart;
            float yTransStart = this.getTranslationYPercent();
            float yTransDelta = yTrans - yTransStart;
            this.aaStepCenter.set(this.ptMoveToCenter);
            this.aaStepCenter.sub(this.fixedRotationCenter);
            this.aaStepCenter.scale(1.0f / (float)totalSteps);
            float pixelScaleDelta = targetPixelScale - startPixelScale;
            float rotationRadiusDelta = targetRotationRadius - startRotationRadius;
            if (navCenter != null && this.isNavigationMode) {
                this.aaStepNavCenter.set(navCenter);
                this.aaStepNavCenter.sub(this.navigationCenter);
                this.aaStepNavCenter.scale(1.0f / (float)totalSteps);
            }
            float xNavTransStart = this.getNavigationOffsetPercent('X');
            float xNavTransDelta = xNav - xNavTransStart;
            float yNavTransStart = this.getNavigationOffsetPercent('Y');
            float yNavTransDelta = yNav - yNavTransStart;
            float navDepthStart = this.getNavigationDepthPercent();
            float navDepthDelta = navDepth - navDepthStart;
            for (int iStep = 1; iStep < totalSteps; ++iStep) {
                this.getRotation(this.matrixStart);
                this.matrixStartInv.invert(this.matrixStart);
                this.matrixStep.mul(this.matrixEnd, this.matrixStartInv);
                this.aaTotal.set(this.matrixStep);
                this.aaStep.set(this.aaTotal);
                this.aaStep.angle /= (float)(totalSteps - iStep);
                if (this.aaStep.angle == 0.0f) {
                    this.matrixStep.setIdentity();
                } else {
                    this.matrixStep.set(this.aaStep);
                }
                this.matrixStep.mul(this.matrixStart);
                float fStep = (float)iStep / ((float)totalSteps - 1.0f);
                this.modelRadius = startRotationRadius + rotationRadiusDelta * fStep;
                this.scaleDefaultPixelsPerAngstrom = startPixelScale + pixelScaleDelta * fStep;
                if (!Float.isNaN(xTrans)) {
                    this.zoomToPercent(zoomStart + zoomDelta * fStep);
                    this.translateToXPercent(xTransStart + xTransDelta * fStep);
                    this.translateToYPercent(yTransStart + yTransDelta * fStep);
                }
                this.setRotation(this.matrixStep);
                if (center != null) {
                    this.fixedRotationCenter.add(this.aaStepCenter);
                }
                if (navCenter != null && this.isNavigationMode) {
                    this.navigationCenter.add(this.aaStepNavCenter);
                    this.navigate(0.0f, this.navigationCenter);
                    if (!Float.isNaN(xNav) && !Float.isNaN(yNav)) {
                        this.navTranslatePercent(0.0f, xNavTransStart + xNavTransDelta * fStep, yNavTransStart + yNavTransDelta * fStep);
                    }
                    if (!Float.isNaN(navDepth)) {
                        this.setNavigationDepthPercent(0.0f, navDepthStart + navDepthDelta * fStep);
                    }
                }
                if (System.currentTimeMillis() >= (targetTime += (long)frameTimeMillis)) continue;
                this.viewer.requestRepaintAndWait();
                if (this.viewer.isScriptExecuting()) {
                    int sleepTime = (int)(targetTime - System.currentTimeMillis());
                    if (sleepTime <= 0) continue;
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    continue;
                }
                break;
            }
        } else {
            int sleepTime = (int)(floatSecondsTotal * 1000.0f) - 30;
            if (sleepTime > 0) {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }
        this.setRotationRadius(targetRotationRadius, true);
        this.scaleDefaultPixelsPerAngstrom = targetPixelScale;
        if (center != null) {
            this.moveRotationCenter(center, !this.windowCentered);
        }
        if (!Float.isNaN(xTrans)) {
            this.zoomToPercent(zoom);
            this.translateToXPercent(xTrans);
            this.translateToYPercent(yTrans);
        }
        this.setRotation(this.matrixEnd);
        if (navCenter != null && this.isNavigationMode) {
            this.navigationCenter.set(navCenter);
            if (!Float.isNaN(xNav) && !Float.isNaN(yNav)) {
                this.navTranslatePercent(0.0f, xNav, yNav);
            }
            if (!Float.isNaN(navDepth)) {
                this.setNavigationDepthPercent(0.0f, navDepth);
            }
        }
        this.viewer.setInMotion(false);
    }

    String getRotationText(boolean asQuaternion) {
        this.axisangleT.set(this.matrixRotate);
        float degrees = this.axisangleT.angle * 57.29578f;
        StringBuffer sb = new StringBuffer();
        this.vectorT.set(this.axisangleT.x, this.axisangleT.y, this.axisangleT.z);
        if (asQuaternion) {
            return new Quaternion(this.vectorT, degrees).toString();
        }
        if (degrees < 0.01f) {
            return "{0 0 1 0}";
        }
        this.vectorT.normalize();
        this.vectorT.scale(1000.0f);
        sb.append("{");
        TransformManager.truncate0(sb, this.vectorT.x);
        TransformManager.truncate0(sb, this.vectorT.y);
        TransformManager.truncate0(sb, this.vectorT.z);
        TransformManager.truncate2(sb, degrees);
        sb.append("}");
        return sb.toString();
    }

    String getMoveToText(float timespan, boolean addComments) {
        StringBuffer sb = new StringBuffer();
        sb.append("moveto ");
        if (addComments) {
            sb.append("/* time, axisAngle */ ");
        }
        sb.append(timespan);
        sb.append(" ").append(this.getRotationText(false));
        if (addComments) {
            sb.append(" /* zoom, translation */ ");
        }
        TransformManager.truncate2(sb, this.zoomPercentSetting);
        TransformManager.truncate2(sb, this.getTranslationXPercent());
        TransformManager.truncate2(sb, this.getTranslationYPercent());
        sb.append(" ");
        if (addComments) {
            sb.append(" /* center, rotationRadius */ ");
        }
        sb.append(this.getCenterText());
        sb.append(" ").append(this.modelRadius);
        sb.append(this.getNavigationText(addComments));
        sb.append(";");
        return sb.toString();
    }

    private String getCenterText() {
        return Escape.escape(this.fixedRotationCenter);
    }

    private String getRotateXyzText() {
        float rZ;
        float rX;
        StringBuffer sb = new StringBuffer();
        float m20 = this.matrixRotate.m20;
        float rY = -((float)Math.asin(m20)) * 57.29578f;
        if (m20 > 0.999f || m20 < -0.999f) {
            rX = -((float)Math.atan2(this.matrixRotate.m12, this.matrixRotate.m11)) * 57.29578f;
            rZ = 0.0f;
        } else {
            rX = (float)Math.atan2(this.matrixRotate.m21, this.matrixRotate.m22) * 57.29578f;
            rZ = (float)Math.atan2(this.matrixRotate.m10, this.matrixRotate.m00) * 57.29578f;
        }
        sb.append("reset");
        sb.append(";center ").append(this.getCenterText());
        if (rX != 0.0f) {
            sb.append("; rotate x");
            TransformManager.truncate2(sb, rX);
        }
        if (rY != 0.0f) {
            sb.append("; rotate y");
            TransformManager.truncate2(sb, rY);
        }
        if (rZ != 0.0f) {
            sb.append("; rotate z");
            TransformManager.truncate2(sb, rZ);
        }
        sb.append(";");
        this.addZoomTranslationNavigationText(sb);
        return sb.toString();
    }

    private void addZoomTranslationNavigationText(StringBuffer sb) {
        float tY;
        float tX;
        if (this.zoomPercent != 100.0f) {
            sb.append(" zoom");
            TransformManager.truncate2(sb, this.zoomPercent);
            sb.append(";");
        }
        if ((tX = this.getTranslationXPercent()) != 0.0f) {
            sb.append(" translate x");
            TransformManager.truncate2(sb, tX);
            sb.append(";");
        }
        if ((tY = this.getTranslationYPercent()) != 0.0f) {
            sb.append(" translate y");
            TransformManager.truncate2(sb, tY);
            sb.append(";");
        }
        if (this.modelRadius != this.rotationRadiusDefault) {
            sb.append(" set rotationRadius");
            TransformManager.truncate2(sb, this.modelRadius);
            sb.append(";");
        }
        if (this.isNavigationMode) {
            sb.append("navigate 0 center ").append(Escape.escape(this.navigationCenter));
            sb.append(";navigate 0 translate");
            TransformManager.truncate2(sb, this.getNavigationOffsetPercent('X'));
            TransformManager.truncate2(sb, this.getNavigationOffsetPercent('Y'));
            sb.append(";navigate 0 depth ");
            TransformManager.truncate2(sb, this.getNavigationDepthPercent());
            sb.append(";");
        }
    }

    private String getRotateZyzText(boolean iAddComment) {
        float rZ2;
        float rZ1;
        StringBuffer sb = new StringBuffer();
        float m22 = this.matrixRotate.m22;
        float rY = (float)Math.acos(m22) * 57.29578f;
        if (m22 > 0.999f || m22 < -0.999f) {
            rZ1 = (float)Math.atan2(this.matrixRotate.m10, this.matrixRotate.m11) * 57.29578f;
            rZ2 = 0.0f;
        } else {
            rZ1 = (float)Math.atan2(this.matrixRotate.m21, -this.matrixRotate.m20) * 57.29578f;
            rZ2 = (float)Math.atan2(this.matrixRotate.m12, this.matrixRotate.m02) * 57.29578f;
        }
        if (rZ1 != 0.0f && rY != 0.0f && rZ2 != 0.0f && iAddComment) {
            sb.append("#Follows Z-Y-Z convention for Euler angles\n");
        }
        sb.append("reset");
        sb.append(";center ").append(this.getCenterText());
        if (rZ1 != 0.0f) {
            sb.append("; rotate z");
            TransformManager.truncate2(sb, rZ1);
        }
        if (rY != 0.0f) {
            sb.append("; rotate y");
            TransformManager.truncate2(sb, rY);
        }
        if (rZ2 != 0.0f) {
            sb.append("; rotate z");
            TransformManager.truncate2(sb, rZ2);
        }
        sb.append(";");
        this.addZoomTranslationNavigationText(sb);
        return sb.toString();
    }

    private static void truncate0(StringBuffer sb, float val) {
        sb.append(' ');
        sb.append(Math.round(val));
    }

    private static void truncate2(StringBuffer sb, float val) {
        sb.append(' ');
        sb.append((float)Math.round(val * 100.0f) / 100.0f);
    }

    void setSpinX(float degrees) {
        this.spinX = degrees;
        if (this.isSpinInternal || this.isSpinFixed) {
            this.clearSpin();
        }
    }

    void setSpinY(float degrees) {
        this.spinY = degrees;
        if (this.isSpinInternal || this.isSpinFixed) {
            this.clearSpin();
        }
    }

    void setSpinZ(float degrees) {
        this.spinZ = degrees;
        if (this.isSpinInternal || this.isSpinFixed) {
            this.clearSpin();
        }
    }

    void setSpinFps(int value) {
        if (value <= 0) {
            value = 1;
        } else if (value > 50) {
            value = 50;
        }
        this.spinFps = value;
    }

    private void clearSpin() {
        this.setSpinOn(false);
        this.isSpinInternal = false;
        this.isSpinFixed = false;
    }

    boolean getSpinOn() {
        return this.spinOn;
    }

    void setSpinOn(boolean spinOn) {
        this.setSpinOn(spinOn, Float.MAX_VALUE, null);
    }

    private void setSpinOn(boolean spinOn, float endDegrees, BitSet bsAtoms) {
        this.spinOn = spinOn;
        this.viewer.getGlobalSettings().setParameterValue("_spinning", spinOn);
        if (spinOn) {
            if (this.spinThread == null) {
                this.spinThread = new SpinThread(endDegrees, bsAtoms);
                this.spinThread.start();
            }
        } else if (this.spinThread != null) {
            this.spinThread.interrupt();
            this.spinThread = null;
        }
    }

    void setVibrationScale(float scale) {
        this.vibrationScale = scale;
    }

    void setVibrationPeriod(float period) {
        if (Float.isNaN(period)) {
            period = this.vibrationPeriod;
        } else if (period == 0.0f) {
            this.vibrationPeriod = 0.0f;
            this.vibrationPeriodMs = 0;
        } else {
            this.vibrationPeriod = Math.abs(period);
            this.vibrationPeriodMs = (int)(this.vibrationPeriod * 1000.0f);
            if (period > 0.0f) {
                return;
            }
            period = -period;
        }
        this.setVibrationOn(period > 0.0f && this.viewer.modelHasVibrationVectors(this.viewer.getCurrentModelIndex()));
    }

    protected void setVibrationT(float t) {
        this.vibrationRadians = t * ((float)Math.PI * 2);
        if (this.vibrationScale == 0.0f) {
            this.vibrationScale = this.viewer.getVibrationScale();
        }
        this.vibrationAmplitude = (float)Math.cos(this.vibrationRadians) * this.vibrationScale;
    }

    boolean isVibrationOn() {
        return this.vibrationOn;
    }

    private void setVibrationOn(boolean vibrationOn) {
        if (!vibrationOn) {
            if (this.vibrationThread != null) {
                this.vibrationThread.interrupt();
                this.vibrationThread = null;
            }
            this.vibrationOn = false;
            return;
        }
        if (this.viewer.getModelCount() < 1) {
            this.vibrationOn = false;
            return;
        }
        if (this.vibrationThread == null) {
            this.vibrationThread = new VibrationThread();
            this.vibrationThread.start();
        }
        this.vibrationOn = true;
    }

    private void clearVibration() {
        this.setVibrationOn(false);
        this.vibrationScale = 0.0f;
    }

    void setStereoMode(int[] twoColors) {
        this.stereoMode = 5;
        this.stereoColors = twoColors;
    }

    void setStereoMode(int stereoMode) {
        this.stereoColors = null;
        this.stereoMode = stereoMode;
    }

    void setStereoDegrees(float stereoDegrees) {
        this.stereoDegrees = stereoDegrees;
        this.stereoRadians = stereoDegrees * ((float)Math.PI / 180);
    }

    synchronized Matrix3f getStereoRotationMatrix(boolean stereoFrame) {
        this.stereoFrame = stereoFrame;
        if (!stereoFrame) {
            return this.matrixRotate;
        }
        this.matrixTemp3.rotY(-this.stereoRadians);
        this.matrixStereo.mul(this.matrixTemp3, this.matrixRotate);
        return this.matrixStereo;
    }

    boolean isWindowCentered() {
        return this.windowCentered;
    }

    void setWindowCentered(boolean TF) {
        this.windowCentered = TF;
        this.resetNavigationPoint(true);
    }

    Point3f getRotationCenter() {
        return this.fixedRotationCenter;
    }

    float getRotationRadius() {
        return this.modelRadius;
    }

    float setRotationRadius(float angstroms, boolean doAll) {
        this.modelRadius = angstroms <= 0.0f ? this.viewer.calcRotationRadius(this.fixedRotationCenter) : angstroms;
        angstroms = this.modelRadius;
        if (doAll) {
            this.viewer.setRotationRadius(angstroms, false);
        }
        return angstroms;
    }

    private void setRotationCenterAndRadiusXYZ(Point3f newCenterOfRotation, boolean andRadius) {
        this.resetNavigationPoint(false);
        if (newCenterOfRotation == null) {
            this.setFixedRotationCenter(this.rotationCenterDefault);
            this.modelRadius = this.rotationRadiusDefault;
            return;
        }
        this.setFixedRotationCenter(newCenterOfRotation);
        if (andRadius && this.windowCentered) {
            this.modelRadius = this.viewer.calcRotationRadius(this.fixedRotationCenter);
        }
    }

    private void setRotationCenterAndRadiusXYZ(String relativeTo, Point3f pt) {
        this.pointT.set(pt);
        if (relativeTo == "average") {
            this.pointT.add(this.viewer.getAverageAtomPoint());
        } else if (relativeTo == "boundbox") {
            this.pointT.add(this.viewer.getBoundBoxCenter());
        } else if (relativeTo != "absolute") {
            this.pointT.set(this.rotationCenterDefault);
        }
        this.setRotationCenterAndRadiusXYZ(this.pointT, true);
    }

    void setNewRotationCenter(Point3f center, boolean doScale) {
        if (center == null) {
            center = this.rotationCenterDefault;
        }
        if (this.windowCentered) {
            this.translateToXPercent(0.0f);
            this.translateToYPercent(0.0f);
            this.setRotationCenterAndRadiusXYZ(center, true);
            if (doScale) {
                this.scaleFitToScreen(true);
            }
        } else {
            this.moveRotationCenter(center, true);
        }
    }

    private void moveRotationCenter(Point3f center, boolean toXY) {
        this.setRotationCenterAndRadiusXYZ(center, false);
        if (toXY) {
            this.setRotationPointXY(this.fixedRotationCenter);
        }
    }

    void setCenter() {
        this.setRotationCenterAndRadiusXYZ(this.fixedRotationCenter, true);
    }

    void setCenterAt(String relativeTo, Point3f pt) {
        this.setRotationCenterAndRadiusXYZ(relativeTo, pt);
        this.scaleFitToScreen(true);
    }

    boolean canNavigate() {
        return false;
    }

    synchronized void navigate(int keyCode, int modifiers) {
    }

    void navigate(float seconds, Point3f center) {
    }

    void navigate(float seconds, Vector3f rotAxis, float degrees) {
    }

    void navigate(float seconds, Point3f[] path, float[] theta, int indexStart, int indexEnd) {
    }

    void navigate(float timeSeconds, Point3f[][] pathGuide) {
    }

    void navTranslate(float seconds, Point3f pt) {
    }

    void navTranslatePercent(float seconds, float x, float y) {
    }

    protected void calcNavigationPoint() {
    }

    protected void resetNavigationPoint(boolean doResetSlab) {
    }

    protected String getNavigationState() {
        return "";
    }

    void setNavigationDepthPercent(float timeSec, float percent) {
        this.viewer.getGlobalSettings().setParameterValue("navigationDepth", percent);
    }

    Point3f getNavigationCenter() {
        return null;
    }

    Point3f getNavigationOffset() {
        return null;
    }

    float getNavigationDepthPercent() {
        return Float.NaN;
    }

    float getNavigationOffsetPercent(char XorY) {
        return 0.0f;
    }

    void setNavigationSlabOffsetPercent(float offset) {
        this.viewer.getGlobalSettings().setParameterValue("navigationSlab", offset);
    }

    String getNavigationText(boolean addComments) {
        return "";
    }

    boolean isNavigationCentered() {
        return false;
    }

    void setFrameOffset(int modelIndex) {
        if (this.frameOffsets == null || modelIndex < 0 || modelIndex >= this.frameOffsets.length) {
            this.frameOffset.set(0.0f, 0.0f, 0.0f);
        } else {
            this.frameOffset.set(this.frameOffsets[modelIndex]);
        }
    }

    void setFrameOffsets(Point3f[] offsets) {
        this.frameOffsets = offsets;
    }

    class VibrationThread
    extends Thread
    implements Runnable {
        VibrationThread() {
            this.setName("VibrationThread");
        }

        public void run() {
            long startTime;
            long lastRepaintTime = startTime = System.currentTimeMillis();
            try {
                do {
                    long currentTime;
                    int elapsed;
                    int sleepTime;
                    if ((sleepTime = 33 - (elapsed = (int)((currentTime = System.currentTimeMillis()) - lastRepaintTime))) > 0) {
                        Thread.sleep(sleepTime);
                    }
                    lastRepaintTime = currentTime = System.currentTimeMillis();
                    elapsed = (int)(currentTime - startTime);
                    float t = (float)(elapsed % TransformManager.this.vibrationPeriodMs) / (float)TransformManager.this.vibrationPeriodMs;
                    TransformManager.this.setVibrationT(t);
                    TransformManager.this.viewer.refresh(3, "TransformationManager:VibrationThread:run()");
                } while (!this.isInterrupted());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private class SpinThread
    extends Thread
    implements Runnable {
        float endDegrees;
        float nDegrees = 0.0f;
        BitSet bsAtoms;

        SpinThread(float endDegrees, BitSet bsAtoms) {
            this.endDegrees = Math.abs(endDegrees);
            this.setName("SpinThread");
            this.bsAtoms = bsAtoms;
        }

        public void run() {
            float myFps = TransformManager.this.spinFps;
            TransformManager.this.viewer.getGlobalSettings().setParameterValue("_spinning", true);
            int i = 0;
            long timeBegin = System.currentTimeMillis();
            while (!this.isInterrupted()) {
                int targetTime;
                int sleepTime;
                boolean refreshNeeded;
                if (myFps != TransformManager.this.spinFps) {
                    myFps = TransformManager.this.spinFps;
                    i = 0;
                    timeBegin = System.currentTimeMillis();
                }
                if (myFps == 0.0f || !TransformManager.this.spinOn) {
                    TransformManager.this.setSpinOn(false);
                    break;
                }
                boolean bl = refreshNeeded = TransformManager.this.isSpinInternal && TransformManager.this.internalRotationAxis.angle != 0.0f || TransformManager.this.isSpinFixed && TransformManager.this.fixedRotationAxis.angle != 0.0f || !TransformManager.this.isSpinFixed && !TransformManager.this.isSpinInternal && TransformManager.this.spinX + TransformManager.this.spinY + TransformManager.this.spinZ != 0.0f;
                int currentTime = (int)(System.currentTimeMillis() - timeBegin);
                if ((sleepTime = (targetTime = (int)((float)(++i * 1000) / myFps)) - currentTime) <= 0) continue;
                boolean isInMotion = TransformManager.this.viewer.getInMotion();
                if (isInMotion) {
                    sleepTime += 1000;
                }
                try {
                    if (refreshNeeded && TransformManager.this.spinOn && !isInMotion) {
                        float angle = 0.0f;
                        if (TransformManager.this.isSpinInternal || TransformManager.this.isSpinFixed) {
                            angle = (TransformManager.this.isSpinInternal ? TransformManager.this.internalRotationAxis : TransformManager.this.fixedRotationAxis).angle / myFps;
                            if (TransformManager.this.isSpinInternal) {
                                TransformManager.this.rotateAxisAngleRadiansInternal(angle, this.bsAtoms);
                            } else {
                                TransformManager.this.rotateAxisAngleRadiansFixed(angle, this.bsAtoms);
                            }
                            this.nDegrees += Math.abs(angle / ((float)Math.PI * 2) * 360.0f);
                        } else {
                            if (TransformManager.this.spinX != 0.0f) {
                                TransformManager.this.rotateXRadians(TransformManager.this.spinX * ((float)Math.PI / 180) / myFps, null);
                            }
                            if (TransformManager.this.spinY != 0.0f) {
                                TransformManager.this.rotateYRadians(TransformManager.this.spinY * ((float)Math.PI / 180) / myFps, null);
                            }
                            if (TransformManager.this.spinZ != 0.0f) {
                                TransformManager.this.rotateZRadians(TransformManager.this.spinZ * ((float)Math.PI / 180) / myFps);
                            }
                        }
                        while (!this.isInterrupted() && !TransformManager.this.viewer.getRefreshing()) {
                            Thread.sleep(10L);
                        }
                        TransformManager.this.viewer.refresh(1, "TransformationManager:SpinThread:run()");
                        if ((double)this.nDegrees >= (double)this.endDegrees - 1.0E-5) {
                            TransformManager.this.setSpinOn(false);
                        }
                    }
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            TransformManager.this.viewer.getGlobalSettings().setParameterValue("_spinning", false);
        }
    }
}

