/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import org.jmol.util.Logger;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

class TransformManager10
extends TransformManager {
    TransformManager10(Viewer viewer) {
        super(viewer);
        this.perspectiveModel = 10;
    }

    TransformManager10(Viewer viewer, int width, int height) {
        super(viewer, width, height);
        this.perspectiveModel = 10;
    }

    protected void calcCameraFactors() {
        if (Float.isNaN(this.cameraDepth)) {
            this.cameraDepth = this.cameraDepthSetting;
        }
        this.cameraDistance = this.cameraDepth * (float)this.screenPixelCount;
        this.cameraScaleFactor = 1.02f + 0.5f / this.cameraDepth;
        this.scalePixelsPerAngstrom = this.scale3D && !this.perspectiveDepth ? 72.0f / this.scale3DAngstromsPerInch : this.scaleDefaultPixelsPerAngstrom * this.zoomPercent / 100.0f * this.cameraScaleFactor;
        this.modelRadiusPixels = this.modelRadius * this.scalePixelsPerAngstrom;
        this.modelCenterOffset = this.cameraDistance + this.modelRadiusPixels;
        this.referencePlaneOffset = this.cameraDistance;
    }

    protected float getPerspectiveFactor(float z) {
        float factor;
        float f = factor = z <= 0.0f ? this.referencePlaneOffset : this.referencePlaneOffset / z;
        if (this.zoomPercent >= 10000.0f) {
            factor += (this.zoomPercent - 10000.0f) / 190000.0f * (1.0f - factor);
        }
        return factor;
    }

    protected void adjustTemporaryScreenPoint() {
        float z = this.point3fScreenTemp.z;
        if (Float.isNaN(z)) {
            if (!this.haveNotifiedNaN) {
                Logger.debug("NaN seen in TransformPoint");
            }
            this.haveNotifiedNaN = true;
            z = 1.0f;
        } else if (z <= 0.0f) {
            z = 1.0f;
        }
        this.point3fScreenTemp.z = z;
        if (this.perspectiveDepth) {
            float factor = this.getPerspectiveFactor(z);
            this.point3fScreenTemp.x *= factor;
            this.point3fScreenTemp.y *= factor;
        }
        this.point3fScreenTemp.x += this.fixedRotationOffset.x;
        this.point3fScreenTemp.y += this.fixedRotationOffset.y;
        if (Float.isNaN(this.point3fScreenTemp.x) && !this.haveNotifiedNaN) {
            Logger.debug("NaN found in transformPoint ");
            this.haveNotifiedNaN = true;
        }
        this.point3iScreenTemp.set((int)this.point3fScreenTemp.x, (int)this.point3fScreenTemp.y, (int)this.point3fScreenTemp.z);
    }
}

