/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.Interface;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolCallbackListener;
import org.jmol.api.JmolImageCreatorInterface;
import org.jmol.api.JmolSelectionListener;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolViewer;
import org.jmol.api.MinimizerInterface;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.AtomDataServer;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.i18n.GT;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomIndexIterator;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BoxInfo;
import org.jmol.modelset.MeasurementPending;
import org.jmol.modelset.ModelLoader;
import org.jmol.modelset.ModelSet;
import org.jmol.shape.Shape;
import org.jmol.util.Base64;
import org.jmol.util.BitSetUtil;
import org.jmol.util.CommandHistory;
import org.jmol.util.Escape;
import org.jmol.util.JpegEncoder;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.TempArray;
import org.jmol.util.TextFormat;
import org.jmol.viewer.AnimationManager;
import org.jmol.viewer.ColorManager;
import org.jmol.viewer.DataManager;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.ModelManager;
import org.jmol.viewer.MouseManager;
import org.jmol.viewer.MouseManager10;
import org.jmol.viewer.MouseWrapper11;
import org.jmol.viewer.MouseWrapper14;
import org.jmol.viewer.PickingManager;
import org.jmol.viewer.PropertyManager;
import org.jmol.viewer.RepaintManager;
import org.jmol.viewer.ScriptCompiler;
import org.jmol.viewer.ScriptContext;
import org.jmol.viewer.ScriptEvaluator;
import org.jmol.viewer.ScriptFunction;
import org.jmol.viewer.ScriptManager;
import org.jmol.viewer.ScriptVariable;
import org.jmol.viewer.SelectionManager;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.StatusManager;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.TransformManager10;
import org.jmol.viewer.TransformManager11;

public class Viewer
extends JmolViewer
implements AtomDataServer {
    private Component display;
    private Graphics3D g3d;
    private JmolAdapter modelAdapter;
    private CommandHistory commandHistory = new CommandHistory();
    private ColorManager colorManager;
    ScriptCompiler compiler;
    Hashtable definedAtomSets;
    private MinimizerInterface minimizer;
    private SmilesMatcherInterface smilesMatcher;
    private SymmetryInterface symmetry;
    ScriptEvaluator eval;
    private AnimationManager animationManager;
    private DataManager dataManager;
    private FileManager fileManager;
    private ModelManager modelManager;
    private ModelSet modelSet;
    public MouseManager mouseManager;
    private PickingManager pickingManager;
    private RepaintManager repaintManager;
    private ScriptManager scriptManager;
    private SelectionManager selectionManager;
    private StateManager stateManager;
    private StateManager.GlobalSettings global;
    private StatusManager statusManager;
    private TempArray tempManager;
    private TransformManager transformManager;
    private String strJavaVendor;
    private String strJavaVersion;
    private String strOSName;
    private String htmlName = "";
    private String fullName = "";
    private String syncId = "";
    private String appletDocumentBase = "";
    private String appletCodeBase = "";
    private boolean jvm11orGreater = false;
    private boolean jvm12orGreater = false;
    private boolean jvm14orGreater = false;
    private boolean isSilent = false;
    private boolean isApplet = false;
    private boolean isPreviewOnly = false;
    boolean autoExit = false;
    boolean haveDisplay = true;
    private boolean isPrintOnly = false;
    private boolean mustRender = true;
    private boolean isCmdLine_c_or_C_Option = false;
    private boolean listCommands = false;
    private boolean isCmdLine_C_Option = true;
    private boolean useCommandThread = false;
    private boolean isSignedApplet = false;
    private boolean isDataOnly;
    private boolean noneSelected;
    private static final int FILE_STATUS_NOT_LOADED = -1;
    private static final int FILE_STATUS_ZAPPED = 0;
    private static final int FILE_STATUS_CREATING_MODELSET = 2;
    private static final int FILE_STATUS_MODELSET_CREATED = 3;
    private static final int FILE_STATUS_MODELS_DELETED = 5;
    static final String STATE_VERSION_STAMP = "# Jmol state version ";
    public static Object testData;
    public static Object testData2;
    BitSet bsFrameOffsets;
    Point3f[] frameOffsets;
    boolean wasInMotion = false;
    int motionEventNumber;
    private boolean refreshing = true;
    private boolean axesAreTainted = false;
    final Dimension dimScreen = new Dimension();
    private int maximumSize = Integer.MAX_VALUE;
    private float imageFontScaling = 1.0f;
    private boolean antialiasDisplay;
    String interruptScript = "";
    int scriptIndex;
    boolean isScriptQueued = true;
    int hoverAtomIndex = -1;
    String hoverText;
    public static final int CURSOR_DEFAULT = 0;
    public static final int CURSOR_HAND = 1;
    public static final int CURSOR_CROSSHAIR = 2;
    public static final int CURSOR_MOVE = 3;
    public static final int CURSOR_WAIT = 4;
    private int currentCursor = 0;
    int prevFrame = Integer.MIN_VALUE;
    boolean frankOn = true;
    private boolean scriptEditorVisible;
    boolean isTainted = true;
    private boolean creatingImage;
    public static final String SYNC_GRAPHICS_MESSAGE = "GET_GRAPHICS";
    public static final String SYNC_NO_GRAPHICS_MESSAGE = "SET_GRAPHICS_OFF";
    private String errorMessage;
    private String errorMessageUntranslated;
    int currentShapeID = -1;
    String currentShapeState;

    protected void finalize() throws Throwable {
        Logger.debug("viewer finalize " + this);
        super.finalize();
    }

    public JmolAdapter getModelAdapter() {
        if (this.modelAdapter == null) {
            this.modelAdapter = new SmarterJmolAdapter();
        }
        return this.modelAdapter;
    }

    MinimizerInterface getMinimizer(boolean createNew) {
        if (this.minimizer == null && createNew) {
            this.minimizer = (MinimizerInterface)Interface.getOptionInterface("minimize.Minimizer");
            this.minimizer.setProperty("viewer", this);
        }
        return this.minimizer;
    }

    SmilesMatcherInterface getSmilesMatcher() {
        if (this.smilesMatcher == null) {
            this.smilesMatcher = (SmilesMatcherInterface)Interface.getOptionInterface("smiles.PatternMatcher");
        }
        this.smilesMatcher.setModelSet(this.modelSet);
        return this.smilesMatcher;
    }

    SymmetryInterface getSymmetry() {
        if (this.symmetry == null) {
            this.symmetry = (SymmetryInterface)Interface.getOptionInterface("symmetry.Symmetry");
        }
        return this.symmetry;
    }

    private void clearModelDependentObjects() {
        this.setFrameOffsets(null);
        if (this.minimizer != null) {
            this.minimizer.setProperty("clear", null);
            this.minimizer = null;
        }
        if (this.smilesMatcher != null) {
            this.smilesMatcher.setModelSet(null);
            this.smilesMatcher = null;
        }
        if (this.symmetry != null) {
            this.symmetry = null;
        }
    }

    StateManager.GlobalSettings getGlobalSettings() {
        return this.global;
    }

    public Viewer(Component display, JmolAdapter modelAdapter) {
        if (Logger.debugging) {
            Logger.debug("Viewer constructor " + this);
        }
        this.display = display;
        this.modelAdapter = modelAdapter;
        this.strJavaVendor = System.getProperty("java.vendor");
        this.strOSName = System.getProperty("os.name");
        this.strJavaVersion = System.getProperty("java.version");
        this.jvm11orGreater = this.strJavaVersion.compareTo("1.1") >= 0 && (!this.strJavaVendor.startsWith("Netscape") || this.strJavaVersion.compareTo("1.1.5") > 0 || !"Mac OS".equals(this.strOSName));
        this.jvm12orGreater = this.strJavaVersion.compareTo("1.2") >= 0;
        this.jvm14orGreater = this.strJavaVersion.compareTo("1.4") >= 0;
        this.stateManager = new StateManager(this);
        this.g3d = new Graphics3D(display);
        this.colorManager = new ColorManager(this, this.g3d);
        this.statusManager = new StatusManager(this);
        this.scriptManager = new ScriptManager(this);
        this.transformManager = new TransformManager11(this);
        this.selectionManager = new SelectionManager(this);
        this.pickingManager = new PickingManager(this);
        if (display != null) {
            this.mouseManager = this.jvm14orGreater ? MouseWrapper14.alloc(display, this) : (this.jvm11orGreater ? MouseWrapper11.alloc(display, this) : new MouseManager10(display, this));
        }
        this.modelManager = new ModelManager(this);
        this.tempManager = new TempArray();
        this.dataManager = new DataManager();
        this.animationManager = new AnimationManager(this);
        this.repaintManager = new RepaintManager(this);
        this.initialize();
        this.fileManager = new FileManager(this);
        this.compiler = new ScriptCompiler(this);
        this.definedAtomSets = new Hashtable();
        this.eval = new ScriptEvaluator(this);
    }

    public static JmolViewer allocateViewer(Component display, JmolAdapter modelAdapter, String fullName, URL documentBase, URL codeBase, String commandOptions, JmolStatusListener statusListener) {
        Viewer viewer = new Viewer(display, modelAdapter);
        ((JmolViewer)viewer).setAppletContext(fullName, documentBase, codeBase, commandOptions);
        ((JmolViewer)viewer).setJmolStatusListener(statusListener);
        return viewer;
    }

    public static JmolViewer allocateViewer(Component display, JmolAdapter modelAdapter) {
        return new Viewer(display, modelAdapter);
    }

    public boolean isApplet() {
        return this.isApplet;
    }

    boolean isPreviewOnly() {
        return this.isPreviewOnly;
    }

    public void setAppletContext(String fullName, URL documentBase, URL codeBase, String commandOptions) {
        fullName = fullName == null ? "" : fullName;
        this.fullName = fullName;
        this.appletDocumentBase = documentBase == null ? "" : documentBase.toString();
        this.appletCodeBase = codeBase == null ? "" : codeBase.toString();
        int i = fullName.lastIndexOf("[");
        this.htmlName = i < 0 ? fullName : fullName.substring(0, i);
        String string = this.syncId = i < 0 ? "" : fullName.substring(i + 1, fullName.length() - 1);
        if (commandOptions == null) {
            commandOptions = "";
        }
        String str = "" + commandOptions;
        this.isPrintOnly = commandOptions.indexOf("-p") >= 0;
        boolean bl = this.isApplet = commandOptions.indexOf("-applet") >= 0;
        if (this.isApplet) {
            Logger.info("applet context: " + commandOptions);
            String appletProxy = null;
            i = str.indexOf("-appletProxy ");
            if (i >= 0) {
                appletProxy = str.substring(i + 13);
                str = str.substring(0, i);
            }
            this.fileManager.setAppletContext(documentBase, codeBase, appletProxy);
            this.isSignedApplet = str.indexOf("-signed") >= 0;
            i = str.indexOf("-maximumSize ");
            if (i >= 0) {
                this.setMaximumSize(Parser.parseInt(str.substring(i + 13)));
            }
            boolean bl2 = this.useCommandThread = str.indexOf("-threaded") >= 0;
            if (this.useCommandThread) {
                this.scriptManager.startCommandWatcher(true);
            }
        } else {
            this.g3d.setBackgroundTransparent(str.indexOf("-b") >= 0);
            boolean bl3 = this.isSilent = str.indexOf("-i") >= 0;
            if (this.isSilent) {
                Logger.setLogLevel(3);
            }
            this.isCmdLine_c_or_C_Option = str.toLowerCase().indexOf("-c") >= 0;
            this.isCmdLine_C_Option = str.indexOf("-C") >= 0;
            this.listCommands = str.indexOf("-l") >= 0;
            this.autoExit = str.indexOf("-x") >= 0;
            this.isDataOnly = this.display == null;
            boolean bl4 = this.haveDisplay = this.display != null && str.indexOf("-n") < 0;
            if (!this.haveDisplay) {
                this.display = null;
            }
            this.mustRender = this.haveDisplay;
            this.cd(".");
        }
        this.isPreviewOnly = str.indexOf("#previewOnly") >= 0;
        this.setBooleanProperty("_applet", this.isApplet);
        this.setBooleanProperty("_signedApplet", this.isSignedApplet);
        this.setBooleanProperty("_useCommandThread", this.useCommandThread);
        if (!this.isSilent) {
            Logger.info("(C) 2009 Jmol Development\nJmol Version " + Viewer.getJmolVersion() + "\njava.vendor:" + this.strJavaVendor + "\njava.version:" + this.strJavaVersion + "\nos.name:" + this.strOSName + "\nmemory:" + this.getParameter("_memory") + "\nuseCommandThread: " + this.useCommandThread + (!this.isApplet ? "" : "\nappletId:" + this.htmlName + (this.isSignedApplet ? " (signed)" : "")));
        }
        this.zap(false, false);
        this.global.setParameterValue("language", GT.getLanguage());
    }

    public boolean isDataOnly() {
        return this.isDataOnly;
    }

    public static String getJmolVersion() {
        return JmolConstants.version + "  " + JmolConstants.date;
    }

    public String getExportDriverList() {
        return (String)this.global.getParameter("exportDrivers");
    }

    private static int getJmolVersionInt() {
        String s = JmolConstants.version;
        int version = -1;
        try {
            int i = s.indexOf(".");
            if (i < 0) {
                version = 100000 * Integer.parseInt(s);
                return version;
            }
            version = 100000 * Integer.parseInt(s.substring(0, i));
            if ((i = (s = s.substring(i + 1)).indexOf(".")) < 0) {
                return version += 1000 * Integer.parseInt(s);
            }
            version += 1000 * Integer.parseInt(s.substring(0, i));
            if ((i = (s = s.substring(i + 1)).indexOf("_")) >= 0) {
                s = s.substring(0, i);
            }
            if ((i = s.indexOf(" ")) >= 0) {
                s = s.substring(0, i);
            }
            version += Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return version;
    }

    String getHtmlName() {
        return this.htmlName;
    }

    boolean mustRenderFlag() {
        return this.mustRender && this.refreshing;
    }

    static int getLogLevel() {
        for (int i = 0; i < 7; ++i) {
            if (!Logger.isActiveLevel(i)) continue;
            return 7 - i;
        }
        return 0;
    }

    public Component getDisplay() {
        return this.display;
    }

    public boolean handleOldJvm10Event(Event e) {
        return this.mouseManager.handleOldJvm10Event(e);
    }

    void reset() {
        this.modelSet.calcBoundBoxDimensions(null);
        this.axesAreTainted = true;
        this.transformManager.homePosition();
        if (this.modelSet.setCrystallographicDefaults()) {
            this.stateManager.setCrystallographicDefaults();
        } else {
            this.setAxesModeMolecular(false);
        }
        this.prevFrame = Integer.MIN_VALUE;
        this.refresh(1, "Viewer:homePosition()");
    }

    public void homePosition() {
        this.evalString("reset");
    }

    Hashtable getAppletInfo() {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("htmlName", this.htmlName);
        info.put("syncId", this.syncId);
        info.put("fullName", this.fullName);
        if (this.isApplet) {
            info.put("documentBase", this.appletDocumentBase);
            info.put("codeBase", this.appletCodeBase);
            info.put("registry", this.statusManager.getRegistryInfo());
        }
        info.put("version", JmolConstants.version);
        info.put("date", JmolConstants.date);
        info.put("javaVendor", this.strJavaVendor);
        info.put("javaVersion", this.strJavaVersion);
        info.put("operatingSystem", this.strOSName);
        return info;
    }

    void initialize() {
        this.global = this.stateManager.getGlobalSettings(this.global);
        this.setIntProperty("_version", Viewer.getJmolVersionInt(), true);
        this.setBooleanProperty("_applet", this.isApplet);
        this.setBooleanProperty("_signedApplet", this.isSignedApplet);
        this.setBooleanProperty("_useCommandThread", this.useCommandThread);
        this.colorManager.resetElementColors();
        this.setObjectColor("background", "black");
        this.setObjectColor("axis1", "red");
        this.setObjectColor("axis2", "green");
        this.setObjectColor("axis3", "blue");
        Viewer.setAmbientPercent(this.global.ambientPercent);
        Viewer.setDiffusePercent(this.global.diffusePercent);
        Viewer.setSpecular(this.global.specular);
        Viewer.setSpecularPercent(this.global.specularPercent);
        Viewer.setSpecularExponent(this.global.specularExponent);
        Viewer.setSpecularPower(this.global.specularPower);
        this.animationManager.setAnimationFps(this.global.animationFps);
        this.statusManager.setAllowStatusReporting(this.global.statusReporting);
        this.setTransformManagerDefaults();
    }

    String listSavedStates() {
        return this.stateManager.listSavedStates();
    }

    void saveOrientation(String saveName) {
        this.stateManager.saveOrientation(saveName);
    }

    boolean restoreOrientation(String saveName, float timeSeconds) {
        return this.stateManager.restoreOrientation(saveName, timeSeconds, true);
    }

    public void restoreRotation(String saveName, float timeSeconds) {
        this.stateManager.restoreOrientation(saveName, timeSeconds, false);
    }

    void saveModelOrientation() {
        this.modelSet.saveModelOrientation(this.animationManager.currentModelIndex, this.stateManager.getOrientation());
    }

    void restoreModelOrientation(int modelIndex) {
        StateManager.Orientation o = this.modelSet.getModelOrientation(modelIndex);
        if (o != null) {
            o.restore(-1.0f, true);
        }
    }

    void restoreModelRotation(int modelIndex) {
        StateManager.Orientation o = this.modelSet.getModelOrientation(modelIndex);
        if (o != null) {
            o.restore(-1.0f, false);
        }
    }

    void saveBonds(String saveName) {
        this.stateManager.saveBonds(saveName);
    }

    boolean restoreBonds(String saveName) {
        this.clearModelDependentObjects();
        return this.stateManager.restoreBonds(saveName);
    }

    void saveState(String saveName) {
        this.stateManager.saveState(saveName);
    }

    public String getSavedState(String saveName) {
        return this.stateManager.getSavedState(saveName);
    }

    void saveStructure(String saveName) {
        this.stateManager.saveStructure(saveName);
    }

    String getSavedStructure(String saveName) {
        return this.stateManager.getSavedStructure(saveName);
    }

    public void saveCoordinates(String saveName, BitSet bsSelected) {
        this.stateManager.saveCoordinates(saveName, bsSelected);
    }

    String getSavedCoordinates(String saveName) {
        return this.stateManager.getSavedCoordinates(saveName);
    }

    void saveSelection(String saveName) {
        this.stateManager.saveSelection(saveName, this.selectionManager.bsSelection);
        this.stateManager.restoreSelection(saveName);
    }

    boolean restoreSelection(String saveName) {
        return this.stateManager.restoreSelection(saveName);
    }

    public Matrix4f getMatrixtransform() {
        return this.transformManager.getMatrixtransform();
    }

    public float getRotationRadius() {
        return this.transformManager.getRotationRadius();
    }

    void setRotationRadius(float angstroms, boolean doAll) {
        if (doAll) {
            angstroms = this.transformManager.setRotationRadius(angstroms, false);
        }
        if (!this.modelSet.setRotationRadius(this.animationManager.currentModelIndex, angstroms)) {
            this.global.setParameterValue("rotationRadius", angstroms);
        }
    }

    public Point3f getRotationCenter() {
        return this.transformManager.getRotationCenter();
    }

    void setCenterAt(String relativeTo, Point3f pt) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.setCenterAt(relativeTo, pt);
    }

    void setCenterBitSet(BitSet bsCenter, boolean doScale) {
        Point3f center;
        Point3f point3f = center = bsCenter != null && BitSetUtil.cardinalityOf(bsCenter) > 0 ? this.getAtomSetCenter(bsCenter) : null;
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.setNewRotationCenter(center, doScale);
    }

    void setNewRotationCenter(Point3f center) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.setNewRotationCenter(center, true);
    }

    Point3f getNavigationCenter() {
        return this.transformManager.getNavigationCenter();
    }

    public boolean getNavigationCentered() {
        return this.transformManager.isNavigationCentered();
    }

    float getNavigationDepthPercent() {
        return this.transformManager.getNavigationDepthPercent();
    }

    void navigate(int keyWhere, int modifiers) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.navigate(keyWhere, modifiers);
        if (!this.transformManager.vibrationOn) {
            this.refresh(1, "Viewer:navigate()");
        }
    }

    public Point3f getNavigationOffset() {
        return this.transformManager.getNavigationOffset();
    }

    float getNavigationOffsetPercent(char XorY) {
        return this.transformManager.getNavigationOffsetPercent(XorY);
    }

    public boolean getNavigating() {
        return this.transformManager.getNavigating();
    }

    boolean isInPosition(Point3f pt, float degrees) {
        return this.transformManager.isInPosition(pt, degrees);
    }

    void move(Vector3f dRot, float dZoom, Vector3f dTrans, float dSlab, float floatSecondsTotal, int fps) {
        this.transformManager.move(dRot, dZoom, dTrans, dSlab, floatSecondsTotal, fps);
        this.moveUpdate(floatSecondsTotal);
    }

    void moveTo(float floatSecondsTotal, Point3f center, Point3f pt, float degrees, float zoom, float xTrans, float yTrans, float rotationRadius, Point3f navCenter, float xNav, float yNav, float navDepth) {
        this.transformManager.moveTo(floatSecondsTotal, center, pt, degrees, zoom, xTrans, yTrans, rotationRadius, navCenter, xNav, yNav, navDepth);
        this.moveUpdate(floatSecondsTotal);
    }

    void moveTo(float floatSecondsTotal, Matrix3f rotationMatrix, Point3f center, float zoom, float xTrans, float yTrans, float rotationRadius, Point3f navCenter, float xNav, float yNav, float navDepth) {
        this.transformManager.moveTo(floatSecondsTotal, rotationMatrix, center, zoom, xTrans, yTrans, rotationRadius, navCenter, xNav, yNav, navDepth);
        this.moveUpdate(floatSecondsTotal);
    }

    private void moveUpdate(float floatSecondsTotal) {
        if (floatSecondsTotal > 0.0f) {
            this.requestRepaintAndWait();
        } else if (floatSecondsTotal == 0.0f) {
            this.setSync();
        }
    }

    String getMoveToText(float timespan) {
        return this.transformManager.getMoveToText(timespan, false);
    }

    void navigate(float timeSeconds, Point3f[] path, float[] theta, int indexStart, int indexEnd) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.navigate(timeSeconds, path, theta, indexStart, indexEnd);
        this.moveUpdate(timeSeconds);
    }

    void navigate(float timeSeconds, Point3f center) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.navigate(timeSeconds, center);
        this.moveUpdate(timeSeconds);
    }

    void navigate(float timeSeconds, Point3f[][] pathGuide) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.navigate(timeSeconds, pathGuide);
        this.moveUpdate(timeSeconds);
    }

    void navigate(float timeSeconds, Vector3f rotAxis, float degrees) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.navigate(timeSeconds, rotAxis, degrees);
        this.moveUpdate(timeSeconds);
    }

    void navTranslate(float timeSeconds, Point3f center) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.navTranslate(timeSeconds, center);
        this.moveUpdate(timeSeconds);
    }

    void navTranslatePercent(float timeSeconds, float x, float y) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.navTranslatePercent(timeSeconds, x, y);
        this.moveUpdate(timeSeconds);
    }

    void zoomBy(int pixels) {
        this.transformManager.zoomBy(pixels);
        this.refresh(2, this.statusManager.syncingMouse ? "Mouse: zoomBy " + pixels : "");
    }

    void zoomByFactor(float factor) {
        this.transformManager.zoomByFactor(factor);
        this.refresh(2, this.statusManager.syncingMouse ? "Mouse: zoomByFactor " + factor : "");
    }

    void rotateXYBy(int xDelta, int yDelta) {
        this.transformManager.rotateXYBy(xDelta, yDelta, null);
        this.refresh(2, this.statusManager.syncingMouse ? "Mouse: rotateXYBy " + xDelta + " " + yDelta : "");
    }

    void rotateZBy(int zDelta) {
        this.transformManager.rotateZBy(zDelta);
        this.refresh(2, this.statusManager.syncingMouse ? "Mouse: rotateZBy " + zDelta : "");
    }

    void rotateMolecule(int deltaX, int deltaY) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.setRotateMolecule(true);
        this.transformManager.rotateXYBy(deltaX, deltaY, this.selectionManager.bsSelection);
        this.transformManager.setRotateMolecule(false);
        this.refreshMeasures();
        this.refresh(2, this.statusManager.syncingMouse ? "Mouse: rotateMolecule " + deltaX + " " + deltaY : "");
    }

    void translateXYBy(int xDelta, int yDelta) {
        this.transformManager.translateXYBy(xDelta, yDelta);
        this.refresh(2, this.statusManager.syncingMouse ? "Mouse: translateXYBy " + xDelta + " " + yDelta : "");
    }

    public void rotateFront() {
        this.transformManager.rotateFront();
        this.refresh(1, "Viewer:rotateFront()");
    }

    public void rotateX(float angleRadians) {
        this.transformManager.rotateX(angleRadians);
        this.refresh(1, "Viewer:rotateX()");
    }

    public void rotateY(float angleRadians) {
        this.transformManager.rotateY(angleRadians);
        this.refresh(1, "Viewer:rotateY()");
    }

    public void rotateZ(float angleRadians) {
        this.transformManager.rotateZ(angleRadians);
        this.refresh(1, "Viewer:rotateZ()");
    }

    public void rotateX(int angleDegrees) {
        this.rotateX((float)angleDegrees * ((float)Math.PI / 180));
    }

    public void rotateY(int angleDegrees) {
        this.rotateY((float)angleDegrees * ((float)Math.PI / 180));
    }

    void translate(char xyz, float x, char type) {
        int xy = type == '\u0000' ? 0 : (type == '%' ? this.transformManager.percentToPixels(xyz, x) : this.transformManager.angstromsToPixels(x * (type == 'n' ? 10.0f : 1.0f)));
        switch (xyz) {
            case 'x': {
                if (type == '\u0000') {
                    this.transformManager.translateToXPercent(x);
                    break;
                }
                this.transformManager.translateXYBy(xy, 0);
                break;
            }
            case 'y': {
                if (type == '\u0000') {
                    this.transformManager.translateToYPercent(x);
                    break;
                }
                this.transformManager.translateXYBy(0, xy);
                break;
            }
            case 'z': {
                if (type == '\u0000') {
                    this.transformManager.translateToZPercent(x);
                    break;
                }
                this.transformManager.translateZBy(xy);
            }
        }
        this.refresh(1, "Viewer:translate()");
    }

    float getTranslationXPercent() {
        return this.transformManager.getTranslationXPercent();
    }

    float getTranslationYPercent() {
        return this.transformManager.getTranslationYPercent();
    }

    float getTranslationZPercent() {
        return this.transformManager.getTranslationZPercent();
    }

    String getTranslationScript() {
        return this.transformManager.getTranslationScript();
    }

    public int getZoomPercent() {
        return (int)this.getZoomSetting();
    }

    float getZoomSetting() {
        return this.transformManager.getZoomSetting();
    }

    public float getZoomPercentFloat() {
        return this.transformManager.getZoomPercentFloat();
    }

    float getMaxZoomPercent() {
        return 200000.0f;
    }

    void slabReset() {
        this.transformManager.slabReset();
    }

    boolean getZoomEnabled() {
        return this.transformManager.zoomEnabled;
    }

    public boolean getSlabEnabled() {
        return this.transformManager.slabEnabled;
    }

    void slabByPixels(int pixels) {
        this.transformManager.slabByPercentagePoints(pixels);
    }

    void depthByPixels(int pixels) {
        this.transformManager.depthByPercentagePoints(pixels);
    }

    void slabDepthByPixels(int pixels) {
        this.transformManager.slabDepthByPercentagePoints(pixels);
    }

    void slabToPercent(int percentSlab) {
        this.transformManager.slabToPercent(percentSlab);
    }

    void slabInternal(Point4f plane, boolean isDepth) {
        this.transformManager.slabInternal(plane, isDepth);
    }

    void depthToPercent(int percentDepth) {
        this.transformManager.depthToPercent(percentDepth);
    }

    void setSlabDepthInternal(boolean isDepth) {
        this.transformManager.setSlabDepthInternal(isDepth);
    }

    public int zValueFromPercent(int zPercent) {
        return this.transformManager.zValueFromPercent(zPercent);
    }

    public Matrix4f getUnscaledTransformMatrix() {
        return this.transformManager.getUnscaledTransformMatrix();
    }

    void finalizeTransformParameters() {
        this.transformManager.finalizeTransformParameters();
        this.g3d.setSlabAndDepthValues(this.transformManager.slabValue, this.transformManager.depthValue, this.global.zShade);
    }

    public void rotatePoint(Point3f pt, Point3f ptRot) {
        this.transformManager.rotatePoint(pt, ptRot);
    }

    public Point3i transformPoint(Point3f pointAngstroms) {
        return this.transformManager.transformPoint(pointAngstroms);
    }

    public Point3i transformPoint(Point3f pointAngstroms, Vector3f vibrationVector) {
        return this.transformManager.transformPoint(pointAngstroms, vibrationVector);
    }

    public void transformPoint(Point3f pointAngstroms, Point3i pointScreen) {
        this.transformManager.transformPoint(pointAngstroms, pointScreen);
    }

    public void transformPointNoClip(Point3f pointAngstroms, Point3f pt) {
        this.transformManager.transformPointNoClip(pointAngstroms, pt);
    }

    public void transformPoint(Point3f pointAngstroms, Point3f pointScreen) {
        this.transformManager.transformPoint(pointAngstroms, pointScreen);
    }

    public void transformPoints(Point3f[] pointsAngstroms, Point3i[] pointsScreens) {
        this.transformManager.transformPoints(pointsAngstroms.length, pointsAngstroms, pointsScreens);
    }

    public void transformVector(Vector3f vectorAngstroms, Vector3f vectorTransformed) {
        this.transformManager.transformVector(vectorAngstroms, vectorTransformed);
    }

    public void unTransformPoint(Point3f pointScreen, Point3f pointAngstroms) {
        this.transformManager.unTransformPoint(pointScreen, pointAngstroms);
    }

    public float getScalePixelsPerAngstrom(boolean asAntialiased) {
        return this.transformManager.scalePixelsPerAngstrom * (asAntialiased || !this.global.antialiasDisplay ? 1.0f : 0.5f);
    }

    public short scaleToScreen(int z, int milliAngstroms) {
        return this.transformManager.scaleToScreen(z, milliAngstroms);
    }

    public float scaleToPerspective(int z, float sizeAngstroms) {
        return this.transformManager.scaleToPerspective(z, sizeAngstroms);
    }

    void setSpin(String key, int value) {
        if (!Parser.isOneOf(key, "x;y;z;fps")) {
            return;
        }
        switch ("x;y;z;fps".indexOf(key)) {
            case 0: {
                this.transformManager.setSpinX(value);
                break;
            }
            case 2: {
                this.transformManager.setSpinY(value);
                break;
            }
            case 4: {
                this.transformManager.setSpinZ(value);
                break;
            }
            default: {
                this.transformManager.setSpinFps(value);
            }
        }
        this.global.setParameterValue("spin" + key, value);
    }

    String getSpinState() {
        return this.transformManager.getSpinState(false);
    }

    float getSpinX() {
        return this.transformManager.spinX;
    }

    float getSpinY() {
        return this.transformManager.spinY;
    }

    float getSpinZ() {
        return this.transformManager.spinZ;
    }

    float getSpinFps() {
        return this.transformManager.spinFps;
    }

    void setSpinOn(boolean spinOn) {
        this.transformManager.setSpinOn(spinOn);
    }

    boolean getSpinOn() {
        return this.transformManager.getSpinOn();
    }

    String getOrientationText(int type) {
        return this.transformManager.getOrientationText(type);
    }

    Hashtable getOrientationInfo() {
        return this.transformManager.getOrientationInfo();
    }

    Matrix3f getMatrixRotate() {
        return this.transformManager.getMatrixRotate();
    }

    void getAxisAngle(AxisAngle4f axisAngle) {
        this.transformManager.getAxisAngle(axisAngle);
    }

    String getTransformText() {
        return this.transformManager.getTransformText();
    }

    void getRotation(Matrix3f matrixRotation) {
        this.transformManager.getRotation(matrixRotation);
    }

    private void setDefaultColors(String colorScheme) {
        this.colorManager.setDefaultColors(colorScheme);
        this.global.setParameterValue("colorRasmol", colorScheme.equals("rasmol"));
    }

    float getDefaultTranslucent() {
        return this.global.defaultTranslucent;
    }

    public int getColixArgb(short colix) {
        return this.g3d.getColixArgb(colix);
    }

    void setRubberbandArgb(int argb) {
        this.colorManager.setRubberbandArgb(argb);
    }

    public short getColixRubberband() {
        return this.colorManager.colixRubberband;
    }

    void setElementArgb(int elementNumber, int argb) {
        this.global.setParameterValue("=color " + JmolConstants.elementNameFromNumber(elementNumber), Escape.escapeColor(argb));
        this.colorManager.setElementArgb(elementNumber, argb);
    }

    public float getVectorScale() {
        return this.global.vectorScale;
    }

    public void setVectorScale(float scale) {
        this.global.setParameterValue("vectorScale", scale);
        this.global.vectorScale = scale;
    }

    public float getDefaultDrawArrowScale() {
        return this.global.defaultDrawArrowScale;
    }

    public void setDefaultDrawArrowScale(float scale) {
        this.global.setParameterValue("defaultDrawArrowScale", scale);
        this.global.defaultDrawArrowScale = scale;
    }

    float getVibrationScale() {
        return this.global.vibrationScale;
    }

    float getVibrationPeriod() {
        return this.global.vibrationPeriod;
    }

    public boolean isVibrationOn() {
        return this.transformManager.vibrationOn;
    }

    public void setVibrationScale(float scale) {
        this.transformManager.setVibrationScale(scale);
        this.global.vibrationScale = scale;
        this.global.setParameterValue("vibrationScale", scale);
    }

    void setVibrationOff() {
        this.transformManager.setVibrationPeriod(0.0f);
    }

    public void setVibrationPeriod(float period) {
        this.transformManager.setVibrationPeriod(period);
        this.global.vibrationPeriod = period = Math.abs(period);
        this.global.setParameterValue("vibrationPeriod", period);
    }

    void setObjectColor(String name, String colorName) {
        if (colorName == null || colorName.length() == 0) {
            return;
        }
        this.setObjectArgb(name, Graphics3D.getArgbFromString(colorName));
    }

    void setObjectArgb(String name, int argb) {
        int objId = StateManager.getObjectIdFromName(name);
        if (objId < 0) {
            return;
        }
        this.global.objColors[objId] = argb;
        switch (objId) {
            case 0: {
                this.g3d.setBackgroundArgb(argb);
                this.colorManager.setColixBackgroundContrast(argb);
                this.global.backgroundImageFileName = null;
            }
        }
        this.global.setParameterValue(name + "Color", Escape.escapeColor(argb));
    }

    void setBackgroundImage(String fileName, Image image) {
        this.global.backgroundImageFileName = fileName;
        this.g3d.setBackgroundImage(image);
    }

    int getObjectArgb(int objId) {
        return this.global.objColors[objId];
    }

    public short getObjectColix(int objId) {
        int argb = this.getObjectArgb(objId);
        if (argb == 0) {
            return this.getColixBackgroundContrast();
        }
        return Graphics3D.getColix(argb);
    }

    public String getObjectState(String name) {
        int objId = StateManager.getObjectIdFromName(name.equalsIgnoreCase("axes") ? "axis" : name);
        if (objId < 0) {
            return "";
        }
        int mad = this.getObjectMad(objId);
        StringBuffer s = new StringBuffer("\n");
        Shape.appendCmd(s, name + (mad == 0 ? " off" : (mad == 1 ? " on" : (mad == -1 ? " dotted" : (mad < 20 ? " " + mad : " " + (float)mad / 2000.0f)))));
        return s.toString();
    }

    public void setColorBackground(String colorName) {
        this.setObjectColor("background", colorName);
    }

    public int getBackgroundArgb() {
        return this.getObjectArgb(0);
    }

    void setObjectMad(int iShape, String name, int mad) {
        int objId = StateManager.getObjectIdFromName(name.equalsIgnoreCase("axes") ? "axis" : name);
        if (objId < 0) {
            return;
        }
        if (mad == -2 || mad == -4) {
            int m = mad + 3;
            mad = this.getObjectMad(objId);
            if (mad == 0) {
                mad = m;
            }
        }
        this.global.setParameterValue("show" + name, mad != 0);
        boolean bl = this.global.objStateOn[objId] = mad != 0;
        if (mad == 0) {
            return;
        }
        this.global.objMad[objId] = mad;
        this.setShapeSize(iShape, mad, Float.NaN);
    }

    public int getObjectMad(int objId) {
        return this.global.objStateOn[objId] ? this.global.objMad[objId] : 0;
    }

    public void setPropertyColorScheme(String scheme, boolean isOverloaded) {
        this.global.propertyColorScheme = scheme;
        this.colorManager.setColorScheme(scheme, isOverloaded);
    }

    public String getPropertyColorScheme() {
        return this.global.propertyColorScheme;
    }

    public short getColixBackgroundContrast() {
        return this.colorManager.colixBackgroundContrast;
    }

    String getSpecularState() {
        return this.global.getSpecularState();
    }

    private static void setSpecular(boolean specular) {
        ColorManager.setSpecular(specular);
    }

    boolean getSpecular() {
        return ColorManager.getSpecular();
    }

    private static void setSpecularPower(int specularPower) {
        ColorManager.setSpecularPower(Math.abs(specularPower));
    }

    private static void setSpecularExponent(int specularExponent) {
        ColorManager.setSpecularPower(-Math.abs(specularExponent));
    }

    private static void setAmbientPercent(int ambientPercent) {
        ColorManager.setAmbientPercent(ambientPercent);
    }

    static int getAmbientPercent() {
        return ColorManager.getAmbientPercent();
    }

    private static void setDiffusePercent(int diffusePercent) {
        ColorManager.setDiffusePercent(diffusePercent);
    }

    static int getDiffusePercent() {
        return ColorManager.getDiffusePercent();
    }

    private static void setSpecularPercent(int specularPercent) {
        ColorManager.setSpecularPercent(specularPercent);
    }

    static int getSpecularPercent() {
        return ColorManager.getSpecularPercent();
    }

    boolean getZShade() {
        return this.global.zShade;
    }

    public short getColixAtomPalette(Atom atom, byte pid) {
        return this.colorManager.getColixAtomPalette(atom, pid);
    }

    public short getColixBondPalette(Bond bond, byte pid) {
        return this.colorManager.getColixBondPalette(bond, pid);
    }

    public int[] getColorSchemeArray(String colorScheme) {
        return this.colorManager.getColorSchemeArray(colorScheme);
    }

    public String getColorSchemeList(String colorScheme, boolean ifDefault) {
        return this.colorManager.getColorSchemeList(colorScheme, ifDefault);
    }

    public static void setUserScale(int[] scale) {
        ColorManager.setUserScale(scale);
    }

    public short getColixForPropertyValue(float val) {
        return this.colorManager.getColixForPropertyValue(val);
    }

    Point3f getColorPointForPropertyValue(float val) {
        short colix = this.colorManager.getColixForPropertyValue(val);
        Point3f pt = new Point3f();
        return Graphics3D.colorPointFromInt(this.g3d.getColixArgb(colix), pt);
    }

    void select(BitSet bs, boolean isQuiet) {
        this.selectionManager.select(bs, isQuiet);
        this.modelSet.setShapeSize(1, Integer.MAX_VALUE, Float.NaN, null);
    }

    void selectBonds(BitSet bs) {
        this.modelSet.setShapeSize(1, Integer.MAX_VALUE, Float.NaN, bs);
    }

    void hide(BitSet bs, boolean isQuiet) {
        this.selectionManager.hide(bs, isQuiet);
    }

    void display(BitSet bs, boolean isQuiet) {
        this.selectionManager.display(this.getModelAtomBitSet(-1, false), bs, isQuiet);
    }

    BitSet getHiddenSet() {
        return this.selectionManager.getHiddenSet();
    }

    public boolean isSelected(int atomIndex) {
        return this.selectionManager.isSelected(atomIndex);
    }

    boolean isInSelectionSubset(int atomIndex) {
        return this.selectionManager.isInSelectionSubset(atomIndex);
    }

    void reportSelection(String msg) {
        if (this.modelSet.getSelectionHaloEnabled()) {
            this.setTainted(true);
        }
        if (this.isScriptQueued || this.global.debugScript) {
            this.scriptStatus(msg);
        }
    }

    public Point3f getAtomSetCenter(BitSet bs) {
        return this.modelSet.getAtomSetCenter(bs);
    }

    private void clearAtomSets() {
        this.setSelectionSubset(null);
        this.definedAtomSets.clear();
    }

    public void selectAll() {
        this.selectionManager.selectAll(false);
    }

    void setNoneSelected(boolean noneSelected) {
        this.noneSelected = noneSelected;
    }

    Boolean getNoneSelected() {
        return this.noneSelected ? Boolean.TRUE : Boolean.FALSE;
    }

    public void clearSelection() {
        this.selectionManager.clearSelection(false);
        this.global.setParameterValue("hideNotSelected", false);
    }

    public void setSelectionSet(BitSet set) {
        this.selectionManager.setSelectionSet(set);
    }

    void setSelectionSubset(BitSet subset) {
        this.selectionManager.setSelectionSubset(subset);
    }

    public BitSet getSelectionSubset() {
        return this.selectionManager.bsSubset;
    }

    void invertSelection() {
        this.selectionManager.invertSelection();
    }

    public BitSet getSelectionSet() {
        return this.selectionManager.bsSelection;
    }

    public int getSelectionCount() {
        return this.selectionManager.getSelectionCount();
    }

    void setFormalCharges(int formalCharge) {
        this.modelSet.setFormalCharges(this.selectionManager.bsSelection, formalCharge);
    }

    public void addSelectionListener(JmolSelectionListener listener) {
        this.selectionManager.addListener(listener);
    }

    public void removeSelectionListener(JmolSelectionListener listener) {
        this.selectionManager.addListener(listener);
    }

    BitSet getAtomBitSet(Object atomExpression) {
        return ScriptEvaluator.getAtomBitSet(this.eval, atomExpression);
    }

    Vector getAtomBitSetVector(Object atomExpression) {
        return ScriptEvaluator.getAtomBitSetVector(this.eval, this.getAtomCount(), atomExpression);
    }

    public void setModeMouse(int modeMouse) {
        if (this.haveDisplay) {
            this.mouseManager.setModeMouse(modeMouse);
        }
        if (modeMouse == -1) {
            this.clearScriptQueue();
            this.haltScriptExecution();
            this.transformManager.setSpinOn(false);
            this.transformManager.setVibrationPeriod(0.0f);
            this.scriptManager.startCommandWatcher(false);
            this.scriptManager.interruptQueueThreads();
            this.g3d.destroy();
        }
    }

    Rectangle getRubberBandSelection() {
        return this.mouseManager.getRubberBand();
    }

    public int getCursorX() {
        return this.mouseManager.xCurrent;
    }

    public int getCursorY() {
        return this.mouseManager.yCurrent;
    }

    String getDefaultDirectory() {
        return this.global.defaultDirectory;
    }

    public BufferedInputStream getBufferedInputStream(String fullPathName) {
        Object ret = this.getBufferedReaderOrErrorMessageFromName(fullPathName, new String[2], true);
        return ret instanceof BufferedInputStream ? (BufferedInputStream)ret : null;
    }

    Object getBufferedReaderOrErrorMessageFromName(String name, String[] fullPathNameReturn, boolean isBinary) {
        return this.fileManager.getBufferedReaderOrErrorMessageFromName(name, fullPathNameReturn, isBinary, true);
    }

    void addLoadScript(String script) {
        this.fileManager.addLoadScript(script);
    }

    private Hashtable setLoadParameters(Hashtable htParams) {
        if (htParams == null) {
            htParams = new Hashtable<String, Object>();
        }
        if (this.global.atomTypes.length() > 0) {
            htParams.put("atomTypes", this.global.atomTypes);
        }
        if (!htParams.containsKey("lattice")) {
            htParams.put("lattice", this.global.getDefaultLattice());
        }
        if (this.global.applySymmetryToBonds) {
            htParams.put("applySymmetryToBonds", Boolean.TRUE);
        }
        if (this.getPdbLoadInfo(2)) {
            htParams.put("getHeader", Boolean.TRUE);
        }
        return htParams;
    }

    public String openFile(String fileName) {
        this.zap(false, false);
        this.fileManager.createAtomSetCollectionFromFile(fileName, null, null, false);
        return this.createModelSetAndReturnError(false);
    }

    public void openFileAsynchronously(String fileName) {
        boolean allowScript;
        boolean bl = allowScript = !fileName.startsWith("\t");
        if (!allowScript) {
            fileName = fileName.substring(1);
        }
        fileName = fileName.replace('\\', '/');
        String type = this.fileManager.getFileTypeName(fileName);
        this.checkHalt("exit");
        if (this.scriptEditorVisible && (allowScript &= type == null)) {
            this.statusManager.showEditor(new String[]{fileName, this.getFileAsString(fileName)});
        } else {
            this.evalString((allowScript ? "script " : "load ") + Escape.escape(fileName));
        }
    }

    void openFile(String fileName, Hashtable htParams, String loadScript, boolean isAppend) {
        if (fileName == null) {
            return;
        }
        if (fileName.equalsIgnoreCase("string[]")) {
            return;
        }
        Logger.startTimer();
        if (fileName.equalsIgnoreCase("string")) {
            String fileData = htParams.containsKey("fileData") ? (String)htParams.get("fileData") : this.fileManager.getInlineData(-1);
            this.createModelSetInline(fileData, htParams, isAppend, false);
        } else {
            if (!isAppend && fileName.charAt(0) != '?') {
                this.zap(false, false);
            }
            this.fileManager.createAtomSetCollectionFromFile(fileName, this.setLoadParameters(htParams), loadScript, isAppend);
        }
        Logger.checkTimer("openFile(" + fileName + ")");
    }

    public String openFiles(String modelName, String[] fileNames) {
        this.openFiles(modelName, fileNames, null, false, null);
        return this.createModelSetAndReturnError(false);
    }

    String openFiles(String modelName, String[] fileNames, String loadScript, boolean isAppend, Hashtable htParams) {
        if (!isAppend) {
            this.zap(false, false);
        }
        long timeBegin = System.currentTimeMillis();
        this.fileManager.createAtomSetCollectionFromFiles(modelName, fileNames, loadScript, isAppend, this.setLoadParameters(htParams));
        long ms = System.currentTimeMillis() - timeBegin;
        String msg = "";
        for (int i = 0; i < fileNames.length; ++i) {
            msg = msg + (i == 0 ? "" : ",") + fileNames[i];
        }
        Logger.info("openFiles(" + fileNames.length + ") " + ms + " ms");
        return msg;
    }

    public String openStringInline(String strModel) {
        return this.createModelSetInline(strModel, null, false, true);
    }

    private String createModelSetInline(String strModel, Hashtable htParams, boolean isAppend, boolean createModelSet) {
        if (!isAppend) {
            this.zap(true, false);
        }
        this.fileManager.createAtomSetCollectionFromString(strModel, this.setLoadParameters(htParams), isAppend);
        return createModelSet ? this.createModelSetAndReturnError(isAppend) : null;
    }

    private String openStringsInline(String[] arrayModels, Hashtable htParams, boolean isAppend) {
        if (!isAppend) {
            this.zap(true, false);
        }
        this.fileManager.createAtomSeCollectionFromStrings(arrayModels, this.setLoadParameters(htParams), isAppend);
        return this.createModelSetAndReturnError(isAppend);
    }

    public char getInlineChar() {
        return this.global.inlineNewlineChar;
    }

    public String loadInline(String strModel) {
        return this.loadInline(strModel, this.global.inlineNewlineChar, false);
    }

    public String loadInline(String strModel, boolean isAppend) {
        return this.loadInline(strModel, '\u0000', isAppend);
    }

    public String loadInline(String strModel, char newLine) {
        return this.loadInline(strModel, newLine, false);
    }

    String loadInline(String strModel, char newLine, boolean isAppend) {
        String datasep;
        int i;
        String rep;
        if (strModel == null) {
            return null;
        }
        Hashtable htParams = new Hashtable();
        Logger.debug(strModel);
        String string = rep = strModel.indexOf(10) >= 0 ? "" : "\n";
        if (newLine != '\u0000' && newLine != '\n') {
            int len = strModel.length();
            for (i = 0; i < len && strModel.charAt(i) == ' '; ++i) {
            }
            if (i < len && strModel.charAt(i) == newLine) {
                strModel = strModel.substring(i + 1);
            }
            strModel = TextFormat.simpleReplace(strModel, "" + newLine, rep);
        }
        if ((datasep = this.getDataSeparator()) != null && datasep != "" && (i = strModel.indexOf(datasep)) >= 0) {
            int n = 2;
            while ((i = strModel.indexOf(datasep, i + 1)) >= 0) {
                ++n;
            }
            String[] strModels = new String[n];
            int pt = 0;
            int pt0 = 0;
            for (i = 0; i < n; ++i) {
                pt = strModel.indexOf(datasep, pt0);
                if (pt < 0) {
                    pt = strModel.length();
                }
                strModels[i] = strModel.substring(pt0, pt);
                pt0 = pt + datasep.length();
            }
            return this.openStringsInline(strModels, htParams, isAppend);
        }
        return this.createModelSetInline(strModel, htParams, isAppend, true);
    }

    String getDataSeparator() {
        return (String)this.global.getParameter("dataseparator");
    }

    public String loadInline(String[] arrayModels) {
        return this.loadInline(arrayModels, false);
    }

    public String loadInline(String[] arrayModels, boolean isAppend) {
        return arrayModels == null || arrayModels.length == 0 ? null : this.openStringsInline(arrayModels, null, isAppend);
    }

    public boolean getApplySymmetryToBonds() {
        return this.global.applySymmetryToBonds;
    }

    void setApplySymmetryToBonds(boolean TF) {
        this.global.applySymmetryToBonds = TF;
    }

    void setAtomData(int type, String name, String coordinateData) {
        this.modelSet.setAtomData(type, name, coordinateData);
    }

    public String openDOM(Object DOMNode) {
        this.zap(true, false);
        long timeBegin = System.currentTimeMillis();
        this.fileManager.createAtomSetCollectionFromDOM(DOMNode);
        long ms = System.currentTimeMillis() - timeBegin;
        Logger.info("openDOM " + ms + " ms");
        return this.createModelSetAndReturnError(false);
    }

    public String openReader(String fullPathName, String fileName, Reader reader) {
        this.zap(true, false);
        this.fileManager.createAtomSetCollectionFromReader(fullPathName, fileName, reader);
        return this.createModelSetAndReturnError(false);
    }

    String createModelSetAndReturnError(boolean isAppend) {
        String errMsg;
        String fullPathName = this.getFullPathName();
        String fileName = this.getFileName();
        Object atomSetCollection = this.fileManager.getAtomSetCollectionOrError();
        this.fileManager.deallocateReaderThreads();
        if (atomSetCollection instanceof String || atomSetCollection == null) {
            errMsg = (String)atomSetCollection;
            this.setFileLoadStatus(-1, fullPathName, null, null, errMsg);
            if (errMsg != null && !isAppend && !errMsg.equals("#CANCELED#")) {
                this.zap(errMsg);
            }
        } else {
            if (isAppend) {
                this.clearAtomSets();
            }
            this.setFileLoadStatus(2, fullPathName, fileName, null, null);
            errMsg = this.createModelSet(fullPathName, fileName, atomSetCollection, isAppend);
            this.setFileLoadStatus(3, fullPathName, fileName, this.getModelSetName(), errMsg);
            if (isAppend) {
                this.selectAll();
                this.setTainted(true);
            }
            atomSetCollection = null;
            System.gc();
        }
        return errMsg;
    }

    String loadAtomDataAndReturnError(int tokType) {
        Object atomSetCollection = this.fileManager.getAtomSetCollectionOrError();
        this.fileManager.deallocateReaderThreads();
        String errMsg = atomSetCollection instanceof String || atomSetCollection == null ? (String)atomSetCollection : this.createAtomDataSet(tokType, atomSetCollection);
        return errMsg;
    }

    private String createAtomDataSet(int tokType, Object atomSetCollection) {
        this.setErrorMessage(null);
        try {
            ((ModelLoader)this.modelSet).createAtomDataSet(tokType, atomSetCollection, this.selectionManager.bsSelection);
            if (tokType == 4162) {
                this.setStatusFrameChanged(Integer.MIN_VALUE);
            }
        }
        catch (Error er) {
            this.handleError(er, true);
            String errMsg = this.getShapeErrorState();
            errMsg = "ERROR adding vibrations: " + er + (errMsg.length() == 0 ? "" : "|" + errMsg);
            this.zap(errMsg);
            this.setErrorMessage(errMsg);
        }
        return this.getErrorMessage();
    }

    void deallocateReaderThreads() {
        this.fileManager.deallocateReaderThreads();
    }

    public void openClientFile(String fullPathName, String fileName, Object clientFile) {
        this.createModelSet(fullPathName, fileName, clientFile, false);
    }

    private String createModelSet(String fullPathName, String fileName, Object atomSetCollection, boolean isAppend) {
        this.pushHoldRepaint("createModelSet");
        this.setErrorMessage(null);
        try {
            this.modelSet = this.modelManager.createModelSet(fullPathName, fileName, atomSetCollection, isAppend);
            if (!isAppend) {
                this.initializeModel();
            }
        }
        catch (Error er) {
            this.handleError(er, true);
            String errMsg = this.getShapeErrorState();
            errMsg = "ERROR creating model: " + er + (errMsg.length() == 0 ? "" : "|" + errMsg);
            this.zap(errMsg);
            this.setErrorMessage(errMsg);
        }
        this.popHoldRepaint("createModelSet");
        return this.getErrorMessage();
    }

    public Object getCurrentFileAsBytes() {
        String filename = this.getFullPathName();
        if (filename.equals("string") || filename.equals("string[]") || filename.equals("JSNode")) {
            String str = this.getCurrentFileAsString();
            try {
                return str.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException e) {
                return str;
            }
        }
        String pathName = this.modelManager.getModelSetPathName();
        if (pathName == null) {
            return "";
        }
        return this.fileManager.getFileAsBytes(pathName);
    }

    public Object getFileAsBytes(String pathName) {
        return this.fileManager.getFileAsBytes(pathName);
    }

    public String getCurrentFileAsString() {
        String filename = this.getFullPathName();
        if (filename == "string") {
            return this.fileManager.getInlineData(-1);
        }
        if (filename == "string[]") {
            int modelIndex = this.getDisplayModelIndex();
            if (modelIndex < 0) {
                return "";
            }
            return this.fileManager.getInlineData(modelIndex);
        }
        if (filename == "JSNode") {
            return "<DOM NODE>";
        }
        String pathName = this.modelManager.getModelSetPathName();
        if (pathName == null) {
            return null;
        }
        return this.getFileAsString(pathName, Integer.MAX_VALUE, true);
    }

    public String getFullPathName() {
        return this.fileManager.getFullPathName();
    }

    public String getFileName() {
        return this.fileManager.getFileName();
    }

    public String getFileAsString(String name) {
        return this.getFileAsString(name, Integer.MAX_VALUE, false);
    }

    public String getFileAsString(String name, int nBytesMax, boolean doSpecialLoad) {
        if (name == null) {
            return this.getCurrentFileAsString();
        }
        String[] data = new String[2];
        data[0] = name;
        this.getFileAsString(data, nBytesMax, doSpecialLoad);
        return data[1];
    }

    public String getFullPath(String name) {
        return this.fileManager.getFullPath(name, false);
    }

    public boolean getFileAsString(String[] data, int nBytesMax, boolean doSpecialLoad) {
        return this.fileManager.getFileDataOrErrorAsString(data, nBytesMax, doSpecialLoad);
    }

    String[] getFileInfo() {
        return this.fileManager.getFileInfo();
    }

    void setFileInfo(String[] fileInfo) {
        this.fileManager.setFileInfo(fileInfo);
    }

    public void autoCalculate(int tokProperty) {
        switch (tokProperty) {
            case 38797328: {
                this.modelSet.getSurfaceDistanceMax();
                break;
            }
            case 38797327: {
                this.modelSet.calculateStraightness();
            }
        }
    }

    int getSurfaceDistanceMax() {
        return this.modelSet.getSurfaceDistanceMax();
    }

    public void calculateStraightness() {
        this.modelSet.calculateStraightness();
    }

    public Point3f[] calculateSurface(BitSet bsSelected, float envelopeRadius) {
        if (bsSelected == null) {
            bsSelected = this.selectionManager.bsSelection;
        }
        this.addStateScript("calculate surfaceDistance " + (envelopeRadius == Float.MAX_VALUE ? "FROM" : "WITHIN"), null, bsSelected, null, "", false, true);
        return this.modelSet.calculateSurface(bsSelected, envelopeRadius);
    }

    void calculateStructures(BitSet bsAtoms) {
        this.modelSet.calculateStructures(bsAtoms);
    }

    public AtomIndexIterator getWithinModelIterator(Atom atom, float distance) {
        return this.modelSet.getWithinModelIterator(atom, distance);
    }

    public AtomIndexIterator getWithinAtomSetIterator(int atomIndex, float distance, BitSet bsSelected, boolean isGreaterOnly, boolean modelZeroBased) {
        return this.modelSet.getWithinAtomSetIterator(atomIndex, distance, bsSelected, isGreaterOnly, modelZeroBased);
    }

    public void fillAtomData(AtomData atomData, int mode) {
        atomData.programInfo = "Jmol Version " + Viewer.getJmolVersion();
        atomData.fileName = this.getFileName();
        this.modelSet.fillAtomData(atomData, mode);
    }

    void addStateScript(String script, boolean addFrameNumber, boolean postDefinitions) {
        this.addStateScript(script, null, null, null, null, addFrameNumber, postDefinitions);
    }

    void addStateScript(String script1, BitSet bsBonds, BitSet bsAtoms1, BitSet bsAtoms2, String script2, boolean addFrameNumber, boolean postDefinitions) {
        this.modelSet.addStateScript(script1, bsBonds, bsAtoms1, bsAtoms2, script2, addFrameNumber, postDefinitions);
    }

    public boolean getEchoStateActive() {
        return this.modelSet.getEchoStateActive();
    }

    void setEchoStateActive(boolean TF) {
        this.modelSet.setEchoStateActive(TF);
    }

    public void zap(boolean notify, boolean resetUndo) {
        this.stopAnimationThreads();
        if (this.modelSet != null) {
            this.clearModelDependentObjects();
            this.fileManager.clear();
            this.repaintManager.clear();
            this.animationManager.clear();
            this.transformManager.clear();
            this.pickingManager.clear();
            this.selectionManager.clear();
            this.clearAllMeasurements();
            if (this.minimizer != null) {
                this.minimizer.setProperty("clear", null);
            }
            this.modelSet = this.modelManager.clear();
            if (this.haveDisplay) {
                this.mouseManager.clear();
            }
            this.stateManager.clear();
            this.global.clear();
            this.tempManager.clear();
            this.colorManager.clear();
            this.definedAtomSets.clear();
            this.dataManager.clear();
            System.gc();
        }
        this.modelSet = this.modelManager.zap();
        this.initializeModel();
        if (notify) {
            this.setFileLoadStatus(0, null, resetUndo ? "resetUndo" : null, null, null);
        }
        if (Logger.debugging) {
            Logger.checkMemory();
        }
    }

    private void zap(String msg) {
        this.zap(true, false);
        this.echoMessage(msg);
    }

    void echoMessage(String msg) {
        int iShape = 26;
        this.loadShape(iShape);
        this.setShapeProperty(iShape, "font", this.getFont3D("SansSerif", "Plain", 9.0f));
        this.setShapeProperty(iShape, "target", "error");
        this.setShapeProperty(iShape, "text", msg);
    }

    public String getMinimizationInfo() {
        return this.minimizer == null ? "" : (String)this.minimizer.getProperty("log", 0);
    }

    public boolean useMinimizationThread() {
        return this.global.useMinimizationThread && !this.autoExit;
    }

    private void initializeModel() {
        this.stopAnimationThreads();
        this.reset();
        this.selectAll();
        this.noneSelected = false;
        this.transformManager.setCenter();
        this.clearAtomSets();
        this.animationManager.initializePointers(1);
        this.setCurrentModelIndex(0);
        this.setBackgroundModelIndex(-1);
        this.setFrankOn(this.getShowFrank());
        if (this.haveDisplay) {
            this.mouseManager.startHoverWatcher(true);
        }
        this.setTainted(true);
        this.finalizeTransformParameters();
    }

    public String getModelSetName() {
        if (this.modelSet == null) {
            return null;
        }
        return this.modelSet.getModelSetName();
    }

    public String getModelSetFileName() {
        return this.modelManager.getModelSetFileName();
    }

    public String getUnitCellInfoText() {
        return this.modelSet.getUnitCellInfoText();
    }

    public String getSpaceGroupInfoText(String spaceGroup) {
        return this.modelSet.getSpaceGroupInfoText(spaceGroup);
    }

    void getPolymerPointsAndVectors(BitSet bs, Vector vList) {
        this.modelSet.getPolymerPointsAndVectors(bs, vList);
    }

    public String getModelSetProperty(String strProp) {
        return this.modelSet.getModelSetProperty(strProp);
    }

    public Object getModelSetAuxiliaryInfo(String strKey) {
        return this.modelSet.getModelSetAuxiliaryInfo(strKey);
    }

    public String getModelSetPathName() {
        return this.modelManager.getModelSetPathName();
    }

    public String getModelSetTypeName() {
        return this.modelSet.getModelSetTypeName();
    }

    public boolean haveFrame() {
        return this.haveModelSet();
    }

    boolean haveModelSet() {
        return this.modelSet != null;
    }

    void clearBfactorRange() {
        this.modelSet.clearBfactorRange();
    }

    public String getHybridizationAndAxes(int atomIndex, Vector3f z, Vector3f x, String lcaoType, boolean hybridizationCompatible) {
        return this.modelSet.getHybridizationAndAxes(atomIndex, z, x, lcaoType, hybridizationCompatible);
    }

    public BitSet getModelAtomBitSet(int modelIndex, boolean asCopy) {
        return this.modelSet.getModelAtomBitSet(modelIndex, asCopy);
    }

    public BitSet getModelBitSet(BitSet atomList, boolean allTrajectories) {
        return this.modelSet.getModelBitSet(atomList, allTrajectories);
    }

    Object getClientFile() {
        return null;
    }

    public String getClientAtomStringProperty(Object clientAtom, String propertyName) {
        return this.modelAdapter == null || propertyName == null || propertyName.length() == 0 ? null : this.modelAdapter.getClientAtomStringProperty(clientAtom, propertyName);
    }

    JmolAdapter getExportJmolAdapter() {
        return null;
    }

    public ModelSet getModelSet() {
        return this.modelSet;
    }

    public String getBoundBoxCommand(boolean withOptions) {
        return this.modelSet.getBoundBoxCommand(withOptions);
    }

    void setBoundBox(Point3f pt1, Point3f pt2, boolean byCorner) {
        this.modelSet.setBoundBox(pt1, pt2, byCorner);
    }

    public Point3f getBoundBoxCenter() {
        return this.modelSet.getBoundBoxCenter(this.animationManager.currentModelIndex);
    }

    Point3f getAverageAtomPoint() {
        return this.modelSet.getAverageAtomPoint();
    }

    void calcBoundBoxDimensions(BitSet bs) {
        this.modelSet.calcBoundBoxDimensions(bs);
        this.axesAreTainted = true;
    }

    BoxInfo getBoxInfo(BitSet bs) {
        return this.modelSet.getBoxInfo(bs);
    }

    float calcRotationRadius(Point3f center) {
        return this.modelSet.calcRotationRadius(this.animationManager.currentModelIndex, center);
    }

    public float calcRotationRadius(BitSet bs) {
        return this.modelSet.calcRotationRadius(bs);
    }

    public Vector3f getBoundBoxCornerVector() {
        return this.modelSet.getBoundBoxCornerVector();
    }

    Hashtable getBoundBoxInfo() {
        return this.modelSet.getBoundBoxInfo();
    }

    public BitSet getBoundBoxModels() {
        return this.modelSet.getBoundBoxModels();
    }

    public int getBoundBoxCenterX() {
        return this.dimScreen.width / 2;
    }

    public int getBoundBoxCenterY() {
        return this.dimScreen.height / 2;
    }

    public int getModelCount() {
        return this.modelSet.getModelCount();
    }

    String getModelInfoAsString() {
        return this.modelSet.getModelInfoAsString();
    }

    String getSymmetryInfoAsString() {
        return this.modelSet.getSymmetryInfoAsString();
    }

    public Properties getModelSetProperties() {
        return this.modelSet.getModelSetProperties();
    }

    public Hashtable getModelSetAuxiliaryInfo() {
        return this.modelSet.getModelSetAuxiliaryInfo();
    }

    public int getModelNumber(int modelIndex) {
        if (modelIndex < 0) {
            return modelIndex;
        }
        return this.modelSet.getModelNumber(modelIndex);
    }

    public int getModelFileNumber(int modelIndex) {
        if (modelIndex < 0) {
            return 0;
        }
        return this.modelSet.getModelFileNumber(modelIndex);
    }

    public String getModelNumberDotted(int modelIndex) {
        return modelIndex < 0 ? "0" : (this.modelSet == null ? null : this.modelSet.getModelNumberDotted(modelIndex));
    }

    public String getModelName(int modelIndex) {
        return this.modelSet == null ? null : this.modelSet.getModelName(modelIndex);
    }

    public Properties getModelProperties(int modelIndex) {
        return this.modelSet.getModelProperties(modelIndex);
    }

    public String getModelProperty(int modelIndex, String propertyName) {
        return this.modelSet.getModelProperty(modelIndex, propertyName);
    }

    public String getModelFileInfo() {
        return this.modelSet.getModelFileInfo(this.getVisibleFramesBitSet());
    }

    String getModelFileInfoAll() {
        return this.modelSet.getModelFileInfo(null);
    }

    public Hashtable getModelAuxiliaryInfo(int modelIndex) {
        return this.modelSet.getModelAuxiliaryInfo(modelIndex);
    }

    public Object getModelAuxiliaryInfo(int modelIndex, String keyName) {
        return this.modelSet.getModelAuxiliaryInfo(modelIndex, keyName);
    }

    int getModelNumberIndex(int modelNumber, boolean useModelNumber, boolean doSetTrajectory) {
        return this.modelSet.getModelNumberIndex(modelNumber, useModelNumber, doSetTrajectory);
    }

    boolean modelSetHasVibrationVectors() {
        return this.modelSet.modelSetHasVibrationVectors();
    }

    public boolean modelHasVibrationVectors(int modelIndex) {
        return this.modelSet.modelHasVibrationVectors(modelIndex);
    }

    public int getChainCount() {
        return this.modelSet.getChainCount(true);
    }

    public int getChainCountInModel(int modelIndex) {
        return this.modelSet.getChainCountInModel(modelIndex, false);
    }

    public int getChainCountInModel(int modelIndex, boolean countWater) {
        return this.modelSet.getChainCountInModel(modelIndex, countWater);
    }

    public int getGroupCount() {
        return this.modelSet.getGroupCount();
    }

    public int getGroupCountInModel(int modelIndex) {
        return this.modelSet.getGroupCountInModel(modelIndex);
    }

    public int getPolymerCount() {
        return this.modelSet.getBioPolymerCount();
    }

    public int getPolymerCountInModel(int modelIndex) {
        return this.modelSet.getBioPolymerCountInModel(modelIndex);
    }

    public int getAtomCount() {
        return this.modelSet.getAtomCount();
    }

    public int getAtomCountInModel(int modelIndex) {
        return this.modelSet.getAtomCountInModel(modelIndex);
    }

    public int getBondCount() {
        return this.modelSet.getBondCount();
    }

    public int getBondCountInModel(int modelIndex) {
        return this.modelSet.getBondCountInModel(modelIndex);
    }

    BitSet getBondsForSelectedAtoms(BitSet bsAtoms) {
        return this.modelSet.getBondsForSelectedAtoms(bsAtoms, this.global.bondModeOr || BitSetUtil.cardinalityOf(bsAtoms) == 1);
    }

    boolean frankClicked(int x, int y) {
        return this.frankOn && this.modelSet.frankClicked(x, y);
    }

    public int findNearestAtomIndex(int x, int y) {
        return this.modelSet == null || !this.getAtomPicking() ? -1 : this.modelSet.findNearestAtomIndex(x, y);
    }

    void selectRectangle(Rectangle rect, int modifiers) {
        BitSet bs = this.modelSet.findAtomsInRectangle(rect, this.getVisibleFramesBitSet());
        if (BitSetUtil.firstSetBit(bs) < 0) {
            return;
        }
        this.pickingManager.atomsPicked(bs, modifiers);
    }

    void toCartesian(Point3f pt) {
        int modelIndex = this.animationManager.currentModelIndex;
        if (modelIndex < 0) {
            return;
        }
        this.modelSet.toCartesian(modelIndex, pt);
    }

    void toUnitCell(Point3f pt, Point3f offset) {
        int modelIndex = this.animationManager.currentModelIndex;
        if (modelIndex < 0) {
            return;
        }
        this.modelSet.toUnitCell(modelIndex, pt, offset);
    }

    void toFractional(Point3f pt) {
        int modelIndex = this.animationManager.currentModelIndex;
        if (modelIndex < 0) {
            return;
        }
        this.modelSet.toFractional(modelIndex, pt);
    }

    public void setCenterSelected() {
        this.setCenterBitSet(this.selectionManager.bsSelection, true);
    }

    public void setBondTolerance(float bondTolerance) {
        this.global.setParameterValue("bondTolerance", bondTolerance);
        this.global.bondTolerance = bondTolerance;
    }

    public float getBondTolerance() {
        return this.global.bondTolerance;
    }

    public void setMinBondDistance(float minBondDistance) {
        this.global.setParameterValue("minBondDistance", minBondDistance);
        this.global.minBondDistance = minBondDistance;
    }

    public float getMinBondDistance() {
        return this.global.minBondDistance;
    }

    int[] getAtomIndices(BitSet bs) {
        return this.modelSet.getAtomIndices(bs);
    }

    public BitSet getAtomBits(int tokType, Object specInfo) {
        return this.modelSet.getAtomBits(tokType, specInfo);
    }

    BitSet getSequenceBits(String specInfo, BitSet bs) {
        return this.modelSet.getSequenceBits(specInfo, bs);
    }

    BitSet getAtomsWithin(float distance, Point3f coord) {
        BitSet bs = new BitSet();
        this.modelSet.getAtomsWithin(distance, coord, bs, -1);
        if (distance < 0.0f) {
            this.modelSet.getAtomsWithin(-distance, coord, bs, -1);
        }
        return bs;
    }

    BitSet getAtomsWithin(float distance, Point4f plane) {
        return this.modelSet.getAtomsWithin(distance, plane);
    }

    BitSet getAtomsWithin(float distance, BitSet bs, boolean isWithinModelSet) {
        return this.modelSet.getAtomsWithin(distance, bs, isWithinModelSet);
    }

    BitSet getAtomsConnected(float min, float max, int intType, BitSet bs) {
        return this.modelSet.getAtomsConnected(min, max, intType, bs);
    }

    BitSet getBranchBitSet(int atomIndex, int atomIndexNot) {
        return this.modelSet.getBranchBitSet(atomIndex, atomIndexNot);
    }

    int getAtomIndexFromAtomNumber(int atomNumber) {
        return this.modelSet.getAtomIndexFromAtomNumber(atomNumber, this.getVisibleFramesBitSet());
    }

    public BitSet getElementsPresentBitSet(int modelIndex) {
        return this.modelSet.getElementsPresentBitSet(modelIndex);
    }

    public Hashtable getHeteroList(int modelIndex) {
        return this.modelSet.getHeteroList(modelIndex);
    }

    BitSet getVisibleSet() {
        return this.modelSet.getVisibleSet();
    }

    BitSet getClickableSet() {
        return this.modelSet.getClickableSet();
    }

    void calcSelectedGroupsCount() {
        this.modelSet.calcSelectedGroupsCount(this.selectionManager.bsSelection);
    }

    void calcSelectedMonomersCount() {
        this.modelSet.calcSelectedMonomersCount(this.selectionManager.bsSelection);
    }

    void calcSelectedMoleculesCount() {
        this.modelSet.calcSelectedMoleculesCount(this.selectionManager.bsSelection);
    }

    String getFileHeader() {
        return this.modelSet.getFileHeader(this.animationManager.currentModelIndex);
    }

    String getPDBHeader() {
        return this.modelSet.getPDBHeader(this.animationManager.currentModelIndex);
    }

    public Hashtable getModelInfo(Object atomExpression) {
        return this.modelSet.getModelInfo(this.getModelBitSet(this.getAtomBitSet(atomExpression), false));
    }

    public Hashtable getAuxiliaryInfo(Object atomExpression) {
        return this.modelSet.getAuxiliaryInfo(this.getModelBitSet(this.getAtomBitSet(atomExpression), false));
    }

    public Hashtable getShapeInfo() {
        return this.modelSet.getShapeInfo();
    }

    int getShapeIdFromObjectName(String objectName) {
        return this.modelSet.getShapeIdFromObjectName(objectName);
    }

    Vector getAllAtomInfo(Object atomExpression) {
        return this.modelSet.getAllAtomInfo(this.getAtomBitSet(atomExpression));
    }

    Vector getAllBondInfo(Object atomExpression) {
        return this.modelSet.getAllBondInfo(this.getAtomBitSet(atomExpression));
    }

    Vector getMoleculeInfo(Object atomExpression) {
        return this.modelSet.getMoleculeInfo(this.getAtomBitSet(atomExpression));
    }

    public String getChimeInfo(int tok) {
        return this.modelSet.getChimeInfo(tok, this.selectionManager.bsSelection);
    }

    public Hashtable getAllChainInfo(Object atomExpression) {
        return this.modelSet.getAllChainInfo(this.getAtomBitSet(atomExpression));
    }

    public Hashtable getAllPolymerInfo(Object atomExpression) {
        return this.modelSet.getAllPolymerInfo(this.getAtomBitSet(atomExpression));
    }

    public String getStateInfo() {
        return this.getStateInfo(null);
    }

    public String getStateInfo(String type) {
        StringBuffer sfunc;
        boolean isAll = type == null || type.equalsIgnoreCase("all");
        StringBuffer s = new StringBuffer("");
        StringBuffer stringBuffer = sfunc = isAll ? new StringBuffer("function _setState() {\n") : null;
        if (isAll) {
            s.append(STATE_VERSION_STAMP + Viewer.getJmolVersion() + ";\n");
        }
        if (this.isApplet && isAll) {
            StateManager.appendCmd(s, "# fullName = " + Escape.escape(this.fullName));
            StateManager.appendCmd(s, "# documentBase = " + Escape.escape(this.appletDocumentBase));
            StateManager.appendCmd(s, "# codeBase = " + Escape.escape(this.appletCodeBase));
            s.append("\n");
        }
        if (isAll || type.equalsIgnoreCase("windowState")) {
            s.append(this.global.getWindowState(sfunc));
        }
        if (isAll) {
            s.append(this.eval.getState());
        }
        if (isAll || type.equalsIgnoreCase("fileState")) {
            s.append(this.fileManager.getState(sfunc));
        }
        if (isAll || type.equalsIgnoreCase("definedState")) {
            s.append(this.modelSet.getDefinedState(sfunc, true));
        }
        if (isAll || type.equalsIgnoreCase("variableState")) {
            s.append(this.global.getState(sfunc));
        }
        if (isAll || type.equalsIgnoreCase("dataState")) {
            this.dataManager.getDataState(s, sfunc, this.modelSet.atoms, this.getAtomCount(), this.modelSet.getAtomicPropertyState(-1, null));
        }
        if (isAll || type.equalsIgnoreCase("modelState")) {
            s.append(this.modelSet.getState(sfunc, true));
        }
        if (isAll || type.equalsIgnoreCase("colorState")) {
            s.append(ColorManager.getState(sfunc));
        }
        if (isAll || type.equalsIgnoreCase("frameState")) {
            s.append(this.animationManager.getState(sfunc));
        }
        if (isAll || type.equalsIgnoreCase("perspectiveState")) {
            s.append(this.transformManager.getState(sfunc));
        }
        if (isAll || type.equalsIgnoreCase("selectionState")) {
            s.append(this.selectionManager.getState(sfunc));
        }
        if (sfunc != null) {
            StateManager.appendCmd(sfunc, "set refreshing true");
            StateManager.appendCmd(sfunc, "set antialiasDisplay " + this.global.antialiasDisplay);
            StateManager.appendCmd(sfunc, "set antialiasTranslucent " + this.global.antialiasTranslucent);
            StateManager.appendCmd(sfunc, "set antialiasImages " + this.global.antialiasImages);
            if (this.getSpinOn()) {
                StateManager.appendCmd(sfunc, "spin on");
            }
            sfunc.append("}\n\n_setState;\n");
        }
        if (isAll) {
            s.append(sfunc);
        }
        return s.toString();
    }

    public String getStructureState() {
        return this.modelSet.getState(null, false);
    }

    String getProteinStructureState() {
        return this.modelSet.getProteinStructureState(this.selectionManager.bsSelection, false, false);
    }

    public String getCoordinateState(BitSet bsSelected) {
        return this.modelSet.getAtomicPropertyState(2, bsSelected);
    }

    void setCurrentColorRange(String label) {
        float[] data = this.getDataFloat(label);
        BitSet bs = data == null ? null : (BitSet)this.dataManager.getData(label)[2];
        this.setCurrentColorRange(data, bs);
    }

    void setCurrentColorRange(float[] data, BitSet bs) {
        this.colorManager.setCurrentColorRange(data, bs, this.global.propertyColorScheme);
    }

    public void setCurrentColorRange(float min, float max) {
        this.colorManager.setCurrentColorRange(min, max);
    }

    public float[] getCurrentColorRange() {
        return this.colorManager.getCurrentColorRange();
    }

    public void setData(String type, Object[] data, int atomCount, int matchField, int matchFieldColumnCount, int field, int fieldColumnCount) {
        this.dataManager.setData(this, type, data, atomCount, matchField, matchFieldColumnCount, field, fieldColumnCount);
    }

    Object[] getData(String type) {
        return this.dataManager.getData(type);
    }

    public float[] getDataFloat(String label) {
        return this.dataManager.getDataFloat(label);
    }

    float[][] getDataFloat2D(String label) {
        return this.dataManager.getDataFloat2D(label);
    }

    float[][][] getDataFloat3D(String label) {
        return null;
    }

    public float getDataFloat(String label, int atomIndex) {
        return this.dataManager.getDataFloat(label, atomIndex);
    }

    public String getAltLocListInModel(int modelIndex) {
        return this.modelSet.getAltLocListInModel(modelIndex);
    }

    public BitSet setConformation() {
        return this.modelSet.setConformation(-1, this.selectionManager.bsSelection);
    }

    public BitSet setConformation(int conformationIndex) {
        return this.modelSet.setConformation(this.animationManager.currentModelIndex, conformationIndex);
    }

    int autoHbond(BitSet bsBonds) {
        return this.autoHbond(this.selectionManager.bsSelection, this.selectionManager.bsSelection, bsBonds, 0.0f, 0.0f);
    }

    int autoHbond(BitSet bsFrom, BitSet bsTo, BitSet bsBonds, float maxXYDistance, float minAttachedAngle) {
        if (maxXYDistance < 0.0f) {
            maxXYDistance = this.global.hbondsDistanceMaximum;
        }
        if (minAttachedAngle < 0.0f) {
            minAttachedAngle = this.global.hbondsAngleMinimum;
        }
        return this.modelSet.autoHbond(bsFrom, bsTo, bsBonds, maxXYDistance, minAttachedAngle *= (float)Math.PI / 180);
    }

    public boolean hasCalculatedHBonds(BitSet bsAtoms) {
        return this.modelSet.hasCalculatedHBonds(bsAtoms);
    }

    public boolean havePartialCharges() {
        return this.modelSet.getPartialCharges() != null;
    }

    public SymmetryInterface getCurrentUnitCell() {
        return this.modelSet.getUnitCell(this.getDisplayModelIndex());
    }

    void setCurrentUnitCellOffset(int offset) {
        int modelIndex = this.animationManager.currentModelIndex;
        if (this.modelSet.setUnitCellOffset(modelIndex, offset)) {
            this.global.setParameterValue("=frame " + this.getModelNumberDotted(modelIndex) + "; set unitcell ", offset);
        }
    }

    void setCurrentUnitCellOffset(Point3f pt) {
        int modelIndex = this.animationManager.currentModelIndex;
        if (this.modelSet.setUnitCellOffset(modelIndex, pt)) {
            this.global.setParameterValue("=frame " + this.getModelNumberDotted(modelIndex) + "; set unitcell ", Escape.escape(pt));
        }
    }

    public String getDefaultMeasurementLabel(int nPoints) {
        switch (nPoints) {
            case 2: {
                return this.global.defaultDistanceLabel;
            }
            case 3: {
                return this.global.defaultAngleLabel;
            }
        }
        return this.global.defaultTorsionLabel;
    }

    public int getMeasurementCount() {
        int count = this.getShapePropertyAsInt(5, "count");
        return count <= 0 ? 0 : count;
    }

    public String getMeasurementStringValue(int i) {
        String str = "" + this.getShapeProperty(5, "stringValue", i);
        return str;
    }

    Vector getMeasurementInfo() {
        return (Vector)this.getShapeProperty(5, "info");
    }

    public String getMeasurementInfoAsString() {
        return (String)this.getShapeProperty(5, "infostring");
    }

    public int[] getMeasurementCountPlusIndices(int i) {
        int[] List2 = (int[])this.getShapeProperty(5, "countPlusIndices", i);
        return List2;
    }

    void setPendingMeasurement(MeasurementPending measurementPending) {
        this.setShapeProperty(5, "pending", measurementPending);
    }

    MeasurementPending getPendingMeasurement() {
        return (MeasurementPending)this.getShapeProperty(5, "pending");
    }

    void clearAllMeasurements() {
        this.setShapeProperty(5, "clear", null);
    }

    public void clearMeasurements() {
        this.evalString("measures delete");
    }

    public boolean getJustifyMeasurements() {
        return this.global.justifyMeasurements;
    }

    void setMeasurementFormats(String strFormat) {
        this.setShapeProperty(5, "setFormats", strFormat);
    }

    void defineMeasurement(Vector monitorExpressions, float[] rangeMinMax, boolean isDelete, boolean isAll, boolean isAllConnected, boolean isOn, boolean isOff, String strFormat) {
        this.setShapeProperty(5, "setConnected", isAllConnected ? Boolean.TRUE : Boolean.FALSE);
        this.setShapeProperty(5, "setRange", rangeMinMax);
        this.setShapeProperty(5, "setFormat", strFormat);
        this.setShapeProperty(5, (isDelete ? "deleteVector" : (isOn ? "showVector" : (isOff ? "hideVector" : "defineVector"))) + (isAll ? "_All" : ""), monitorExpressions);
    }

    public void deleteMeasurement(int i) {
        this.setShapeProperty(5, "delete", new Integer(i));
    }

    void deleteMeasurement(int[] atomCountPlusIndices) {
        this.setShapeProperty(5, "delete", atomCountPlusIndices);
    }

    public void showMeasurement(int[] atomCountPlusIndices, boolean isON) {
        this.setShapeProperty(5, isON ? "show" : "hide", atomCountPlusIndices);
    }

    void hideMeasurements(boolean isOFF) {
        this.setShapeProperty(5, "hideAll", isOFF);
    }

    void toggleMeasurement(int[] atomCountPlusIndices, String strFormat) {
        this.setShapeProperty(5, strFormat == null ? "toggle" : "toggleOn", atomCountPlusIndices);
        if (strFormat != null) {
            this.setShapeProperty(5, "setFormats", strFormat);
        }
    }

    void repaint() {
        if (this.display == null) {
            return;
        }
        this.display.repaint();
    }

    void setAnimationDirection(int direction) {
        this.animationManager.setAnimationDirection(direction);
    }

    void reverseAnimation() {
        this.animationManager.reverseAnimation();
    }

    int getAnimationDirection() {
        return this.animationManager.animationDirection;
    }

    Hashtable getAnimationInfo() {
        return this.animationManager.getAnimationInfo();
    }

    public void setAnimationFps(int fps) {
        if (fps < 1) {
            fps = 1;
        }
        if (fps > 50) {
            fps = 50;
        }
        this.global.setParameterValue("animationFps", fps);
        this.animationManager.setAnimationFps(fps);
    }

    public int getAnimationFps() {
        return this.animationManager.animationFps;
    }

    void setAnimationReplayMode(int replay, float firstFrameDelay, float lastFrameDelay) {
        this.animationManager.setAnimationReplayMode(replay, firstFrameDelay, lastFrameDelay);
    }

    int getAnimationReplayMode() {
        return this.animationManager.animationReplayMode;
    }

    void setAnimationOn(boolean animationOn) {
        boolean wasAnimating = this.animationManager.animationOn;
        if (animationOn == wasAnimating) {
            return;
        }
        this.animationManager.setAnimationOn(animationOn);
    }

    void resumeAnimation() {
        if (this.animationManager.animationOn) {
            Logger.debug("animation is ON in resumeAnimation");
            return;
        }
        this.animationManager.resumeAnimation();
    }

    void pauseAnimation() {
        if (!this.animationManager.animationOn || this.animationManager.animationPaused) {
            return;
        }
        this.animationManager.pauseAnimation();
    }

    void setAnimationRange(int modelIndex1, int modelIndex2) {
        this.animationManager.setAnimationRange(modelIndex1, modelIndex2);
    }

    public BitSet getVisibleFramesBitSet() {
        BitSet bs = BitSetUtil.copy(this.animationManager.getVisibleFramesBitSet());
        this.modelSet.selectDisplayedTrajectories(bs);
        return bs;
    }

    boolean isAnimationOn() {
        return this.animationManager.animationOn;
    }

    void setAnimationNext() {
        this.animationManager.setAnimationNext();
    }

    void setAnimationPrevious() {
        this.animationManager.setAnimationPrevious();
    }

    void setAnimationLast() {
        this.animationManager.setAnimationLast();
    }

    void rewindAnimation() {
        this.animationManager.rewindAnimation();
    }

    void setCurrentModelIndex(int modelIndex) {
        if (modelIndex == Integer.MIN_VALUE) {
            this.prevFrame = Integer.MIN_VALUE;
            this.setCurrentModelIndex(this.animationManager.currentModelIndex, true);
            return;
        }
        this.animationManager.setCurrentModelIndex(modelIndex);
    }

    void setTrajectory(int modelIndex) {
        this.modelSet.setTrajectory(modelIndex);
    }

    public void setTrajectory(BitSet bsModels) {
        this.modelSet.setTrajectory(bsModels);
    }

    boolean isTrajectory(int modelIndex) {
        return this.modelSet.isTrajectory(modelIndex);
    }

    public BitSet getBitSetTrajectories() {
        return this.modelSet.getBitSetTrajectories();
    }

    String getTrajectoryInfo() {
        return this.modelSet.getTrajectoryInfo();
    }

    void setFrameOffset(int modelIndex) {
        this.transformManager.setFrameOffset(modelIndex);
    }

    public void setFrameOffsets(BitSet bsAtoms) {
        this.bsFrameOffsets = bsAtoms;
        this.frameOffsets = this.modelSet.getFrameOffsets(this.bsFrameOffsets);
        this.transformManager.setFrameOffsets(this.frameOffsets);
    }

    public BitSet getFrameOffsets() {
        return this.bsFrameOffsets;
    }

    public void setCurrentModelIndex(int modelIndex, boolean clearBackground) {
        this.animationManager.setCurrentModelIndex(modelIndex, clearBackground);
    }

    public int getCurrentModelIndex() {
        return this.animationManager.currentModelIndex;
    }

    public int getDisplayModelIndex() {
        int modelIndex = this.animationManager.currentModelIndex;
        int backgroundIndex = this.getBackgroundModelIndex();
        return backgroundIndex >= 0 ? -2 - modelIndex : modelIndex;
    }

    boolean haveFileSet() {
        return this.getModelCount() > 1 && this.getModelNumber(0) > 1000000;
    }

    void setBackgroundModelIndex(int modelIndex) {
        this.animationManager.setBackgroundModelIndex(modelIndex);
        this.global.setParameterValue("backgroundModel", this.modelSet.getModelNumberDotted(modelIndex));
    }

    public int getBackgroundModelIndex() {
        return this.animationManager.backgroundModelIndex;
    }

    void setFrameVariables(int firstModelIndex, int lastModelIndex) {
        this.global.setParameterValue("_firstFrame", this.getModelNumberDotted(firstModelIndex));
        this.global.setParameterValue("_lastFrame", this.getModelNumberDotted(lastModelIndex));
    }

    public int getMotionEventNumber() {
        return this.motionEventNumber;
    }

    void setInMotion(boolean inMotion) {
        if (this.wasInMotion ^ inMotion) {
            this.animationManager.setInMotion(inMotion);
            if (inMotion) {
                ++this.motionEventNumber;
            } else {
                this.repaintManager.refresh();
            }
            this.wasInMotion = inMotion;
        }
    }

    public boolean getInMotion() {
        return this.animationManager.inMotion;
    }

    public void pushHoldRepaint() {
        this.pushHoldRepaint(null);
    }

    void pushHoldRepaint(String why) {
        this.repaintManager.pushHoldRepaint();
    }

    public void popHoldRepaint() {
        this.repaintManager.popHoldRepaint();
    }

    void popHoldRepaint(String why) {
        this.repaintManager.popHoldRepaint();
    }

    void setRefreshing(boolean TF) {
        this.refreshing = TF;
    }

    boolean getRefreshing() {
        return this.refreshing;
    }

    public void refresh(int mode, String strWhy) {
        if (this.repaintManager == null || !this.refreshing) {
            return;
        }
        if (mode > 0) {
            this.repaintManager.refresh();
        }
        if (mode % 3 != 0 && this.statusManager.doSync()) {
            this.statusManager.setSync(mode == 2 ? strWhy : null);
        }
    }

    void requestRepaintAndWait() {
        if (!this.haveDisplay) {
            return;
        }
        this.repaintManager.requestRepaintAndWait();
        if (this.statusManager.doSync()) {
            this.statusManager.setSync(null);
        }
    }

    void setSync() {
        if (this.statusManager.doSync()) {
            this.statusManager.setSync(null);
        }
    }

    public void repaintView() {
        this.repaintManager.repaintDone();
    }

    public boolean areAxesTainted() {
        boolean TF = this.axesAreTainted;
        this.axesAreTainted = false;
        return TF;
    }

    private void setMaximumSize(int x) {
        this.maximumSize = Math.max(x, 100);
    }

    public void setScreenDimension(Dimension dim) {
        dim.height = Math.min(dim.height, this.maximumSize);
        dim.width = Math.min(dim.width, this.maximumSize);
        int height = dim.height;
        int width = dim.width;
        if (this.transformManager.stereoMode == 1) {
            width = (width + 1) / 2;
        }
        if (this.dimScreen.width == width && this.dimScreen.height == height) {
            return;
        }
        this.resizeImage(width, height, false, false, true);
    }

    public float getImageFontScaling() {
        return this.imageFontScaling;
    }

    private void resizeImage(int width, int height, boolean isImageWrite, boolean isGenerator, boolean isReset) {
        if (!isImageWrite && this.creatingImage) {
            return;
        }
        if (width > 0) {
            if (isImageWrite && !isReset) {
                this.setImageFontScaling(width, height);
            }
            this.dimScreen.width = width;
            this.dimScreen.height = height;
        }
        this.antialiasDisplay = false;
        if (isReset) {
            this.imageFontScaling = 1.0f;
            this.antialiasDisplay = this.global.antialiasDisplay;
        } else if (isImageWrite && !isGenerator) {
            this.antialiasDisplay = this.global.antialiasImages;
        }
        if (this.antialiasDisplay) {
            this.imageFontScaling *= 2.0f;
        }
        if (width > 0 && !isImageWrite) {
            this.global.setParameterValue("_width", width);
            this.global.setParameterValue("_height", height);
            this.setStatusResized(width, height);
        }
        if (width <= 0) {
            width = this.dimScreen.width;
            height = this.dimScreen.height;
        }
        this.transformManager.setScreenParameters(width, height, isImageWrite || isReset ? this.global.zoomLarge : false, this.antialiasDisplay, false, false);
        this.g3d.setWindowParameters(width, height, this.antialiasDisplay);
    }

    public int getScreenWidth() {
        return this.dimScreen.width;
    }

    public int getScreenHeight() {
        return this.dimScreen.height;
    }

    public int getScreenDim() {
        return this.global.zoomLarge == this.dimScreen.height > this.dimScreen.width ? this.dimScreen.height : this.dimScreen.width;
    }

    public String generateOutput(String type, String fileName, int width, int height) {
        if (this.isDataOnly) {
            return "";
        }
        this.mustRender = true;
        this.saveState("_Export");
        int saveWidth = this.dimScreen.width;
        int saveHeight = this.dimScreen.height;
        this.resizeImage(width, height, true, true, false);
        this.setModelVisibility();
        String data = this.repaintManager.generateOutput(type, this.g3d, this.modelSet, fileName);
        this.resizeImage(saveWidth, saveHeight, true, true, true);
        return data;
    }

    public void renderScreenImage(Graphics gLeft, Graphics gRight, Dimension size, Rectangle clip) {
        if (this.creatingImage) {
            return;
        }
        if (this.isTainted || this.getSlabEnabled()) {
            this.setModelVisibility();
        }
        this.isTainted = false;
        if (size != null) {
            this.setScreenDimension(size);
        }
        if (gRight == null) {
            Image image = this.getScreenImage();
            if (this.transformManager.stereoMode == 1) {
                this.render1(gLeft, image, this.dimScreen.width, 0);
                image = this.getImage(false);
            }
            this.render1(gLeft, image, 0, 0);
        } else {
            this.render1(gRight, this.getImage(true), 0, 0);
            this.render1(gLeft, this.getImage(false), 0, 0);
        }
        this.repaintView();
    }

    public void renderScreenImage(Graphics g, Dimension size, Rectangle clip) {
        this.renderScreenImage(g, null, size, clip);
    }

    private Image getImage(boolean isDouble) {
        Image image = null;
        try {
            this.g3d.beginRendering(this.transformManager.getStereoRotationMatrix(isDouble));
            this.render();
            this.g3d.endRendering();
            image = this.g3d.getScreenImage();
        }
        catch (Error er) {
            this.handleError(er, false);
            this.setErrorMessage("Error during rendering: " + er);
        }
        return image;
    }

    private void render() {
        boolean antialias2 = this.antialiasDisplay && this.global.antialiasTranslucent;
        this.repaintManager.render(this.g3d, this.modelSet);
        if (this.g3d.setPass2(antialias2)) {
            this.transformManager.setAntialias(antialias2);
            this.repaintManager.render(this.g3d, this.modelSet);
            this.transformManager.setAntialias(this.antialiasDisplay);
        }
    }

    private Image getStereoImage(int stereoMode) {
        this.g3d.beginRendering(this.transformManager.getStereoRotationMatrix(true));
        this.render();
        this.g3d.endRendering();
        this.g3d.snapshotAnaglyphChannelBytes();
        this.g3d.beginRendering(this.transformManager.getStereoRotationMatrix(false));
        this.render();
        this.g3d.endRendering();
        switch (stereoMode) {
            case 2: {
                this.g3d.applyCyanAnaglyph();
                break;
            }
            case 5: {
                this.g3d.applyCustomAnaglyph(this.transformManager.stereoColors);
                break;
            }
            case 3: {
                this.g3d.applyBlueAnaglyph();
                break;
            }
            default: {
                this.g3d.applyGreenAnaglyph();
            }
        }
        return this.g3d.getScreenImage();
    }

    private void render1(Graphics g, Image img, int x, int y) {
        if (g != null && img != null) {
            try {
                g.drawImage(img, x, y, null);
            }
            catch (NullPointerException npe) {
                Logger.error("Sun!! ... fix graphics your bugs!");
            }
        }
        this.g3d.releaseScreenImage();
    }

    public Image getScreenImage() {
        return this.transformManager.stereoMode <= 1 ? this.getImage(this.transformManager.stereoMode == 1) : this.getStereoImage(this.transformManager.stereoMode);
    }

    public Object getImageAs(String type, int quality, int width, int height, String fileName, OutputStream os) {
        int saveWidth = this.dimScreen.width;
        int saveHeight = this.dimScreen.height;
        this.mustRender = true;
        this.resizeImage(width, height, true, false, false);
        this.setModelVisibility();
        this.creatingImage = true;
        JmolImageCreatorInterface c = null;
        Object bytes = null;
        type = type.toLowerCase();
        if (!Parser.isOneOf(type, "jpg;jpeg;jpg64;jpeg64")) {
            try {
                c = (JmolImageCreatorInterface)Interface.getOptionInterface("export.image.ImageCreator");
            }
            catch (Error er) {
                // empty catch block
            }
        }
        if (c == null) {
            Image eImage = this.getScreenImage();
            if (eImage != null) {
                try {
                    if (quality < 0) {
                        quality = 75;
                    }
                    bytes = JpegEncoder.getBytes(eImage, quality);
                    this.releaseScreenImage();
                    if (type.equals("jpg64") || type.equals("jpeg64")) {
                        bytes = bytes == null ? "" : Base64.getBase64((byte[])bytes).toString();
                    }
                }
                catch (Error er) {
                    this.releaseScreenImage();
                    this.handleError(er, false);
                    this.setErrorMessage("Error creating image: " + er);
                    bytes = this.getErrorMessage();
                }
            }
        } else {
            c.setViewer(this);
            try {
                bytes = c.getImageBytes(type, quality, fileName, os);
            }
            catch (IOException e) {
                bytes = e;
                this.setErrorMessage("Error creating image: " + e);
            }
            catch (Error er) {
                this.handleError(er, false);
                this.setErrorMessage("Error creating image: " + er);
                bytes = this.getErrorMessage();
            }
        }
        this.creatingImage = false;
        this.resizeImage(saveWidth, saveHeight, true, false, true);
        return bytes;
    }

    public void releaseScreenImage() {
        this.g3d.releaseScreenImage();
    }

    boolean getAllowEmbeddedScripts() {
        return this.global.allowEmbeddedScripts;
    }

    public String evalFile(String strFilename) {
        int ptWait = strFilename.indexOf(" -noqueue");
        if (ptWait >= 0) {
            return (String)this.evalStringWaitStatus("String", strFilename.substring(0, ptWait), "", true, false, false);
        }
        return this.scriptManager.addScript(strFilename, true, false);
    }

    public String script(String strScript) {
        return this.evalString(strScript);
    }

    String getInterruptScript() {
        String s = this.interruptScript;
        this.interruptScript = "";
        if (Logger.debugging && s != "") {
            Logger.debug("interrupt: " + s);
        }
        return s;
    }

    public String evalString(String strScript) {
        return this.evalStringQuiet(strScript, false, true);
    }

    public String evalStringQuiet(String strScript) {
        return this.evalStringQuiet(strScript, true, true);
    }

    String evalStringQuiet(String strScript, boolean isQuiet, boolean allowSyncScript) {
        String msg;
        boolean isInterrupt;
        if (allowSyncScript && this.statusManager.syncingScripts && strScript.indexOf("#NOSYNC;") < 0) {
            this.syncScript(strScript + " #NOSYNC;", null);
        }
        if (this.eval.isExecutionPaused() && strScript.charAt(0) != '!') {
            strScript = '!' + TextFormat.trim(strScript, "\n\r\t ");
        }
        boolean bl = isInterrupt = strScript.length() > 0 && strScript.charAt(0) == '!';
        if (isInterrupt) {
            strScript = strScript.substring(1);
        }
        if ((msg = this.checkScriptExecution(strScript)) != null) {
            return msg;
        }
        if (this.isScriptExecuting() && (isInterrupt || this.eval.isExecutionPaused())) {
            this.interruptScript = strScript;
            if (strScript.indexOf("moveto ") == 0) {
                this.scriptManager.flushQueue("moveto ");
            }
            return "!" + strScript;
        }
        this.interruptScript = "";
        if (isQuiet) {
            strScript = strScript + "\u0000## EDITOR_IGNORE ##";
        }
        return this.scriptManager.addScript(strScript, false, isQuiet && !this.getMessageStyleChime());
    }

    private String checkScriptExecution(String strScript) {
        String str = strScript;
        if (str.indexOf("\u0000##") >= 0) {
            str = str.substring(0, str.indexOf("\u0000##"));
        }
        if (this.checkResume(str)) {
            return "script processing resumed";
        }
        if (this.checkStepping(str)) {
            return "script processing stepped";
        }
        if (this.checkHalt(str)) {
            return "script execution halted";
        }
        return null;
    }

    boolean usingScriptQueue() {
        return this.scriptManager.useQueue;
    }

    public void clearScriptQueue() {
        this.scriptManager.clearQueue();
    }

    public boolean checkResume(String str) {
        if (str.equalsIgnoreCase("resume")) {
            this.scriptStatus("", "execution resumed", 0, null);
            this.resumeScriptExecution();
            return true;
        }
        return false;
    }

    public boolean checkStepping(String str) {
        if (str.equalsIgnoreCase("step")) {
            this.stepScriptExecution();
            return true;
        }
        if (str.equalsIgnoreCase("?")) {
            this.scriptStatus(this.eval.getNextStatement());
            return true;
        }
        return false;
    }

    public boolean checkHalt(String str) {
        if (str.equalsIgnoreCase("pause")) {
            this.pauseScriptExecution();
            if (this.scriptEditorVisible) {
                this.scriptStatus("", "paused -- type RESUME to continue", 0, null);
            }
            return true;
        }
        if ((str = str.toLowerCase()).startsWith("exit")) {
            this.haltScriptExecution();
            this.clearScriptQueue();
            if (this.isCmdLine_c_or_C_Option) {
                Logger.info("exit -- stops script checking");
            }
            this.isCmdLine_c_or_C_Option = false;
            return str.equals("exit");
        }
        if (str.startsWith("quit")) {
            this.haltScriptExecution();
            if (this.isCmdLine_c_or_C_Option) {
                Logger.info("quit -- stops script checking");
            }
            this.isCmdLine_c_or_C_Option = false;
            return str.equals("quit");
        }
        return false;
    }

    public String scriptWait(String strScript) {
        this.scriptManager.waitForQueue();
        boolean doTranslateTemp = GT.getDoTranslate();
        GT.setDoTranslate(false);
        String str = (String)this.evalStringWaitStatus("JSON", strScript, "+scriptStarted,+scriptStatus,+scriptEcho,+scriptTerminated", false, false, false);
        GT.setDoTranslate(doTranslateTemp);
        return str;
    }

    public Object scriptWaitStatus(String strScript, String statusList) {
        this.scriptManager.waitForQueue();
        boolean doTranslateTemp = GT.getDoTranslate();
        GT.setDoTranslate(false);
        Object ret = this.evalStringWaitStatus("object", strScript, statusList, false, false, false);
        GT.setDoTranslate(doTranslateTemp);
        return ret;
    }

    public Object evalStringWaitStatus(String returnType, String strScript, String statusList) {
        this.scriptManager.waitForQueue();
        return this.evalStringWaitStatus(returnType, strScript, statusList, false, false, false);
    }

    synchronized Object evalStringWaitStatus(String returnType, String strScript, String statusList, boolean isScriptFile, boolean isQuiet, boolean isQueued) {
        boolean historyDisabled;
        if (strScript == null) {
            return null;
        }
        String str = this.checkScriptExecution(strScript);
        if (str != null) {
            return str;
        }
        String oldStatusList = this.statusManager.getStatusList();
        this.getProperty("String", "jmolStatus", statusList);
        if (this.isCmdLine_c_or_C_Option) {
            Logger.info("--checking script:\n" + this.eval.getScript() + "\n----\n");
        }
        boolean bl = historyDisabled = strScript.indexOf(")") == 0;
        if (historyDisabled) {
            strScript = strScript.substring(1);
        }
        historyDisabled = historyDisabled || !isQueued;
        this.setErrorMessage(null);
        boolean isOK = isScriptFile ? this.eval.compileScriptFile(strScript, isQuiet) : this.eval.compileScriptString(strScript, isQuiet);
        String strErrorMessage = this.eval.getErrorMessage();
        String strErrorMessageUntranslated = this.eval.getErrorMessageUntranslated();
        this.setErrorMessage(strErrorMessage, strErrorMessageUntranslated);
        if (isOK) {
            this.isScriptQueued = isQueued;
            if (!isQuiet) {
                this.scriptStatus(null, strScript, -2 - ++this.scriptIndex, null);
            }
            this.eval.evaluateCompiledScript(this.isCmdLine_c_or_C_Option, this.isCmdLine_C_Option, historyDisabled, this.listCommands);
            strErrorMessage = this.eval.getErrorMessage();
            strErrorMessageUntranslated = this.eval.getErrorMessageUntranslated();
            this.setErrorMessage(strErrorMessage, strErrorMessageUntranslated);
            if (!isQuiet) {
                this.scriptStatus("Jmol script terminated", strErrorMessage, 1 + this.eval.getExecutionWalltime(), strErrorMessageUntranslated);
            }
        } else {
            this.scriptStatus(strErrorMessage);
            this.scriptStatus("Jmol script terminated", strErrorMessage, 1, strErrorMessageUntranslated);
        }
        if (strErrorMessage != null && this.autoExit) {
            this.exitJmol();
        }
        if (this.isCmdLine_c_or_C_Option) {
            if (strErrorMessage == null) {
                Logger.info("--script check ok");
            } else {
                Logger.error("--script check error\n" + strErrorMessageUntranslated);
            }
        }
        if (this.isCmdLine_c_or_C_Option) {
            Logger.info("(use 'exit' to stop checking)");
        }
        this.isScriptQueued = true;
        if (returnType.equalsIgnoreCase("String")) {
            return strErrorMessageUntranslated;
        }
        Object info = this.getProperty(returnType, "jmolStatus", statusList);
        this.getProperty("object", "jmolStatus", oldStatusList);
        return info;
    }

    void exitJmol() {
        Logger.debug("exitJmol -- exiting");
        System.out.flush();
        System.exit(0);
    }

    private Object scriptCheck(String strScript, boolean returnContext) {
        if (strScript.indexOf(")") == 0 || strScript.indexOf("!") == 0) {
            strScript = strScript.substring(1);
        }
        ScriptContext sc = new ScriptEvaluator(this).checkScriptSilent(strScript);
        if (returnContext || sc.errorMessage == null) {
            return sc;
        }
        return sc.errorMessage;
    }

    public synchronized Object scriptCheck(String strScript) {
        return this.scriptCheck(strScript, false);
    }

    public boolean isScriptExecuting() {
        return this.eval.isScriptExecuting();
    }

    public void haltScriptExecution() {
        this.eval.haltExecution();
    }

    public void resumeScriptExecution() {
        this.eval.resumePausedExecution();
    }

    public void stepScriptExecution() {
        this.eval.stepPausedExecution();
    }

    public void pauseScriptExecution() {
        this.eval.pauseExecution();
    }

    String getDefaultLoadScript() {
        return this.global.defaultLoadScript;
    }

    String getLoadFormat() {
        return this.global.loadFormat;
    }

    public String getStandardLabelFormat() {
        return this.stateManager.getStandardLabelFormat();
    }

    public int getRibbonAspectRatio() {
        return this.global.ribbonAspectRatio;
    }

    public float getSheetSmoothing() {
        return this.global.sheetSmoothing;
    }

    public boolean getSsbondsBackbone() {
        return this.global.ssbondsBackbone;
    }

    public boolean getHbondsBackbone() {
        return this.global.hbondsBackbone;
    }

    public boolean getHbondsSolid() {
        return this.global.hbondsSolid;
    }

    public void setMarBond(short marBond) {
        this.global.bondRadiusMilliAngstroms = marBond;
        this.global.setParameterValue("bondRadiusMilliAngstroms", marBond);
        this.setShapeSize(1, marBond * 2, Float.NaN, BitSetUtil.setAll(this.getAtomCount()));
    }

    public void hoverOn(int atomIndex) {
        if (this.eval != null && this.isScriptExecuting() || atomIndex == this.hoverAtomIndex || this.global.hoverDelayMs == 0) {
            return;
        }
        if (!this.isInSelectionSubset(atomIndex)) {
            return;
        }
        this.loadShape(30);
        this.setShapeProperty(30, "text", null);
        this.setShapeProperty(30, "target", new Integer(atomIndex));
        this.hoverText = null;
        this.hoverAtomIndex = atomIndex;
        this.refresh(3, "hover on atom");
    }

    int getHoverDelay() {
        return this.global.hoverDelayMs;
    }

    public void hoverOn(int x, int y, String text) {
        if (this.eval != null && this.isScriptExecuting()) {
            return;
        }
        this.loadShape(30);
        this.setShapeProperty(30, "xy", new Point3i(x, y, 0));
        this.setShapeProperty(30, "target", null);
        this.setShapeProperty(30, "text", text);
        this.hoverAtomIndex = -1;
        this.hoverText = text;
        this.refresh(3, "hover on point");
    }

    void hoverOff() {
        if (this.hoverAtomIndex >= 0) {
            this.setShapeProperty(30, "target", null);
            this.hoverAtomIndex = -1;
        }
        if (this.hoverText != null) {
            this.setShapeProperty(30, "text", null);
            this.hoverText = null;
        }
        this.refresh(3, "hover off");
    }

    void setLabel(String strLabel) {
        this.modelSet.setLabel(strLabel, this.selectionManager.bsSelection);
    }

    void togglePickingLabel(BitSet bs) {
        if (bs == null) {
            bs = this.selectionManager.bsSelection;
        }
        this.loadShape(4);
        this.setShapeSize(4, 0, Float.NaN, bs);
        this.modelSet.setShapeProperty(4, "toggleLabel", null, bs);
    }

    BitSet getBitSetSelection() {
        return this.selectionManager.bsSelection;
    }

    public void clearShapes() {
        this.repaintManager.clear();
    }

    public void loadShape(int shapeID) {
        this.modelSet.loadShape(shapeID);
    }

    void setShapeSize(int shapeID, int size, float fsize) {
        this.setShapeSize(shapeID, size, fsize, this.selectionManager.bsSelection);
    }

    public void setShapeSize(int shapeID, int size, BitSet bsAtoms) {
        this.setShapeSize(shapeID, size, Float.NaN, bsAtoms);
    }

    public void setShapeSize(int shapeID, int size, float fsize, BitSet bsAtoms) {
        this.modelSet.setShapeSize(shapeID, size, fsize, bsAtoms);
    }

    public void setShapeProperty(int shapeID, String propertyName, Object value) {
        if (shapeID < 0) {
            return;
        }
        this.modelSet.setShapeProperty(shapeID, propertyName, value, this.selectionManager.bsSelection);
    }

    void setShapeProperty(int shapeID, String propertyName, Object value, BitSet bs) {
        if (shapeID < 0) {
            return;
        }
        this.modelSet.setShapeProperty(shapeID, propertyName, value, bs);
    }

    void setShapePropertyArgb(int shapeID, String propertyName, int argb) {
        this.setShapeProperty(shapeID, propertyName, argb == 0 ? null : new Integer(argb | 0xFF000000));
    }

    public Object getShapeProperty(int shapeType, String propertyName) {
        return this.modelSet.getShapeProperty(shapeType, propertyName, Integer.MIN_VALUE);
    }

    Object getShapeProperty(int shapeType, String propertyName, int index) {
        return this.modelSet.getShapeProperty(shapeType, propertyName, index);
    }

    int getShapePropertyAsInt(int shapeID, String propertyName) {
        Object value = this.getShapeProperty(shapeID, propertyName);
        return value == null || !(value instanceof Integer) ? Integer.MIN_VALUE : (Integer)value;
    }

    short getColix(Object object) {
        return Graphics3D.getColix(object);
    }

    boolean getRasmolHydrogenSetting() {
        return this.global.rasmolHydrogenSetting;
    }

    boolean getRasmolHeteroSetting() {
        return this.global.rasmolHeteroSetting;
    }

    boolean getDebugScript() {
        return this.global.debugScript;
    }

    public void setDebugScript(boolean debugScript) {
        this.global.debugScript = debugScript;
        this.global.setParameterValue("debugScript", debugScript);
        this.eval.setDebugging();
    }

    void atomPicked(int atomIndex, Point3f ptClicked, int modifiers, boolean isDoubleClick) {
        this.pickingManager.atomPicked(atomIndex, ptClicked, modifiers, isDoubleClick);
    }

    void clearClickCount() {
        this.setTainted(true);
    }

    public void setCursor(int cursor) {
        int c;
        if (this.currentCursor == cursor || this.display == null) {
            return;
        }
        this.currentCursor = cursor;
        switch (this.currentCursor) {
            case 1: {
                c = 12;
                break;
            }
            case 3: {
                c = 13;
                break;
            }
            case 2: {
                c = 1;
                break;
            }
            case 4: {
                c = 3;
                break;
            }
            default: {
                this.display.setCursor(Cursor.getDefaultCursor());
                return;
            }
        }
        this.display.setCursor(Cursor.getPredefinedCursor(c));
    }

    private void setPickingMode(String mode) {
        int pickingMode = JmolConstants.getPickingMode(mode);
        if (pickingMode < 0) {
            pickingMode = 1;
        }
        this.pickingManager.setPickingMode(pickingMode);
        this.global.setParameterValue("picking", JmolConstants.getPickingModeName(this.pickingManager.getPickingMode()));
    }

    public int getPickingMode() {
        return this.pickingManager.getPickingMode();
    }

    public boolean getDrawPicking() {
        return this.global.drawPicking;
    }

    public boolean getBondPicking() {
        return this.global.bondPicking;
    }

    private boolean getAtomPicking() {
        return this.global.atomPicking;
    }

    private void setPickingStyle(String style) {
        int pickingStyle = JmolConstants.getPickingStyle(style);
        if (pickingStyle < 0) {
            pickingStyle = 0;
        }
        this.pickingManager.setPickingStyle(pickingStyle);
        this.global.setParameterValue("pickingStyle", JmolConstants.getPickingStyleName(this.pickingManager.getPickingStyle()));
    }

    int getPickingStyle() {
        return this.pickingManager.getPickingStyle();
    }

    public boolean getDrawHover() {
        return this.pickingManager.getDrawHover();
    }

    public String getAtomInfo(int atomIndex) {
        return atomIndex >= 0 ? this.modelSet.getAtomInfo(atomIndex, null) : (String)this.modelSet.getShapeProperty(5, "pointInfo", -atomIndex);
    }

    public String getAtomInfoXYZ(int atomIndex, boolean useChimeFormat) {
        return this.modelSet.getAtomInfoXYZ(atomIndex, useChimeFormat);
    }

    public void setJmolCallbackListener(JmolCallbackListener jmolCallbackListener) {
        this.statusManager.setJmolCallbackListener(jmolCallbackListener);
    }

    public void setJmolStatusListener(JmolStatusListener jmolStatusListener) {
        this.statusManager.setJmolStatusListener(jmolStatusListener, null);
    }

    public Hashtable getMessageQueue() {
        return this.statusManager.getMessageQueue();
    }

    Object getStatusChanged(String statusNameList) {
        return this.statusManager.getStatusChanged(statusNameList);
    }

    void popupMenu(int x, int y) {
        if (this.isPreviewOnly || this.global.disablePopupMenu) {
            return;
        }
        this.statusManager.popupMenu(x, y);
    }

    String getMenu(String type) {
        return this.statusManager.getMenu(type);
    }

    void setMenu(String fileOrText, boolean isFile) {
        if (isFile) {
            Logger.info("Setting menu " + (fileOrText.length() == 0 ? "to Jmol defaults" : "from file " + fileOrText));
        }
        if (fileOrText.length() == 0) {
            fileOrText = null;
        } else if (isFile) {
            fileOrText = this.getFileAsString(fileOrText);
        }
        this.statusManager.setCallbackFunction("menu", fileOrText);
    }

    void setStatusFrameChanged(int frameNo) {
        String strModelNo;
        int frameID;
        int modelIndex = this.animationManager.currentModelIndex;
        if (frameNo == Integer.MIN_VALUE) {
            this.prevFrame = Integer.MIN_VALUE;
            frameNo = modelIndex;
        }
        this.transformManager.setVibrationPeriod(Float.NaN);
        int firstIndex = this.animationManager.firstModelIndex;
        int lastIndex = this.animationManager.lastModelIndex;
        if (firstIndex == lastIndex) {
            modelIndex = firstIndex;
        }
        int fileNo = frameID = this.getModelFileNumber(modelIndex);
        int modelNo = frameID % 1000000;
        int firstNo = this.getModelFileNumber(firstIndex);
        int lastNo = this.getModelFileNumber(lastIndex);
        if (fileNo == 0) {
            strModelNo = this.getModelNumberDotted(firstIndex);
            if (firstIndex != lastIndex) {
                strModelNo = strModelNo + " - " + this.getModelNumberDotted(lastIndex);
            }
            if (firstNo / 1000000 == lastNo / 1000000) {
                fileNo = firstNo;
            }
        } else {
            strModelNo = this.getModelNumberDotted(modelIndex);
        }
        if (fileNo != 0) {
            fileNo = fileNo < 1000000 ? 1 : fileNo / 1000000;
        }
        this.global.setParameterValue("_currentFileNumber", fileNo);
        this.global.setParameterValue("_currentModelNumberInFile", modelNo);
        this.global.setParameterValue("_frameID", frameID);
        this.global.setParameterValue("_modelNumber", strModelNo);
        this.global.setParameterValue("_modelName", modelIndex < 0 ? "" : this.getModelName(modelIndex));
        this.global.setParameterValue("_modelTitle", modelIndex < 0 ? "" : this.getModelTitle(modelIndex));
        this.global.setParameterValue("_modelFile", modelIndex < 0 ? "" : this.getModelFileName(modelIndex));
        if (modelIndex == this.prevFrame) {
            return;
        }
        this.prevFrame = modelIndex;
        this.statusManager.setStatusFrameChanged(frameNo, fileNo, modelNo, this.animationManager.animationDirection < 0 ? -firstNo : firstNo, this.animationManager.currentDirection < 0 ? -lastNo : lastNo);
    }

    public void scriptEcho(String strEcho) {
        this.statusManager.setScriptEcho(strEcho, this.isScriptQueued);
        if (this.listCommands && strEcho != null && strEcho.indexOf("$[") == 0) {
            Logger.info(strEcho);
        }
    }

    void notifyError(String errType, String errMsg, String errMsgUntranslated) {
        this.statusManager.notifyError(errType, errMsg, errMsgUntranslated);
    }

    String jsEval(String strEval) {
        return this.statusManager.jsEval(strEval);
    }

    public void setStatusAtomHovered(int atomIndex, String info) {
        this.global.setParameterValue("_atomhovered", atomIndex);
        this.statusManager.setStatusAtomHovered(atomIndex, info);
    }

    private void setFileLoadStatus(int ptLoad, String fullPathName, String fileName, String modelName, String strError) {
        this.setErrorMessage(strError);
        this.global.setParameterValue("_loadPoint", ptLoad);
        boolean doCallback = ptLoad == 3 || ptLoad == 0 || ptLoad == -1;
        this.statusManager.setFileLoadStatus(fullPathName, fileName, modelName, strError, ptLoad, doCallback);
    }

    public void setStatusMeasuring(String status, int intInfo, String strMeasure) {
        this.statusManager.setStatusMeasuring(status, intInfo, strMeasure);
    }

    public void notifyMinimizationStatus() {
        Object step = this.getParameter("_minimizationStep");
        this.statusManager.notifyMinimizationStatus((String)this.getParameter("_minimizationStatus"), step instanceof String ? new Integer(0) : (Integer)step, (Float)this.getParameter("_minimizationEnergy"), (Float)this.getParameter("_minimizationEnergyDiff"));
    }

    public void setStatusAtomPicked(int atomIndex, String info) {
        if (info == null) {
            info = this.global.pickLabel;
            info = info.length() == 0 ? this.getAtomInfoXYZ(atomIndex, this.getMessageStyleChime()) : this.modelSet.getAtomInfo(atomIndex, info);
        }
        this.global.setParameterValue("_atompicked", atomIndex);
        this.global.setParameterValue("_pickinfo", info);
        this.statusManager.setStatusAtomPicked(atomIndex, info);
    }

    public void setStatusResized(int width, int height) {
        this.statusManager.setStatusResized(width, height);
    }

    void scriptStatus(String strStatus) {
        this.scriptStatus(strStatus, "", 0, null);
    }

    void scriptStatus(String strStatus, String statusMessage) {
        this.scriptStatus(strStatus, statusMessage, 0, null);
    }

    void scriptStatus(String strStatus, String statusMessage, int msWalltime, String strErrorMessageUntranslated) {
        this.statusManager.setScriptStatus(strStatus, statusMessage, msWalltime, strErrorMessageUntranslated);
    }

    private String getModelTitle(int modelIndex) {
        return this.modelSet == null ? null : this.modelSet.getModelTitle(modelIndex);
    }

    private String getModelFileName(int modelIndex) {
        return this.modelSet == null ? null : this.modelSet.getModelFileName(modelIndex);
    }

    public String dialogAsk(String type, String fileName) {
        return this.statusManager.dialogAsk(type, fileName);
    }

    int getScriptDelay() {
        return this.global.scriptDelay;
    }

    public void showUrl(String urlString) {
        if (urlString == null) {
            return;
        }
        if (urlString.indexOf(":") < 0) {
            String base = this.fileManager.getAppletDocumentBase();
            if (base == "") {
                base = this.fileManager.getFullPathName();
            }
            if (base.indexOf("/") >= 0) {
                base = base.substring(0, base.lastIndexOf("/") + 1);
            } else if (base.indexOf("\\") >= 0) {
                base = base.substring(0, base.lastIndexOf("\\") + 1);
            }
            urlString = base + urlString;
        }
        Logger.info("showUrl:" + urlString);
        this.statusManager.showUrl(urlString);
    }

    void showConsole(boolean showConsole) {
        this.statusManager.showConsole(showConsole);
    }

    void clearConsole() {
        this.statusManager.clearConsole();
    }

    Object getParameterEscaped(String key) {
        return this.global.getParameterEscaped(key, 0);
    }

    public Object getParameter(String key) {
        return this.global.getParameter(key);
    }

    ScriptVariable getOrSetNewVariable(String key, boolean doSet) {
        return this.global.getOrSetNewVariable(key, doSet);
    }

    ScriptVariable setUserVariable(String name, ScriptVariable value) {
        return this.global.setUserVariable(name, value);
    }

    void unsetProperty(String name) {
        this.global.unsetUserVariable(name);
    }

    String getVariableList() {
        return this.global.getVariableList();
    }

    public boolean getBooleanProperty(String key) {
        return this.getBooleanProperty(key, true);
    }

    public boolean getBooleanProperty(String key, boolean doICare) {
        if (this.global.htPropertyFlags.containsKey(key = key.toLowerCase())) {
            return (Boolean)this.global.htPropertyFlags.get(key);
        }
        if (key.equalsIgnoreCase("executionPaused")) {
            return this.eval.isExecutionPaused();
        }
        if (key.equalsIgnoreCase("executionStepping")) {
            return this.eval.isExecutionStepping();
        }
        if (key.equalsIgnoreCase("haveBFactors")) {
            return this.modelSet.getBFactors() != null;
        }
        if (key.equalsIgnoreCase("colorRasmol")) {
            return this.colorManager.getDefaultColorRasmol();
        }
        if (key.equalsIgnoreCase("frank")) {
            return this.getShowFrank();
        }
        if (key.equalsIgnoreCase("showSelections")) {
            return this.getSelectionHaloEnabled();
        }
        if (this.global.htUserVariables.containsKey(key)) {
            ScriptVariable t = this.global.getUserVariable(key);
            if (t.tok == 0x10000D) {
                return true;
            }
            if (t.tok == 0x10000C) {
                return false;
            }
        }
        if (doICare) {
            Logger.error("viewer.getBooleanProperty(" + key + ") - unrecognized");
        }
        return false;
    }

    public void setStringProperty(String key, String value) {
        if (key.charAt(0) == '_') {
            this.global.setParameterValue(key, value);
            return;
        }
        boolean notFound = false;
        if (key.equalsIgnoreCase("atomTypes")) {
            this.global.atomTypes = value;
        } else if (!key.equalsIgnoreCase("currentLocalPath")) {
            if (key.equalsIgnoreCase("pickLabel")) {
                this.global.pickLabel = value;
            } else if (key.equalsIgnoreCase("quaternionFrame")) {
                this.global.quaternionFrame = "" + (value.toLowerCase() + "c").charAt(0);
                this.modelSet.setHaveStraightness(false);
            } else {
                if (key.equalsIgnoreCase("defaultVDW")) {
                    this.setDefaultVdw(value);
                    return;
                }
                if (key.equalsIgnoreCase("language")) {
                    this.statusManager.setCallbackFunction("language", value);
                    value = GT.getLanguage();
                } else if (key.equalsIgnoreCase("loadFormat")) {
                    this.global.loadFormat = value;
                } else {
                    if (key.equalsIgnoreCase("backgroundColor")) {
                        this.setObjectColor("background", value);
                        return;
                    }
                    if (key.equalsIgnoreCase("axesColor")) {
                        this.setObjectColor("axis1", value);
                        this.setObjectColor("axis2", value);
                        this.setObjectColor("axis3", value);
                        return;
                    }
                    if (key.equalsIgnoreCase("axis1Color")) {
                        this.setObjectColor("axis1", value);
                        return;
                    }
                    if (key.equalsIgnoreCase("axis2Color")) {
                        this.setObjectColor("axis2", value);
                        return;
                    }
                    if (key.equalsIgnoreCase("axis3Color")) {
                        this.setObjectColor("axis3", value);
                        return;
                    }
                    if (key.equalsIgnoreCase("boundBoxColor")) {
                        this.setObjectColor("boundbox", value);
                        return;
                    }
                    if (key.equalsIgnoreCase("unitCellColor")) {
                        this.setObjectColor("unitcell", value);
                        return;
                    }
                    if (key.equalsIgnoreCase("propertyColorScheme")) {
                        this.setPropertyColorScheme(value, false);
                        return;
                    }
                    if (key.equalsIgnoreCase("propertyColorSchemeOverload")) {
                        this.setPropertyColorScheme(value, true);
                        return;
                    }
                    if (key.equalsIgnoreCase("hoverLabel")) {
                        this.setShapeProperty(30, "atomLabel", value);
                    } else if (key.equalsIgnoreCase("defaultDistanceLabel")) {
                        this.global.defaultDistanceLabel = value;
                    } else if (key.equalsIgnoreCase("defaultAngleLabel")) {
                        this.global.defaultAngleLabel = value;
                    } else if (key.equalsIgnoreCase("defaultTorsionLabel")) {
                        this.global.defaultTorsionLabel = value;
                    } else if (key.equalsIgnoreCase("defaultLoadScript")) {
                        this.global.defaultLoadScript = value;
                    } else if (key.equalsIgnoreCase("appletProxy")) {
                        this.fileManager.setAppletProxy(value);
                    } else if (key.equalsIgnoreCase("defaultDirectory")) {
                        if (value == null) {
                            value = "";
                        }
                        this.global.defaultDirectory = value = value.replace('\\', '/');
                    } else if (key.equalsIgnoreCase("helpPath")) {
                        this.global.helpPath = value;
                    } else if (key.equalsIgnoreCase("defaults")) {
                        this.setDefaults(value);
                    } else if (key.equalsIgnoreCase("defaultColorScheme")) {
                        this.setDefaultColors(value);
                    } else {
                        if (key.equalsIgnoreCase("picking")) {
                            this.setPickingMode(value);
                            return;
                        }
                        if (key.equalsIgnoreCase("pickingStyle")) {
                            this.setPickingStyle(value);
                            return;
                        }
                        if (!key.equalsIgnoreCase("dataSeparator")) {
                            if (key.toLowerCase().indexOf("callback") >= 0) {
                                this.statusManager.setCallbackFunction(key, value.length() == 0 || value.equalsIgnoreCase("none") ? null : value);
                            } else {
                                notFound = true;
                            }
                        }
                    }
                }
            }
        }
        key = key.toLowerCase();
        boolean isJmol = this.global.htParameterValues.containsKey(key);
        if (!isJmol && notFound && key.charAt(0) != '@' && (this.global.htPropertyFlags.containsKey(key) || this.global.htPropertyFlagsRemoved.containsKey(key))) {
            this.setPropertyError(GT._("ERROR: cannot set boolean flag to string value: {0}", key));
            return;
        }
        if (isJmol) {
            this.global.setParameterValue(key, value);
        } else {
            this.global.setUserVariable(key, new ScriptVariable(4, value));
        }
    }

    private void setPropertyError(String msg) {
        Logger.error(msg);
        this.scriptEcho(msg);
    }

    void removeUserVariable(String key) {
        this.global.removeUserVariable(key);
        if (key.indexOf("callback") >= 0) {
            this.statusManager.setCallbackFunction(key, null);
        }
    }

    boolean isJmolVariable(String key) {
        return this.global.isJmolVariable(key);
    }

    public void setFloatProperty(String key, float value) {
        if (key.charAt(0) == '_') {
            this.global.setParameterValue(key, value);
            return;
        }
        this.setFloatProperty(key, value, false);
    }

    private boolean setFloatProperty(String key, float value, boolean isInt) {
        boolean notFound = false;
        if (key.equalsIgnoreCase("hbondsAngleMinimum")) {
            this.global.hbondsAngleMinimum = value;
        } else if (key.equalsIgnoreCase("hbondsDistanceMaximum")) {
            this.global.hbondsDistanceMaximum = value;
        } else if (key.equalsIgnoreCase("pointGroupDistanceTolerance")) {
            this.global.pointGroupDistanceTolerance = value;
        } else if (key.equalsIgnoreCase("pointGroupLinearTolerance")) {
            this.global.pointGroupLinearTolerance = value;
        } else if (key.equalsIgnoreCase("ellipsoidAxisDiameter")) {
            if (isInt) {
                value /= 1000.0f;
            }
        } else if (key.equalsIgnoreCase("spinX")) {
            this.setSpin("x", (int)value);
        } else if (key.equalsIgnoreCase("spinY")) {
            this.setSpin("y", (int)value);
        } else if (key.equalsIgnoreCase("spinZ")) {
            this.setSpin("z", (int)value);
        } else if (key.equalsIgnoreCase("spinFPS")) {
            this.setSpin("fps", (int)value);
        } else if (key.equalsIgnoreCase("defaultDrawArrowScale")) {
            this.setDefaultDrawArrowScale(value);
        } else if (key.equalsIgnoreCase("defaultTranslucent")) {
            this.global.defaultTranslucent = value;
        } else if (key.equalsIgnoreCase("axesScale")) {
            this.setAxesScale(value);
        } else if (key.equalsIgnoreCase("visualRange")) {
            this.setVisualRange(value);
        } else if (key.equalsIgnoreCase("navigationDepth")) {
            this.setNavigationDepthPercent(0.0f, value);
        } else if (key.equalsIgnoreCase("navigationSpeed")) {
            this.global.navigationSpeed = value;
        } else if (key.equalsIgnoreCase("navigationSlab")) {
            this.transformManager.setNavigationSlabOffsetPercent(value);
        } else if (key.equalsIgnoreCase("cameraDepth")) {
            this.transformManager.setCameraDepthPercent(value);
            this.refresh(1, "set cameraDepth");
        } else {
            if (key.equalsIgnoreCase("rotationRadius")) {
                this.setRotationRadius(value, true);
                return true;
            }
            if (key.equalsIgnoreCase("hoverDelay")) {
                this.global.hoverDelayMs = (int)(value * 1000.0f);
            } else if (key.equalsIgnoreCase("sheetSmoothing")) {
                this.global.sheetSmoothing = value;
            } else if (key.equalsIgnoreCase("dipoleScale")) {
                this.global.dipoleScale = value;
            } else if (key.equalsIgnoreCase("stereoDegrees")) {
                this.transformManager.setStereoDegrees(value);
            } else {
                if (key.equalsIgnoreCase("vectorScale")) {
                    this.setVectorScale(value);
                    return true;
                }
                if (key.equalsIgnoreCase("vibrationPeriod")) {
                    this.setVibrationPeriod(value);
                    return true;
                }
                if (key.equalsIgnoreCase("vibrationScale")) {
                    this.setVibrationScale(value);
                    return true;
                }
                if (key.equalsIgnoreCase("bondTolerance")) {
                    this.setBondTolerance(value);
                    return true;
                }
                if (key.equalsIgnoreCase("minBondDistance")) {
                    this.setMinBondDistance(value);
                    return true;
                }
                if (key.equalsIgnoreCase("scaleAngstromsPerInch")) {
                    this.transformManager.setScaleAngstromsPerInch(value);
                } else if (key.equalsIgnoreCase("solventProbeRadius")) {
                    this.global.solventProbeRadius = value;
                } else {
                    if (key.equalsIgnoreCase("radius")) {
                        this.setFloatProperty("solventProbeRadius", value);
                        return true;
                    }
                    if (isInt) {
                        return false;
                    }
                    notFound = true;
                }
            }
        }
        key = key.toLowerCase();
        boolean isJmol = this.global.htParameterValues.containsKey(key);
        if (!isJmol && notFound && this.global.htPropertyFlags.containsKey(key)) {
            this.setPropertyError(GT._("ERROR: cannot set boolean flag to numeric value: {0}", key));
            return true;
        }
        if (isJmol) {
            this.global.setParameterValue(key, value);
        } else {
            this.global.setUserVariable(key, new ScriptVariable(3, new Float(value)));
        }
        return true;
    }

    public void setIntProperty(String key, int value) {
        if (key.charAt(0) == '_') {
            this.global.setParameterValue(key, value);
            return;
        }
        this.setIntProperty(key, value, true);
    }

    private void setIntProperty(String key, int value, boolean defineNew) {
        boolean isJmol;
        boolean notFound = false;
        if (!key.equalsIgnoreCase("propertyDataColumnCount") && !key.equalsIgnoreCase("propertyAtomNumberColumnCount")) {
            if (key.equalsIgnoreCase("dotDensity")) {
                this.global.dotDensity = value;
            } else if (key.equalsIgnoreCase("delayMaximumMs")) {
                this.global.delayMaximumMs = value;
            } else {
                if (key.equalsIgnoreCase("logLevel")) {
                    Logger.setLogLevel(value);
                    Logger.info("logging level set to " + value);
                    this.global.setParameterValue("logLevel", value);
                    this.eval.setDebugging();
                    return;
                }
                if (key.equalsIgnoreCase("axesMode")) {
                    switch (value) {
                        case 1: {
                            this.setAxesModeMolecular(true);
                            return;
                        }
                        case 0: {
                            this.setAxesModeMolecular(false);
                            return;
                        }
                        case 2: {
                            this.setAxesModeUnitCell(true);
                            return;
                        }
                    }
                    return;
                }
                if (!key.equalsIgnoreCase("propertyDataField")) {
                    if (key.equalsIgnoreCase("strandCount")) {
                        this.setStrandCount(0, value);
                        return;
                    }
                    if (key.equalsIgnoreCase("strandCountForStrands")) {
                        this.setStrandCount(12, value);
                        return;
                    }
                    if (key.equalsIgnoreCase("strandCountForMeshRibbon")) {
                        this.setStrandCount(13, value);
                        return;
                    }
                    if (key.equalsIgnoreCase("perspectiveModel")) {
                        this.setPerspectiveModel(value);
                    } else if (key.equalsIgnoreCase("showScript")) {
                        this.global.scriptDelay = value;
                    } else if (key.equalsIgnoreCase("specularPower")) {
                        Viewer.setSpecularPower(value);
                    } else if (key.equalsIgnoreCase("specularExponent")) {
                        Viewer.setSpecularExponent(value);
                    } else {
                        if (key.equalsIgnoreCase("specular")) {
                            this.setIntProperty("specularPercent", value);
                            return;
                        }
                        if (key.equalsIgnoreCase("diffuse")) {
                            this.setIntProperty("diffusePercent", value);
                            return;
                        }
                        if (key.equalsIgnoreCase("ambient")) {
                            this.setIntProperty("ambientPercent", value);
                            return;
                        }
                        if (key.equalsIgnoreCase("specularPercent")) {
                            Viewer.setSpecularPercent(value);
                        } else if (key.equalsIgnoreCase("diffusePercent")) {
                            Viewer.setDiffusePercent(value);
                        } else if (key.equalsIgnoreCase("ambientPercent")) {
                            Viewer.setAmbientPercent(value);
                        } else if (key.equalsIgnoreCase("ribbonAspectRatio")) {
                            this.global.ribbonAspectRatio = value;
                        } else if (key.equalsIgnoreCase("pickingSpinRate")) {
                            this.global.pickingSpinRate = value < 1 ? 1 : value;
                        } else if (key.equalsIgnoreCase("animationFps")) {
                            this.setAnimationFps(value);
                        } else if (key.equalsIgnoreCase("percentVdwAtom")) {
                            this.setPercentVdwAtom(value);
                        } else {
                            if (key.equalsIgnoreCase("bondRadiusMilliAngstroms")) {
                                this.setMarBond((short)value);
                                return;
                            }
                            if (key.equalsIgnoreCase("hermiteLevel")) {
                                this.global.hermiteLevel = value;
                            } else {
                                if ((value != 0 && value != 1 || !this.setBooleanProperty(key, value == 1, false)) && this.setFloatProperty(key, value, true)) {
                                    return;
                                }
                                notFound = true;
                            }
                        }
                    }
                }
            }
        }
        if (!(isJmol = this.global.htParameterValues.containsKey(key = key.toLowerCase())) && notFound && this.global.htPropertyFlags.containsKey(key)) {
            this.setPropertyError(GT._("ERROR: cannot set boolean flag to numeric value: {0}", key));
            return;
        }
        if (!defineNew) {
            return;
        }
        if (isJmol) {
            this.global.setParameterValue(key, value);
        } else {
            this.global.setUserVariable(key, ScriptVariable.intVariable(value));
        }
    }

    int getDelayMaximum() {
        return this.global.delayMaximumMs;
    }

    public void setBooleanProperty(String key, boolean value) {
        if (key.charAt(0) == '_') {
            this.global.setParameterValue(key, value);
            return;
        }
        this.setBooleanProperty(key, value, true);
    }

    boolean setBooleanProperty(String key, boolean value, boolean defineNew) {
        boolean notFound = false;
        boolean doRepaint = true;
        if (key.equalsIgnoreCase("useMinimizationThread")) {
            this.global.useMinimizationThread = value;
        } else if (key.equalsIgnoreCase("autoLoadOrientation")) {
            this.global.autoLoadOrientation = value;
        } else if (key.equalsIgnoreCase("allowKeyStrokes")) {
            if (this.global.disablePopupMenu) {
                value = false;
            }
            this.global.allowKeyStrokes = value;
        } else if (key.equalsIgnoreCase("showKeyStrokes")) {
            this.global.showKeyStrokes = value;
        } else if (key.equalsIgnoreCase("fontCaching")) {
            this.global.fontCaching = value;
        } else if (key.equalsIgnoreCase("atomPicking")) {
            this.global.atomPicking = value;
        } else if (key.equalsIgnoreCase("bondPicking")) {
            this.global.bondPicking = value;
        } else if (key.equalsIgnoreCase("selectAllModels")) {
            this.global.selectAllModels = value;
        } else if (key.equalsIgnoreCase("messageStyleChime")) {
            this.global.messageStyleChime = value;
        } else if (key.equalsIgnoreCase("pdbSequential")) {
            this.global.pdbSequential = value;
        } else if (key.equalsIgnoreCase("pdbGetHeader")) {
            this.global.pdbGetHeader = value;
        } else if (key.equalsIgnoreCase("fontScaling")) {
            this.global.fontScaling = value;
        } else if (key.equalsIgnoreCase("syncMouse")) {
            this.setSyncTarget(0, value);
        } else if (key.equalsIgnoreCase("syncScript")) {
            this.setSyncTarget(1, value);
        } else if (key.equalsIgnoreCase("wireframeRotation")) {
            this.global.wireframeRotation = value;
        } else if (key.equalsIgnoreCase("isosurfacePropertySmoothing")) {
            this.global.isosurfacePropertySmoothing = value;
        } else if (key.equalsIgnoreCase("drawPicking")) {
            this.global.drawPicking = value;
        } else if (key.equalsIgnoreCase("antialiasDisplay")) {
            this.setAntialias(0, value);
        } else if (key.equalsIgnoreCase("antialiasTranslucent")) {
            this.setAntialias(1, value);
        } else if (key.equalsIgnoreCase("antialiasImages")) {
            this.setAntialias(2, value);
        } else if (key.equalsIgnoreCase("smartAromatic")) {
            this.global.smartAromatic = value;
        } else if (key.equalsIgnoreCase("applySymmetryToBonds")) {
            this.setApplySymmetryToBonds(value);
        } else if (key.equalsIgnoreCase("appendNew")) {
            this.setAppendNew(value);
        } else if (key.equalsIgnoreCase("autoFPS")) {
            this.global.autoFps = value;
        } else if (key.equalsIgnoreCase("useNumberLocalization")) {
            this.global.useNumberLocalization = value;
            TextFormat.setUseNumberLocalization(this.global.useNumberLocalization);
        } else if (key.equalsIgnoreCase("showFrank")) {
            this.setFrankOn(value);
        } else if (key.equalsIgnoreCase("solventProbe")) {
            this.global.solventOn = value;
        } else if (key.equalsIgnoreCase("dynamicMeasurements")) {
            this.setDynamicMeasurements(value);
        } else if (key.equalsIgnoreCase("allowRotateSelected")) {
            this.setAllowRotateSelected(value);
        } else {
            if (key.equalsIgnoreCase("showScript")) {
                this.setIntProperty("showScript", value ? 1 : 0);
                return true;
            }
            if (key.equalsIgnoreCase("allowEmbeddedScripts")) {
                this.global.allowEmbeddedScripts = value;
            } else if (key.equalsIgnoreCase("navigationPeriodic")) {
                this.global.navigationPeriodic = value;
            } else if (key.equalsIgnoreCase("zShade")) {
                this.global.zShade = value;
            } else if (key.equalsIgnoreCase("drawHover")) {
                this.pickingManager.setDrawHover(value);
            } else if (key.equalsIgnoreCase("navigationMode")) {
                this.setNavigationMode(value);
            } else if (key.equalsIgnoreCase("hideNavigationPoint")) {
                this.global.hideNavigationPoint = value;
            } else if (key.equalsIgnoreCase("showNavigationPointAlways")) {
                this.global.showNavigationPointAlways = value;
            } else if (key.equalsIgnoreCase("refreshing")) {
                this.setRefreshing(value);
            } else if (key.equalsIgnoreCase("justifyMeasurements")) {
                this.global.justifyMeasurements = value;
            } else if (key.equalsIgnoreCase("ssBondsBackbone")) {
                this.global.ssbondsBackbone = value;
            } else if (key.equalsIgnoreCase("hbondsBackbone")) {
                this.global.hbondsBackbone = value;
            } else if (key.equalsIgnoreCase("hbondsSolid")) {
                this.global.hbondsSolid = value;
            } else if (key.equalsIgnoreCase("specular")) {
                Viewer.setSpecular(value);
            } else if (key.equalsIgnoreCase("slabEnabled")) {
                this.transformManager.setSlabEnabled(value);
            } else if (key.equalsIgnoreCase("zoomEnabled")) {
                this.transformManager.setZoomEnabled(value);
            } else if (key.equalsIgnoreCase("highResolution")) {
                this.global.highResolutionFlag = value;
            } else if (key.equalsIgnoreCase("traceAlpha")) {
                this.global.traceAlpha = value;
            } else if (key.equalsIgnoreCase("zoomLarge")) {
                this.global.zoomLarge = value;
                this.transformManager.scaleFitToScreen(false, value, false, true);
            } else if (key.equalsIgnoreCase("languageTranslation")) {
                GT.setDoTranslate(value);
            } else if (key.equalsIgnoreCase("hideNotSelected")) {
                this.selectionManager.setHideNotSelected(value);
            } else if (key.equalsIgnoreCase("colorRasmol")) {
                this.setDefaultColors(value ? "rasmol" : "jmol");
            } else if (key.equalsIgnoreCase("scriptQueue")) {
                this.scriptManager.setQueue(value);
            } else if (key.equalsIgnoreCase("dotSurface")) {
                this.global.dotSurface = value;
            } else if (key.equalsIgnoreCase("dotsSelectedOnly")) {
                this.global.dotsSelectedOnly = value;
            } else if (key.equalsIgnoreCase("selectionHalos")) {
                this.setSelectionHalos(value);
            } else if (key.equalsIgnoreCase("selectHydrogen")) {
                this.global.rasmolHydrogenSetting = value;
            } else if (key.equalsIgnoreCase("selectHetero")) {
                this.global.rasmolHeteroSetting = value;
            } else if (key.equalsIgnoreCase("showMultipleBonds")) {
                this.global.showMultipleBonds = value;
            } else if (key.equalsIgnoreCase("showHiddenSelectionHalos")) {
                this.global.showHiddenSelectionHalos = value;
            } else if (key.equalsIgnoreCase("windowCentered")) {
                this.transformManager.setWindowCentered(value);
            } else if (key.equalsIgnoreCase("displayCellParameters")) {
                this.global.displayCellParameters = value;
            } else if (key.equalsIgnoreCase("testFlag1")) {
                this.global.testFlag1 = value;
            } else if (key.equalsIgnoreCase("testFlag2")) {
                this.global.testFlag2 = value;
            } else if (key.equalsIgnoreCase("testFlag3")) {
                this.global.testFlag3 = value;
            } else if (key.equalsIgnoreCase("testFlag4")) {
                this.global.testFlag4 = value;
            } else if (key.equalsIgnoreCase("ribbonBorder")) {
                this.global.ribbonBorder = value;
            } else if (key.equalsIgnoreCase("cartoonRockets")) {
                this.global.cartoonRockets = value;
            } else if (key.equalsIgnoreCase("rocketBarrels")) {
                this.global.rocketBarrels = value;
            } else if (key.equalsIgnoreCase("greyscaleRendering")) {
                this.global.greyscaleRendering = value;
                this.g3d.setGreyscaleMode(this.global.greyscaleRendering);
            } else if (key.equalsIgnoreCase("measurementLabels")) {
                this.global.measurementLabels = value;
            } else {
                if (key.equalsIgnoreCase("axesWindow")) {
                    this.setAxesModeMolecular(!value);
                    return true;
                }
                if (key.equalsIgnoreCase("axesMolecular")) {
                    this.setAxesModeMolecular(value);
                    return true;
                }
                if (key.equalsIgnoreCase("axesUnitCell")) {
                    this.setAxesModeUnitCell(value);
                    return true;
                }
                if (key.equalsIgnoreCase("axesOrientationRasmol")) {
                    this.setAxesOrientationRasmol(value);
                    return true;
                }
                if (key.equalsIgnoreCase("debugScript")) {
                    this.setDebugScript(value);
                    return true;
                }
                if (key.equalsIgnoreCase("perspectiveDepth")) {
                    this.setPerspectiveDepth(value);
                    return true;
                }
                if (key.equalsIgnoreCase("showAxes")) {
                    this.setShowAxes(value);
                    return true;
                }
                if (key.equalsIgnoreCase("showBoundBox")) {
                    this.setShowBbcage(value);
                    return true;
                }
                if (key.equalsIgnoreCase("showHydrogens")) {
                    this.setShowHydrogens(value);
                    return true;
                }
                if (key.equalsIgnoreCase("showMeasurements")) {
                    this.setShowMeasurements(value);
                    return true;
                }
                if (key.equalsIgnoreCase("showUnitcell")) {
                    this.setShowUnitCell(value);
                    return true;
                }
                if (key.equalsIgnoreCase("frank")) {
                    return this.setBooleanProperty("showFrank", value, true);
                }
                if (key.equalsIgnoreCase("solvent")) {
                    return this.setBooleanProperty("solventProbe", value, true);
                }
                if (key.equalsIgnoreCase("bonds")) {
                    return this.setBooleanProperty("showMultipleBonds", value, true);
                }
                if (key.equalsIgnoreCase("hydrogen")) {
                    return this.setBooleanProperty("selectHydrogen", value, true);
                }
                if (key.equalsIgnoreCase("hetero")) {
                    return this.setBooleanProperty("selectHetero", value, true);
                }
                if (key.equalsIgnoreCase("showSelections")) {
                    return this.setBooleanProperty("selectionHalos", value, true);
                }
                doRepaint = false;
                if (key.equalsIgnoreCase("bondModeOr")) {
                    this.global.bondModeOr = value;
                } else if (key.equalsIgnoreCase("zeroBasedXyzRasmol")) {
                    this.global.zeroBasedXyzRasmol = value;
                    this.reset();
                } else if (key.equalsIgnoreCase("rangeSelected")) {
                    this.global.rangeSelected = value;
                } else if (key.equalsIgnoreCase("measureAllModels")) {
                    this.global.measureAllModels = value;
                } else if (key.equalsIgnoreCase("statusReporting")) {
                    this.statusManager.setAllowStatusReporting(value);
                } else if (key.equalsIgnoreCase("chainCaseSensitive")) {
                    this.global.chainCaseSensitive = value;
                } else if (key.equalsIgnoreCase("hideNameInPopup")) {
                    this.global.hideNameInPopup = value;
                } else if (key.equalsIgnoreCase("disablePopupMenu")) {
                    this.global.disablePopupMenu = value;
                } else if (key.equalsIgnoreCase("forceAutoBond")) {
                    this.global.forceAutoBond = value;
                } else {
                    if (key.equalsIgnoreCase("autobond")) {
                        this.setAutoBond(value);
                        return true;
                    }
                    notFound = true;
                }
                if (!defineNew) {
                    return !notFound;
                }
                notFound = true;
            }
        }
        if (!defineNew) {
            return !notFound;
        }
        boolean isJmol = this.global.htPropertyFlags.containsKey(key = key.toLowerCase());
        if (!isJmol && notFound && this.global.htParameterValues.containsKey(key)) {
            this.setPropertyError(GT._("ERROR: Cannot set value of this variable to a boolean: {0}", key));
            return true;
        }
        if (isJmol) {
            this.global.setParameterValue(key, value);
        } else {
            this.global.setUserVariable(key, ScriptVariable.getBoolean(value));
        }
        if (notFound) {
            return false;
        }
        if (doRepaint) {
            this.setTainted(true);
        }
        return true;
    }

    public boolean getPdbLoadInfo(int type) {
        switch (type) {
            case 1: {
                return this.global.pdbSequential;
            }
            case 2: {
                return this.global.pdbGetHeader;
            }
        }
        return false;
    }

    boolean getSelectAllModels() {
        return this.global.selectAllModels;
    }

    boolean getMessageStyleChime() {
        return this.global.messageStyleChime;
    }

    public boolean getFontCaching() {
        return this.global.fontCaching;
    }

    public boolean getFontScaling() {
        return this.global.fontScaling;
    }

    void showParameter(String key, boolean ifNotSet, int nMax) {
        String sv = "" + this.global.getParameterEscaped(key, nMax);
        if (ifNotSet || sv.indexOf("<not defined>") < 0) {
            this.showString(key + " = " + sv, false);
        }
    }

    public void showString(String str, boolean isPrint) {
        if (this.isScriptQueued && (!this.isSilent || isPrint)) {
            Logger.warn(str);
        }
        this.scriptEcho(str);
    }

    String getAllSettings(String prefix) {
        return this.global.getAllSettings(prefix);
    }

    public boolean getDotSurfaceFlag() {
        return this.global.dotSurface;
    }

    public boolean getDotsSelectedOnlyFlag() {
        return this.global.dotsSelectedOnly;
    }

    public int getDotDensity() {
        return this.global.dotDensity;
    }

    public boolean isRangeSelected() {
        return this.global.rangeSelected;
    }

    boolean getIsosurfacePropertySmoothing() {
        return this.global.isosurfacePropertySmoothing;
    }

    public boolean getWireframeRotation() {
        return this.global.wireframeRotation;
    }

    boolean isWindowCentered() {
        return this.transformManager.isWindowCentered();
    }

    void setNavigationDepthPercent(float timeSec, float percent) {
        this.transformManager.setNavigationDepthPercent(timeSec, percent);
        this.refresh(1, "set navigationDepth");
    }

    float getNavigationSpeed() {
        return this.global.navigationSpeed;
    }

    public boolean getShowNavigationPoint() {
        if (!this.global.navigationMode || !this.transformManager.canNavigate()) {
            return false;
        }
        return this.getNavigating() && !this.global.hideNavigationPoint || this.global.showNavigationPointAlways || this.getInMotion();
    }

    public void setVisualRange(float angstroms) {
        this.transformManager.setVisualRange(angstroms);
        this.refresh(1, "set visualRange");
    }

    float getSolventProbeRadius() {
        return this.global.solventProbeRadius;
    }

    public float getCurrentSolventProbeRadius() {
        return this.global.solventOn ? this.global.solventProbeRadius : 0.0f;
    }

    boolean getSolventOn() {
        return this.global.solventOn;
    }

    public boolean getTestFlag1() {
        return this.global.testFlag1;
    }

    public boolean getTestFlag2() {
        return this.global.testFlag2;
    }

    public boolean getTestFlag3() {
        return this.global.testFlag3;
    }

    public boolean getTestFlag4() {
        return this.global.testFlag4;
    }

    public void setPerspectiveDepth(boolean perspectiveDepth) {
        this.global.setParameterValue("perspectiveDepth", perspectiveDepth);
        this.transformManager.setPerspectiveDepth(perspectiveDepth);
    }

    public void setAxesOrientationRasmol(boolean TF) {
        this.global.setParameterValue("axesOrientationRasmol", TF);
        this.global.axesOrientationRasmol = TF;
        this.reset();
    }

    public boolean getAxesOrientationRasmol() {
        return this.global.axesOrientationRasmol;
    }

    void setAxesScale(float scale) {
        this.global.axesScale = scale;
        this.axesAreTainted = true;
    }

    public Point3f[] getAxisPoints() {
        return this.getObjectMad(1) == 0 || this.getAxesMode() != 2 || (Boolean)this.getShapeProperty(27, "axesTypeXY") != false ? null : (Point3f[])this.getShapeProperty(27, "axisPoints");
    }

    public float getAxesScale() {
        return this.global.axesScale;
    }

    private void setAxesModeMolecular(boolean TF) {
        this.global.axesMode = TF ? 1 : 0;
        this.axesAreTainted = true;
        this.global.removeJmolParameter("axesunitcell");
        this.global.removeJmolParameter(TF ? "axeswindow" : "axesmolecular");
        this.global.setParameterValue("axesMode", this.global.axesMode);
        this.global.setParameterValue(TF ? "axesMolecular" : "axesWindow", true);
    }

    void setAxesModeUnitCell(boolean TF) {
        this.global.axesMode = TF ? 2 : 0;
        this.axesAreTainted = true;
        this.global.removeJmolParameter("axesmolecular");
        this.global.removeJmolParameter(TF ? "axeswindow" : "axesunitcell");
        this.global.setParameterValue(TF ? "axesUnitcell" : "axesWindow", true);
        this.global.setParameterValue("axesMode", this.global.axesMode);
    }

    public int getAxesMode() {
        return this.global.axesMode;
    }

    public boolean getDisplayCellParameters() {
        return this.global.displayCellParameters;
    }

    public boolean getPerspectiveDepth() {
        return this.transformManager.getPerspectiveDepth();
    }

    public void setSelectionHalos(boolean TF) {
        if (this.modelSet == null || TF == this.getSelectionHaloEnabled()) {
            return;
        }
        this.global.setParameterValue("selectionHalos", TF);
        this.loadShape(8);
        this.modelSet.setSelectionHaloEnabled(TF);
    }

    public boolean getSelectionHaloEnabled() {
        return this.modelSet.getSelectionHaloEnabled();
    }

    public boolean getBondSelectionModeOr() {
        return this.global.bondModeOr;
    }

    public boolean getChainCaseSensitive() {
        return this.global.chainCaseSensitive;
    }

    public boolean getRibbonBorder() {
        return this.global.ribbonBorder;
    }

    public boolean getCartoonRocketFlag() {
        return this.global.cartoonRockets;
    }

    public boolean getRocketBarrelFlag() {
        return this.global.rocketBarrels;
    }

    private void setStrandCount(int type, int value) {
        switch (type) {
            case 12: {
                this.global.strandCountForStrands = value;
                break;
            }
            case 13: {
                this.global.strandCountForMeshRibbon = value;
                break;
            }
            default: {
                this.global.strandCountForStrands = value;
                this.global.strandCountForMeshRibbon = value;
            }
        }
        this.global.setParameterValue("strandCount", value);
        this.global.setParameterValue("strandCountForStrands", this.global.strandCountForStrands);
        this.global.setParameterValue("strandCountForMeshRibbon", this.global.strandCountForMeshRibbon);
    }

    public int getStrandCount(int type) {
        return type == 12 ? this.global.strandCountForStrands : this.global.strandCountForMeshRibbon;
    }

    boolean getHideNameInPopup() {
        return this.global.hideNameInPopup;
    }

    boolean getNavigationPeriodic() {
        return this.global.navigationPeriodic;
    }

    private void stopAnimationThreads() {
        this.setVibrationOff();
        this.setSpinOn(false);
        this.setAnimationOn(false);
    }

    private void setNavigationMode(boolean TF) {
        this.global.navigationMode = TF;
        if (TF && !this.transformManager.canNavigate()) {
            this.stopAnimationThreads();
            this.transformManager = this.transformManager.getNavigationManager(this, this.dimScreen.width, this.dimScreen.height);
            this.transformManager.homePosition();
        }
        this.transformManager.setNavigationMode(TF);
    }

    boolean getNavigationMode() {
        return this.global.navigationMode;
    }

    private void setPerspectiveModel(int mode) {
        this.stopAnimationThreads();
        switch (mode) {
            case 10: {
                this.transformManager = new TransformManager10(this, this.dimScreen.width, this.dimScreen.height);
                break;
            }
            default: {
                this.transformManager = this.transformManager.getNavigationManager(this, this.dimScreen.width, this.dimScreen.height);
            }
        }
        this.setTransformManagerDefaults();
        this.transformManager.homePosition();
    }

    private void setTransformManagerDefaults() {
        this.transformManager.setCameraDepthPercent(this.global.cameraDepth);
        this.transformManager.setPerspectiveDepth(this.global.perspectiveDepth);
        this.transformManager.setStereoDegrees(-5.0f);
        this.transformManager.setVisualRange(this.global.visualRange);
        this.transformManager.setSpinOn(false);
        this.transformManager.setVibrationPeriod(0.0f);
        this.transformManager.setFrameOffsets(this.frameOffsets);
    }

    boolean getZoomLarge() {
        return this.global.zoomLarge;
    }

    public boolean getTraceAlpha() {
        return this.global.traceAlpha;
    }

    public int getHermiteLevel() {
        return this.global.hermiteLevel;
    }

    public boolean getHighResolution() {
        return this.global.highResolutionFlag;
    }

    String getLoadState() {
        return this.global.getLoadState();
    }

    public void setAutoBond(boolean TF) {
        this.global.setParameterValue("autobond", TF);
        this.global.autoBond = TF;
    }

    public boolean getAutoBond() {
        return this.global.autoBond;
    }

    int[] makeConnections(float minDistance, float maxDistance, short order, int connectOperation, BitSet bsA, BitSet bsB, BitSet bsBonds, boolean isBonds) {
        this.clearModelDependentObjects();
        this.clearAllMeasurements();
        return this.modelSet.makeConnections(minDistance, maxDistance, order, connectOperation, bsA, bsB, bsBonds, isBonds);
    }

    public void rebond() {
        this.clearModelDependentObjects();
        this.modelSet.deleteAllBonds();
        this.modelSet.autoBond(null, null, null, null);
        this.addStateScript("connect;", false, true);
    }

    void setPdbConectBonding(boolean isAuto) {
        this.clearModelDependentObjects();
        this.modelSet.deleteAllBonds();
        BitSet bsExclude = new BitSet();
        this.modelSet.setPdbConectBonding(0, 0, bsExclude);
        if (isAuto) {
            this.modelSet.autoBond(null, null, bsExclude, null);
            this.addStateScript("connect PDB AUTO;", false, true);
            return;
        }
        this.addStateScript("connect PDB;", false, true);
    }

    boolean getGreyscaleRendering() {
        return this.global.greyscaleRendering;
    }

    boolean getDisablePopupMenu() {
        return this.global.disablePopupMenu;
    }

    public boolean getForceAutoBond() {
        return this.global.forceAutoBond;
    }

    public void setPercentVdwAtom(int percentVdwAtom) {
        this.global.setParameterValue("percentVdwAtom", percentVdwAtom);
        this.global.percentVdwAtom = percentVdwAtom;
        this.setShapeSize(0, -percentVdwAtom, Float.NaN);
    }

    public int getPercentVdwAtom() {
        return this.global.percentVdwAtom;
    }

    public short getDefaultMadAtom() {
        return (short)(this.global.percentVdwAtom == 0 ? 0 : -2000 - this.global.percentVdwAtom);
    }

    public short getMadBond() {
        return (short)(this.global.bondRadiusMilliAngstroms * 2);
    }

    public short getMarBond() {
        return this.global.bondRadiusMilliAngstroms;
    }

    public byte getModeMultipleBond() {
        return this.global.modeMultipleBond;
    }

    public boolean getShowMultipleBonds() {
        return this.global.showMultipleBonds;
    }

    public void setShowHydrogens(boolean TF) {
        this.global.setParameterValue("showHydrogens", TF);
        this.global.showHydrogens = TF;
    }

    public boolean getShowHydrogens() {
        return this.global.showHydrogens;
    }

    public boolean getShowHiddenSelectionHalos() {
        return this.global.showHiddenSelectionHalos;
    }

    public void setShowBbcage(boolean value) {
        this.setObjectMad(28, "boundbox", (short)(value ? -4 : 0));
        this.global.setParameterValue("showBoundBox", value);
    }

    public boolean getShowBbcage() {
        return this.getObjectMad(4) != 0;
    }

    public void setShowUnitCell(boolean value) {
        this.setObjectMad(29, "unitcell", (short)(value ? -2 : 0));
        this.global.setParameterValue("showUnitCell", value);
    }

    public boolean getShowUnitCell() {
        return this.getObjectMad(5) != 0;
    }

    public void setShowAxes(boolean value) {
        this.setObjectMad(27, "axes", (short)(value ? -2 : 0));
        this.global.setParameterValue("showAxes", value);
    }

    public boolean getShowAxes() {
        return this.getObjectMad(1) != 0;
    }

    public void setFrankOn(boolean TF) {
        if (this.isPreviewOnly) {
            TF = false;
        }
        this.frankOn = TF;
        this.setObjectMad(31, "frank", (short)(TF ? 1 : 0));
    }

    public boolean getShowFrank() {
        if (this.isPreviewOnly || this.isApplet && this.creatingImage) {
            return false;
        }
        return this.isSignedApplet || this.frankOn;
    }

    public boolean isSignedApplet() {
        return this.isSignedApplet;
    }

    public void setShowMeasurements(boolean TF) {
        this.global.setParameterValue("showMeasurements", TF);
        this.global.showMeasurements = TF;
    }

    public boolean getShowMeasurements() {
        return this.global.showMeasurements;
    }

    public boolean getShowMeasurementLabels() {
        return this.global.measurementLabels;
    }

    public boolean getMeasureAllModelsFlag() {
        return this.global.measureAllModels;
    }

    void setMeasureDistanceUnits(String units) {
        this.global.setMeasureDistanceUnits(units);
        this.setShapeProperty(5, "reformatDistances", null);
    }

    public String getMeasureDistanceUnits() {
        return this.global.getMeasureDistanceUnits();
    }

    public boolean getUseNumberLocalization() {
        return this.global.useNumberLocalization;
    }

    void setAppendNew(boolean value) {
        this.global.appendNew = value;
    }

    public boolean getAppendNew() {
        return this.global.appendNew;
    }

    boolean getAutoFps() {
        return this.global.autoFps;
    }

    public void setRasmolDefaults() {
        this.setDefaults("RasMol");
    }

    public void setJmolDefaults() {
        this.setDefaults("Jmol");
    }

    private void setDefaults(String type) {
        if (type.equalsIgnoreCase("RasMol")) {
            this.stateManager.setRasMolDefaults();
            return;
        }
        this.stateManager.setJmolDefaults();
        this.setShapeSize(0, this.getDefaultMadAtom(), Float.NaN, this.getModelAtomBitSet(-1, true));
    }

    public boolean getZeroBasedXyzRasmol() {
        return this.global.zeroBasedXyzRasmol;
    }

    private void setAntialias(int mode, boolean TF) {
        switch (mode) {
            case 0: {
                this.global.antialiasDisplay = TF;
                break;
            }
            case 1: {
                this.global.antialiasTranslucent = TF;
                break;
            }
            case 2: {
                this.global.antialiasImages = TF;
                return;
            }
        }
        this.resizeImage(0, 0, false, false, true);
    }

    public Point3f[] allocTempPoints(int size) {
        return this.tempManager.allocTempPoints(size);
    }

    public void freeTempPoints(Point3f[] tempPoints) {
        this.tempManager.freeTempPoints(tempPoints);
    }

    public Point3i[] allocTempScreens(int size) {
        return this.tempManager.allocTempScreens(size);
    }

    public void freeTempScreens(Point3i[] tempScreens) {
        this.tempManager.freeTempScreens(tempScreens);
    }

    public byte[] allocTempBytes(int size) {
        return this.tempManager.allocTempBytes(size);
    }

    public void freeTempBytes(byte[] tempBytes) {
        this.tempManager.freeTempBytes(tempBytes);
    }

    Font3D getFont3D(String fontFace, String fontStyle, float fontSize) {
        return this.g3d.getFont3D(fontFace, fontStyle, fontSize);
    }

    public String formatText(String text0) {
        int i = text0.indexOf("@{");
        if (i < 0 && (i = text0.indexOf("%{")) < 0) {
            return text0;
        }
        String text = TextFormat.simpleReplace(text0, "%{", "@{");
        while ((i = text.indexOf("@{")) >= 0) {
            int i0 = ++i + 1;
            int len = text.length();
            if ((i = ScriptCompiler.ichMathTerminator(text, i, len)) >= len) {
                return text;
            }
            String name = text.substring(i0, i);
            if (name.length() == 0) {
                return text;
            }
            Object v = this.evaluateExpression(name);
            if (v instanceof Point3f) {
                v = Escape.escape((Point3f)v);
            }
            text = text.substring(0, i0 - 2) + v.toString() + text.substring(i + 1);
        }
        return text;
    }

    String getElementSymbol(int i) {
        return this.modelSet.getElementSymbol(i);
    }

    int getElementNumber(int i) {
        return this.modelSet.getElementNumber(i);
    }

    public String getAtomName(int i) {
        return this.modelSet.getAtomName(i);
    }

    public int getAtomNumber(int i) {
        return this.modelSet.getAtomNumber(i);
    }

    float getAtomX(int i) {
        return this.modelSet.getAtomX(i);
    }

    float getAtomY(int i) {
        return this.modelSet.getAtomY(i);
    }

    float getAtomZ(int i) {
        return this.modelSet.getAtomZ(i);
    }

    public Point3f getAtomPoint3f(int i) {
        return this.modelSet.getAtomAt(i);
    }

    public float getAtomRadius(int i) {
        return this.modelSet.getAtomRadius(i);
    }

    public float getAtomVdwRadius(int i) {
        return this.modelSet.getAtomVdwRadius(i);
    }

    public int getAtomArgb(int i) {
        return this.g3d.getColixArgb(this.modelSet.getAtomColix(i));
    }

    String getAtomChain(int i) {
        return this.modelSet.getAtomChain(i);
    }

    public int getAtomModelIndex(int i) {
        return this.modelSet.getAtomModelIndex(i);
    }

    String getAtomSequenceCode(int i) {
        return this.modelSet.getAtomSequenceCode(i);
    }

    public float getBondRadius(int i) {
        return this.modelSet.getBondRadius(i);
    }

    public short getBondOrder(int i) {
        return this.modelSet.getBondOrder(i);
    }

    void assignAromaticBonds() {
        this.modelSet.assignAromaticBonds();
    }

    public boolean getSmartAromatic() {
        return this.global.smartAromatic;
    }

    void resetAromatic() {
        this.modelSet.resetAromatic();
    }

    public int getBondArgb1(int i) {
        return this.g3d.getColixArgb(this.modelSet.getBondColix1(i));
    }

    public int getBondModelIndex(int i) {
        return this.modelSet.getBondModelIndex(i);
    }

    public int getBondArgb2(int i) {
        return this.g3d.getColixArgb(this.modelSet.getBondColix2(i));
    }

    public Point3f[] getPolymerLeadMidPoints(int modelIndex, int polymerIndex) {
        return this.modelSet.getPolymerLeadMidPoints(modelIndex, polymerIndex);
    }

    void setStereoMode(int[] twoColors, int stereoMode, float degrees) {
        this.setFloatProperty("stereoDegrees", degrees);
        this.setBooleanProperty("greyscaleRendering", stereoMode > 1);
        if (twoColors != null) {
            this.transformManager.setStereoMode(twoColors);
        } else {
            this.transformManager.setStereoMode(stereoMode);
        }
    }

    public boolean isJvm12orGreater() {
        return this.jvm12orGreater;
    }

    public String getOperatingSystemName() {
        return this.strOSName;
    }

    public String getJavaVendor() {
        return this.strJavaVendor;
    }

    public String getJavaVersion() {
        return this.strJavaVersion;
    }

    public Graphics3D getGraphics3D() {
        return this.g3d;
    }

    public boolean showModelSetDownload() {
        return true;
    }

    public Object getProperty(String returnType, String infoType, String paramInfo) {
        return this.getProperty(returnType, infoType, (Object)paramInfo);
    }

    boolean isScriptEditorVisible() {
        return this.scriptEditorVisible;
    }

    public Object getProperty(String returnType, String infoType, Object paramInfo) {
        if ("DATA_API".equals(returnType)) {
            switch ("scriptCheck.........scriptContext.......scriptEditor........scriptEditorState...".indexOf(infoType)) {
                case 0: {
                    return this.scriptCheck((String)paramInfo, true);
                }
                case 20: {
                    return this.eval.getScriptContext();
                }
                case 40: {
                    this.statusManager.showEditor((String[])paramInfo);
                    return null;
                }
                case 60: {
                    this.scriptEditorVisible = (Boolean)paramInfo;
                    return null;
                }
            }
        }
        return PropertyManager.getProperty(this, returnType, infoType, paramInfo);
    }

    String getModelExtract(Object atomExpression) {
        return this.fileManager.getFullPathName() + "\nJmol version " + Viewer.getJmolVersion() + "\nEXTRACT: " + atomExpression + "\n" + this.modelSet.getModelExtract(this.getAtomBitSet(atomExpression));
    }

    public String getHexColorFromIndex(short colix) {
        return this.g3d.getHexColorFromIndex(colix);
    }

    void setModelVisibility() {
        if (this.modelSet == null) {
            return;
        }
        this.modelSet.setModelVisibility();
    }

    void setFrameTitle(int modelIndex, String title) {
        this.modelSet.setFrameTitle(modelIndex, title);
    }

    String getFrameTitle(int modelIndex) {
        return this.modelSet.getFrameTitle(modelIndex);
    }

    void setTainted(boolean TF) {
        this.isTainted = TF && this.refreshing;
        this.axesAreTainted = TF && this.refreshing;
    }

    Point3f checkObjectClicked(int x, int y, int modifiers) {
        return this.modelSet.checkObjectClicked(x, y, modifiers, this.getVisibleFramesBitSet());
    }

    boolean checkObjectHovered(int x, int y) {
        if (this.modelSet == null) {
            return false;
        }
        return this.modelSet.checkObjectHovered(x, y, this.getVisibleFramesBitSet());
    }

    void checkObjectDragged(int prevX, int prevY, int x, int y, int modifiers) {
        this.modelSet.checkObjectDragged(prevX, prevY, x, y, modifiers, this.getVisibleFramesBitSet());
    }

    void rotateAxisAngleAtCenter(Point3f rotCenter, Vector3f rotAxis, float degrees, float endDegrees, boolean isSpin, BitSet bsSelected) {
        if (Float.isNaN(degrees) || degrees == 0.0f) {
            return;
        }
        this.transformManager.rotateAxisAngleAtCenter(rotCenter, rotAxis, degrees, endDegrees, isSpin, bsSelected);
        this.refresh(-1, "rotateAxisAngleAtCenter");
    }

    void rotateAboutPointsInternal(Point3f point1, Point3f point2, float degrees, float endDegrees, boolean isSpin, BitSet bsSelected) {
        if (Float.isNaN(degrees) || degrees == 0.0f) {
            return;
        }
        this.transformManager.rotateAboutPointsInternal(point1, point2, degrees, endDegrees, false, isSpin, bsSelected);
        this.refresh(-1, "rotateAxisAboutPointsInternal");
    }

    int getPickingSpinRate() {
        return this.global.pickingSpinRate;
    }

    public void startSpinningAxis(int atomIndex1, int atomIndex2, boolean isClockwise) {
        Atom pt1 = this.modelSet.getAtomAt(atomIndex1);
        Atom pt2 = this.modelSet.getAtomAt(atomIndex2);
        this.startSpinningAxis(pt1, pt2, isClockwise);
    }

    public void startSpinningAxis(Point3f pt1, Point3f pt2, boolean isClockwise) {
        if (this.getSpinOn()) {
            this.setSpinOn(false);
            return;
        }
        this.transformManager.rotateAboutPointsInternal(pt1, pt2, this.global.pickingSpinRate, Float.MAX_VALUE, isClockwise, true, null);
    }

    public Vector3f getModelDipole() {
        return this.modelSet.getModelDipole(this.getDisplayModelIndex());
    }

    public Vector3f calculateMolecularDipole() {
        return this.modelSet.calculateMolecularDipole(this.getDisplayModelIndex());
    }

    public float getDipoleScale() {
        return this.global.dipoleScale;
    }

    public void getAtomIdentityInfo(int atomIndex, Hashtable info) {
        this.modelSet.getAtomIdentityInfo(atomIndex, info);
    }

    void setDefaultLattice(Point3f ptLattice) {
        this.global.setDefaultLattice(ptLattice);
        this.global.setParameterValue("defaultLattice", Escape.escape(ptLattice));
    }

    Point3f getDefaultLattice() {
        return this.global.getDefaultLattice();
    }

    BitSet getTaintedAtoms(byte type) {
        return this.modelSet.getTaintedAtoms(type);
    }

    public void setTaintedAtoms(BitSet bs, byte type) {
        this.modelSet.setTaintedAtoms(bs, type);
    }

    public String getData(String atomExpression, String type) {
        String exp = "";
        exp = type.toLowerCase().indexOf("property_") == 0 ? "{selected}.label(\"%{" + type + "}\")" : (type.equalsIgnoreCase("PDB") ? "{selected and not hetero}.label(\"ATOM  %5i %-4a%1A%3.3n %1c%4R%1E   %8.3x%8.3y%8.3z%6.2Q%6.2b          %2e  \").lines+{selected and hetero}.label(\"HETATM%5i %-4a%1A%3.3n %1c%4R%1E   %8.3x%8.3y%8.3z%6.2Q%6.2b          %2e  \").lines" : (type.equalsIgnoreCase("MOL") ? "\"line1\nline2\nline3\n\"+(\"\"+{selected}.size)%-3+(\"\"+{selected}.bonds.size)%-3+\"  0  0  0\n\"+{selected}.labels(\"%10.4x%10.4y%10.4z %-2e  0  0  0  0  0\").lines+{selected}.bonds.labels(\"%3D1%3D2%3ORDER  0  0  0\").lines" : (type.startsWith("USER:") ? "{selected}.label(\"" + type.substring(5) + "\").lines" : "\"\" + {selected}.size + \"\n\n\"+{selected}.label(\"%-2e %10.5x %10.5y %10.5z\").lines")));
        if (!atomExpression.equals("selected")) {
            exp = TextFormat.simpleReplace(exp, "selected", atomExpression);
        }
        return (String)this.evaluateExpression(exp);
    }

    public synchronized Object evaluateExpression(Object stringOrTokens) {
        return ScriptEvaluator.evaluateExpression(this, stringOrTokens);
    }

    Object getHelixData(BitSet bs, int tokType) {
        return this.modelSet.getHelixData(bs, tokType);
    }

    public String getPdbData(BitSet bs) {
        if (bs == null) {
            bs = this.getSelectionSet();
        }
        return this.modelSet.getPdbAtomData(bs);
    }

    String getPdbData(int modelIndex, String type) {
        return this.modelSet.getPdbData(modelIndex, type, this.selectionManager.bsSelection, false);
    }

    public boolean isJmolDataFrame(int modelIndex) {
        return this.modelSet.isJmolDataFrame(modelIndex);
    }

    public boolean isJmolDataFrame() {
        return this.modelSet.isJmolDataFrame(this.animationManager.currentModelIndex);
    }

    int getJmolDataFrameIndex(int modelIndex, String type) {
        return this.modelSet.getJmolDataFrameIndex(modelIndex, type);
    }

    void setJmolDataFrame(String type, int modelIndex, int dataIndex) {
        this.modelSet.setJmolDataFrame(type, modelIndex, dataIndex);
    }

    void setFrameTitle(String title) {
        this.loadShape(26);
        this.modelSet.setFrameTitle(this.animationManager.currentModelIndex, title);
    }

    public String getFrameTitle() {
        return this.modelSet.getFrameTitle(this.animationManager.currentModelIndex);
    }

    String getJmolFrameType(int modelIndex) {
        return this.modelSet.getJmolFrameType(modelIndex);
    }

    public int getJmolDataSourceFrame(int modelIndex) {
        return this.modelSet.getJmolDataSourceFrame(modelIndex);
    }

    void setAtomProperty(BitSet bs, int tok, int iValue, float fValue, String sValue, float[] values, String[] list) {
        this.modelSet.setAtomProperty(bs, tok, iValue, fValue, sValue, values, list);
        switch (tok) {
            case 38797330: 
            case 38797331: 
            case 38797332: 
            case 38797571: 
            case 38797572: 
            case 38797573: 
            case 38797574: 
            case 38797575: 
            case 38797576: {
                this.refreshMeasures();
            }
        }
    }

    public void setAtomCoord(int atomIndex, float x, float y, float z) {
        this.modelSet.setAtomCoord(atomIndex, x, y, z);
    }

    void setAtomCoord(BitSet bs, int tokType, Object xyzValues) {
        this.modelSet.setAtomCoord(bs, tokType, xyzValues);
        this.refreshMeasures();
    }

    public void setAtomCoordRelative(int atomIndex, float x, float y, float z) {
        this.modelSet.setAtomCoordRelative(atomIndex, x, y, z);
    }

    void setAtomCoordRelative(Point3f offset) {
        this.modelSet.setAtomCoordRelative(offset, this.selectionManager.bsSelection);
        this.refreshMeasures();
    }

    void setAllowRotateSelected(boolean TF) {
        this.global.allowRotateSelected = TF;
    }

    boolean allowRotateSelected() {
        return this.global.allowRotateSelected;
    }

    void invertSelected(Point3f pt, BitSet bs) {
        this.modelSet.invertSelected(pt, null, bs);
        this.refreshMeasures();
    }

    void invertSelected(Point3f pt, Point4f plane) {
        this.modelSet.invertSelected(pt, plane, this.selectionManager.bsSelection);
        this.refreshMeasures();
    }

    synchronized void moveSelected(int deltaX, int deltaY, int x, int y, boolean isTranslation) {
        if (this.isJmolDataFrame()) {
            return;
        }
        BitSet bsSelected = this.selectionManager.bsSelection;
        if (deltaX == Integer.MIN_VALUE) {
            this.setSelectionHalos(true);
            this.refresh(3, "moveSelected");
            return;
        }
        if (deltaX == Integer.MAX_VALUE) {
            this.setSelectionHalos(false);
            this.refresh(3, "moveSelected");
            return;
        }
        if (isTranslation) {
            Point3f ptCenter = this.getAtomSetCenter(bsSelected);
            Point3i pti = this.transformPoint(ptCenter);
            Point3f pt = new Point3f(pti.x + deltaX, pti.y + deltaY, pti.z);
            this.unTransformPoint(pt, pt);
            pt.sub(ptCenter);
            this.modelSet.setAtomCoordRelative(pt, bsSelected);
        } else {
            this.transformManager.setRotateMolecule(true);
            this.transformManager.rotateXYBy(deltaX, deltaY, bsSelected);
            this.transformManager.setRotateMolecule(false);
        }
        this.refreshMeasures();
    }

    void rotateAtoms(Matrix3f mNew, Matrix3f matrixRotate, boolean fullMolecule, Point3f center, boolean isInternal, BitSet bsAtoms) {
        this.modelSet.rotateAtoms(mNew, matrixRotate, bsAtoms, fullMolecule, center, isInternal);
        this.refreshMeasures();
    }

    public void refreshMeasures() {
        this.setShapeProperty(5, "refresh", null);
    }

    void setDynamicMeasurements(boolean TF) {
        this.global.dynamicMeasurements = TF;
    }

    public boolean getDynamicMeasurements() {
        return this.global.dynamicMeasurements;
    }

    public float[][] functionXY(String functionName, int nX, int nY) {
        float[][] fdata;
        String data = null;
        if (functionName.indexOf("file:") == 0) {
            data = this.getFileAsString(functionName.substring(5));
        } else if (functionName.indexOf("data2d_") != 0) {
            return this.statusManager.functionXY(functionName, nX, nY);
        }
        nX = Math.abs(nX);
        nY = Math.abs(nY);
        if (data == null) {
            fdata = this.getDataFloat2D(functionName);
            if (fdata != null) {
                return fdata;
            }
            data = "";
        }
        fdata = new float[nX][nY];
        float[] f = new float[nX * nY];
        Parser.parseFloatArray(data, null, f);
        int n = 0;
        for (int i = 0; i < nX; ++i) {
            for (int j = 0; j < nY; ++j) {
                fdata[i][j] = f[n++];
            }
        }
        return fdata;
    }

    float[][][] functionXYZ(String functionName, int nX, int nY, int nZ) {
        float[][][] xyzdata;
        String data = null;
        if (functionName.indexOf("file:") == 0) {
            data = this.getFileAsString(functionName.substring(5));
        } else if (functionName.indexOf("data3d_") != 0) {
            return this.statusManager.functionXYZ(functionName, nX, nY, nZ);
        }
        nX = Math.abs(nX);
        nY = Math.abs(nY);
        nZ = Math.abs(nZ);
        if (data == null) {
            xyzdata = this.getDataFloat3D(functionName);
            if (xyzdata != null) {
                return xyzdata;
            }
            data = "";
        }
        xyzdata = new float[nX][nY][nZ];
        float[] f = new float[nX * nY * nZ];
        Parser.parseFloatArray(data, null, f);
        int n = 0;
        for (int i = 0; i < nX; ++i) {
            for (int j = 0; j < nY; ++j) {
                for (int k = 0; k < nZ; ++k) {
                    xyzdata[i][j][k] = f[n++];
                }
            }
        }
        return xyzdata;
    }

    void getHelp(String what) {
        if (what.length() > 0 && what.indexOf("?") != 0 && this.global.helpPath.indexOf("?") < 0) {
            what = "?search=" + what;
        }
        this.showUrl(this.global.helpPath + what);
    }

    void addCommand(String command) {
        if (!this.autoExit) {
            this.commandHistory.addCommand(TextFormat.replaceAllCharacters(command, "\r\n\t", " "));
        }
    }

    String removeCommand() {
        return this.commandHistory.removeCommand();
    }

    public String getSetHistory(int howFarBack) {
        return this.commandHistory.getSetHistory(howFarBack);
    }

    public void writeTextFile(String fileName, String data) {
        this.createImage(fileName, "txt", data, Integer.MIN_VALUE, 0, 0);
    }

    public String clipImage(String text) {
        try {
            JmolImageCreatorInterface c = (JmolImageCreatorInterface)Interface.getOptionInterface("util.ImageCreator");
            c.setViewer(this);
            return c.clipImage(text);
        }
        catch (Error er) {
            return GT._("clipboard is not accessible -- use signed applet");
        }
    }

    String createImage(String fileName, String type, Object text_or_bytes, int quality, int width, int height, BitSet bsFrames) {
        if (bsFrames == null) {
            return this.createImage(fileName, type, text_or_bytes, quality, width, height);
        }
        int modelCount = this.getModelCount();
        String info = "";
        int n = 0;
        int ptDot = fileName.indexOf(".");
        if (ptDot < 0) {
            ptDot = fileName.length();
        }
        String froot = fileName.substring(0, ptDot);
        String fext = fileName.substring(ptDot);
        for (int i = 0; i < modelCount; ++i) {
            if (!bsFrames.get(i)) continue;
            this.setCurrentModelIndex(i);
            fileName = "0000" + ++n;
            fileName = froot + fileName.substring(fileName.length() - 4) + fext;
            String msg = this.createImage(fileName, type, text_or_bytes, quality, width, height);
            Logger.info(msg);
            info = info + msg + "\n";
            if (msg.startsWith("OK")) continue;
            return "ERROR WRITING FILE SET: \n" + info;
        }
        if (info.length() == 0) {
            info = "OK\n";
        }
        return info + "\n" + n + " files created";
    }

    public String createImage(String fileName, String type, Object text_or_bytes, int quality, int width, int height) {
        int saveWidth = this.dimScreen.width;
        int saveHeight = this.dimScreen.height;
        if (quality != Integer.MIN_VALUE) {
            this.mustRender = true;
            this.resizeImage(width, height, true, false, false);
            this.setModelVisibility();
        }
        this.creatingImage = true;
        String err = null;
        try {
            if (fileName == null) {
                err = this.clipImage((String)text_or_bytes);
            } else {
                boolean useDialog;
                boolean bl = useDialog = fileName.indexOf("?") == 0;
                if (useDialog) {
                    fileName = fileName.substring(1);
                }
                fileName = FileManager.setLocalPathForWritingFile(this, fileName);
                err = this.statusManager.createImage((useDialog ? "?" : "") + fileName, type, text_or_bytes, quality);
            }
        }
        catch (Throwable er) {
            err = "ERROR creating image: " + er;
            Logger.error(this.setErrorMessage(err));
        }
        this.creatingImage = false;
        if (quality != Integer.MIN_VALUE) {
            this.resizeImage(saveWidth, saveHeight, true, false, true);
        }
        return err;
    }

    private void setImageFontScaling(int width, int height) {
        float screenDimNew = this.global.zoomLarge == height > width ? height : width;
        this.imageFontScaling = screenDimNew / (float)this.getScreenDim();
    }

    private void setSyncTarget(int mode, boolean TF) {
        switch (mode) {
            case 0: {
                this.statusManager.syncingMouse = TF;
                break;
            }
            case 1: {
                this.statusManager.syncingScripts = TF;
                break;
            }
            case 2: {
                this.statusManager.syncSend(TF ? SYNC_GRAPHICS_MESSAGE : SYNC_NO_GRAPHICS_MESSAGE, "*");
                if (Float.isNaN(this.transformManager.stereoDegrees)) {
                    this.setFloatProperty("stereoDegrees", -5.0f);
                }
                if (TF) {
                    this.setBooleanProperty("syncMouse", false);
                    this.setBooleanProperty("syncScript", false);
                }
                return;
            }
        }
        if (!this.statusManager.syncingScripts && !this.statusManager.syncingMouse) {
            this.refresh(-1, "set sync");
        }
    }

    public void syncScript(String script, String applet) {
        if (script.equalsIgnoreCase(SYNC_GRAPHICS_MESSAGE)) {
            this.statusManager.setSyncDriver(5);
            this.statusManager.syncSend(script, applet);
            this.setBooleanProperty("syncMouse", false);
            this.setBooleanProperty("syncScript", false);
            return;
        }
        boolean disableSend = "~".equals(applet);
        if (!disableSend && !".".equals(applet)) {
            this.statusManager.syncSend(script, applet);
            if (!"*".equals(applet)) {
                return;
            }
        }
        if (script.equalsIgnoreCase("on")) {
            this.statusManager.setSyncDriver(1);
            return;
        }
        if (script.equalsIgnoreCase("off")) {
            this.statusManager.setSyncDriver(0);
            return;
        }
        if (script.equalsIgnoreCase("slave")) {
            this.statusManager.setSyncDriver(2);
            return;
        }
        int syncMode = this.statusManager.getSyncMode();
        if (syncMode == 0) {
            return;
        }
        if (syncMode != 1) {
            disableSend = false;
        }
        if (Logger.debugging) {
            Logger.debug(this.htmlName + " syncing with script: " + script);
        }
        if (disableSend) {
            this.statusManager.setSyncDriver(3);
        }
        if (script.indexOf("Mouse: ") != 0) {
            this.evalStringQuiet(script, true, false);
            return;
        }
        String[] tokens = Parser.getTokens(script);
        String key = tokens[1];
        switch (tokens.length) {
            case 3: {
                if (key.equals("zoomByFactor")) {
                    this.zoomByFactor(Parser.parseFloat(tokens[2]));
                    break;
                }
                if (key.equals("zoomBy")) {
                    this.zoomBy(Parser.parseInt(tokens[2]));
                    break;
                }
                if (!key.equals("rotateZBy")) break;
                this.rotateZBy(Parser.parseInt(tokens[2]));
                break;
            }
            case 4: {
                if (key.equals("rotateXYBy")) {
                    this.rotateXYBy(Parser.parseInt(tokens[2]), Parser.parseInt(tokens[3]));
                    break;
                }
                if (key.equals("translateXYBy")) {
                    this.translateXYBy(Parser.parseInt(tokens[2]), Parser.parseInt(tokens[3]));
                    break;
                }
                if (!key.equals("rotateMolecule")) break;
                this.rotateMolecule(Parser.parseInt(tokens[2]), Parser.parseInt(tokens[3]));
            }
        }
        if (disableSend) {
            this.setSyncDriver(4);
        }
    }

    void setSyncDriver(int mode) {
        this.statusManager.setSyncDriver(mode);
    }

    public float[] getPartialCharges() {
        return this.modelSet.getPartialCharges();
    }

    void setProteinType(byte iType, BitSet bs) {
        this.modelSet.setProteinType(bs == null ? this.selectionManager.bsSelection : bs, iType);
    }

    public Point3f getBondPoint3f1(int i) {
        return this.modelSet.getBondAtom1(i);
    }

    public Point3f getBondPoint3f2(int i) {
        return this.modelSet.getBondAtom2(i);
    }

    public Vector3f getVibrationVector(int atomIndex) {
        return this.modelSet.getVibrationVector(atomIndex, false);
    }

    public int getVanderwaalsMar(int i) {
        return this.dataManager.defaultVdw == 3 ? this.dataManager.userVdwMars[i] : JmolConstants.getVanderwaalsMar(i, this.dataManager.defaultVdw);
    }

    public int getVanderwaalsMar(int i, int iMode) {
        if (iMode == 3 && this.dataManager.bsUserVdws == null) {
            iMode = this.dataManager.defaultVdw;
        }
        return iMode == 3 ? this.dataManager.userVdwMars[i] : JmolConstants.getVanderwaalsMar(i, iMode);
    }

    void setDefaultVdw(String mode) {
        this.dataManager.setDefaultVdw(mode);
        this.global.setParameterValue("defaultVDW", this.getDefaultVdw(Integer.MIN_VALUE));
    }

    String getDefaultVdw(int iMode) {
        return this.dataManager.getDefaultVdw(iMode, null);
    }

    public int deleteAtoms(BitSet bs, boolean fullModels) {
        this.clearModelDependentObjects();
        if (!fullModels) {
            return this.selectionManager.deleteAtoms(bs);
        }
        this.fileManager.addLoadScript("zap " + Escape.escape(bs));
        this.setCurrentModelIndex(0, false);
        this.animationManager.setAnimationOn(false);
        BitSet bsDeleted = this.modelSet.deleteModels(bs);
        this.setAnimationRange(0, 0);
        this.eval.deleteAtomsInVariables(bsDeleted);
        this.repaintManager.clear();
        this.animationManager.clear();
        this.animationManager.initializePointers(1);
        if (this.getModelCount() > 1) {
            this.setCurrentModelIndex(-1, true);
        }
        this.hoverAtomIndex = -1;
        this.setFileLoadStatus(5, null, null, null, null);
        this.refreshMeasures();
        return BitSetUtil.cardinalityOf(bsDeleted);
    }

    public void deleteModelAtoms(int firstAtomIndex, int nAtoms, BitSet bsDeleted) {
        this.dataManager.deleteModelAtoms(firstAtomIndex, nAtoms, bsDeleted);
    }

    public BitSet getDeletedAtoms() {
        return this.selectionManager.bsDeleted;
    }

    public char getQuaternionFrame() {
        return this.global.quaternionFrame.charAt(0);
    }

    String calculatePointGroup() {
        return this.modelSet.calculatePointGroup(this.selectionManager.bsSelection);
    }

    public Hashtable getPointGroupInfo(Object atomExpression) {
        return this.modelSet.getPointGroupInfo(this.getAtomBitSet(atomExpression));
    }

    public String getPointGroupAsString(boolean asDraw, String type, int index, float scale) {
        return this.modelSet.getPointGroupAsString(this.selectionManager.bsSelection, asDraw, type, index, scale);
    }

    public float getPointGroupTolerance(int type) {
        switch (type) {
            case 0: {
                return this.global.pointGroupDistanceTolerance;
            }
            case 1: {
                return this.global.pointGroupLinearTolerance;
            }
        }
        return 0.0f;
    }

    Object getFileAsImage(String pathName, Hashtable htParams) {
        if (!this.haveDisplay) {
            return "no display";
        }
        Object obj = this.fileManager.getFileAsImage(pathName, htParams);
        if (obj instanceof String) {
            return obj;
        }
        Image image = (Image)obj;
        MediaTracker tracker = new MediaTracker(this.display);
        tracker.addImage(image, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return image;
    }

    String cd(String dir) {
        String path;
        if (dir == null) {
            dir = ".";
        } else if (dir.length() == 0) {
            this.setStringProperty("defaultDirectory", "");
            dir = ".";
        }
        dir = this.fileManager.getDefaultDirectory(dir + (dir.equals("=") || dir.endsWith("/") ? "" : "/X"));
        if (dir.length() > 0) {
            this.setStringProperty("defaultDirectory", dir);
        }
        if ((path = this.fileManager.getFullPath(dir + "/", true)).startsWith("file:/")) {
            FileManager.setLocalPath(this, dir, false);
        }
        return dir;
    }

    private String setErrorMessage(String errMsg) {
        return this.setErrorMessage(errMsg, null);
    }

    private String setErrorMessage(String errMsg, String errMsgUntranslated) {
        this.errorMessageUntranslated = errMsgUntranslated;
        this.errorMessage = errMsg;
        return this.errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorMessageUntranslated() {
        return this.errorMessageUntranslated == null ? this.errorMessage : this.errorMessageUntranslated;
    }

    public void setShapeErrorState(int shapeID, String state) {
        this.currentShapeID = shapeID;
        this.currentShapeState = state;
    }

    public String getShapeErrorState() {
        if (this.currentShapeID < 0) {
            return "";
        }
        if (this.modelSet != null) {
            this.modelSet.releaseShape(this.currentShapeID);
        }
        this.repaintManager.clear(this.currentShapeID);
        return JmolConstants.getShapeClassName(this.currentShapeID) + " " + this.currentShapeState;
    }

    public void handleError(Error er, boolean doClear) {
        try {
            if (doClear) {
                this.zap("" + er);
            }
            Logger.error("viewer handling error condition: " + er);
            this.notifyError("Error", "doClear=" + doClear + "; " + er, "" + er);
        }
        catch (Throwable e1) {
            try {
                Logger.error("Could not notify error " + er + ": due to " + e1);
            }
            catch (Throwable er2) {
                // empty catch block
            }
        }
    }

    float[] getAtomicCharges() {
        return this.modelSet.getAtomicCharges();
    }

    ScriptFunction getFunction(String name) {
        return this.stateManager.getFunction(name);
    }

    void addFunction(ScriptFunction f) {
        this.stateManager.addFunction(f);
    }

    void clearFunctions() {
        StateManager.globalFunctions.clear();
        this.stateManager.localFunctions.clear();
    }

    boolean isFunction(String name) {
        return this.stateManager.isFunction(name);
    }

    Hashtable getFunctions(boolean isLocal) {
        return isLocal ? this.stateManager.localFunctions : StateManager.globalFunctions;
    }

    void showMessage(String s) {
        if (!this.isPrintOnly) {
            Logger.warn(s);
        }
    }

    public String getMoInfo(int modelIndex) {
        return this.modelSet.getMoInfo(modelIndex);
    }

    boolean isRepaintPending() {
        return this.repaintManager.repaintPending;
    }
}

