/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jmol.api.JmolViewer;
import org.jmol.console.JmolConsole;
import org.jmol.console.ScriptEditor;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.openscience.jmol.app.jmolpanel.EnterListener;
import org.openscience.jmol.app.jmolpanel.HelpDialog;

public final class AppConsole
extends JmolConsole
implements EnterListener {
    protected ConsoleTextPane console;
    private JButton varButton;
    private JButton haltButton;
    private JButton closeButton;
    private JButton clearButton;
    private JButton questButton;
    private JButton helpButton;
    private JButton undoButton;
    private JButton redoButton;
    private JButton checkButton;
    protected JButton stepButton;
    private JButton topButton;
    JPanel buttonPanel = new JPanel();
    boolean isError = false;
    ExecuteCommandThread execThread;
    static int MAXUNDO = 50;
    String[] undoStack = new String[MAXUNDO];
    int undoPointer = 0;
    boolean undoSaved = false;
    ScriptEditor scriptEditor;

    public AppConsole(JmolViewer viewer, JFrame frame) {
        super(frame, GT._("Jmol Script Console"), false);
        this.viewer = viewer;
        this.layoutWindow(this.getContentPane());
        this.setSize(645, 400);
        this.setLocationRelativeTo(frame);
    }

    JButton setButton(String s) {
        JButton b = new JButton(s);
        b.addActionListener(this);
        this.buttonPanel.add(b);
        return b;
    }

    void layoutWindow(Container container) {
        this.console = new ConsoleTextPane(this);
        this.console.setPrompt();
        this.console.setDragEnabled(true);
        JScrollPane consolePane = new JScrollPane(this.console);
        this.editButton = this.setButton(GT._("Editor"));
        this.checkButton = this.setButton(GT._("Check"));
        this.topButton = this.setButton(GT._("Top"));
        this.stepButton = this.setButton(GT._("Step"));
        this.varButton = this.setButton(GT._("Variables"));
        this.clearButton = this.setButton(GT._("Clear"));
        this.haltButton = this.setButton(GT._("Halt"));
        this.historyButton = this.setButton(GT._("History"));
        this.stateButton = this.setButton(GT._("State"));
        this.helpButton = this.setButton(GT._("Help"));
        this.closeButton = this.setButton(GT._("Close"));
        this.undoButton = this.setButton(GT._("Undo"));
        this.redoButton = this.setButton(GT._("Redo"));
        this.undoButton.setEnabled(false);
        this.redoButton.setEnabled(false);
        JPanel buttonPanelWrapper = new JPanel();
        buttonPanelWrapper.setLayout(new BorderLayout());
        buttonPanelWrapper.add((Component)this.buttonPanel, "Center");
        JSplitPane spane = new JSplitPane(0, consolePane, buttonPanelWrapper);
        consolePane.setMinimumSize(new Dimension(300, 300));
        consolePane.setPreferredSize(new Dimension(5000, 5000));
        buttonPanelWrapper.setMinimumSize(new Dimension(60, 60));
        buttonPanelWrapper.setMaximumSize(new Dimension(1000, 60));
        buttonPanelWrapper.setPreferredSize(new Dimension(60, 60));
        spane.setDividerSize(0);
        spane.setResizeWeight(0.95);
        container.add(spane);
    }

    public void sendConsoleEcho(String strEcho) {
        if (strEcho != null && !this.isError) {
            this.console.outputEcho(strEcho);
        }
        this.setError(false);
    }

    private void setError(boolean TF) {
        this.isError = TF;
    }

    public void sendConsoleMessage(String strStatus) {
        if (strStatus == null) {
            this.console.clearContent(null);
            this.console.outputStatus("");
        } else if (strStatus.indexOf("ERROR:") >= 0) {
            this.console.outputError(strStatus);
            this.setError(true);
        } else if (!this.isError) {
            this.console.outputStatus(strStatus);
        }
    }

    public void enterPressed() {
        this.executeCommandAsThread(null);
    }

    protected void execute(String strCommand) {
        this.executeCommandAsThread(strCommand);
    }

    void executeCommandAsThread(String strCommand) {
        if (strCommand == null) {
            strCommand = this.console.getCommandString().trim();
        }
        if (strCommand.equalsIgnoreCase("undo")) {
            this.undoRedo(false);
            this.console.appendNewline();
            this.console.setPrompt();
            return;
        }
        if (strCommand.equalsIgnoreCase("redo")) {
            this.undoRedo(true);
            this.console.appendNewline();
            this.console.setPrompt();
            return;
        }
        if (strCommand.equalsIgnoreCase("exitJmol")) {
            System.exit(0);
        } else if (strCommand.length() == 0) {
            strCommand = "!resume";
        }
        if (strCommand.length() > 0) {
            this.execThread = new ExecuteCommandThread(strCommand);
            this.execThread.start();
        }
    }

    void undoClear() {
        for (int i = 0; i < MAXUNDO; ++i) {
            this.undoStack[i] = null;
        }
        this.undoPointer = 0;
        this.undoButton.setEnabled(false);
        this.redoButton.setEnabled(false);
    }

    void undoSetEnabled() {
        this.undoButton.setEnabled(this.undoPointer > 0 && this.undoStack[this.undoPointer - 1] != null);
        this.redoButton.setEnabled(this.undoPointer + 1 < MAXUNDO && this.undoStack[this.undoPointer + 1] != null);
    }

    void undoRedo(boolean isRedo) {
        if (!this.viewer.getBooleanProperty("undo")) {
            return;
        }
        if (!this.undoSaved) {
            this.undoSave();
        }
        String state = this.undoStack[this.undoPointer];
        int ptr = this.undoPointer + (isRedo ? 1 : -1);
        if (ptr == MAXUNDO) {
            --ptr;
        }
        if (ptr < 0) {
            ptr = 0;
        }
        if ((state = this.undoStack[ptr]) != null) {
            state = state + "#----";
            this.setError(false);
            this.viewer.evalStringQuiet(state);
            this.undoPointer = ptr;
        }
        this.undoSetEnabled();
    }

    void undoSave() {
        int i;
        if (!this.viewer.getBooleanProperty("undo")) {
            return;
        }
        ++this.undoPointer;
        if (this.undoPointer == MAXUNDO) {
            for (i = 1; i < MAXUNDO; ++i) {
                this.undoStack[i - 1] = this.undoStack[i];
            }
            --this.undoPointer;
        }
        for (i = this.undoPointer; i < MAXUNDO; ++i) {
            this.undoStack[i] = null;
        }
        Logger.startTimer();
        this.undoStack[this.undoPointer] = (String)this.viewer.getProperty("readable", "stateInfo", null);
        if (Logger.checkTimer(null) > 1000L) {
            this.viewer.setBooleanProperty("undo", false);
            Logger.info("command processing slow; undo disabled");
            this.undoClear();
        } else {
            this.undoSetEnabled();
        }
        this.undoSaved = true;
    }

    void executeCommand(String strCommand) {
        boolean doWait;
        this.console.appendNewline();
        this.console.setPrompt();
        if (strCommand.length() == 0) {
            this.console.grabFocus();
            return;
        }
        if (strCommand.charAt(0) != '!' && this.viewer.getBooleanProperty("executionPaused")) {
            strCommand = "!" + strCommand;
        }
        if (strCommand.charAt(0) != '!' && !this.isError) {
            this.undoSave();
        }
        this.setError(false);
        this.undoSaved = false;
        String strErrorMessage = null;
        boolean bl = doWait = strCommand.indexOf("WAITTEST ") == 0;
        if (doWait) {
            Vector info = (Vector)this.viewer.scriptWaitStatus(strCommand.substring(5), "+fileLoaded,+scriptStarted,+scriptStatus,+scriptEcho,+scriptTerminated");
            for (int i = 0; i < info.size(); ++i) {
                Vector statusRecordSet = (Vector)info.get(i);
                for (int j = 0; j < statusRecordSet.size(); ++j) {
                    Vector statusRecord = (Vector)statusRecordSet.get(j);
                    Logger.info("msg#=" + statusRecord.get(0) + " " + statusRecord.get(1) + " intInfo=" + statusRecord.get(2) + " stringInfo=" + statusRecord.get(3));
                }
            }
            this.console.appendNewline();
        } else {
            boolean isScriptExecuting = this.viewer.isScriptExecuting();
            strErrorMessage = "";
            if (this.viewer.checkHalt(strCommand)) {
                String string = strErrorMessage = isScriptExecuting ? "script execution halted with " + strCommand : "no script was executing";
            }
            if (strErrorMessage.length() > 0) {
                this.console.outputError(strErrorMessage);
            } else {
                this.viewer.script(strCommand + (strCommand.indexOf("\u0000##") >= 0 ? "" : "\u0000## EDITOR_IGNORE ##"));
            }
        }
        if (strCommand.indexOf("\u0000##") < 0) {
            this.console.grabFocus();
        }
    }

    protected void clearContent(String text) {
        this.console.clearContent(text);
    }

    void setScriptEditor(ScriptEditor se) {
        this.scriptEditor = se;
    }

    public void actionPerformed(ActionEvent e) {
        this.console.grabFocus();
        Object source = e.getSource();
        if (source == this.topButton) {
            if (this.scriptEditor != null) {
                this.scriptEditor.gotoTop();
            }
            return;
        }
        if (source == this.checkButton && this.scriptEditor != null) {
            this.scriptEditor.checkScript();
        }
        if (source == this.stepButton) {
            if (this.scriptEditor != null) {
                this.scriptEditor.doStep();
            }
            return;
        }
        if (source == this.closeButton) {
            this.setVisible(false);
            return;
        }
        if (source == this.haltButton) {
            this.viewer.haltScriptExecution();
            return;
        }
        if (source == this.questButton) {
            this.execute("!?");
            return;
        }
        if (source == this.varButton) {
            this.execute("!show variables");
            return;
        }
        if (source == this.clearButton) {
            this.console.clearContent(null);
            return;
        }
        if (source == this.undoButton) {
            this.undoRedo(false);
            return;
        }
        if (source == this.redoButton) {
            this.undoRedo(true);
            return;
        }
        if (source == this.helpButton) {
            URL url = this.getClass().getClassLoader().getResource("org/openscience/jmol/Data/guide/ch04.html");
            HelpDialog hd = new HelpDialog(null, url);
            hd.setVisible(true);
        }
        super.actionPerformed(e);
    }

    class ConsoleDocument
    extends DefaultStyledDocument {
        ConsoleTextPane consoleTextPane;
        SimpleAttributeSet attError = new SimpleAttributeSet();
        SimpleAttributeSet attEcho;
        SimpleAttributeSet attPrompt;
        SimpleAttributeSet attUserInput;
        SimpleAttributeSet attStatus;
        Position positionBeforePrompt;
        Position positionAfterPrompt;
        int offsetAfterPrompt;

        ConsoleDocument() {
            StyleConstants.setForeground(this.attError, Color.red);
            this.attPrompt = new SimpleAttributeSet();
            StyleConstants.setForeground(this.attPrompt, Color.magenta);
            this.attUserInput = new SimpleAttributeSet();
            StyleConstants.setForeground(this.attUserInput, Color.black);
            SimpleAttributeSet attEcho = new SimpleAttributeSet();
            StyleConstants.setForeground(attEcho, Color.blue);
            StyleConstants.setBold(attEcho, true);
            this.attStatus = new SimpleAttributeSet();
            StyleConstants.setForeground(this.attStatus, Color.black);
            StyleConstants.setItalic(this.attStatus, true);
        }

        void setConsoleTextPane(ConsoleTextPane consoleTextPane) {
            this.consoleTextPane = consoleTextPane;
        }

        void clearContent() {
            try {
                super.remove(0, this.getLength());
            }
            catch (BadLocationException exception) {
                Logger.error("Could not clear script window content", exception);
            }
        }

        void setPrompt() {
            try {
                super.insertString(this.getLength(), "$ ", this.attPrompt);
                this.setOffsetPositions();
                this.consoleTextPane.setCaretPosition(this.offsetAfterPrompt);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }

        void setOffsetPositions() {
            try {
                this.offsetAfterPrompt = this.getLength();
                this.positionBeforePrompt = this.createPosition(this.offsetAfterPrompt - 2);
                this.positionAfterPrompt = this.createPosition(this.offsetAfterPrompt - 1);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }

        void setNoPrompt() {
            try {
                this.offsetAfterPrompt = this.getLength();
                this.positionAfterPrompt = this.positionBeforePrompt = this.createPosition(this.offsetAfterPrompt);
                this.consoleTextPane.setCaretPosition(this.offsetAfterPrompt);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }

        void outputBeforePrompt(String str, SimpleAttributeSet attribute) {
            try {
                int pt = this.consoleTextPane.getCaretPosition();
                Position caretPosition = this.createPosition(pt);
                pt = this.positionBeforePrompt.getOffset();
                super.insertString(pt, str + "\n", attribute);
                this.offsetAfterPrompt += str.length() + 1;
                this.positionBeforePrompt = this.createPosition(this.offsetAfterPrompt - 2);
                this.positionAfterPrompt = this.createPosition(this.offsetAfterPrompt - 1);
                pt = caretPosition.getOffset();
                this.consoleTextPane.setCaretPosition(pt);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.consoleTextPane.setCaretPosition(this.getLength());
            }
        }

        void outputError(String strError) {
            this.outputBeforePrompt(strError, this.attError);
        }

        void outputErrorForeground(String strError) {
            try {
                super.insertString(this.getLength(), strError + "\n", this.attError);
                this.consoleTextPane.setCaretPosition(this.getLength());
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }

        void outputEcho(String strEcho) {
            this.outputBeforePrompt(strEcho, this.attEcho);
        }

        void outputStatus(String strStatus) {
            this.outputBeforePrompt(strStatus, this.attStatus);
        }

        void appendNewline() {
            try {
                super.insertString(this.getLength(), "\n", this.attUserInput);
                this.consoleTextPane.setCaretPosition(this.getLength());
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            int ichNewline = str.indexOf(10);
            if (ichNewline != 0) {
                if (offs < this.offsetAfterPrompt) {
                    offs = this.getLength();
                }
                super.insertString(offs, str, a == this.attError ? a : this.attUserInput);
                this.consoleTextPane.setCaretPosition(offs + str.length());
            }
            if (ichNewline >= 0) {
                this.consoleTextPane.enterPressed();
            }
        }

        String getCommandString() {
            String strCommand = "";
            try {
                int cmdStart = this.positionAfterPrompt.getOffset();
                strCommand = this.getText(cmdStart, this.getLength() - cmdStart);
                while (strCommand.length() > 0 && strCommand.charAt(0) == ' ') {
                    strCommand = strCommand.substring(1);
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            return strCommand;
        }

        public void remove(int offs, int len) throws BadLocationException {
            if (offs < this.offsetAfterPrompt) {
                if ((len -= this.offsetAfterPrompt - offs) <= 0) {
                    return;
                }
                offs = this.offsetAfterPrompt;
            }
            super.remove(offs, len);
        }

        public void replace(int offs, int length, String str, AttributeSet attrs) throws BadLocationException {
            if (offs < this.offsetAfterPrompt) {
                if (offs + length < this.offsetAfterPrompt) {
                    offs = this.getLength();
                    length = 0;
                } else {
                    length -= this.offsetAfterPrompt - offs;
                    offs = this.offsetAfterPrompt;
                }
            }
            super.replace(offs, length, str, attrs);
        }

        void replaceCommand(String newCommand, boolean isError) throws BadLocationException {
            if (this.positionAfterPrompt == this.positionBeforePrompt) {
                return;
            }
            this.replace(this.offsetAfterPrompt, this.getLength() - this.offsetAfterPrompt, newCommand, isError ? this.attError : this.attUserInput);
        }

        void colorCommand(SimpleAttributeSet att) {
            if (this.positionAfterPrompt == this.positionBeforePrompt) {
                return;
            }
            this.setCharacterAttributes(this.offsetAfterPrompt, this.getLength() - this.offsetAfterPrompt, att, true);
        }
    }

    class ConsoleTextPane
    extends JTextPane {
        ConsoleDocument consoleDoc;
        EnterListener enterListener;
        boolean checking;

        ConsoleTextPane(AppConsole appConsole2) {
            super(new ConsoleDocument());
            this.checking = false;
            this.consoleDoc = (ConsoleDocument)this.getDocument();
            this.consoleDoc.setConsoleTextPane(this);
            this.enterListener = appConsole2;
        }

        public String getCommandString() {
            String cmd = this.consoleDoc.getCommandString();
            return cmd;
        }

        public void setPrompt() {
            this.consoleDoc.setPrompt();
        }

        public void appendNewline() {
            this.consoleDoc.appendNewline();
        }

        public void outputError(String strError) {
            this.consoleDoc.outputError(strError);
        }

        public void outputErrorForeground(String strError) {
            this.consoleDoc.outputErrorForeground(strError);
        }

        public void outputEcho(String strEcho) {
            this.consoleDoc.outputEcho(strEcho);
        }

        public void outputStatus(String strStatus) {
            this.consoleDoc.outputStatus(strStatus);
        }

        public void enterPressed() {
            if (this.enterListener != null) {
                this.enterListener.enterPressed();
            }
        }

        public void clearContent(String text) {
            this.consoleDoc.clearContent();
            if (text != null) {
                this.consoleDoc.outputEcho(text);
            }
            this.setPrompt();
        }

        protected void processKeyEvent(KeyEvent ke) {
            int kcode = ke.getKeyCode();
            int kid = ke.getID();
            if (kcode == 38 && kid == 401 && !ke.isControlDown()) {
                this.recallCommand(true);
            } else if (kcode == 40 && kid == 401 && !ke.isControlDown()) {
                this.recallCommand(false);
            } else if ((kcode == 40 || kcode == 38) && kid == 401 && ke.isControlDown()) {
                super.processKeyEvent(new KeyEvent((Component)ke.getSource(), kid, ke.getWhen(), 0, kcode, ke.getKeyChar(), ke.getKeyLocation()));
            } else {
                super.processKeyEvent(ke);
                if (kid == 402 && ke.getModifiers() < 2 && (kcode > 40 && kcode < 400 || kcode == 8)) {
                    this.checkCommand();
                }
            }
        }

        void recallCommand(boolean up) {
            String cmd = AppConsole.this.viewer.getSetHistory(up ? -1 : 1);
            if (cmd == null) {
                return;
            }
            boolean isError = false;
            try {
                if (cmd.endsWith("#??")) {
                    isError = true;
                    cmd = cmd.substring(0, cmd.indexOf("#??"));
                }
                cmd = TextFormat.trim(cmd, ";");
                this.consoleDoc.replaceCommand(cmd, isError);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }

        synchronized void checkCommand() {
            String strCommand = this.consoleDoc.getCommandString();
            if (strCommand.length() == 0 || strCommand.charAt(0) == '!' || AppConsole.this.viewer.isScriptExecuting() || AppConsole.this.viewer.getBooleanProperty("executionPaused")) {
                return;
            }
            this.checking = true;
            this.consoleDoc.colorCommand(AppConsole.this.viewer.scriptCheck(strCommand) instanceof String ? this.consoleDoc.attError : this.consoleDoc.attUserInput);
            this.checking = false;
        }
    }

    class ExecuteCommandThread
    extends Thread {
        String strCommand;

        ExecuteCommandThread(String command) {
            this.strCommand = command;
            this.setName("appConsoleExecuteCommandThread");
        }

        public void run() {
            try {
                while (AppConsole.this.console.checking) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {
                        // empty catch block
                        break;
                    }
                }
                AppConsole.this.executeCommand(this.strCommand);
            }
            catch (Exception ie) {
                Logger.error("execution command interrupted!", ie);
            }
        }
    }
}

