/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.vecmath.Point3f;
import org.jmol.api.JmolViewer;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.openscience.jmol.app.jmolpanel.JmolResourceHandler;

public class AtomSetChooser
extends JFrame
implements TreeSelectionListener,
PropertyChangeListener,
ActionListener,
ChangeListener,
Runnable {
    private Thread animThread = null;
    private JTextArea propertiesTextArea;
    private JTree tree;
    private DefaultTreeModel treeModel;
    private JmolViewer viewer;
    private JCheckBox repeatCheckBox;
    private JSlider selectSlider;
    private JLabel infoLabel;
    private JSlider fpsSlider;
    private JSlider amplitudeSlider;
    private JSlider periodSlider;
    private JSlider scaleSlider;
    private JSlider radiusSlider;
    private JFileChooser saveChooser;
    static final String REWIND = "rewind";
    static final String PREVIOUS = "prev";
    static final String PLAY = "play";
    static final String PAUSE = "pause";
    static final String NEXT = "next";
    static final String FF = "ff";
    static final String SAVE = "save";
    static final String COLLECTION = "collection";
    static final String VECTOR = "vector";
    private int[] indexes;
    private int currentIndex = -1;
    private static final int FPS_MAX = 30;
    private static final float AMPLITUDE_PRECISION = 0.01f;
    private static final float AMPLITUDE_MAX = 1.0f;
    private static final float AMPLITUDE_VALUE = 0.5f;
    private static final float PERIOD_PRECISION = 0.001f;
    private static final float PERIOD_MAX = 1.0f;
    private static final float PERIOD_VALUE = 0.5f;
    private static final int RADIUS_MAX = 19;
    private static final int RADIUS_VALUE = 3;
    private static final float SCALE_PRECISION = 0.01f;
    private static final float SCALE_MAX = 2.0f;
    private static final float SCALE_VALUE = 1.0f;

    public AtomSetChooser(JmolViewer viewer, JFrame frame) {
        super(GT._("AtomSetChooser"));
        this.viewer = viewer;
        this.saveChooser = new JFileChooser();
        this.treeModel = new DefaultTreeModel(new DefaultMutableTreeNode(GT._("No AtomSets")));
        this.layoutWindow(this.getContentPane());
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private void layoutWindow(Container container) {
        container.setLayout(new BorderLayout());
        JPanel treePanel = new JPanel();
        treePanel.setLayout(new BorderLayout());
        this.tree = new JTree(this.treeModel);
        this.tree.setVisibleRowCount(5);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        this.tree.setEnabled(false);
        treePanel.add((Component)new JScrollPane(this.tree), "Center");
        JPanel propertiesPanel = new JPanel();
        propertiesPanel.setLayout(new BorderLayout());
        propertiesPanel.setBorder(new TitledBorder(GT._("Properties")));
        this.propertiesTextArea = new JTextArea();
        this.propertiesTextArea.setEditable(false);
        propertiesPanel.add((Component)new JScrollPane(this.propertiesTextArea), "Center");
        JPanel astPanel = new JPanel();
        astPanel.setLayout(new BorderLayout());
        astPanel.setBorder(new TitledBorder(GT._("Atom Set Collection")));
        JSplitPane splitPane = new JSplitPane(0, treePanel, propertiesPanel);
        astPanel.add((Component)splitPane, "Center");
        splitPane.setResizeWeight(0.5);
        container.add((Component)astPanel, "Center");
        JPanel controllerPanel = new JPanel();
        controllerPanel.setLayout(new BoxLayout(controllerPanel, 1));
        container.add((Component)controllerPanel, "South");
        JPanel collectionPanel = new JPanel();
        collectionPanel.setLayout(new BoxLayout(collectionPanel, 1));
        collectionPanel.setBorder(new TitledBorder(GT._("Collection")));
        controllerPanel.add(collectionPanel);
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new BorderLayout());
        infoPanel.setBorder(new TitledBorder(GT._("Info")));
        this.infoLabel = new JLabel(" ");
        infoPanel.add((Component)this.infoLabel, "South");
        collectionPanel.add(infoPanel);
        JPanel cpsPanel = new JPanel();
        cpsPanel.setLayout(new BorderLayout());
        cpsPanel.setBorder(new TitledBorder(GT._("Select")));
        this.selectSlider = new JSlider(0, 0, 0);
        this.selectSlider.addChangeListener(this);
        this.selectSlider.setMajorTickSpacing(5);
        this.selectSlider.setMinorTickSpacing(1);
        this.selectSlider.setPaintTicks(true);
        this.selectSlider.setSnapToTicks(true);
        this.selectSlider.setEnabled(false);
        cpsPanel.add((Component)this.selectSlider, "South");
        collectionPanel.add(cpsPanel);
        JPanel row = new JPanel();
        collectionPanel.add(row);
        row.setLayout(new BoxLayout(row, 0));
        this.repeatCheckBox = new JCheckBox(GT._("Repeat"), false);
        JPanel vcrpanel = this.createVCRController(COLLECTION);
        vcrpanel.add(this.repeatCheckBox);
        row.add(vcrpanel);
        JPanel fpsPanel = new JPanel();
        row.add(fpsPanel);
        int fps = this.viewer.getAnimationFps();
        if (fps > 30) {
            fps = 30;
        }
        fpsPanel.setLayout(new BorderLayout());
        fpsPanel.setBorder(new TitledBorder(GT._("FPS")));
        this.fpsSlider = new JSlider(0, 30, fps);
        this.fpsSlider.setMajorTickSpacing(5);
        this.fpsSlider.setMinorTickSpacing(1);
        this.fpsSlider.setPaintTicks(true);
        this.fpsSlider.setSnapToTicks(true);
        this.fpsSlider.addChangeListener(this);
        fpsPanel.add((Component)this.fpsSlider, "South");
        JPanel vectorPanel = new JPanel();
        controllerPanel.add(vectorPanel);
        vectorPanel.setLayout(new BoxLayout(vectorPanel, 1));
        vectorPanel.setBorder(new TitledBorder(GT._("Vector")));
        JPanel row1 = new JPanel();
        row1.setLayout(new BoxLayout(row1, 0));
        JPanel radiusPanel = new JPanel();
        radiusPanel.setLayout(new BorderLayout());
        radiusPanel.setBorder(new TitledBorder(GT._("Radius")));
        this.radiusSlider = new JSlider(0, 19, 3);
        this.radiusSlider.setMajorTickSpacing(5);
        this.radiusSlider.setMinorTickSpacing(1);
        this.radiusSlider.setPaintTicks(true);
        this.radiusSlider.setSnapToTicks(true);
        this.radiusSlider.addChangeListener(this);
        this.viewer.evalStringQuiet("vector 3");
        radiusPanel.add(this.radiusSlider);
        row1.add(radiusPanel);
        JPanel scalePanel = new JPanel();
        scalePanel.setLayout(new BorderLayout());
        scalePanel.setBorder(new TitledBorder(GT._("Scale")));
        this.scaleSlider = new JSlider(0, 200, 100);
        this.scaleSlider.addChangeListener(this);
        this.viewer.evalStringQuiet("vector scale 1.0");
        scalePanel.add(this.scaleSlider);
        row1.add(scalePanel);
        vectorPanel.add(row1);
        JPanel row2 = new JPanel();
        row2.setLayout(new BoxLayout(row2, 0));
        JPanel amplitudePanel = new JPanel();
        amplitudePanel.setLayout(new BorderLayout());
        amplitudePanel.setBorder(new TitledBorder(GT._("Amplitude")));
        this.amplitudeSlider = new JSlider(0, 100, 50);
        this.viewer.evalStringQuiet("vibration scale 0.5");
        this.amplitudeSlider.addChangeListener(this);
        amplitudePanel.add(this.amplitudeSlider);
        row2.add(amplitudePanel);
        JPanel periodPanel = new JPanel();
        periodPanel.setLayout(new BorderLayout());
        periodPanel.setBorder(new TitledBorder(GT._("Period")));
        this.periodSlider = new JSlider(0, 999, 499);
        this.viewer.evalStringQuiet("vibration 0.5");
        this.periodSlider.addChangeListener(this);
        periodPanel.add(this.periodSlider);
        row2.add(periodPanel);
        vectorPanel.add(row2);
        vectorPanel.add(this.createVCRController(VECTOR));
    }

    private JPanel createVCRController(String section) {
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 0));
        controlPanel.setBorder(new TitledBorder(GT._("Controller")));
        Insets inset = new Insets(1, 1, 1, 1);
        String[] buttons = new String[]{REWIND, PREVIOUS, PLAY, PAUSE, NEXT, FF};
        String insert = null;
        if (section.equals(COLLECTION)) {
            insert = GT._("atom set");
        } else if (section.equals(VECTOR)) {
            insert = GT._(VECTOR);
        }
        String[] tooltips = new String[]{GT._("Go to first {0} in the collection", insert), GT._("Go to previous {0} in the collection", insert), GT._("Play the whole collection of {0}'s", insert), GT._("Pause playing"), GT._("Go to next {0} in the collection", insert), GT._("Jump to last {0} in the collection", insert)};
        int i = buttons.length;
        int idx = 0;
        while (--i >= 0) {
            String action = buttons[idx];
            JButton btn = new JButton(JmolResourceHandler.getIconX("AtomSetChooser." + action + "Image"));
            btn.setToolTipText(tooltips[idx]);
            btn.setMargin(inset);
            btn.setActionCommand(section + "." + action);
            btn.addActionListener(this);
            controlPanel.add(btn);
            ++idx;
        }
        controlPanel.add(Box.createHorizontalGlue());
        return controlPanel;
    }

    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        try {
            int index = 0;
            if (node.isLeaf()) {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                this.setIndexes(parent);
                index = parent.getIndex(node);
            } else {
                this.setIndexes(node);
            }
            this.showAtomSetIndex(index, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void showAtomSetIndex(int index, boolean bSetSelectSlider) {
        if (bSetSelectSlider) {
            this.selectSlider.setValue(index);
            return;
        }
        try {
            this.currentIndex = index;
            int atomSetIndex = this.indexes[index];
            this.viewer.evalStringQuiet("frame " + this.viewer.getModelNumber(atomSetIndex));
            this.infoLabel.setText(this.viewer.getModelName(atomSetIndex));
            this.showProperties(this.viewer.getModelProperties(atomSetIndex));
            this.showAuxiliaryInfo(this.viewer.getModelAuxiliaryInfo(atomSetIndex));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setIndexes(DefaultMutableTreeNode node) {
        int atomSetCount = node.getLeafCount();
        this.indexes = new int[atomSetCount];
        Enumeration<TreeNode> e = node.depthFirstEnumeration();
        int idx = 0;
        while (e.hasMoreElements()) {
            node = (DefaultMutableTreeNode)e.nextElement();
            if (!node.isLeaf()) continue;
            this.indexes[idx++] = ((AtomSet)node).getAtomSetIndex();
        }
        this.selectSlider.setEnabled(atomSetCount > 0);
        this.selectSlider.setMaximum(atomSetCount - 1);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        String[] parts = cmd.split("\\.");
        try {
            if (parts.length == 2) {
                String section = parts[0];
                cmd = parts[1];
                if (COLLECTION.equals(section)) {
                    if (REWIND.equals(cmd)) {
                        this.animThread = null;
                        this.showAtomSetIndex(0, true);
                    } else if (PREVIOUS.equals(cmd)) {
                        this.showAtomSetIndex(this.currentIndex - 1, true);
                    } else if (PLAY.equals(cmd)) {
                        if (this.animThread == null) {
                            this.animThread = new Thread((Runnable)this, "AtomSetChooserAnimationThread");
                            this.animThread.start();
                        }
                    } else if (PAUSE.equals(cmd)) {
                        this.animThread = null;
                    } else if (NEXT.equals(cmd)) {
                        this.showAtomSetIndex(this.currentIndex + 1, true);
                    } else if (FF.equals(cmd)) {
                        this.animThread = null;
                        this.showAtomSetIndex(this.indexes.length - 1, true);
                    } else if (SAVE.equals(cmd)) {
                        this.saveXYZCollection();
                    }
                } else if (VECTOR.equals(section)) {
                    if (REWIND.equals(cmd)) {
                        this.findFrequency(0, 1);
                    } else if (PREVIOUS.equals(cmd)) {
                        this.findFrequency(this.currentIndex - 1, -1);
                    } else if (PLAY.equals(cmd)) {
                        this.viewer.evalStringQuiet("vibration on");
                    } else if (PAUSE.equals(cmd)) {
                        this.viewer.evalStringQuiet("vibration off");
                    } else if (NEXT.equals(cmd)) {
                        this.findFrequency(this.currentIndex + 1, 1);
                    } else if (FF.equals(cmd)) {
                        this.findFrequency(this.indexes.length - 1, -1);
                    } else if (SAVE.equals(cmd)) {
                        Logger.warn("Not implemented");
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveXYZCollection() {
        int nidx = this.indexes.length;
        if (nidx == 0) {
            Logger.warn("No collection selected.");
            return;
        }
        int retval = this.saveChooser.showSaveDialog(this);
        if (retval == 0) {
            File file = this.saveChooser.getSelectedFile();
            String fname = file.getAbsolutePath();
            try {
                PrintWriter f = new PrintWriter(new FileOutputStream(fname));
                for (int idx = 0; idx < nidx; ++idx) {
                    int modelIndex = this.indexes[idx];
                    StringBuffer str = new StringBuffer(this.viewer.getModelName(modelIndex)).append("\n");
                    int natoms = 0;
                    int atomCount = this.viewer.getAtomCount();
                    for (int i = 0; i < atomCount; ++i) {
                        if (this.viewer.getAtomModelIndex(i) != modelIndex) continue;
                        ++natoms;
                        Point3f p = this.viewer.getAtomPoint3f(i);
                        str.append(this.viewer.getAtomName(i)).append("\t");
                        str.append(p.x).append("\t").append(p.y).append("\t").append(p.z).append("\n");
                    }
                    f.println(natoms);
                    f.print(str);
                }
                f.close();
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
    }

    public void findFrequency(int index, int increment) {
        int maxIndex = this.indexes.length;
        boolean foundFrequency = false;
        while (index >= 0 && index < maxIndex && !(foundFrequency = this.viewer.modelHasVibrationVectors(this.indexes[index]))) {
            index += increment;
        }
        if (foundFrequency) {
            this.showAtomSetIndex(index, true);
        }
    }

    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        int value = ((JSlider)src).getValue();
        if (src == this.selectSlider) {
            this.showAtomSetIndex(value, false);
        } else if (src == this.fpsSlider) {
            if (value == 0) {
                this.fpsSlider.setValue(1);
            } else {
                this.viewer.evalStringQuiet("animation fps " + value);
            }
        } else if (src == this.radiusSlider) {
            if (value == 0) {
                this.radiusSlider.setValue(1);
            } else {
                this.viewer.evalStringQuiet("vector " + value);
            }
        } else if (src == this.scaleSlider) {
            this.viewer.evalStringQuiet("vector scale " + (float)value * 0.01f);
        } else if (src == this.amplitudeSlider) {
            this.viewer.evalStringQuiet("vibration scale " + (float)value * 0.01f);
        } else if (src == this.periodSlider) {
            this.viewer.evalStringQuiet("vibration " + (float)value * 0.001f);
        }
    }

    protected void showProperties(Properties properties) {
        boolean needLF = false;
        this.propertiesTextArea.setText("");
        if (properties != null) {
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String propertyName = (String)e.nextElement();
                if (propertyName.startsWith(".")) continue;
                this.propertiesTextArea.append((needLF ? "\n " : " ") + propertyName + "=" + properties.getProperty(propertyName));
                needLF = true;
            }
        }
    }

    protected void showAuxiliaryInfo(Hashtable auxiliaryInfo) {
        String separator = " ";
        if (auxiliaryInfo != null) {
            Enumeration e = auxiliaryInfo.keys();
            while (e.hasMoreElements()) {
                String keyName = (String)e.nextElement();
                if (keyName.startsWith(".")) continue;
                this.propertiesTextArea.append(separator + keyName + "=" + auxiliaryInfo.get(keyName));
                separator = "\n ";
            }
        }
    }

    private void createTreeModel() {
        Properties modelSetProperties;
        String key = null;
        String separator = null;
        String name = this.viewer.getModelSetName();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(name == null ? "zapped" : name);
        Properties properties = modelSetProperties = name == null ? null : this.viewer.getModelSetProperties();
        if (modelSetProperties != null) {
            key = modelSetProperties.getProperty("PATH_KEY");
            separator = modelSetProperties.getProperty("PATH_SEPARATOR");
        }
        if (key == null || separator == null) {
            if (name != null) {
                int count = this.viewer.getModelCount();
                for (int atomSetIndex = 0; atomSetIndex < count; ++atomSetIndex) {
                    root.add(new AtomSet(atomSetIndex, this.viewer.getModelName(atomSetIndex)));
                }
            }
        } else {
            int count = this.viewer.getModelCount();
            for (int atomSetIndex = 0; atomSetIndex < count; ++atomSetIndex) {
                DefaultMutableTreeNode current = root;
                String path = this.viewer.getModelProperty(atomSetIndex, key);
                if (path != null) {
                    DefaultMutableTreeNode child = null;
                    String[] folders = path.split(separator);
                    int i = 0;
                    int nFolders = folders.length;
                    while (--nFolders >= 0) {
                        boolean found = false;
                        String lookForFolder = folders[i];
                        int childIndex = current.getChildCount();
                        while (--childIndex >= 0 && !(found = lookForFolder.equals((child = (DefaultMutableTreeNode)current.getChildAt(childIndex)).toString()))) {
                        }
                        if (found) {
                            current = child;
                        } else {
                            DefaultMutableTreeNode newFolder = new DefaultMutableTreeNode(lookForFolder);
                            current.add(newFolder);
                            current = newFolder;
                        }
                        ++i;
                    }
                }
                current.add(new AtomSet(atomSetIndex, this.viewer.getModelName(atomSetIndex)));
            }
        }
        this.treeModel.setRoot(root);
        this.treeModel.reload();
        this.tree.setEnabled(root.getChildCount() > 0);
        this.indexes = null;
        this.currentIndex = -1;
        this.selectSlider.setEnabled(false);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String eventName = propertyChangeEvent.getPropertyName();
        if (eventName.equals("chemFile")) {
            this.createTreeModel();
        }
    }

    public void run() {
        Thread myThread = Thread.currentThread();
        myThread.setPriority(1);
        while (this.animThread == myThread) {
            if (this.currentIndex < 0) {
                this.animThread = null;
                continue;
            }
            ++this.currentIndex;
            if (this.currentIndex == this.indexes.length) {
                if (this.repeatCheckBox.isSelected()) {
                    this.currentIndex = 0;
                } else {
                    --this.currentIndex;
                    this.animThread = null;
                }
            }
            this.showAtomSetIndex(this.currentIndex, true);
            try {
                int fps = this.viewer.getAnimationFps();
                Thread.sleep((int)(1000.0 / (double)(fps == 0 ? 1 : fps)));
            }
            catch (InterruptedException e) {
                Logger.error(null, e);
            }
        }
    }

    private static class AtomSet
    extends DefaultMutableTreeNode {
        private int atomSetIndex;
        private String atomSetName;

        public AtomSet(int atomSetIndex, String atomSetName) {
            this.atomSetIndex = atomSetIndex;
            this.atomSetName = atomSetName;
        }

        public int getAtomSetIndex() {
            return this.atomSetIndex;
        }

        public String toString() {
            return this.atomSetName;
        }
    }
}

