/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.text.Document;
import org.jmol.i18n.GT;
import org.openscience.jmol.app.jmolpanel.LoopedStreams;

public class ConsoleTextArea
extends JTextArea {
    public ConsoleTextArea(InputStream[] inStreams) {
        for (int i = 0; i < inStreams.length; ++i) {
            this.startConsoleReaderThread(inStreams[i]);
        }
    }

    public ConsoleTextArea(boolean doRedirect) throws IOException {
        String redirect;
        LoopedStreams ls = new LoopedStreams();
        String string = redirect = doRedirect ? System.getProperty("JmolConsole") : "false";
        if (redirect == null || redirect.equals("true")) {
            PrintStream ps = new PrintStream(ls.getOutputStream());
            System.setOut(ps);
            System.setErr(ps);
        }
        this.startConsoleReaderThread(ls.getInputStream());
    }

    private void startConsoleReaderThread(InputStream inStream) {
        final BufferedReader br = new BufferedReader(new InputStreamReader(inStream));
        new Thread(new Runnable(){

            public void run() {
                Thread.currentThread().setName("ConsoleReaderThread");
                StringBuffer sb = new StringBuffer();
                try {
                    Document doc = ConsoleTextArea.this.getDocument();
                    String s = br.readLine();
                    while (s != null) {
                        boolean caretAtEnd = false;
                        caretAtEnd = ConsoleTextArea.this.getCaretPosition() == doc.getLength();
                        sb.setLength(0);
                        ConsoleTextArea.this.append(sb.append(s).append('\n').toString());
                        if (caretAtEnd) {
                            ConsoleTextArea.this.setCaretPosition(doc.getLength());
                        }
                        s = br.readLine();
                    }
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, GT._("Error reading from BufferedReader: {0}", e.getMessage()));
                    System.exit(1);
                }
            }
        }).start();
    }
}

