/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.webexport;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileSystemView;
import org.jmol.api.JmolViewer;
import org.jmol.export.history.HistoryFile;
import org.jmol.i18n.GT;
import org.jmol.util.TextFormat;
import org.openscience.jmol.app.webexport.LogPanel;
import org.openscience.jmol.app.webexport.Molecules;
import org.openscience.jmol.app.webexport.Orbitals;
import org.openscience.jmol.app.webexport.PopInJmol;
import org.openscience.jmol.app.webexport.ScriptButtons;
import org.openscience.jmol.app.webexport.WebPanel;

public class WebExport
extends JPanel
implements WindowListener {
    private static boolean showMoleculesAndOrbitals = false;
    private static final int STAND_ALONE = 0;
    private static final int IN_JMOL = 1;
    private static int runStatus = 1;
    private static HistoryFile historyFile;
    private static WebPanel[] webPanels;
    static WebExport webExport;
    private static JFrame webFrame;
    private static String windowName;
    static String remoteAppletPath;
    static String localAppletPath;
    static Properties prop;
    static String pageAuthorName;
    private static String[] translations;

    private WebExport(JmolViewer viewer, HistoryFile hFile) {
        super(new BorderLayout());
        historyFile = hFile;
        remoteAppletPath = historyFile.getProperty("webMakerAppletPath", "..");
        localAppletPath = historyFile.getProperty("webMakerLocalAppletPath", "..");
        pageAuthorName = historyFile.getProperty("webMakerPageAuthorName", GT._("Jmol Web Page Maker"));
        JTabbedPane mainTabs = new JTabbedPane();
        JFileChooser fc = new JFileChooser();
        webPanels = new WebPanel[2];
        WebExport.setTranslations();
        if (runStatus != 0) {
            JPanel introPanel = new JPanel();
            String introFileName = "WebExportIntro";
            URL url = WebExport.getHtmlResource(this, introFileName);
            if (url == null) {
                System.err.println(GT._("Couldn't find file: {0}", introFileName + ".html"));
            }
            JEditorPane intro = new JEditorPane();
            if (url != null) {
                try {
                    intro.setPage(url);
                }
                catch (IOException e) {
                    System.err.println("Attempted to read a bad URL: " + url);
                }
            }
            intro.setEditable(false);
            JScrollPane introPane = new JScrollPane(intro);
            introPane.setMaximumSize(new Dimension(450, 350));
            introPane.setPreferredSize(new Dimension(400, 300));
            introPanel.setLayout(new BorderLayout());
            introPanel.add(introPane);
            introPanel.setMaximumSize(new Dimension(450, 350));
            introPanel.setPreferredSize(new Dimension(400, 300));
            mainTabs.add(GT._("Introduction"), introPanel);
            WebExport.webPanels[0] = new PopInJmol(viewer, fc, webPanels, 0);
            WebExport.webPanels[1] = new ScriptButtons(viewer, fc, webPanels, 1);
            int w = Integer.parseInt(historyFile.getProperty("webMakerInfoWidth", "300"));
            int h = Integer.parseInt(historyFile.getProperty("webMakerInfoHeight", "350"));
            mainTabs.addTab(GT._("Pop-In Jmol"), webPanels[0].getPanel(w, h));
            mainTabs.addTab(GT._("ScriptButton Jmol"), webPanels[1].getPanel(w, h));
        }
        boolean bl = showMoleculesAndOrbitals = runStatus == 0 || JmolViewer.checkOption(viewer, "webMakerAllTabs");
        if (showMoleculesAndOrbitals) {
            mainTabs.addTab("Orbitals", new Orbitals().getPanel());
            mainTabs.addTab("Molecules", new Molecules().getPanel());
        }
        mainTabs.addTab(GT._("Log"), LogPanel.getPanel());
        this.add(mainTabs);
        this.add((Component)LogPanel.getMiniPanel(), "South");
    }

    static String TimeStamp_WebLink() {
        return " <small>" + GT._("Page skeleton and JavaScript generated by export to web function using {0} on {1}.", new String[]{" <a href=\"http://jmol.sourceforge.net\">Jmol " + JmolViewer.getJmolVersion() + "</a> ", DateFormat.getDateInstance().format(new Date())}) + "</small><br />";
    }

    public static void dispose() {
        webFrame.dispose();
        webFrame = null;
    }

    public static WebExport createAndShowGUI(JmolViewer viewer, HistoryFile historyFile, String wName) {
        if (viewer == null) {
            runStatus = 0;
        }
        if (webFrame != null) {
            webFrame.setVisible(true);
            webFrame.toFront();
            return webExport;
        }
        webFrame = new JFrame(GT._("Jmol Web Page Maker"));
        windowName = wName;
        historyFile.repositionWindow(windowName, webFrame, 700, 400);
        if (runStatus == 0) {
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
            webFrame.setDefaultCloseOperation(3);
        } else {
            webFrame.setDefaultCloseOperation(2);
        }
        webExport = new WebExport(viewer, historyFile);
        webExport.setOpaque(true);
        webFrame.setContentPane(webExport);
        webFrame.addWindowListener(webExport);
        webFrame.pack();
        webFrame.setVisible(true);
        if (runStatus == 0) {
            // empty if block
        }
        return webExport;
    }

    public static void saveHistory() {
        historyFile.addWindowInfo(windowName, webFrame, null);
        prop.setProperty("webMakerAppletPath", remoteAppletPath);
        prop.setProperty("webMakerLocalAppletPath", localAppletPath);
        prop.setProperty("webMakerPageAuthorName", pageAuthorName);
        historyFile.addProperties(prop);
    }

    static String getAppletPath(boolean isRemote) {
        return isRemote ? remoteAppletPath : localAppletPath;
    }

    static void setAppletPath(String path, boolean isRemote) {
        if (path == null) {
            path = "..";
        }
        if (isRemote) {
            remoteAppletPath = path;
            prop.setProperty("webMakerAppletPath", remoteAppletPath);
            historyFile.addProperties(prop);
        } else {
            localAppletPath = path;
            prop.setProperty("webMakerLocalAppletPath", localAppletPath);
            historyFile.addProperties(prop);
        }
    }

    static String getPageAuthorName() {
        return pageAuthorName;
    }

    static void setWebPageAuthor(String pageAuthor) {
        if (pageAuthor == null) {
            pageAuthor = GT._("Jmol Web Page Maker");
        }
        pageAuthorName = pageAuthor;
        prop.setProperty("webMakerPageAuthorName", pageAuthorName);
        historyFile.addProperties(prop);
    }

    static JFrame getFrame() {
        return webFrame;
    }

    static URL getResource(Object object, String fileName) {
        return WebExport.getResource(object, fileName, true);
    }

    static URL getHtmlResource(Object object, String root) {
        String lang = GT.getLanguage();
        String fileName = root + "_" + lang + ".html";
        URL url = WebExport.getResource(object, fileName, false);
        if (url == null && lang.length() == 5) {
            fileName = root + "_" + lang.substring(0, 2) + ".html";
            url = WebExport.getResource(object, fileName, false);
        }
        if (url == null) {
            fileName = root + ".html";
            url = WebExport.getResource(object, fileName, true);
        }
        return url;
    }

    static URL getResource(Object object, String fileName, boolean flagError) {
        URL url = null;
        try {
            url = object.getClass().getResource("html/" + fileName);
            if (url == null && flagError) {
                System.err.println("Couldn't find file: " + fileName);
            }
        }
        catch (Exception e) {
            System.err.println("Exception " + e.getMessage() + " in getResource " + fileName);
        }
        return url;
    }

    private static void setTranslations() {
        translations = new String[]{"GT_JmolPopIn.js_TOGETA3DMODEL", GT.escapeHTML(GT._("To get a 3-D model you can manipulate, click {0}here{1}. Download time may be significant the first time the applet is loaded.", new String[]{"<a href=\"HREF\">", "</a>"})), "GT_pop_in_template.html_INSERTTITLE", GT.escapeHTML(GT._("Insert the page TITLE here.")), "GT_pop_in_template.html_INSERTINTRO", GT.escapeHTML(GT._("Insert the page INTRODUCTION here.")), "GT_pop_in_template2.html_INSERTCAPTION", GT.escapeHTML(GT._("Insert a caption for {0} here.", "@NAME@")), "GT_pop_in_template2.html_INSERTADDITIONAL", GT.escapeHTML(GT._("Insert additonal explanatory text here. Long text will wrap around Jmol model {0}.", "@NAME@")), "GT_script_button_template.html_INSERT", GT.escapeHTML(GT._("Insert your TITLE and INTRODUCTION here.")), "GT_script_button_template2.html_BUTTONINFO", GT.escapeHTML(GT._("The button {0} will appear in the box below.  Insert information for {0} here and below.", "@NAME@")), "GT_script_button_template2.html_MORE", GT.escapeHTML(GT._("Insert more information for {0} here.", "@NAME@"))};
    }

    private static String translate(String str) {
        for (int i = 0; i < translations.length; i += 2) {
            str = TextFormat.simpleReplace(str, translations[i], translations[i + 1]);
        }
        return str;
    }

    static String getResourceString(Object object, String name) throws IOException {
        URL url;
        URL uRL = url = name.indexOf(".") >= 0 ? WebExport.getResource(object, name) : WebExport.getHtmlResource(object, name);
        if (url == null) {
            throw new FileNotFoundException("Error loading resource " + name);
        }
        StringBuffer sb = new StringBuffer();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)url.getContent()));
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            br.close();
        }
        catch (Exception e) {
            LogPanel.log(e.getMessage());
        }
        return WebExport.translate(sb.toString());
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowGainedFocus(WindowEvent e) {
    }

    public void windowLostFocus(WindowEvent e) {
    }

    public void windowStateChanged(WindowEvent e) {
    }

    public static void cleanUp() {
        FileSystemView Directories = FileSystemView.getFileSystemView();
        File homedir = Directories.getHomeDirectory();
        String homedirpath = homedir.getPath();
        String scratchpath = homedirpath + "/.jmol_WPM";
        File scratchdir = new File(scratchpath);
        if (scratchdir.exists()) {
            File[] dirListing = null;
            dirListing = scratchdir.listFiles();
            for (int i = 0; i < dirListing.length; ++i) {
                dirListing[i].delete();
            }
        }
        WebExport.saveHistory();
        System.gc();
    }

    static {
        prop = new Properties();
    }
}

