/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.webexport;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.GZIPOutputStream;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import org.jmol.api.JmolViewer;
import org.jmol.i18n.GT;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Parser;
import org.jmol.util.TextFormat;
import org.jmol.viewer.FileManager;
import org.openscience.jmol.app.jmolpanel.HelpDialog;
import org.openscience.jmol.app.webexport.ArrayListTransferHandler;
import org.openscience.jmol.app.webexport.JmolInstance;
import org.openscience.jmol.app.webexport.LogPanel;
import org.openscience.jmol.app.webexport.WebExport;

abstract class WebPanel
extends JPanel
implements ActionListener {
    protected String panelName;
    protected String htmlAppletTemplate;
    protected String listLabel;
    protected String appletInfoDivs;
    protected boolean useAppletJS;
    protected JSpinner appletSizeSpinnerW;
    protected JSpinner appletSizeSpinnerH;
    protected JSpinner appletSizeSpinnerP;
    private JScrollPane editorScrollPane;
    private JButton saveButton;
    private JButton helpButton;
    private JButton addInstanceButton;
    private JButton deleteInstanceButton;
    private JButton showInstanceButton;
    private JTextField remoteAppletPath;
    private JTextField localAppletPath;
    private JTextField pageAuthorName;
    private JTextField webPageTitle;
    private JFileChooser fc;
    private JList instanceList;
    private JmolViewer viewer;
    private int panelIndex;
    private WebPanel[] webPanels;

    abstract String getAppletDefs(int var1, String var2, StringBuffer var3, JmolInstance var4);

    abstract String fixHtml(String var1);

    abstract JPanel appletParamPanel();

    protected WebPanel(JmolViewer viewer, JFileChooser fc, WebPanel[] webPanels, int panelIndex) {
        this.viewer = viewer;
        this.fc = fc;
        this.webPanels = webPanels;
        this.panelIndex = panelIndex;
        this.remoteAppletPath = new JTextField(20);
        this.remoteAppletPath.addActionListener(this);
        this.remoteAppletPath.setText(WebExport.getAppletPath(true));
        this.localAppletPath = new JTextField(20);
        this.localAppletPath.addActionListener(this);
        this.localAppletPath.setText(WebExport.getAppletPath(false));
        this.pageAuthorName = new JTextField(20);
        this.pageAuthorName.addActionListener(this);
        this.pageAuthorName.setText(WebExport.getPageAuthorName());
        this.webPageTitle = new JTextField(20);
        this.webPageTitle.addActionListener(this);
        this.webPageTitle.setText(GT._("A web page containing Jmol applets"));
    }

    JPanel getPanel(int infoWidth, int infoHeight) {
        this.instanceList = new JList(new DefaultListModel());
        this.instanceList.setSelectionMode(1);
        this.instanceList.setTransferHandler(new ArrayListTransferHandler(this));
        this.instanceList.setCellRenderer(new InstanceCellRenderer());
        this.instanceList.setDragEnabled(true);
        this.instanceList.setPreferredSize(new Dimension(350, 200));
        JScrollPane instanceListView = new JScrollPane(this.instanceList);
        instanceListView.setPreferredSize(new Dimension(350, 200));
        JPanel instanceSet = new JPanel();
        instanceSet.setLayout(new BorderLayout());
        instanceSet.add((Component)new JLabel(this.listLabel), "North");
        instanceSet.add((Component)instanceListView, "Center");
        instanceSet.add((Component)new JLabel(GT._("double-click and drag to reorder")), "South");
        this.addInstanceButton = new JButton(GT._("Add Present Jmol State as Instance..."));
        this.addInstanceButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setMaximumSize(new Dimension(350, 50));
        this.showInstanceButton = new JButton(GT._("Show Selected"));
        this.showInstanceButton.addActionListener(this);
        this.deleteInstanceButton = new JButton(GT._("Delete Selected"));
        this.deleteInstanceButton.addActionListener(this);
        buttonPanel.add(this.showInstanceButton);
        buttonPanel.add(this.deleteInstanceButton);
        JPanel paramPanel = this.appletParamPanel();
        paramPanel.setMaximumSize(new Dimension(350, 70));
        JPanel instanceButtonPanel = new JPanel();
        instanceButtonPanel.add(this.addInstanceButton);
        instanceButtonPanel.setSize(300, 70);
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)instanceButtonPanel, "North");
        p.add((Component)buttonPanel, "South");
        JPanel instancePanel = new JPanel();
        instancePanel.setLayout(new BorderLayout());
        instancePanel.add((Component)instanceSet, "Center");
        instancePanel.add((Component)p, "South");
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BorderLayout());
        rightPanel.setMinimumSize(new Dimension(350, 350));
        rightPanel.setMaximumSize(new Dimension(350, 1000));
        rightPanel.add((Component)paramPanel, "North");
        rightPanel.add((Component)instancePanel, "Center");
        rightPanel.setBorder(BorderFactory.createTitledBorder(GT._("Jmol Instances:")));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel leftPanel = this.getLeftPanel(infoWidth, infoHeight);
        leftPanel.setMaximumSize(new Dimension(350, 1000));
        panel.add((Component)leftPanel, "Center");
        panel.add((Component)rightPanel, "East");
        this.enableButtons(this.instanceList);
        return panel;
    }

    private JPanel getLeftPanel(int w, int h) {
        this.helpButton = new JButton(GT._("Help/Instructions"));
        this.helpButton.addActionListener(this);
        String templateImage = this.panelName + ".png";
        URL pageCartoon = WebExport.getResource(this, templateImage);
        ImageIcon pageImage = null;
        if (pageCartoon != null) {
            pageImage = new ImageIcon(pageCartoon, GT._("Cartoon of Page"));
        } else {
            System.err.println("Error Loading Page Cartoon Image " + templateImage);
        }
        JLabel pageCartoonLabel = new JLabel(pageImage);
        JPanel pageCartoonPanel = new JPanel();
        pageCartoonPanel.setLayout(new BorderLayout());
        pageCartoonPanel.setBorder(BorderFactory.createTitledBorder(GT._("Cartoon of Page") + ":"));
        pageCartoonPanel.add(pageCartoonLabel);
        this.saveButton = new JButton(GT._("Save HTML as..."));
        this.saveButton.addActionListener(this);
        JPanel savePanel = new JPanel();
        savePanel.add(this.saveButton);
        JPanel pathPanel = new JPanel();
        pathPanel.setLayout(new BorderLayout());
        pathPanel.setBorder(BorderFactory.createTitledBorder(GT._("Relative server path to jar files:")));
        pathPanel.add((Component)this.remoteAppletPath, "North");
        JPanel pathPanel2 = new JPanel();
        pathPanel2.setLayout(new BorderLayout());
        pathPanel2.setBorder(BorderFactory.createTitledBorder(GT._("Relative local path to jar files:")));
        pathPanel2.add((Component)this.localAppletPath, "North");
        JPanel authorPanel = new JPanel();
        authorPanel.setBorder(BorderFactory.createTitledBorder(GT._("Author (your name):")));
        authorPanel.add((Component)this.pageAuthorName, "North");
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BorderLayout());
        titlePanel.setBorder(BorderFactory.createTitledBorder(GT._("Browser window title for this web page:")));
        titlePanel.add((Component)this.webPageTitle, "North");
        titlePanel.add((Component)savePanel, "South");
        JPanel pathPanels = new JPanel();
        pathPanels.setLayout(new BorderLayout());
        pathPanels.add((Component)pathPanel, "North");
        pathPanels.add((Component)pathPanel2, "South");
        JPanel settingsPanel = new JPanel();
        settingsPanel.setLayout(new BorderLayout());
        settingsPanel.add((Component)pathPanels, "North");
        settingsPanel.add((Component)authorPanel, "Center");
        settingsPanel.add((Component)titlePanel, "South");
        JPanel leftpanel = new JPanel();
        leftpanel.setLayout(new BorderLayout());
        leftpanel.add((Component)this.helpButton, "North");
        leftpanel.add((Component)pageCartoonPanel, "Center");
        leftpanel.add((Component)settingsPanel, "South");
        return leftpanel;
    }

    int getInfoWidth() {
        return this.editorScrollPane.getWidth();
    }

    int getInfoHeight() {
        return this.editorScrollPane.getHeight();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.remoteAppletPath) {
            String path = this.remoteAppletPath.getText();
            WebExport.setAppletPath(path, true);
            return;
        }
        if (e.getSource() == this.localAppletPath) {
            String path = this.localAppletPath.getText();
            WebExport.setAppletPath(path, false);
            return;
        }
        if (e.getSource() == this.addInstanceButton) {
            JmolInstance instance;
            String label = this.instanceList.getSelectedIndices().length != 1 ? "" : this.getInstanceName(-1);
            String name = JOptionPane.showInputDialog(GT._("Give the occurrence of Jmol a name:"), (Object)label);
            if (name == null) {
                return;
            }
            String script = this.viewer.getStateInfo();
            if (script == null) {
                LogPanel.log("Error trying to get Jmol State within pop_in_Jmol.");
            }
            DefaultListModel listModel = (DefaultListModel)this.instanceList.getModel();
            int width = 300;
            int height = 300;
            if (this.appletSizeSpinnerH != null) {
                width = ((SpinnerNumberModel)this.appletSizeSpinnerW.getModel()).getNumber().intValue();
                height = ((SpinnerNumberModel)this.appletSizeSpinnerH.getModel()).getNumber().intValue();
            }
            if ((instance = new JmolInstance(this.viewer, name, script, width, height)) == null) {
                LogPanel.log(GT._("Error creating new instance containing script(s) and image."));
            }
            int i = this.instanceList.getModel().getSize();
            while (--i >= 0 && !this.getInstanceName(i).equals(instance.name)) {
            }
            if (i < 0) {
                i = listModel.getSize();
                listModel.addElement(instance);
                LogPanel.log(GT._("added Instance {0}", instance.name));
            } else {
                listModel.setElementAt(instance, i);
                LogPanel.log(GT._("updated Instance {0}", instance.name));
            }
            this.instanceList.setSelectedIndex(i);
            this.syncLists();
            return;
        }
        if (e.getSource() == this.deleteInstanceButton) {
            DefaultListModel listModel = (DefaultListModel)this.instanceList.getModel();
            int[] todelete = this.instanceList.getSelectedIndices();
            int nDeleted = 0;
            for (int i = 0; i < todelete.length; ++i) {
                JmolInstance instance = (JmolInstance)listModel.get(todelete[i]);
                try {
                    instance.delete();
                }
                catch (IOException err) {
                    LogPanel.log(err.getMessage());
                }
                listModel.remove(todelete[i] - nDeleted++);
            }
            this.syncLists();
            return;
        }
        if (e.getSource() == this.showInstanceButton) {
            DefaultListModel listModel = (DefaultListModel)this.instanceList.getModel();
            int[] list = this.instanceList.getSelectedIndices();
            if (list.length != 1) {
                return;
            }
            JmolInstance instance = (JmolInstance)listModel.get(list[0]);
            this.viewer.evalStringQuiet(")" + instance.script);
            return;
        }
        if (e.getSource() == this.saveButton) {
            this.fc.setDialogTitle(GT._("Select a directory to create or an HTML file to save"));
            int returnVal = this.fc.showSaveDialog(this);
            if (returnVal != 0) {
                return;
            }
            File file = this.fc.getSelectedFile();
            boolean retVal = true;
            try {
                String path = this.remoteAppletPath.getText();
                WebExport.setAppletPath(path, true);
                path = this.localAppletPath.getText();
                WebExport.setAppletPath(path, false);
                String authorName = this.pageAuthorName.getText();
                WebExport.setWebPageAuthor(authorName);
                retVal = this.fileWriter(file, this.instanceList);
            }
            catch (IOException IOe) {
                LogPanel.log(IOe.getMessage());
            }
            if (!retVal) {
                LogPanel.log(GT._("Call to FileWriter unsuccessful."));
            }
        }
        if (e.getSource() == this.helpButton) {
            HelpDialog webExportHelp = new HelpDialog(WebExport.getFrame(), WebExport.getHtmlResource(this, this.panelName + "_instructions"));
            webExportHelp.setVisible(true);
            webExportHelp.setDefaultCloseOperation(2);
        }
    }

    String getInstanceName(int i) {
        JmolInstance instance;
        if (i < 0) {
            i = this.instanceList.getSelectedIndex();
        }
        return (instance = (JmolInstance)this.instanceList.getModel().getElementAt(i)) == null ? "" : instance.name;
    }

    boolean fileWriter(File file, JList InstanceList) throws IOException {
        String str;
        String html;
        this.useAppletJS = JmolViewer.checkOption(this.viewer, "webMakerCreateJS");
        String datadirPath = file.getPath();
        String datadirName = file.getName();
        String fileName = null;
        if (datadirName.indexOf(".htm") > 0) {
            fileName = datadirName;
            datadirPath = file.getParent();
            file = new File(datadirPath);
            datadirName = file.getName();
        } else {
            fileName = datadirName + ".html";
        }
        datadirPath = datadirPath.replace('\\', '/');
        boolean made_datadir = file.exists() && file.isDirectory() || file.mkdir();
        DefaultListModel listModel = (DefaultListModel)InstanceList.getModel();
        LogPanel.log("");
        if (made_datadir) {
            LogPanel.log(GT._("Using directory {0}", datadirPath));
            LogPanel.log("  " + GT._("adding JmolPopIn.js"));
            this.viewer.writeTextFile(datadirPath + "/JmolPopIn.js", WebExport.getResourceString(this, "JmolPopIn.js"));
            for (int i = 0; i < listModel.getSize(); ++i) {
                JmolInstance thisInstance = (JmolInstance)listModel.getElementAt(i);
                String javaname = thisInstance.javaname;
                String script = thisInstance.script;
                LogPanel.log("  ...jmolApplet" + i);
                LogPanel.log("      ..." + GT._("adding {0}.png", javaname));
                thisInstance.movepict(datadirPath);
                String fileList = "";
                fileList = fileList + WebPanel.addFileList(script, "/*file*/");
                fileList = fileList + WebPanel.addFileList(script, "FILE0=");
                fileList = fileList + WebPanel.addFileList(script, "FILE1=");
                if (this.localAppletPath.getText().equals(".") || this.remoteAppletPath.getText().equals(".")) {
                    fileList = fileList + "Jmol.js\nJmolApplet.jar";
                }
                String[] filesToCopy = fileList.split("\n");
                String[] copiedFileNames = new String[filesToCopy.length];
                for (int iFile = 0; iFile < filesToCopy.length; ++iFile) {
                    String f = filesToCopy[iFile];
                    int pt = f.indexOf("|");
                    if (pt >= 0) {
                        filesToCopy[iFile] = f.substring(0, pt);
                    }
                    copiedFileNames[iFile] = WebPanel.copyBinaryFile(filesToCopy[iFile], datadirPath);
                }
                script = WebPanel.localizeFileReferences(script, filesToCopy, copiedFileNames);
                LogPanel.log("      ..." + GT._("adding {0}.spt", javaname));
                this.viewer.writeTextFile(datadirPath + "/" + javaname + ".spt", script);
            }
            html = WebExport.getResourceString(this, this.panelName + "_template");
            html = this.fixHtml(html);
            this.appletInfoDivs = "";
            StringBuffer appletDefs = new StringBuffer();
            if (!this.useAppletJS) {
                this.htmlAppletTemplate = WebExport.getResourceString(this, this.panelName + "_template2");
            }
            for (int i = 0; i < listModel.getSize(); ++i) {
                html = this.getAppletDefs(i, html, appletDefs, (JmolInstance)listModel.getElementAt(i));
            }
            html = TextFormat.simpleReplace(html, "@AUTHOR@", GT.escapeHTML(this.pageAuthorName.getText()));
            html = TextFormat.simpleReplace(html, "@TITLE@", GT.escapeHTML(this.webPageTitle.getText()));
            html = TextFormat.simpleReplace(html, "@REMOTEAPPLETPATH@", this.remoteAppletPath.getText());
            html = TextFormat.simpleReplace(html, "@LOCALAPPLETPATH@", this.localAppletPath.getText());
            html = TextFormat.simpleReplace(html, "@DATADIRNAME@", datadirName);
            if (this.appletInfoDivs.length() > 0) {
                this.appletInfoDivs = "\n<div style='display:none'>\n" + this.appletInfoDivs + "\n</div>\n";
            }
            str = appletDefs.toString();
            if (this.useAppletJS) {
                str = "<script type='text/javascript'>\n" + str + "\n</script>";
            }
        } else {
            IOException IOe = new IOException("Error creating directory: " + datadirPath);
            throw IOe;
        }
        html = TextFormat.simpleReplace(html, "@APPLETINFO@", this.appletInfoDivs);
        html = TextFormat.simpleReplace(html, "@APPLETDEFS@", str);
        html = TextFormat.simpleReplace(html, "@CREATIONDATA@", GT.escapeHTML(WebExport.TimeStamp_WebLink()));
        html = TextFormat.simpleReplace(html, "@AUTHORDATA@", GT.escapeHTML(GT._("Based on template by A. Herr&#x00E1;ez as modified by J. Gutow")));
        html = TextFormat.simpleReplace(html, "@LOGDATA@", "<pre>\n" + LogPanel.getText() + "\n</pre>\n");
        LogPanel.log("      ..." + GT._("creating {0}", fileName));
        this.viewer.writeTextFile(datadirPath + "/" + fileName, html);
        LogPanel.log("");
        return true;
    }

    private static String addFileList(String script, String tag) {
        String fileList = "";
        int i = -1;
        while ((i = script.indexOf(tag, i + 1)) >= 0) {
            fileList = fileList + Parser.getNextQuotedString(script, i) + "\n";
        }
        return fileList;
    }

    private static String copyBinaryFile(String fullPathName, String dataPath) {
        String name = fullPathName.substring(fullPathName.lastIndexOf(47) + 1);
        name = dataPath + "/" + name;
        String gzname = name + ".gz";
        File outFile = new File(name);
        File gzoutFile = new File(gzname);
        if (outFile.exists()) {
            return name;
        }
        if (gzoutFile.exists()) {
            return gzname;
        }
        try {
            LogPanel.log("      ..." + GT._("copying\n{0}\n         to", fullPathName));
            byte[] data = WebPanel.getFileAsBytes(fullPathName);
            if (data == null) {
                LogPanel.log(GT._("Could not find or open:\n{0}", fullPathName));
            } else {
                name = WebPanel.writeFileBytes(name, data);
                LogPanel.log(name);
            }
        }
        catch (Exception e) {
            LogPanel.log(e.getMessage());
        }
        return name;
    }

    private static byte[] getFileAsBytes(String path) throws IOException {
        int len = 0;
        int totalLen = 0;
        Object streamOrError = FileManager.getInputStream(path, false, null, null);
        if (streamOrError instanceof String) {
            LogPanel.log((String)streamOrError);
            return null;
        }
        byte[] buf = new byte[1024];
        byte[] bytes = new byte[4096];
        BufferedInputStream bis = new BufferedInputStream((InputStream)streamOrError);
        while ((len = bis.read(buf)) > 0) {
            if ((totalLen += len) >= bytes.length) {
                bytes = ArrayUtil.ensureLength(bytes, totalLen * 2);
            }
            System.arraycopy(buf, 0, bytes, totalLen - len, len);
        }
        bis.close();
        buf = new byte[totalLen];
        System.arraycopy(bytes, 0, buf, 0, totalLen);
        return buf;
    }

    private static String writeFileBytes(String path, byte[] data) {
        try {
            if (data.length >= 524288 && !path.endsWith("JmolApplet.jar")) {
                path = path + ".gz";
                GZIPOutputStream gzFile = new GZIPOutputStream(new FileOutputStream(path));
                gzFile.write(data);
                LogPanel.log("      ..." + GT._("compressing large data file to") + "\n");
                gzFile.flush();
                gzFile.close();
            } else {
                FileOutputStream os = new FileOutputStream(path);
                os.write(data);
                os.flush();
                os.close();
            }
        }
        catch (IOException e) {
            LogPanel.log(e.getMessage());
        }
        return path;
    }

    private static String localizeFileReferences(String script, String[] origFileList, String[] copiedFileNames) {
        for (int i = 0; i < origFileList.length; ++i) {
            String fullPathName = origFileList[i];
            String fullCopiedName = copiedFileNames[i];
            String name = fullCopiedName.substring(fullCopiedName.lastIndexOf(47) + 1);
            if (name.equals(fullPathName)) continue;
            script = TextFormat.simpleReplace(script, fullPathName, name);
        }
        return script;
    }

    void syncLists() {
        JList list = this.webPanels[1 - this.panelIndex].instanceList;
        DefaultListModel model1 = (DefaultListModel)this.instanceList.getModel();
        DefaultListModel model2 = (DefaultListModel)list.getModel();
        model2.clear();
        int n = model1.getSize();
        for (int i = 0; i < n; ++i) {
            model2.addElement(model1.get(i));
        }
        list.setSelectedIndices(new int[0]);
        this.enableButtons(this.instanceList);
        this.webPanels[1 - this.panelIndex].enableButtons(list);
    }

    void enableButtons(JList list) {
        int nSelected = list.getSelectedIndices().length;
        int nListed = list.getModel().getSize();
        this.saveButton.setEnabled(nListed > 0);
        this.deleteInstanceButton.setEnabled(nSelected > 0);
        this.showInstanceButton.setEnabled(nSelected == 1);
    }

    class InstanceCellRenderer
    extends JLabel
    implements ListCellRenderer {
        InstanceCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(" " + ((JmolInstance)value).name);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            WebPanel.this.enableButtons(list);
            return this;
        }
    }
}

