C
C       ======================================================================
C     ==========================================================================
C
C     DDDDDDD   IIII   CCCCCC   VV    VV   OOOOOO   LL         999999        11
C     DD    DD   II   CC    CC  VV    VV  OO    OO  LL        99    99     1111
C     DD    DD   II   CC        VV    VV  OO    OO  LL        99    99   111 11
C     DD    DD   II   CC        VV    VV  OO    OO  LL         9999999       11
C     DD    DD   II   CC         VV  VV   OO    OO  LL              99       11
C     DD    DD   II   CC    CC    VVVV    OO    OO  LL    LL  99    99       11
C     DDDDDDD   IIII   CCCCCC      VV      OOOOOO   LLLLLLLL   999999       1111
C
C     ==========================================================================
C       ======================================================================
C
C     DICVOL91-VERSION PC :  30/06/92
C
C     (VERSION WITH SCREEN AND FILE OUTPUT - 19/03/93)
C
C     TRIAL AND ERROR METHOD FOR THE AUTOMATIC INDEXING OF POWDER DIFFRACTION
C     PATTERNS - VARIATION OF PARAMETERS BY SUCCESSIVE DICHOTOMY.
C     THIS VERSION INCLUDES PARTITION OF VOLUME SPACE.
C     THE FOLLOWING CRYSTALLINE SYSTEMS CAN BE EXAMINED :
C     CUBIC, TETRAGONAL,HEXAGONAL, ORTHORHOMBIC, MONOCLINIC
C     AND TRICLINIC.
C
C     PRECURSOR PROGRAMS :   P1 AND P2 (REF. 1), DICVOL (REF. 2)
C
C     DICVOL91 HAS BEEN WRITTEN BY D. LOUER AND A. BOULTIF (REF. 3)
C
C     FOR FURTHER INFORMATION CONTACT
C               D. LOUER
C               LABORATOIRE DE CRISTALLOCHIMIE
C               UNIVERSITE DE RENNES I
C               CAMPUS DE BEAULIEU
C               35042 RENNES CEDEX    -FRANCE-
C               TEL.   (33) 99-28-62-48
C               FAX    (33) 99-38-34-87
C               E-MAIL  LOUER@CICB.FR	  
C
C      ---------------------------------------------------------------
C      |            G E N E R A L   I N S T R U C T I O N S          |
C      ---------------------------------------------------------------
C
C      DICVOL PROPOSES SOLUTIONS; THE USER DISPOSES OF THEM.
C      THE AUTHORS DISCLAIM RESPONSABILITY FOR ALL USE OF THIS
C      PROGRAM, WHETHER GOOD, BAD OR INDIFFERENT.
C
C      DATA CARDS
C      ----------
C
C  CARD 1  TITLE                                       FORMAT(16A4)
C
C
C  CARD 2  N,ITYPE,JC,JT,JH,JO,JM,JTR                  FREE FORMAT
C
C          N               NUMBER OF LINES USED.
C          ITYPE           SPACING DATA TYPE.
C                      =1  THETA BRAGG IN DEGREES.
C                      =2  2-THETA ANGLE IN DEGREES.
C                      =3  D-SPACING IN ANGSTROMS.
C                      =4  Q SPECIFIED IN Q-UNITS AS E+04/D**2.
C          JC          =0  CUBIC SYSTEM IS NOT TESTED.
C                      =1  CUBIC SYSTEM IS TESTED.
C          JT          =0  TETRAGONAL SYSTEM IS NOT TESTED.
C                      =1  TETRAGONAL SYSTEM IS TESTED.
C          JH          =0  HEXAGONAL SYSTEM IS NOT TESTED.
C                      =1  HEXAGONAL SYSTEM IS TESTED.
C          JO          =0  ORTHORHOMBIC SYSTEM IS NOT TESTED.
C                      =1  ORTHORHOMBIC SYSTEM IS TESTED.
C          JM          =0  MONOCLINIC SYSTEM IS NOT TESTED.
C                      =1  MONOCLINIC SYSTEM IS TESTED.
C          JTR         =0  TRICLINIC SYSTEM IS NOT TESTED.
C                      =1  TRICLINIC SYSTEM IS TESTED.
C
C
C  CARD 3  AMAX,BMAX,CMAX,VOLMIN,VOLMAX,BEMIN,BEMAX    FREE FORMAT
C
C          AMAX    MAXIMUM VALUE OF UNIT CELL DIMENSION A IN ANGSTROMS.
C                  (IF AMAX= 0.0 DEFAULT= 20. ANGSTROMS)
C          BMAX    MAXIMUM VALUE OF UNIT CELL DIMENSION B IN ANGSTROMS.
C                  (IF BMAX= 0.0 DEFAULT= 20. ANGSTROMS)
C          CMAX    MAXIMUM VALUE OF UNIT CELL DIMENSION C IN ANGSTROMS.
C                  (IF CMAX= 0.0 DEFAULT= 20. ANGSTROMS)
C          VOLMIN  MINIMUM VOLUME FOR TRIAL UNIT CELLS IN ANGSTROMS**3.
C          VOLMAX  MAXIMUM VOLUME FOR TRIAL UNIT CELLS IN ANGSTROMS**3.
C                  (IF VOLMAX= 0.0 DEFAULT= 1500. ANGSTROMS**3)
C          BEMIN   MINIMUM ANGLE FOR UNIT CELL IN DEGREES
C                  (IF BEMIN= 0.0 DEFAULT= 90. DEGREES).
C          BEMAX   MAXIMUM ANGLE FOR UNIT CELL IN DEGREES
C                  (IF BEMAX= 0.0 DEFAULT= 125. DEGREES).
C
C
C  CARD 4  WAVE,POIMOL,DENS,DELDEN                     FREE FORMAT
C
C          WAVE    WAVELENGTH IN ANGSTROMS (DEFAULT=0.0 IF CU K ALPHA1).
C          POIMOL  MOLECULAR WEIGHT OF ONE FORMULA UNIT IN A.M.U.
C                  (DEFAULT =0.0 IF FORMULA WEIGHT NOT KNOWN).
C          DENS    MEASURED DENSITY IN G.CM(-3)
C                  (DEFAULT =0.0 IF DENSITY NOT KNOWN).
C          DELDEN  ABSOLUTE ERROR IN MEASURED DENSITY.
C
C
C  CARD 5  EPS,FOM                                     FREE FORMAT
C
C          EPS       =0.0  THE ABSOLUTE ERROR ON EACH OBSERVED LINE
C                          IS TAKEN TO .03 DEG. 2THETA, WHATEVER THE
C                          SPACING DATA TYPE (ITYPE IN CARD 2).
C                    =1.0  THE ABSOLUTE ERROR ON EACH OBSERVED LINE IS
C                          INPUT INDIVIDUALLY IN THE FOLLOWING CARDS,
C                          TOGETHER WITH THE OBSERVED 'D(I)', ACCORDING
C                          WITH THE SPACING DATA UNIT.
C                    EPS NE 0.0 AND 1.0
C                          THE ABSOLUTE ERROR IS TAKEN AS A CONSTANT
C                          (=EPS),IN DEG. 2THETA, WHATEVER THE SPACING
C                          DATA TYPE (ITYPE IN CARD 2).
C          FOM             LOWER FIGURE OF MERIT M(N) REQUIRED FOR PRINTED
C                          SOLUTION(S) (DEFAULT=0.0 IF LOWER M(N)=5.0).
C
C
C  CARD 6 TO 6+N  D(I),EPSIL(I)                        FREE FORMAT
C
C          (ONE FOR EACH OBSERVED LINE, UP TO N)
C          D(I)    VALUE DESCRIBING THE OBSERVED POSITION
C                  OF THIS LINE ACCORDING TO 'ITYPE'.
C          EPSIL   ABSOLUTE ERROR IN 'D(I)', ACCORDING TO 'ITYPE',
C                  ONLY IF EPS=1.0 (CARD 5).
C  NOTE:
C          IF ITYPE=1,2,4 THE VALUES OF 'D(I)' AND 'EPSIL(I)' MUST
C          BE LISTED IN INCREASING ORDER.
C          IF ITYPE=3 THEY MUST BE IN DECREASING ORDER.
C
C  REFERENCES:
C     1.-  LOUER, D. AND LOUER, M., METHODE D'ESSAIS ET ERREURS POUR
C          L'INDEXATION AUTOMATIQUE DES DIAGRAMMES DE POUDRE,
C	   J. APPL. CRYST. 5, 271-275 (1972).
C     2.-  LOUER, D. AND VARGAS, R., INDEXATION AUTOMATIQUE DES
C          DIAGRAMMES DE POUDRE PAR DICHOTOMIES SUCCESSIVES,
C	   J. APPL. CRYST. 15, 542-545 (1982).
C     3.-  BOULTIF, A. AND LOUER, D., INDEXING OF POWDER DIFFRACTION
C	   PATTERNS FOR LOW SYMMETRY LATTICES BY THE SUCCESSIVE
C	   DICHOTOMY METHOD, J. APPL. CRYST. 24, 987-993 (1991).
C     4.-  DE WOLFF, P.M., A SIMPLIFIED CRITERION FOR THE RELIABILITY
C	   OF A POWDER PATTERN INDEXING, J. APPL. CRYST. 5, 108-113 (1968).
C     5.-  SMITH, G. S. AND SNYDER, R. L., F(N): A CRITERION FOR RATING
C	   POWDER DIFFRACTION PATTERNS AND EVALUATING THE RELIABILITY
C	   OF POWDER-PATTERN INDEXING, J. APPL. CRYST. 12, 60-65 (1979).
C     6.-  MIGHELL, A.D., HUBBARD, C.R. AND STALIK, J.K., NBS*AIDS80:
C          A FORTRAN PROGRAM FOR CRYSTALLOGRAPHIC DATA EVALUATION.
C          NAT. BUR. STAND. (U.S.) TECH. NOTE 1141 (1981). (NBS*AIDS83
C          IS AN EXPANDED VERSION OF NBS*AIDS80).
C     7.-  LOUER, D., AUTOMATIC INDEXING: PROCEDURES AND APPLICATIONS,IN
C          'ACCURACY IN POWDER DIFFRACTION II', NIST, SPEC. PUBL. No. 846,
C          GAITHERSBURG, MD, USA, pp. 92-104, 1992. 
C        *****************************************************
C        *                                                   *
C        *         THE USE OF DICVOL91 (VERSION 1.0)         *
C        *                                                   *
C        *****************************************************
C
C      USE AS INPUT DATA THE FIRST 20 LINES (ALTHOUGH THIS NUMBER
C      CAN BE DIFFERENT). AVOID SPURIOUS LINES OR TOO INACCURATE DATA.
C      ALL SYMMETRIES CAN BE EXAMINED IN ONE RUN. HOWEVER, IT IS
C      RECOMMENDED TO USE A TWO- OR THREE-STAGE PROCEDURE :
C        1- SEARCH IN HIGH SYMMETRIES DOWN TO ORTHORHOMBIC.
C           CARD 2 : N,ITYPE,1,1,1,1,0,0
C        2- SEARCH IN MONOCLINIC SYMMETRY.
C           CARD 2 : N,ITYPE,0,0,0,0,1,0
C        3- IF NECESSARY, SEARCH IN TRICLINIC SYMMETRY.
C           CARD 2 : N,ITYPE,0,0,0,0,0,1
C
C      NOTE THAT FOR SOLUTIONS WITH TRICLINIC SYMMETRY THE USE OF A
C      REDUCTION CELL PROGRAM IS USUALLY USEFULL TO OBTAIN THE
C      CONVENTIONAL UNIT CELL (E.G. CDF-SRCH/JCPDS).
C
C     NOTE - CASE OF TRIGONAL SYMMETRY WITH RHOMBOEDRAL LATTICE:
C	    THE PATTERN IS INDEXED WITH AN HEXAGONAL LATTICE, HAVING
C	    A UNIT CELL VOLUME THREE TIMES GREATER. OWING TO THE
C	    STRATEGY BASED ON THE PATITION OF VOLUME SPACE (SHELLS OF
C	    400 A**3) YOU CAN MISS THE SOLUTION IF, BY ACCIDENT, A
C	    SMALLER (PSEUDO) SOLUTION IS FOUND IN AN OTHER SYMMETRY.
C	    IF YOU SUSPECT SUCH A CASE, RUN DICVOL91 WITH THE HEXAGONAL
C	    CASE ONLY (JC=0, JT=0, JH=1, JO=0, JM=0, JTR=0).
C
C  RECOMMENDATIONS
C   ---------------
C   1- PLEASE SPEND TIME TO ENSURE THE QUALITY OF YOUR OBSERVED DATA.
C      WITH ACCURATE DATA THE SUCCESS RATE OF DICVOL91 IS VERY HIGH
C      (SEE REF. 3).
C      WITH BAD DATA THE CHANCE TO OBTAIN THE CORRECT SOLUTION IS VERY
C      SMALL AND THE CALCULATION CAN BE TIME-CONSUMMING.
C
C      WITH MODERN X-RAY POWDER DIFFRACTOMETERS (THE USE OF MONOCHROMATIC
C      RADIATION IS STRONGLY RECOMMENDED) ABSOLUTE ERRORS ON PEAK
C      POSITIONS LOWER THAN 0.03 DEGREES 2-THETA CAN BE ROUTINELY OBTAINED.
C      FOR INDEXING PURPOSES, ERRORS SHOULD NOT EXCEED 0.03 DEG. 2-THETA
C      [IN EXCEPTIONAL CASES, A FEW LINES WITH GREATER ERROR CAN BE
C      INTRODUCED IN INPUT DATA. IN THIS CASE, USE THE PARAMETER EPS= 1.
C      (CARD 5), AND ENTER INDIVIDUAL ERRORS ON EACH LINE(CARD 6 TO 6+N)].
C
C      WITH HIGH RESOLUTION POWDER DIFFRACTION DATA (CONVENTIONAL OR,
C      PARTICULARLY, SYNCHROTRON X-RAY SOURCES) THE ABSOLUTE ERROR IS
C      USUALLY LESS THAN 0.02 (OR EVEN 0.01) DEG. 2-THETA; CONSEQUENTLY,
C      EPS=0.02 (OR EVEN EPS=0.01) IS THEN RECOMMENDED; THE CONVERGENCE
C      OF THE DICHOTOMY PROCEDURE WILL BE IMPROVED. HOWEVER, BE SURE THAT
C      THIS CONDITION IS TRUE FOR ALL THE LINES USED AS INPUT DATA.
C
C   2- IF DICVOL91 HAS FOUND A SOLUTION FROM THE FIRST 20 (OR N) LINES,
C      THIS SOLUTION MUST INDEXED THE COMPLETE POWDER DIFFRACTION
C      PATTERN FOR THIS PURPOSE, THE PROGRAM NBS*AIDS83 (REF. 6) CAN BE
C      USED.
C
C           ----------          ------------------          ----------
C           |        |=========>|     CUBIC      |=========>|        |
C           |        |          ------------------          |        |
C           |        |                   V                  |        |
C           |        |              ----------              |        |
C           |        |              | CUDHKL |              |        |
C           |        |              ----------              |    A   |
C           |        |                                      |    F   |
C           |        |                                      |    F   |
C           |        |                                      |    I   |
C           |        |          ------------------          |    N   |
C           |        |=========>|   TETRAGONAL   |=========>|    E   |
C           |    P   |          ------------------          |    M   |
C           |    R   |                   V                  |    E   |
C           |    O   |              ----------              |    N   |
C           |    G   |              | TEDHKL |              |    T   |
C           |    R   |              ----------              |        |
C           |    A   |                                      |        |
C           |    M   |                                      |    D   |
C           |    M   |                                      |    E   |
C           |    E   |          ------------------          |    S   |
C           |        |=========>|    HEXAGONAL   |=========>|        |
C           |        |          ------------------          |        |
C           |    P   |                   V                  |    P   |
C           |    R   |              ----------              |    A   |
C           |    I   |              | TEDHKL |              |    R   |
C           |    N   |              ----------              |    A   |
C           |    C   |                                      |    M   |
C           |    I   |                                      |    E   |
C           |    P   |                                      |    T   |
C           |    A   |          ------------------          |    R   |
C           |    L   |=========>|  ORTHORHOMBIC  |=========>|    E   |
C           |        |          ------------------          |    S   |
C           |        |                   V                  |        |
C           |        |              ----------              |        |
C           |        |              | ORDHKL |              |        |
C           |        |              ----------              |        |
C           |        |                                      |        |
C           |        |                                      |        |
C           |        |          ------------------          |    R   |
C           |        |=========>|   MONOCLINIC   |=========>|    E   |
C           |        |          ------------------          |    S   |
C           |        |                   V                  |        |
C           |        |              ----------              |        |
C           |        |              | MODHKL |              |        |
C           |        |              ----------              |        |
C           |        |                                      |        |
C           |        |                                      |        |
C           |        |          ------------------          |        |
C           |        |=========>|   TRICLINIC    |=========>|        |
C           |        |          ------------------          ----------
C           |        |                   V                       V
C           |        |              ----------              ----------
C           |        |              | TRIHKL |              | PASAJE |
C           ----------              ----------              ----------
C     ------------------------------------------------------------------
C     |              P R O G R A M M E   P R I N C I P A L             |
C     ------------------------------------------------------------------
      DIMENSION IDENT(64)
C     CHARACTER IDENT*64
      COMMON D(50),Q(50),KQ(50),TH(50),EPSIL(50),EPSQ(50),KEPSQ(50),DTH,
     1       V,VINF,VSUP,PAS,PAS2,PAS4,PAS8,PAS16,PAS32,PAS64,COEFF,RAP,
     2       WAVE2,PIDEG,PIRAD,N,MH,MH2,MK,MK2,ML,ML2,KDENS,KZ,KQT(50)
      COMMON IR,IW
      COMMON /AMAX DD/AMAX,DD1,DD2
      COMMON /MONO/AMAXM,BMAXM,CMAXM,MC,PETIAMAX
      COMMON /JCOUNT/JCOUNT,EPST,NINI,FOM
      REAL*8 BEGIN_TIME,END_TIME,DIF_TIME,SECNDS,TIME2
C     L E C T U R E   D E S   D O N N E E S
      IR=7
      IW=8
      READ(IR,525,ERR=343)(IDENT(K),K=1,64)
      READ(IR,*,ERR=343)N,ITYPE,JC,JT,JH,JO,JM,JTR
      READ(IR,*,ERR=343)AMAX,BMAX,CMAX,VOLMIN,VOLMAX,BEMIN,BEMAX
      READ(IR,*,ERR=343)WAVE,POIMOL,DENS,DELDEN
      IF(WAVE.EQ.0.0)WAVE=1.540598
      IF(AMAX.EQ.0.)AMAX=20.
      IF(BMAX.EQ.0.)BMAX=20.
      IF(CMAX.EQ.0.)CMAX=20.
      IF(VOLMAX.EQ.0.)VOLMAX=1500.
      READ(IR,*,ERR=343)EPS,FOM
      BEGIN_TIME=SECNDS()
      TIME2=3600.*24.
C
      PI=4.*ATAN(1.)
      PIRAD=PI/180.
      PIDEG=180./PI
      WAVE2=WAVE/2.
      PAS=0.4
      COEF4=1.E-04
      COEFF=1.E+08
      IF(FOM.EQ.0.)FOM=5.
      IF(EPS.EQ.1.)THEN
      EPST=.0
      DO 36 I=1,N
      READ(IR,*,ERR=343)D(I),EPSIL(I)
      GO TO(42,43,44,45),ITYPE
   42 EPSTI=2.*EPSIL(I)+.015
      GO TO 36
   43 EPSTI=EPSIL(I)+.015
      GO TO 36
   44 EPSTI=2.*EPSIL(I)*WAVE/D(I)/SQRT(4.*D(I)**2-WAVE**2)*PIDEG+.015
      GO TO 36
   45 D(I)=COEF4*D(I)
      EPSIL(I)=COEF4*EPSIL(I)
      EPSTI=2.*WAVE*EPSIL(I)/2./SQRT(D(I)*(4.-D(I)*WAVE**2))*PIDEG+.015
      D(I)=D(I)/COEF4
      EPSIL(I)=EPSIL(I)/COEF4
   36 IF(EPSTI.GT.EPST)EPST=EPSTI
      GO TO 35
      ENDIF
      READ(IR,*,ERR=343)(D(I),I=1,N)
      IF(EPS.EQ.0.)EPS=.03
      EPST=EPS+.015
      IF(ITYPE.EQ.1)EPS=EPS/2.
      IF(ITYPE.EQ.1.OR.ITYPE.EQ.2)THEN
      DO 32 I=1,N
   32 EPSIL(I)=EPS
      GO TO 35
      ENDIF
      IF(ITYPE.EQ.3)THEN
      EPS=EPS/2.
      DO 33 I=1,N
   33 EPSIL(I)=D(I)/WAVE*EPS*PIRAD*SQRT(4.*D(I)**2-WAVE**2)
      GO TO 35
      ENDIF
      IF(ITYPE.EQ.4)THEN
      EPS=EPS/2.
      DO 34 I=1,N
      D(I)=COEF4*D(I)
      EPSIL(I)=2./COEF4*PIRAD*EPS/WAVE*SQRT(D(I)*(4.-D(I)*WAVE**2))
   34 D(I)=D(I)/COEF4
      ENDIF
C
C     P R E P A R A T I O N   E T   E C R I T U R E
C                 D E S   D O N N E E S
C
   35 CONTINUE
      BB=0.
      CC=0.
      BETA=0.
      JCOUNT=0
      NINI=N
      WRITE(IW,515)(IDENT(K),K=1,64)
      WRITE(IW,506)
      DTH=0.
      GOTO(110,112,114,116),ITYPE
  116 WRITE(IW,501)
      WRITE(IW,511)(D(I),EPSIL(I),I=1,N)
      DO 118 I=1,N
      Q(I)=D(I)*COEF4
      EPSQ(I)=EPSIL(I)*COEF4
      D(I)=1./SQRT(Q(I))
      QTERME=EPSQ(I)/(2.*Q(I))
      EPSIL(I)=D(I)*QTERME
      ANGULO=ASIN(WAVE2/D(I))
      TH(I)=2.*PIDEG*ANGULO
      DTH=DTH+(QTERME*PIDEG*TAN(ANGULO))
  118 CONTINUE
      VN=.6/(1./N-.0052)*D(N)**3
      GOTO 122
  114 WRITE(IW,502)
      WRITE(IW,510)(D(I),EPSIL(I),I=1,N)
      DO 124 I=1,N
      ANGULO=ASIN(WAVE2/D(I))
      TH(I)=2.*PIDEG*ANGULO
      DTH=DTH+(2.*TAN(ANGULO)*EPSIL(I)*PIDEG/D(I))
  124 CONTINUE
      VN=.6/(1./N-.0052)*D(N)**3
      GOTO 126
  112 WRITE(IW,503)
      WRITE(IW,511)(D(I),EPSIL(I),I=1,N)
      DOS=1.
      DOSINV=.5
      GOTO 128
  110 WRITE(IW,504)
      WRITE(IW,511)(D(I),EPSIL(I),I=1,N)
      DOS=2.
      DOSINV=1.
  128 DO 132 I=1,N
      TH(I)=DOS*D(I)
      ANGULO=PIRAD*DOSINV*D(I)
      D(I)=WAVE2/SIN(ANGULO)
      DTH=DTH+DOS*EPSIL(I)
      EPSIL(I)=D(I)*EPSIL(I)*PIRAD*DOSINV/TAN(ANGULO)
  132 CONTINUE
      VN=.6/(1./N-.0052)*D(N)**3
  126 DO 134 I=1,N
      PR=D(I)*D(I)
      Q(I)=1./PR
      EPSQ(I)=2.*EPSIL(I)/(PR*D(I))
  134 CONTINUE
      DTH=DTH/N
  122 CONTINUE
  123 NR=NINT(D(1)/D(2))
      IF(NR.EQ.1)GO TO 2079
      IF(ABS((NR*D(2)-D(1))).GE.(EPSIL(1)+NR*EPSIL(2)))GO TO 2079
      DI=D(2)
      THI=TH(2)
      QI=Q(2)
      EPSILI=EPSIL(2)
      EPSQI=EPSQ(2)
      DO 2040 I=2,N-1
      D(I)=D(I+1)
      TH(I)=TH(I+1)
      Q(I)=Q(I+1)
      EPSIL(I)=EPSIL(I+1)
 2040 EPSQ(I)=EPSQ(I+1)
      D(N)=DI
      TH(N)=THI
      Q(N)=QI
      EPSIL(N)=EPSILI
      EPSQ(N)=EPSQI
      N=N-1
      IF(N.EQ.0)THEN
      WRITE(IW,*)' EXPERIMENTAL ERROR TOO LARGE !'
      WRITE(*,*)' EXPERIMENTAL ERROR TOO LARGE !'
      GO TO 2200
      ENDIF
      GO TO 123
2079  DO 101 I=1,N
      KQ(I)=COEFF*Q(I)
      KEPSQ(I)=COEFF*EPSQ(I)
  101 CONTINUE
      IF (JM.EQ.0) GOTO 201
      IF (BEMIN.EQ.0.0) BEMIN=90.
      IF (BEMAX.EQ.0.0) BEMAX=125.
      WRITE(IW,524)AMAX,BMAX,VOLMIN,CMAX,BEMIN,VOLMAX,BEMAX
      GOTO 202
  201 IF((JC+JT+JH+JO).EQ.0)THEN
      WRITE(IW,529)VOLMIN,VOLMAX
      ELSE
      WRITE(IW,526)AMAX,VOLMIN,BMAX,VOLMAX,CMAX
      ENDIF
  202 WRITE(IW,527)WAVE
      WRITE(IW,827)NINI,FOM
C
C     A V E C   O U   S A N S   D E N S I T E ?
C
      KDENS=1
      X=POIMOL*DENS*DELDEN
      IF(X.LE.1.0E-04)GO TO 70
      KDENS=2
      WRITE(IW,528)POIMOL,DENS,DELDEN
   70 WRITE(IW,22)
C
C     F O R M A T S
C
    4 FORMAT(/1H ,4X,'MOLECULAR WEIGHT =',F9.4,9X,8HDENSITY=,F7.4,7X
     1,10HPRECISION=,F7.4)
  525 FORMAT(64A1)
  515 FORMAT(1H1/1H ,6X,68(1H-)/1H ,6X,'| ',64A1,' |'/1H ,6X,68(1H-))
  506 FORMAT(/36X,'INPUT DATA'/36X,10(1H*))
    7 FORMAT(//1H ,55X,10(1H*)/1H ,10X,'A MAXIMUM =',F6.2,' A'/1H ,8X,'B
     1 MAXIMUM =',F6.2,' A'/1H ,8X,' MAXIMUM ='F6.2,' A'/1H ,8X,'VOLUME
     2MINIMUM =',F9.2,' A**3'/1H ,5X,16HVOLUME MAXIMUM =,F9.2,' A**3')
    8 FORMAT(8X,'CUBIC SYSTEM'/8X,12('-'))
    9 FORMAT(/,36X,'NO SOLUTION'/)
   10 FORMAT(8X,'TETRAGONAL SYSTEM'/8X,17('-'))
   11 FORMAT(8X,'HEXAGONAL SYSTEM'/8X,16('-'))
   12 FORMAT(8X,'ORTHORHOMBIC SYSTEM'/8X,19('-'))
  206 FORMAT(/2X,'END OF SEARCH FOR CUBIC SOLUTION(S)'/2X,35('*'))
   13 FORMAT(//2X,77HEND OF SEARCH FOR TETRAGONAL AND/OR HEXAGONAL AND/O
     1R ORTHORHOMBIC SOLUTION(S)/2X,77(1H*))
  510 FORMAT(11X,F10.4,37X,F10.4)
   16 FORMAT(8X,'MONOCLINIC SYSTEM'/8X,17('-'))
   17 FORMAT(/2X,'VOLUME DOMAIN BEING SCANNED :'/2X,27('=')/15X,
     1'LOWER BOUND = ',F7.2,' A**3',5X,'HIGHER BOUND = ',F7.2,' A**3'/)
   22 FORMAT(///12X,60('*')/12X,'**',56X,'**'/12X,'**  ATTENTION  : VOS
     SDONNEES SONT-ELLES IRREPROCHABLES ?  **'/ 12X,'**  WARNING    : AR
     SE YOUR DATA IRREPROACHABLE ?	     **'/12X,'**',56X,'**'/
     S12X,60('*')///)
   23 FORMAT(/2X,38HEND OF SEARCH FOR MONOCLINIC SOLUTIONS/
     S2X,38(1H*))
   24 FORMAT(/1H ,10X,14HBETA MINIMUM =,F9.2/1H ,10X,14HBETA MAXIMUM =,F
     19.2)
   25 FORMAT(/3X,'SEARCH OF CUBIC SOLUTION(S)'/3X,27('*')//)
   26 FORMAT(//3X,'SEARCH OF TETRAGONAL AND/OR HEXAGONAL AND/OR ORTHORHO
     SMBIC SOLUTION(S)'/3X,69('*')/)
   28 FORMAT(//3X,'SEARCH OF MONOCLINIC SOLUTION(S)'/3X,32('*')/)
   29 FORMAT(//3X,'SEARCH OF TRICLINIC SOLUTION(S)'/3X,31('*')/)
  501 FORMAT(12X,'EXPERIMENTAL',35X,'EXPERIMENTAL'/
     S	     14X,'Q VALUES',41X,'ERROR'/)
  502 FORMAT(12X,'EXPERIMENTAL',35X,'EXPERIMENTAL'/
     S	     14X,'D VALUES',41X,'ERROR'/)
  503 FORMAT(12X,'EXPERIMENTAL',35X,'EXPERIMENTAL'/
     S	     14X,'2-THETA',42X,'ERROR'/)
  504 FORMAT(12X,'EXPERIMENTAL',35X,'EXPERIMENTAL'/
     S	     15X,'THETA',43X,'ERROR'/)
  511 FORMAT(11X,F10.3,36X,F10.3)
  524 FORMAT(//21X,42('*')//4X,3('-'),'----  PARAMETER LIMITS  ----',
     S	     4('-'),5X,5('-'),'---  VOLUME LIMITS  ---',6('-')/
     S	     4X,'|',33X,'|',5X,'|',32X,'|'/4X,'|',4X,'A MAXIMUM    =',
     S F8.2,' A',5X,'|',5X,'|',32X,'|'/4X,'|',4X,'B MAXIMUM',4X,'=',
     S F8.2,' A',5X ,'|',5X,'|',2X,'VOLUME MINIMUM =',F8.2,' A**3 |'/
     S 4X,'|',4X,'C MAXIMUM    =',F8.2,' A',5X ,'|',5X,'|',32X,'|'/
     S 4X,'|',4X,'BETA MINIMUM =',F8.2,' Deg.',2X ,'|',5X,'|',2X,
     S 'VOLUME MAXIMUM =',F8.2,' A**3 |'/4X,'|',4X,'BETA MAXIMUM ='
     S ,F8.2,' Deg.',2X ,'|',5X,'|',32X,'|'/4X,'|',33X,'|',5X,'|',32X,
     S '|'/4X,35('-'),5X,34('-')//)
  526 FORMAT(//21X,42('*')//4X,3('-'),'----  PARAMETER LIMITS  ----',
     S	     4('-'),5X,5('-'),'---  VOLUME LIMITS  ---',6('-')/
     S	     4X,'|',33X,'|',5X,'|',32X,'|'/4X,'|',8X,'A MAXIMUM =',
     S	     F6.2,' A',6X,'|',5X,'|',32X,'|'/4X,'|',33X,'|',5X,'|',2X,
     S	     'VOLUME MINIMUM =',F8.2,' A**3 |'/4X,'|',8X,'B MAXIMUM =',
     S	     F6.2,' A',6X,'|',5X,'|',32X,'|'/4X,'|',33X,'|',5X,'|',2X,
     S	     'VOLUME MAXIMUM =',F8.2,' A**3 |'/4X,'|',8X,'C MAXIMUM =',
     S	     F6.2,' A',6X,'|',5X,'|',32X,'|'/4X,'|',33X,'|',5X,'|',32X,
     S	     '|'/4X,35('-'),5X,34('-')//)
  529 FORMAT(//21X,42('*')//22X,9('-'),'---  VOLUME LIMITS  ---',8('-')/
     S 22X,'|',38X,'|'/22X,'|',38X,'|'/22X,'|',3X,' VOLUME MINIMUM =',F
     S8.2,' A**3',5X,'|'/22X,'|',38X,'|'/22X,'|',3X,' VOLUME MAXIMUM =',
     SF8.2,' A**3',5X,'|'/22X,'|',38X,'|'/22X,'|',38X,'|'/22X,40('-')//)
  527 FORMAT(31X,'WAVELENGTH =',F9.6)
  528 FORMAT(//5X,'MOLECULAR WEIGHT =',F9.4,5X,
     S	     'MEASURED DENSITY =',F8.4,' G.CM(-3)'/37X,
     S	     'DENSITY ERROR    =',F8.4,' G.CM(-3)'/)
  808 FORMAT(/,3X,'SEARCH OF MONOCLINIC SOLUTION(S) WITHIN THE LIMITS ON
     S LINEAR PARAMETERS'/3X,71('*')/3X,'(SLIGHT TOLERANCE ACCEPTED):','
     S  A MAX=',F7.3,'   B MAX=',F7.3,'   C MAX=',F7.3)
  809 FORMAT(/,3X,'EXTENSION OF THE SEARCH OF MONOCLINIC SOLUTION(S)'/
     S3X,'WITHIN THE LIMITS ON LINEAR PARAMETERS :'/
     S14X,'A MAX =',F8.3,6X,'B MAX =',F8.3,6X,'C MAX =',F8.3,6X,F8.3)
  827 FORMAT(/5X,'LOWER FIGURE OF MERIT REQUIRED FOR PRINTED SOLUTION(S)
     S :  M(',I3,') = ',F5.1/)
C
C     P A R T I E   C O M M U N E
C
      V=VOLMAX
      VOLMAXC=VOLMAX
      VV=V
      PAS2=PAS/2.
      PAS4=PAS/4.
      PAS8=PAS/8.
      PAS16=PAS/16.
      PAS32=PAS/32.
      PAS64=PAS/64.
      VSUPM=VOLMIN
      AMIN=D(1)-EPSIL(1)
      DD1=AMIN
      ZB=2.*EPSIL(2)+EPSIL(1)
      ZZ=ABS(2.*D(2)-D(1))
      IF(ZZ-ZB)19,19,18
   19 BMIN=D(3)-EPSIL(3)
      DD2=BMIN
      GO TO 27
   18 BMIN=D(2)-EPSIL(2)
      DD2=BMIN
   27 CMIN=2.5
      NA=(AMAX-AMIN)/PAS+1.
      NB=(BMAX-BMIN)/PAS+1.
      NC=(CMAX-CMIN)/PAS+1.
      IF(KDENS.EQ.2)GO TO 3001
C
C     T R A I T E M E N T   S A N S   D E N S I T E
C
      VSUP=VOLMIN
      PASVOL=400.
      NVOL=(VOLMAXC-VOLMIN)/PASVOL
      NVOL=NVOL+1
      IF(JC.EQ.0)GO TO 21
      WRITE(IW,25)
      VINF=VOLMIN
      VSUP=VOLMAXC
      WRITE(*,17)VINF,VSUP
      WRITE(IW,17)VINF,VSUP
      WRITE(*,8)
      WRITE(IW,8)
      CALL CUBIQU(AMIN,AMAX,NA)
      DIFVOL=ABS(VV-V)
      IF(DIFVOL-1E-12)20,20,52
   20 WRITE(IW,9)
C1002 CONTINUE
   52 WRITE(IW,206)
      VSUP=VSUPM
      VV=V
      VOLMAXC=AMIN 1(VOLMAXC,V)
   21 IF(JT.EQ.0.AND.JH.EQ.0.AND.JO.EQ.0)GO TO 2100
      WRITE(IW,26)
      DO 1000 KVOL=1,NVOL
      VINF=VSUP
      VSUP=VINF+PASVOL
      IF(VSUP.GT.VOLMAXC)VSUP=VOLMAXC
      IF(VINF.GE.VOLMAXC)GO TO 1100
      WRITE(*,17)VINF,VSUP
      WRITE(IW,17)VINF,VSUP
      IF(JT.EQ.0)GO TO 31
      WRITE(*,*)' '
      WRITE(*,*)'++++++++++++++++++++++++++++++++++++++++++++++++++++'
      WRITE(*,10)
      WRITE(IW,10)
      ICHOIX=-1
      CALL TETHEX(CMIN,NC,ICHOIX)
      DIFVOL=ABS(VV-V)
      IF(DIFVOL-1E-12)30,30,31
   30 WRITE(IW,9)
   31 IF(JH.EQ.0)GO TO 41
      VV=V
      WRITE(*,*)' '
      WRITE(*,*)'++++++++++++++++++++++++++++++++++++++++++++++++++++'
      WRITE(*,11)
      WRITE(IW,11)
      ICHOIX=1
      CALL TETHEX(CMIN,NC,ICHOIX)
      DIFVOL=ABS(VV-V)
      IF(DIFVOL-1E-12)40,40,41
   40 WRITE(IW,9)
   41 IF(JO.EQ.0)GO TO 1000
      VV=V
      WRITE(*,*)' '
      WRITE(*,*)'++++++++++++++++++++++++++++++++++++++++++++++++++++'
      WRITE(*,12)
      WRITE(IW,12)
      CALL ORTHOR(AMIN,BMIN,CMIN,NA,NB,NC)
      DIFVOL=ABS(VV-V)
      IF(DIFVOL-1E-12)50,50,1100
   50 WRITE(IW,9)
 1000 CONTINUE
 1100 WRITE(IW,13)
      END_TIME=SECNDS()
      DIF_TIME=END_TIME-BEGIN_TIME
      IF(DIF_TIME.LT.0.)DIF_TIME=DIF_TIME+TIME2
C     WRITE(*,614)DIF_TIME
      WRITE(IW,614)DIF_TIME
      VV=V
      VOLMAXC=AMIN 1(VOLMAXC,V)
2100  IF(JM.EQ.0)GO TO 2700
      WRITE(IW,28)
      WRITE(*,*)' '
      WRITE(*,*)'++++++++++++++++++++++++++++++++++++++++++++++++++++'
      WRITE(*,16)
      WRITE(IW,16)
      BEMIN=BEMIN*PIRAD
      BEMAX=BEMAX*PIRAD
      PETIAMAXI=AMAX
      PETICMAXI=CMAX
      AMIN=BMIN*SIN(BEMAX)
      BMIN=CMIN
      CMIN=CMIN*SIN(BEMAX)
      NAC=NINT((AMIN-CMIN)/PAS)
      IF((NAC*PAS).LT.(AMIN-CMIN))NAC=NAC+1
      CMIN=AMIN-NAC*PAS
      AMAX=AMAX*SIN(BEMIN)
      CMAX=CMAX*SIN(BEMIN)
      AMAXI=AMAX
      BMAXI=BMAX
      CMAXI=CMAX
C
      Q11=2./SQRT(Q(1)-EPSQ(1))
      AMAX=AMIN 1(((Q11+.5)*SIN(BEMIN)),AMAX)
      BMAX=AMIN 1(Q11+.5,BMAX)
      IF(AMAX.GT.AMAXI)AMAX=AMAXI
      IF(BMAX.GT.BMAXI)BMAX=BMAXI
      IF(CMAX.GT.CMAXI)CMAX=CMAXI
      CMAX=AMIN 1(AMAX,CMAX)
      MC=1
      GO TO 21001
2001  AMAXM=AMAX
      BMAXM=BMAX
      CMAXM=CMAX
      JFL=JFL+1
      IF(AMAX.GE.AMAXI.AND.BMAX.GE.BMAXI.AND.CMAX.GE.CMAXI)GO TO 2300
      AMAX=AMAX+8.
      BMAX=BMAX+8.
      CMAX=CMAX+8.
      IF(AMAX.GT.AMAXI)AMAX=AMAXI
      IF(BMAX.GT.BMAXI)BMAX=BMAXI
      IF(CMAX.GT.CMAXI)CMAX=CMAXI
      IF(CMAX.GT.AMAX)CMAX=AMAX
      MC=0
      GO TO 21003
21001 PETIAMAX=AMIN 1(PETIAMAXI,AMAX/SIN(BEMIN))
      PETICMAX=AMIN 1(PETICMAXI,CMAX/SIN(BEMIN))
      WRITE(*,808)PETIAMAX,BMAX,PETICMAX
      WRITE(IW,808)PETIAMAX,BMAX,PETICMAX
21003 NA=(AMAX-AMIN)/PAS
      NB=(BMAX-BMIN)/PAS
      NC=(CMAX-CMIN)/PAS
      VSUP=VSUPM
      PETIAMAX=AMIN 1(PETIAMAXI,AMAX/SIN(BEMIN))
      PETICMAX=AMIN 1(PETICMAXI,CMAX/SIN(BEMIN))
      IF(MC.EQ.0)WRITE(IW,809)PETIAMAX,BMAX,PETICMAX
      IF(MC.EQ.0)WRITE(*,809)PETIAMAX,BMAX,PETICMAX
      PETIAMAX=AMIN 1(PETIAMAXI,AMAX/SIN(BEMAX))
      PETICMAX=AMIN 1(PETICMAXI,CMAX/SIN(BEMAX))
      DO 2000 KVOL=1,NVOL
      VINF=VSUP
      VSUP=VINF+PASVOL
      IF(VSUP.GT.VOLMAXC)VSUP=VOLMAXC
      IF(VINF.GE.VOLMAXC)GO TO 2000
      WRITE(*,17)VINF,VSUP
      WRITE(IW,17)VINF,VSUP
      CALL MONOC1(AMIN,NA,NB,CMIN,NC,BEMAX,BEMIN,BMIN)
      DIFVOL=ABS(VV-V)
      IF(DIFVOL-1E-12)60,60,2300
   60 WRITE(IW,9)
 2000 CONTINUE
      GO TO 2001
 2300 WRITE(IW,23)
      END_TIME=SECNDS()
      DIF_TIME=END_TIME-BEGIN_TIME
      IF(DIF_TIME.LT.0.)DIF_TIME=DIF_TIME+TIME2
C     WRITE(*,14)DIF_TIME
      WRITE(IW,14)DIF_TIME
 2700 IF(JTR.EQ.0)GO TO 2200
      WRITE(IW,29)
      WRITE(IW,702)
      WRITE(*,*)' '
      WRITE(*,*)'++++++++++++++++++++++++++++++++++++++++++++++++++++'
      WRITE(*,702)
      AMAX=AMAXI
      BMAX=BMAXI
      CMAX=CMAXI
      VV=V
      VOLMAXC=AMIN 1(VOLMAXC,V)
      VMOI=AMAX 1(VN*.7,VOLMIN)
      VPLU=AMIN 1(VN*1.3,VOLMAXC)
      KLV=1
      IF(VPLU.LT.VMOI)THEN
      VMOI=VOLMIN
      VPLU=VOLMAXC
      KLV=3
      ENDIF
      VMOII=VMOI
 6801 PASVOL1=AMIN 1(200.,(VPLU-VMOI))
      IF(VMOI.EQ.VN*.7.AND.VPLU.EQ.VN*1.3)PASVOL1=VPLU-VMOI
      NVOL=(VPLU-VMOI)/PASVOL1
      DO 6802 I=0,NVOL
      VMIN=VMOI+I*PASVOL1
      VMAX=VMIN+PASVOL1
      IF(VMIN.GE.VPLU)THEN
      GO TO(6805,6806,6807),KLV
      ENDIF
      IF(VMAX.GT.VPLU)VMAX=VPLU
      WRITE(IW,17)VMIN,VMAX
      WRITE(*,17)VMIN,VMAX
      CALL TRICLINI1(VMIN,VMAX)
      DIFVOL=ABS(V-VV)
      IF(DIFVOL-1E-12)6802,6802,6807
 6802 WRITE(IW,9)
      GO TO(6805,6806,6807),KLV
 6805 IF(VPLU.EQ.VOLMAXC)GO TO 6806
      VMOI=VPLU
      VPLU=VOLMAXC
      KLV=2
      GO TO 6801
 6806 IF(VMOII.EQ.VOLMIN)GO TO 6807
      VMOI=VOLMIN
      VPLU=VMOII
      KLV=3
      GO TO 6801
 6807 WRITE(IW,703)
      GO TO 2200
C
C     T R A I T E M E N T   A V E C   D E N S I T E
C
 3001 AVOG=0.602253
      RAP=POIMOL/AVOG
      VUNITP=RAP/(DENS-DELDEN)
      VUNITM=RAP/(DENS+DELDEN)
      IF(JC.EQ.0)GO TO 121
      WRITE(IW,25)
      WRITE(*,*)'++++++++++++++++++++++++++++++++++++++++++++++++++++'
      WRITE(*,8)
      WRITE(IW,8)
      DO 3002 KZ=1,50
      VINF=KZ*VUNITM
      VSUP=KZ*VUNITP
      IF (VSUP.LT.VOLMIN)GO TO 3002
C -----------------------------11/10/91
      IF (VSUP.GT.VOLMAXC)VSUP=VOLMAXC
C -------------------------------------
      IF(VINF.GE.VOLMAXC)GO TO 3101
C -----------------------------11/10/91
      IF(VINF.LT.VOLMIN)VINF=VOLMIN
C--------------------------------------
      WRITE(*,17)VINF,VSUP
      WRITE(IW,17)VINF,VSUP
      CALL CUBIQU(AMIN,AMAX,NA)
      DIFVOL=ABS(VV-V)
      IF(DIFVOL-1E-12)120,120,121
  120 WRITE(IW,9)
 3002 CONTINUE
 3101 WRITE(IW,206)
      VV=V
      VOLMAXC=AMIN 1(VOLMAXC,V)
  121 IF(JT.EQ.0.AND.JH.EQ.0.AND.JO.EQ.0)GO TO 3200
      WRITE(IW,26)
      DO 3000 KZ=1,50
      VINF=KZ*VUNITM
      VSUP=KZ*VUNITP
      IF (VSUP.LT.VOLMIN)GO TO 3000
      IF(VINF.GE.VOLMAXC)GO TO 3100
C -----------------------------11/10/91
      IF (VSUP.GT.VOLMAXC)VSUP=VOLMAXC
C -------------------------------------
      IF(VINF.GE.VOLMAXC)GO TO 3101
C -----------------------------11/10/91
      IF(VINF.LT.VOLMIN)VINF=VOLMIN
C--------------------------------------
      WRITE(*,17)VINF,VSUP
      WRITE(IW,17)VINF,VSUP
      IF(JT.EQ.0)GO TO 131
      VV=V
      WRITE(*,*)' '
      WRITE(*,*)'++++++++++++++++++++++++++++++++++++++++++++++++++++'
      WRITE(*,10)
      WRITE(IW,10)
      ICHOIX=-1
      CALL TETHEX(CMIN,NC,ICHOIX)
      DIFVOL=ABS(VV-V)
      IF(DIFVOL-1E-12)130,130,131
  130 WRITE(IW,9)
  131 IF(JH.EQ.0)GO TO 141
      VV=V
      WRITE(*,*)' '
      WRITE(*,*)'++++++++++++++++++++++++++++++++++++++++++++++++++++'
      WRITE(*,11)
      WRITE(IW,11)
      ICHOIX=1
      CALL TETHEX(CMIN,NC,ICHOIX)
      DIFVOL=ABS(VV-V)
      IF(DIFVOL-1E-12)140,140,141
  140 WRITE(IW,9)
  141 IF(JO.EQ.0)GO TO 3000
      VV=V
      WRITE(*,*)' '
      WRITE(*,*)'++++++++++++++++++++++++++++++++++++++++++++++++++++'
      WRITE(*,12)
      WRITE(IW,12)
      CALL ORTHOR(AMIN,BMIN,CMIN,NA,NB,NC)
      DIFVOL=ABS(VV-V)
      IF(DIFVOL-1E-12)150,150,3100
  150 WRITE(IW,9)
 3000 CONTINUE
 3100 WRITE(IW,13)
      END_TIME=SECNDS()
      DIF_TIME=END_TIME-BEGIN_TIME
      IF(DIF_TIME.LT.0.)DIF_TIME=DIF_TIME+TIME2
C     WRITE(*,614)DIF_TIME
      WRITE(IW,614)DIF_TIME
 3200 IF(JM.EQ.0)GO TO 3300
      WRITE(IW,28)
      WRITE(*,*)' '
      WRITE(*,*)'++++++++++++++++++++++++++++++++++++++++++++++++++++'
      WRITE(*,16)
      WRITE(IW,16)
      BEMIN=BEMIN*PIRAD
      BEMAX=BEMAX*PIRAD
      PETIAMAXI=AMAX
      PETICMAXI=CMAX
      AMIN=BMIN*SIN(BEMAX)
      BMIN=CMIN
      CMIN=CMIN*SIN(BEMAX)
      NAC=NINT((AMIN-CMIN)/PAS)
      IF((NAC*PAS).LT.(AMIN-CMIN))NAC=NAC+1
      CMIN=AMIN-NAC*PAS
      VV=V
      AMAX=AMAX*SIN(BEMIN)
      CMAX=CMAX*SIN(BEMIN)
      AMAXI=AMAX
      BMAXI=BMAX
      CMAXI=CMAX
C
      Q11=2./SQRT(Q(1)-EPSQ(1))
      AMAX=AMIN 1((Q11+.5)*SIN(BEMIN),AMAX)
      BMAX=AMIN 1(Q11+.5,BMAX)
      IF(AMAX.GT.AMAXI)AMAX=AMAXI
      IF(BMAX.GT.BMAXI)BMAX=BMAXI
      IF(CMAX.GT.CMAXI)CMAX=CMAXI
      CMAX=AMIN 1(AMAX,CMAX)
      MC=1
      GO TO 21002
2002  AMAXM=AMAX
      BMAXM=BMAX
      CMAXM=CMAX
      IF(AMAX.EQ.AMAXI.AND.BMAX.EQ.BMAXI.AND.CMAX.EQ.CMAXI)GO TO 4300
      AMAX=AMAX+8.
      BMAX=BMAX+8.
      CMAX=CMAX+8.
      IF(AMAX.GT.AMAXI)AMAX=AMAXI
      IF(BMAX.GT.BMAXI)BMAX=BMAXI
      IF(CMAX.GT.CMAXI)CMAX=CMAXI
      IF(CMAX.GT.AMAX)CMAX=AMAX
      MC=0
      GO TO 21004
21002 PETIAMAX=AMIN 1(PETIAMAXI,AMAX/SIN(BEMIN))
      PETICMAX=AMIN 1(PETICMAXI,CMAX/SIN(BEMIN))
      WRITE(*,808)PETIAMAX,BMAX,PETICMAX
      WRITE(IW,808)PETIAMAX,BMAX,PETICMAX
21004 NA=(AMAX-AMIN)/PAS
      NB=(BMAX-BMIN)/PAS
      NC=(CMAX-CMIN)/PAS
      PETIAMAX=AMIN 1(PETIAMAXI,AMAX/SIN(BEMIN))
      PETICMAX=AMIN 1(PETICMAXI,CMAX/SIN(BEMIN))
      IF(MC.EQ.0)WRITE(*,808)PETIAMAX,BMAX,PETICMAX
      IF(MC.EQ.0)WRITE(IW,808)PETIAMAX,BMAX,PETICMAX
      PETIAMAX=AMIN 1(PETIAMAXI,AMAX/SIN(BEMAX))
      PETICMAX=AMIN 1(PETICMAXI,CMAX/SIN(BEMAX))
      DO 4000 KZ=1,50
      VINF=KZ*VUNITM
      VSUP=KZ*VUNITP
      IF(VSUP.LT.VOLMIN)GO TO 4000
      IF(VINF.GE.VOLMAXC)GO TO 4000
      IF(VSUP.GT.VOLMAXC)VSUP=VOLMAXC
C     ------------------------	le 14/10/91
      IF(VINF.LT.VOLMIN)VINF=VOLMIN
C     ---------------------------------
      WRITE(*,17)VINF,VSUP
      WRITE(IW,17)VINF,VSUP
      CALL MONOC1(AMIN,NA,NB,CMIN,NC,BEMAX,BEMIN,BMIN)
      DIFVOL=ABS(VV-V)
      IF(DIFVOL-1E-12)160,160,4300
  160 WRITE(IW,9)
 4000 CONTINUE
      GO TO 2002
 4300 WRITE(IW,23)
      END_TIME=SECNDS()
      DIF_TIME=END_TIME-BEGIN_TIME
      IF(DIF_TIME.LT.0.)DIF_TIME=DIF_TIME+TIME2
C     WRITE(*,14)DIF_TIME
      WRITE(IW,14)DIF_TIME
 3300 IF(JTR.EQ.0)GO TO 2200
      WRITE(IW,29)
      WRITE(IW,702)
      AMAX=AMAXI
      BMAX=BMAXI
      CMAX=CMAXI
      VV=V
      VOLMAXC=AMIN 1(VOLMAXC,V)
      VMIN=.7*VN
      VMAX=1.3*VN
      IF(VMIN.LT.VOLMIN)VMIN=VOLMIN
      IF(VMAX.GT.VOLMAXC)VMAX=VOLMAXC
      VOINF=VMIN
      VOSUP=VMAX
      KZT=1
      KZ1=0
1085  CONTINUE
      DO 5000 KZ=1,50
      IF(KZT.EQ.1.AND.KZ.GE.KZ1.AND.KZ.LE.KZ2)GO TO 5000
      VMIN=KZ*VUNITM
      VMAX=KZ*VUNITP
      IF(VMAX.LT.VOINF)GO TO 5000
      IF(VMIN.GT.VOSUP)GO TO 701
      IF(VMAX.GT.VOLMAXC)VMAX=VOLMAXC
      WRITE(*,*)' '
      WRITE(*,*)'++++++++++++++++++++++++++++++++++++++++++++++++++++'
      WRITE(*,702)
      WRITE(*,17)VMIN,VMAX
      WRITE(IW,17)VMIN,VMAX
      WRITE(IW,702)
      IF(KZ1.EQ.0)KZ1=KZ
      CALL TRICLINI1(VMIN,VMAX)
  702 FORMAT(8X,'TRICLINIC SYSTEM'/8X,16('-'))
      DIFVOL=ABS(VV-V)
      IF(DIFVOL-1E-12)704,704,707
  704 WRITE(IW,9)
 5000 CONTINUE
  701 IF(VOINF.EQ.VOLMIN.AND.VOSUP.EQ.VOLMAXC)GO TO 707
      VOINF=VOLMIN
      VOSUP=VOLMAXC
      KZT=1
      KZ2=KZ-1
      GO TO 1085
  707 WRITE(IW,703)
  703 FORMAT(//2X,'END OF SEARCH FOR TRICLINIC SOLUTIONS'/
     +2X,37(1H*))
      GO TO 2200
 343  WRITE(IW,*)' ERROR IN READING !'
      WRITE(* ,*)' ERROR IN READING !'
      STOP
 2200 CONTINUE
      END_TIME=SECNDS()
      DIF_TIME=END_TIME-BEGIN_TIME
      IF(DIF_TIME.LT.0.)DIF_TIME=DIF_TIME+TIME2
      WRITE(IW,1012)DIF_TIME
      WRITE(IW,1013)
  614 FORMAT(/,2X,'---  CALCULATION TIME FOR SEARCH DOWN TO ORTHORHOMBIC
     + SYMMETRY :',F9.3,' SEC.'/)
   14 FORMAT(/,2X,'---  CALCULATION TIME FOR SEARCH DOWN TO MONOCLINIC S
     +YMMETRY :',F9.3,' SEC.'/)
 1012 FORMAT(/,2X,'---  T O T A L   CALCULATION TIME : ',F10.4,' SEC.'/)
 1013 FORMAT(/14X,'DICVOL91 : USEFUL REFERENCES'/14X,'--------'/16X,
     +'* LOUER, D. & LOUER, M. (1972). J. APPL. CRYST. 5, 271-275.'/16X
     +,'* BOULTIF, A. & LOUER, D. (1991). J. APPL. CRYST. 24, 987-993.')
      STOP
      END
      REAL*8 FUNCTION SECNDS()
      INTEGER*2 HOUR,MINUTE,SECOND,HUNDREDTH
      CALL GETTIM(HOUR,MINUTE,SECOND,HUNDREDTH)
      SECNDS = ((DBLE(HOUR)*3600.0)+(DBLE(MINUTE)*60.0)+
     +		 DBLE(SECOND)+(DBLE(HUNDREDTH)/100.0))
      END
